/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class OpenJavaType
extends Action
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private ITextEditor editor;
    private IFile file;

    public void init(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = page != null ? page.getActiveEditor() : null;
        this.setActiveEditor((IAction)this, editor);
    }

    public void dispose() {
    }

    public void setActiveEditor(IAction action, IEditorPart part) {
        this.editor = SpringUIUtils.getTextEditor((IEditorPart)part);
        if (this.editor != null) {
            this.file = BeansUIUtils.getConfigFile((IEditorPart)this.editor);
        } else {
            this.editor = null;
            this.file = null;
        }
        action.setEnabled(this.file != null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setActiveEditor(action, SpringUIUtils.getActiveEditor());
    }

    public void run(IAction action) {
        IType type;
        String className;
        if (this.editor != null && this.file != null && (className = this.guessType()) != null && className.length() > 0 && (type = BeansModelUtils.getJavaType((IProject)this.file.getProject(), (String)className)) != null) {
            SpringUIUtils.openInEditor((IType)type);
        }
    }

    private String guessType() {
        String selectedText = SpringUIUtils.getSelectedText((ITextEditor)this.editor);
        if (!this.isJavaType(selectedText)) {
            int caretPosition = SpringUIUtils.getCaretOffset((ITextEditor)this.editor);
            IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            try {
                IRegion line = doc.getLineInformation(doc.getLineOfOffset(caretPosition));
                String lineText = doc.get(line.getOffset(), line.getLength());
                selectedText = this.findJavaType(lineText, caretPosition - line.getOffset());
            }
            catch (BadLocationException badLocationException) {
                selectedText = null;
            }
        }
        return selectedText;
    }

    private boolean isJavaType(String type) {
        if (type == null || type.length() == 0) {
            return false;
        }
        if (Character.isJavaIdentifierStart(type.charAt(0))) {
            int i = 1;
            while (i < type.length()) {
                char c = type.charAt(i);
                if (!Character.isJavaIdentifierPart(c) && c != '.') {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private String findJavaType(String line, int offset) {
        int start = offset;
        while (start > 0) {
            char c = line.charAt(start - 1);
            if (!Character.isJavaIdentifierPart(c) && c != '.') break;
            --start;
        }
        int length = offset - start;
        int max = line.length();
        while (offset < max) {
            char c = line.charAt(offset);
            if (!Character.isJavaIdentifierPart(c) && c != '.') break;
            ++offset;
            ++length;
        }
        if (length == max) {
            return line;
        }
        if (length > 0) {
            return line.substring(start, start + length);
        }
        return null;
    }
}

