/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class BeansUILabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String DECORATOR_ID = "org.springframework.ide.eclipse.beans.ui.beansLabelDecorator";
    private IModelChangeListener listener = new IModelChangeListener(){

        public void elementChanged(ModelChangeEvent event) {
            BeansUILabelDecorator.update();
        }
    };

    public BeansUILabelDecorator() {
        BeansCorePlugin.getModel().addChangeListener(this.listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        block10: {
            IBeansProject project;
            IJavaElement javaElement;
            int type;
            IBeansModel model = BeansCorePlugin.getModel();
            if (element instanceof IFile) {
                if (model.getConfig((IFile)element) != null) {
                    decoration.addOverlay(BeansUIImages.DESC_OVR_SPRING);
                }
            } else if (element instanceof IJavaElement && ((type = (javaElement = (IJavaElement)element).getElementType()) == 5 || type == 6) && (project = model.getProject(javaElement.getJavaProject().getProject())) != null) {
                try {
                    if (type == 5) {
                        IType[] javaTypes = ((ICompilationUnit)javaElement).getTypes();
                        int i = 0;
                        while (i < javaTypes.length) {
                            IType javaType = javaTypes[i];
                            if (project.isBeanClass(javaType.getFullyQualifiedName())) {
                                decoration.addOverlay(BeansUIImages.DESC_OVR_SPRING);
                                break block10;
                            }
                            ++i;
                        }
                        break block10;
                    }
                    IType javaType = ((IClassFile)javaElement).getType();
                    if (project.isBeanClass(javaType.getFullyQualifiedName())) {
                        decoration.addOverlay(BeansUIImages.DESC_OVR_SPRING);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
        BeansCorePlugin.getModel().removeChangeListener(this.listener);
    }

    public static final void update() {
        SpringUIUtils.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                workbench.getDecoratorManager().update(BeansUILabelDecorator.DECORATOR_ID);
            }
        });
    }
}

