/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.ide.eclipse.beans.core.BeanDefinitionException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.util.Assert;

public class BeansModelUtils {
    public static final IBeansConfig getConfig(String configName, IModelElement context) {
        if (configName.charAt(0) == '/') {
            int pos = configName.indexOf(47, 1);
            String projectName = configName.substring(1, pos);
            configName = configName.substring(pos + 1);
            IBeansProject project = BeansCorePlugin.getModel().getProject(projectName);
            if (project != null) {
                return project.getConfig(configName);
            }
        } else {
            if (context instanceof IBeansProject) {
                return ((IBeansProject)context).getConfig(configName);
            }
            if (context instanceof IBeansConfigSet) {
                return ((IBeansProject)context.getElementParent()).getConfig(configName);
            }
        }
        return null;
    }

    public static final IBeansConfig getConfig(IModelElement element) {
        IModelElement parent;
        if (element instanceof IBean) {
            parent = element.getElementParent();
        } else if (element instanceof IBeanConstructorArgument || element instanceof IBeanProperty) {
            parent = element.getElementParent().getElementParent();
        } else {
            throw new IllegalArgumentException("Unsupported model element " + element);
        }
        return parent instanceof IBeansConfig ? (IBeansConfig)parent : BeansModelUtils.getConfig(parent);
    }

    public static final IBeansProject getProject(IModelElement element) {
        if (element instanceof IBeansProject) {
            return (IBeansProject)element;
        }
        if (element instanceof IBeansConfig || element instanceof IBeansConfigSet) {
            return (IBeansProject)element.getElementParent();
        }
        if (element instanceof IBean) {
            return (IBeansProject)element.getElementParent().getElementParent();
        }
        if (element instanceof IBeanConstructorArgument || element instanceof IBeanProperty) {
            return (IBeansProject)element.getElementParent().getElementParent().getElementParent();
        }
        throw new IllegalArgumentException("Unsupported model element " + element);
    }

    public static final Collection getBeanReferences(IModelElement element, IModelElement context, boolean recursive) {
        ArrayList references = new ArrayList();
        ArrayList referencedBeans = new ArrayList();
        if (element instanceof Bean) {
            IBean factoryBean;
            Bean bean = (Bean)element;
            HashSet<String> beanNames = new HashSet<String>();
            beanNames.add(bean.getElementName());
            IBean parentBean = bean;
            while (parentBean != null && !parentBean.isRootBean()) {
                String parentName = parentBean.getParentName();
                if (beanNames.contains(parentName)) break;
                beanNames.add(parentName);
                parentBean = BeansModelUtils.getBean(parentName, context);
                if (!BeansModelUtils.addBeanReference(2, (IModelElement)bean, parentBean, references, referencedBeans) || !recursive) continue;
                BeansModelUtils.addBeanReferencesForElement((IModelElement)parentBean, context, references, referencedBeans, recursive);
            }
            AbstractBeanDefinition bd = recursive ? (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, context) : (AbstractBeanDefinition)BeansModelUtils.getBeanDefinition(bean);
            if (bd.getFactoryBeanName() != null && BeansModelUtils.addBeanReference(3, (IModelElement)bean, factoryBean = BeansModelUtils.getBean(bd.getFactoryBeanName(), context), references, referencedBeans) && recursive) {
                BeansModelUtils.addBeanReferencesForElement((IModelElement)factoryBean, context, references, referencedBeans, recursive);
            }
            if (bd.getDependsOn() != null) {
                String[] dependsOnBeans = bd.getDependsOn();
                int i = 0;
                while (i < dependsOnBeans.length) {
                    IBean dependsOnBean = BeansModelUtils.getBean(dependsOnBeans[i], context);
                    if (BeansModelUtils.addBeanReference(4, (IModelElement)bean, dependsOnBean, references, referencedBeans) && recursive) {
                        BeansModelUtils.addBeanReferencesForElement((IModelElement)dependsOnBean, context, references, referencedBeans, recursive);
                    }
                    ++i;
                }
            }
            if (!bd.getMethodOverrides().isEmpty()) {
                Iterator methodsOverrides = bd.getMethodOverrides().getOverrides().iterator();
                while (methodsOverrides.hasNext()) {
                    IBean overrideBean;
                    String beanName;
                    MethodOverride methodOverride = (MethodOverride)methodsOverrides.next();
                    if (methodOverride instanceof LookupOverride) {
                        beanName = ((LookupOverride)methodOverride).getBeanName();
                        overrideBean = BeansModelUtils.getBean(beanName, context);
                        if (!BeansModelUtils.addBeanReference(5, (IModelElement)bean, overrideBean, references, referencedBeans) || !recursive) continue;
                        BeansModelUtils.addBeanReferencesForElement((IModelElement)overrideBean, context, references, referencedBeans, recursive);
                        continue;
                    }
                    if (!(methodOverride instanceof ReplaceOverride) || !BeansModelUtils.addBeanReference(5, (IModelElement)bean, overrideBean = BeansModelUtils.getBean(beanName = ((ReplaceOverride)methodOverride).getMethodReplacerBeanName(), context), references, referencedBeans) || !recursive) continue;
                    BeansModelUtils.addBeanReferencesForElement((IModelElement)overrideBean, context, references, referencedBeans, recursive);
                }
            }
            Iterator cargs = bean.getConstructorArguments().iterator();
            while (cargs.hasNext()) {
                IBeanConstructorArgument carg = (IBeanConstructorArgument)cargs.next();
                BeansModelUtils.addBeanReferencesForValue((IModelElement)bean, carg.getValue(), context, references, referencedBeans, recursive);
            }
            Iterator properties = bean.getProperties().iterator();
            while (properties.hasNext()) {
                IBeanProperty property = (IBeanProperty)properties.next();
                BeansModelUtils.addBeanReferencesForValue((IModelElement)property, property.getValue(), context, references, referencedBeans, recursive);
            }
        } else if (element instanceof IBeanConstructorArgument) {
            IBeanConstructorArgument carg = (IBeanConstructorArgument)element;
            BeansModelUtils.addBeanReferencesForValue((IModelElement)carg, carg.getValue(), context, references, referencedBeans, recursive);
        } else if (element instanceof IBeanProperty) {
            IBeanProperty property = (IBeanProperty)element;
            BeansModelUtils.addBeanReferencesForValue((IModelElement)property, property.getValue(), context, references, referencedBeans, recursive);
        } else {
            throw new IllegalArgumentException("Unsupported model element " + element);
        }
        return references;
    }

    private static boolean addBeanReference(int type, IModelElement source, IBean target, List references, List referencedBeans) {
        BeanReference ref;
        if (target != null && target != source && !references.contains(ref = new BeanReference(type, source, target))) {
            references.add(ref);
            if (!referencedBeans.contains(target)) {
                return true;
            }
        }
        return false;
    }

    private static final void addBeanReferencesForElement(IModelElement element, IModelElement context, List references, List referencedBeans, boolean recursive) {
        if (!referencedBeans.contains(element)) {
            Iterator refs = BeansModelUtils.getBeanReferences(element, context, recursive).iterator();
            while (refs.hasNext()) {
                BeanReference ref = (BeanReference)refs.next();
                if (references.contains(ref)) continue;
                references.add(ref);
            }
            referencedBeans.add(element);
        }
    }

    private static final void addBeanReferencesForValue(IModelElement element, Object value, IModelElement context, List references, List referencedBeans, boolean recursive) {
        block8: {
            block10: {
                block11: {
                    block9: {
                        block7: {
                            if (!(value instanceof RuntimeBeanReference)) break block7;
                            String beanName = ((RuntimeBeanReference)value).getBeanName();
                            IBean bean = BeansModelUtils.getBean(beanName, context);
                            if (!BeansModelUtils.addBeanReference(1, element, bean, references, referencedBeans) || !recursive) break block8;
                            BeansModelUtils.addBeanReferencesForElement((IModelElement)bean, context, references, referencedBeans, recursive);
                            break block8;
                        }
                        if (!(value instanceof BeanDefinitionHolder)) break block9;
                        String beanName = ((BeanDefinitionHolder)value).getBeanName();
                        IBean bean = BeansModelUtils.getInnerBean(beanName, context);
                        BeansModelUtils.addBeanReference(7, bean.getElementParent(), bean, references, referencedBeans);
                        BeansModelUtils.addBeanReferencesForElement((IModelElement)bean, context, references, referencedBeans, recursive);
                        break block8;
                    }
                    if (!(value instanceof List)) break block10;
                    if (!(element instanceof IBeanProperty) || !element.getElementName().equals("interceptorNames")) break block11;
                    IType type = BeansModelUtils.getBeanType((IBean)element.getElementParent(), context);
                    if (type == null || !type.getFullyQualifiedName().equals("org.springframework.aop.framework.ProxyFactoryBean")) break block8;
                    Iterator names = ((List)value).iterator();
                    while (names.hasNext()) {
                        IBean interceptor;
                        Object name = names.next();
                        if (!(name instanceof String) || !BeansModelUtils.addBeanReference(6, element, interceptor = BeansModelUtils.getBean((String)name, context), references, referencedBeans) || !recursive) continue;
                        BeansModelUtils.addBeanReferencesForElement((IModelElement)interceptor, context, references, referencedBeans, recursive);
                    }
                    break block8;
                }
                List list = (List)value;
                int i = 0;
                while (i < list.size()) {
                    BeansModelUtils.addBeanReferencesForValue(element, list.get(i), context, references, referencedBeans, recursive);
                    ++i;
                }
                break block8;
            }
            if (value instanceof Set) {
                Set set = (Set)value;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    BeansModelUtils.addBeanReferencesForValue(element, iter.next(), context, references, referencedBeans, recursive);
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    BeansModelUtils.addBeanReferencesForValue(element, map.get(iter.next()), context, references, referencedBeans, recursive);
                }
            }
        }
    }

    public static final BeanDefinition getBeanDefinition(IBean bean) {
        return ((Bean)bean).getBeanDefinitionHolder().getBeanDefinition();
    }

    public static final BeanDefinition getMergedBeanDefinition(IBean bean, IModelElement context) {
        BeanDefinition bd = BeansModelUtils.getBeanDefinition(bean);
        if (!bean.isRootBean()) {
            ArrayList<BeanDefinition> beanDefinitions = new ArrayList<BeanDefinition>();
            beanDefinitions.add(bd);
            BeansModelUtils.addBeanDefinition(bean, context, beanDefinitions);
            RootBeanDefinition rbd = null;
            int bdCount = beanDefinitions.size();
            int i = bdCount - 1;
            while (i >= 0) {
                AbstractBeanDefinition abd = (AbstractBeanDefinition)beanDefinitions.get(i);
                if (rbd != null) {
                    rbd.overrideFrom(abd);
                } else {
                    if (!(abd instanceof RootBeanDefinition)) break;
                    rbd = new RootBeanDefinition((RootBeanDefinition)abd);
                }
                --i;
            }
            if (rbd != null) {
                return rbd;
            }
        }
        return bd;
    }

    private static final void addBeanDefinition(IBean bean, IModelElement context, List beanDefinitions) {
        String parentName = bean.getParentName();
        Bean parentBean = (Bean)BeansModelUtils.getBean(parentName, context);
        if (parentBean != null) {
            BeanDefinition parentBd = parentBean.getBeanDefinitionHolder().getBeanDefinition();
            if (parentName.equals(bean.getElementName()) || beanDefinitions.contains(parentBd)) {
                throw new BeanDefinitionException("Cyclic references are not supported");
            }
            beanDefinitions.add(parentBd);
            if (!parentBean.isRootBean()) {
                BeansModelUtils.addBeanDefinition(parentBean, context, beanDefinitions);
            }
        }
    }

    public static final IBean getBean(String beanName, IModelElement context) {
        if (context instanceof IBeansConfig) {
            return ((IBeansConfig)context).getBean(beanName);
        }
        if (context instanceof IBeansConfigSet) {
            return ((IBeansConfigSet)context).getBean(beanName);
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    public static final IBean getInnerBean(String beanName, IModelElement context) {
        if (context instanceof IBeansConfig) {
            Iterator beans = ((IBeansConfig)context).getInnerBeans().iterator();
            while (beans.hasNext()) {
                IBean bean = (IBean)beans.next();
                if (!beanName.equals(bean.getElementName())) continue;
                return bean;
            }
            return null;
        }
        if (context instanceof IBeansConfigSet) {
            Iterator configs = ((IBeansConfigSet)context).getConfigs().iterator();
            while (configs.hasNext()) {
                String configName = (String)configs.next();
                IBeansConfig config = BeansModelUtils.getConfig(configName, context);
                Iterator beans = config.getInnerBeans().iterator();
                while (beans.hasNext()) {
                    IBean bean = (IBean)beans.next();
                    if (!beanName.equals(bean.getElementName())) continue;
                    return bean;
                }
            }
            return ((IBeansConfigSet)context).getBean(beanName);
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    public static final IType getJavaType(IProject project, String className) {
        if (className != null && project.isAccessible()) {
            int pos = className.lastIndexOf(36);
            if (pos > 0 && pos < className.length() - 1) {
                className = String.valueOf(className.substring(0, pos)) + '.' + className.substring(pos + 1);
            }
            try {
                IJavaProject javaProject;
                IType type;
                if (project.hasNature("org.eclipse.jdt.core.javanature") && (type = (javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature")).findType(className)) != null) {
                    return type;
                }
                IProject[] projects = project.getReferencedProjects();
                int i = 0;
                while (i < projects.length) {
                    IJavaProject javaProject2;
                    IType type2;
                    IProject refProject = projects[i];
                    if (refProject.isAccessible() && refProject.hasNature("org.eclipse.jdt.core.javanature") && (type2 = (javaProject2 = (IJavaProject)refProject.getNature("org.eclipse.jdt.core.javanature")).findType(className)) != null) {
                        return type2;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                BeansCorePlugin.log("Error getting Java type '" + className + "'", e);
            }
        }
        return null;
    }

    public static final String getBeanClass(IBean bean, IModelElement context) {
        Assert.notNull((Object)bean);
        if (bean.isRootBean()) {
            return bean.getClassName();
        }
        if (context == null) {
            context = bean.getElementParent();
        }
        do {
            String parentName;
            if ((parentName = bean.getParentName()) == null || (bean = BeansModelUtils.getBean(parentName, context)) == null || !bean.isRootBean()) continue;
            return bean.getClassName();
        } while (bean != null);
        return null;
    }

    public static final IType getBeanType(IBean bean, IModelElement context) {
        Assert.notNull((Object)bean);
        String className = BeansModelUtils.getBeanClass(bean, context);
        if (className != null) {
            return BeansModelUtils.getJavaType(BeansModelUtils.getProject((IModelElement)bean).getProject(), className);
        }
        return null;
    }

    public static final void createProblemMarker(IModelElement element, String message, int severity, int line, int errorCode) {
        BeansModelUtils.createProblemMarker(element, message, severity, line, errorCode, null, null);
    }

    public static final void createProblemMarker(IModelElement element, String message, int severity, int line, int errorCode, String beanID, String errorData) {
        if (element instanceof IResourceModelElement) {
            IResource resource = ((IResourceModelElement)element).getElementResource();
            BeansCoreUtils.createProblemMarker(resource, message, severity, line, errorCode, beanID, errorData);
        }
    }

    public static final void removeProblemMarkers(IModelElement element) {
        if (element instanceof IBeansConfig) {
            IFile file = ((IBeansConfig)element).getConfigFile();
            BeansCoreUtils.deleteProblemMarkers((IResource)file);
        } else if (element instanceof IBeansProject) {
            Iterator configs = ((IBeansProject)element).getConfigs().iterator();
            while (configs.hasNext()) {
                IBeansConfig config = (IBeansConfig)configs.next();
                BeansModelUtils.removeProblemMarkers((IModelElement)config);
            }
        }
    }

    public static final void registerBeanDefinitions(IBeansConfig config, BeanDefinitionRegistry registry) {
        Iterator beans = config.getBeans().iterator();
        while (beans.hasNext()) {
            Bean bean = (Bean)beans.next();
            try {
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bean.getBeanDefinitionHolder(), (BeanDefinitionRegistry)registry);
            }
            catch (BeansException beansException) {}
        }
    }
}

