/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.util.StringUtils;

public class Introspector {
    public static int STATIC_IRRELVANT = 0;
    public static int STATIC_NO = 2;
    public static int STATIC_YES = 1;

    protected static String concatenate(String text1, String text2, String delimiter) {
        StringBuffer buf = new StringBuffer();
        if (text1 != null && text1.length() > 0) {
            buf.append(text1);
        }
        if (text2 != null && text2.length() > 0) {
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            buf.append(text2);
        }
        return buf.toString();
    }

    protected static JavaModelException createException(String message) {
        return new JavaModelException(new CoreException(BeansCorePlugin.createErrorStatus(message, null)));
    }

    public static Collection findAllMethods(IType type, String methodPrefix, int argCount, boolean isPublic, int staticFlag) throws JavaModelException {
        HashMap<String, IMethod> allMethods = new HashMap<String, IMethod>();
        while (type != null) {
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                int flags = method.getFlags();
                String key = String.valueOf(method.getElementName()) + method.getSignature();
                if (!allMethods.containsKey(key) && Flags.isPublic((int)flags) == isPublic && (staticFlag == STATIC_IRRELVANT || staticFlag == STATIC_YES && Flags.isStatic((int)flags) || staticFlag == STATIC_NO && !Flags.isStatic((int)flags)) && (argCount == -1 || method.getNumberOfParameters() == argCount) && method.getElementName().startsWith(methodPrefix)) {
                    allMethods.put(key, method);
                }
                ++i;
            }
            type = Introspector.getSuperType(type);
        }
        return allMethods.values();
    }

    public static Collection findAllNoParameterMethods(IType type, String prefix) throws JavaModelException {
        if (prefix == null) {
            prefix = "";
        }
        return Introspector.findAllMethods(type, prefix, 0, true, STATIC_IRRELVANT);
    }

    public static IMethod findMethod(IType type, String methodName, int argCount, boolean isPublic, int staticFlag) throws JavaModelException {
        while (type != null) {
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                int flags = method.getFlags();
                if (Flags.isPublic((int)flags) == isPublic && (staticFlag == STATIC_IRRELVANT || staticFlag == STATIC_YES && Flags.isStatic((int)flags) || staticFlag == STATIC_NO && !Flags.isStatic((int)flags)) && (argCount == -1 || method.getNumberOfParameters() == argCount) && methodName.equals(method.getElementName())) {
                    return method;
                }
                ++i;
            }
            type = Introspector.getSuperType(type);
        }
        return null;
    }

    public static Collection findWritableProperties(IType type, String methodPrefix) throws JavaModelException {
        String base = StringUtils.capitalize((String)methodPrefix);
        return Introspector.findAllMethods(type, "set" + base, 1, true, STATIC_NO);
    }

    protected static IType getSuperType(IType type) throws JavaModelException {
        String name = type.getSuperclassName();
        if (name != null) {
            if (type.isBinary()) {
                return type.getJavaProject().findType(name);
            }
            String[][] resolvedNames = type.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                String resolvedName = Introspector.concatenate(resolvedNames[0][0], resolvedNames[0][1], ".");
                return type.getJavaProject().findType(resolvedName);
            }
        }
        return null;
    }

    public static boolean hasConstructor(IType type, int argCount) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        if (argCount == 0) {
            boolean hasExplicitConstructor = false;
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                if (method.isConstructor()) {
                    hasExplicitConstructor = true;
                }
                ++i;
            }
            if (!hasExplicitConstructor) {
                return true;
            }
        }
        int i = 0;
        while (i < methods.length) {
            int flags;
            IMethod method = methods[i];
            if (method.isConstructor() && method.getNumberOfParameters() == argCount && Flags.isPublic((int)(flags = method.getFlags()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasWritableProperty(IType type, String propertyName) throws JavaModelException {
        if (propertyName == null || propertyName.length() == 0) {
            throw Introspector.createException("bad property name");
        }
        String base = StringUtils.capitalize((String)propertyName);
        return Introspector.findMethod(type, "set" + base, 1, true, STATIC_NO) != null;
    }

    public static IMethod getWritableProperty(IType type, String propertyName) throws JavaModelException {
        if (propertyName == null || propertyName.length() == 0) {
            throw Introspector.createException("bad property name");
        }
        String base = StringUtils.capitalize((String)propertyName);
        return Introspector.findMethod(type, "set" + base, 1, true, STATIC_NO);
    }
}

