/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.springframework.ide.eclipse.beans.core.internal.Introspector;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.editor.BeansEditorUtils;
import org.springframework.ide.eclipse.beans.ui.editor.BeansJavaDocUtils;
import org.springframework.ide.eclipse.beans.ui.editor.BeansLablelProvider;
import org.springframework.ide.eclipse.beans.ui.editor.BeansModelImageDescriptor;
import org.springframework.ide.eclipse.beans.ui.editor.templates.BeansTemplateCompletionProcessor;
import org.springframework.ide.eclipse.core.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeansContentAssistProcessor
extends XMLContentAssistProcessor
implements IPropertyChangeListener {
    private IEditorPart editor;
    private BeansTemplateCompletionProcessor fTemplateProcessor = null;

    public BeansContentAssistProcessor(IEditorPart editor) {
        this.editor = editor;
    }

    protected void addTagInsertionProposals(ContentAssistRequest request, int childPosition) {
        IDOMNode node = (IDOMNode)request.getNode();
        if (node != null && node.getParentNode() != null) {
            Node parentNode = node.getParentNode();
            if ("bean".equals(parentNode.getNodeName())) {
                this.addTemplates(request, "org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.bean");
            } else if ("beans".equals(parentNode.getNodeName())) {
                this.addTemplates(request, "org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.all");
            } else if ("property".equals(parentNode.getNodeName())) {
                this.addTemplates(request, "org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.property");
                this.addTemplates(request, "org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.all");
            }
        }
        super.addTagInsertionProposals(request, childPosition);
    }

    protected void addAttributeValueProposals(ContentAssistRequest request) {
        String matchString;
        IDOMNode node = (IDOMNode)request.getNode();
        IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
        ITextRegionList openRegions = open.getRegions();
        int i = openRegions.indexOf(request.getRegion());
        if (i < 0) {
            return;
        }
        ITextRegion nameRegion = null;
        while (i >= 0) {
            if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
        }
        if ((matchString = request.getMatchString()) == null) {
            matchString = "";
        }
        if (matchString.length() > 0 && (matchString.startsWith("\"") || matchString.startsWith("'"))) {
            matchString = matchString.substring(1);
        }
        if (nameRegion != null) {
            String attributeName = open.getText(nameRegion);
            if ("bean".equals(node.getNodeName())) {
                if ("class".equals(attributeName)) {
                    this.addClassAttributeValueProposals(request, matchString);
                } else if ("init-method".equals(attributeName) || "destroy-method".equals(attributeName)) {
                    NamedNodeMap attributes = node.getAttributes();
                    String className = attributes.getNamedItem("class").getNodeValue();
                    if (className != null) {
                        this.addInitDestroyAttributeValueProposals(request, matchString, className);
                    }
                } else if ("factory-method".equals(attributeName)) {
                    NamedNodeMap attributes = node.getAttributes();
                    Node factoryBean = attributes.getNamedItem("factory-bean");
                    String className = null;
                    String factoryClassName = null;
                    if (factoryBean != null) {
                        String factoryBeanId = factoryBean.getNodeValue();
                        Document doc = node.getOwnerDocument();
                        Element bean = doc.getElementById(factoryBeanId);
                        if (bean != null && bean instanceof Node) {
                            NamedNodeMap attr = bean.getAttributes();
                            className = attr.getNamedItem("class").getNodeValue();
                        } else if (this.editor.getEditorInput() instanceof IFileEditorInput) {
                            IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
                            Iterator beans = BeansEditorUtils.getBeansFromConfigSets(file).iterator();
                            while (beans.hasNext()) {
                                IBean modelBean = (IBean)beans.next();
                                if (!modelBean.getElementName().equals(factoryBeanId)) continue;
                                className = modelBean.getClassName();
                            }
                        }
                    } else if (attributes.getNamedItem("class") != null) {
                        className = attributes.getNamedItem("class").getNodeValue();
                    }
                    if (attributes.getNamedItem("class") != null) {
                        factoryClassName = attributes.getNamedItem("class").getNodeValue();
                    }
                    if (className != null && factoryClassName != null) {
                        this.addFactoryMethodAttributeValueProposals(request, matchString, className, factoryClassName);
                    }
                } else if ("parent".equals(attributeName) || "depends-on".equals(attributeName) || "factory-bean".equals(attributeName)) {
                    this.addBeanReferenceProposals(request, matchString, node.getOwnerDocument(), true);
                }
            } else if ("property".equals(node.getNodeName())) {
                Node parentNode = node.getParentNode();
                NamedNodeMap attributes = parentNode.getAttributes();
                if ("name".equals(attributeName) && attributes != null && attributes.getNamedItem("class") != null) {
                    String className = attributes.getNamedItem("class").getNodeValue();
                    this.addPropertyNameAttributeValueProposals(request, matchString, className);
                }
            } else if ("ref".equals(node.getNodeName())) {
                if ("local".equals(attributeName)) {
                    this.addBeanReferenceProposals(request, matchString, node.getOwnerDocument(), false);
                } else if ("bean".equals(attributeName)) {
                    this.addBeanReferenceProposals(request, matchString, node.getOwnerDocument(), true);
                }
            }
            if (request != null && request.getProposals() != null && request.getProposals().size() == 0) {
                super.addAttributeValueProposals(request);
            }
        }
    }

    private void addBeanReferenceProposals(ContentAssistRequest request, String prefix, Document document, boolean showExternal) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.editor.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
            if (document != null) {
                BeanReferenceSearchRequestor requestor = new BeanReferenceSearchRequestor(request);
                NodeList beanNodes = document.getElementsByTagName("bean");
                int i = 0;
                while (i < beanNodes.getLength()) {
                    Node beanNode = beanNodes.item(i);
                    requestor.acceptSearchMatch(beanNode, file, prefix);
                    ++i;
                }
                if (showExternal) {
                    List beans = BeansEditorUtils.getBeansFromConfigSets(file);
                    int i2 = 0;
                    while (i2 < beans.size()) {
                        IBean bean = (IBean)beans.get(i2);
                        requestor.acceptSearchMatch(bean, file, prefix);
                        ++i2;
                    }
                }
            }
        }
    }

    private void addPropertyNameAttributeValueProposals(ContentAssistRequest request, String prefix, String className) {
        IFile file;
        IType type;
        if (this.editor.getEditorInput() instanceof IFileEditorInput && (type = BeansModelUtils.getJavaType((IProject)(file = ((IFileEditorInput)this.editor.getEditorInput()).getFile()).getProject(), (String)className)) != null) {
            try {
                Collection methods = Introspector.findWritableProperties((IType)type, (String)prefix);
                if (methods != null && methods.size() > 0) {
                    PropertyNameSearchRequestor requestor = new PropertyNameSearchRequestor(request);
                    Iterator iterator = methods.iterator();
                    while (iterator.hasNext()) {
                        requestor.acceptSearchMatch((IMethod)iterator.next());
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private void addFactoryMethodAttributeValueProposals(ContentAssistRequest request, String prefix, String className, String factoryClassName) {
        IFile file;
        IType type;
        if (this.editor.getEditorInput() instanceof IFileEditorInput && (type = BeansModelUtils.getJavaType((IProject)(file = ((IFileEditorInput)this.editor.getEditorInput()).getFile()).getProject(), (String)className)) != null) {
            try {
                Collection methods = Introspector.findAllMethods((IType)type, (String)prefix, (int)-1, (boolean)true, (int)Introspector.STATIC_YES);
                if (methods != null && methods.size() > 0) {
                    FactoryMethodSearchRequestor requestor = new FactoryMethodSearchRequestor(request, factoryClassName);
                    Iterator iterator = methods.iterator();
                    while (iterator.hasNext()) {
                        requestor.acceptSearchMatch((IMethod)iterator.next());
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private void addInitDestroyAttributeValueProposals(ContentAssistRequest request, String prefix, String className) {
        IFile file;
        IType type;
        if (this.editor.getEditorInput() instanceof IFileEditorInput && (type = BeansModelUtils.getJavaType((IProject)(file = ((IFileEditorInput)this.editor.getEditorInput()).getFile()).getProject(), (String)className)) != null) {
            try {
                Collection methods = Introspector.findAllNoParameterMethods((IType)type, (String)prefix);
                if (methods != null && methods.size() > 0) {
                    VoidMethodSearchRequestor requestor = new VoidMethodSearchRequestor(request);
                    Iterator iterator = methods.iterator();
                    while (iterator.hasNext()) {
                        requestor.acceptSearchMatch((IMethod)iterator.next());
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private void addClassAttributeValueProposals(ContentAssistRequest request, String prefix) {
        if (this.editor.getEditorInput() instanceof IFileEditorInput) {
            if (prefix != null && prefix.length() > 0) {
                String prefixTemp = prefix;
                if (!prefixTemp.endsWith("*")) {
                    prefixTemp = String.valueOf(prefixTemp) + "*";
                }
                IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
                try {
                    if (file.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject project = JavaCore.create((IProject)file.getProject());
                        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}, (boolean)true);
                        SearchPattern packagePattern = SearchPattern.createPattern((String)prefixTemp, (int)2, (int)0, (int)2);
                        SearchPattern typePattern = SearchPattern.createPattern((String)prefixTemp, (int)0, (int)0, (int)2);
                        SearchPattern pattern = SearchPattern.createOrPattern((SearchPattern)packagePattern, (SearchPattern)typePattern);
                        TypeSearchRequestor requestor = new TypeSearchRequestor(request, StringUtils.isCapitalized((String)prefixTemp));
                        SearchEngine engine = new SearchEngine();
                        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, this.getProgressMonitor());
                    }
                }
                catch (CoreException coreException) {}
            }
        } else {
            this.setErrorMessage("Prefix too short");
        }
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    private IProgressMonitor getProgressMonitor() {
        if (this.editor != null && this.editor.getEditorSite() != null && this.editor.getEditorSite().getActionBars() != null && this.editor.getEditorSite().getActionBars().getStatusLineManager() != null && this.editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor() != null) {
            IStatusLineManager manager = this.editor.getEditorSite().getActionBars().getStatusLineManager();
            IProgressMonitor monitor = manager.getProgressMonitor();
            manager.setMessage("Processing completion proposals");
            return monitor;
        }
        return new NullProgressMonitor();
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String context) {
        boolean useProposalList;
        if (contentAssistRequest == null) {
            return;
        }
        boolean bl = useProposalList = !contentAssistRequest.shouldSeparate();
        if (this.getTemplateCompletionProcessor() != null) {
            this.getTemplateCompletionProcessor().setContextType(context);
            ICompletionProposal[] proposals = this.getTemplateCompletionProcessor().computeCompletionProposals(this.fTextViewer, contentAssistRequest.getReplacementBeginPosition());
            int i = 0;
            while (i < proposals.length) {
                if (useProposalList) {
                    contentAssistRequest.addProposal(proposals[i]);
                } else {
                    contentAssistRequest.addMacro(proposals[i]);
                }
                ++i;
            }
        }
    }

    private BeansTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new BeansTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }

    class BeanReferenceSearchRequestor {
        public static final int LOCAL_BEAN_RELEVANCE = 20;
        public static final int EXTERNAL_BEAN_RELEVANCE = 10;
        protected ContentAssistRequest request;
        protected Map beans;

        public BeanReferenceSearchRequestor(ContentAssistRequest request) {
            this.request = request;
            this.beans = new HashMap();
        }

        public void acceptSearchMatch(Node beanNode, IFile file, String prefix) {
            NamedNodeMap attributes = beanNode.getAttributes();
            if (attributes.getNamedItem("id") != null && attributes.getNamedItem("id").getNodeValue() != null && attributes.getNamedItem("id").getNodeValue().startsWith(prefix) && beanNode.getParentNode() != null && "beans".equals(beanNode.getParentNode().getNodeName())) {
                String replaceText = attributes.getNamedItem("id").getNodeValue();
                String relFileName = file.getProjectRelativePath().toString();
                String key = String.valueOf(replaceText) + relFileName;
                if (!this.beans.containsKey(key)) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(replaceText);
                    if (attributes.getNamedItem("class") != null) {
                        String className = attributes.getNamedItem("class").getNodeValue();
                        buf.append(" [");
                        buf.append(Signature.getSimpleName((String)className));
                        buf.append("]");
                    }
                    Image image = BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.rootbean_obj.gif");
                    CustomCompletionProposal proposal = new CustomCompletionProposal(replaceText, this.request.getReplacementBeginPosition() + 1, this.request.getReplacementLength() - 2, replaceText.length(), image, buf.toString(), null, BeansLablelProvider.createAdditionalProposalInfo(beanNode, file), 20);
                    this.request.addProposal((ICompletionProposal)proposal);
                    this.beans.put(key, proposal);
                }
            }
        }

        public void acceptSearchMatch(IBean bean, IFile file, String prefix) {
            if (bean.getElementName() != null && bean.getElementName().startsWith(prefix)) {
                String replaceText = bean.getElementName();
                String relFileName = bean.getElementResource().getProjectRelativePath().toString();
                String key = String.valueOf(replaceText) + relFileName;
                if (!this.beans.containsKey(key)) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(replaceText);
                    if (bean.getClassName() != null) {
                        String className = bean.getClassName();
                        buf.append(" [");
                        buf.append(Signature.getSimpleName((String)className));
                        buf.append("]");
                    }
                    buf.append(" - ");
                    buf.append(relFileName);
                    Image image = BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.rootbean_obj.gif");
                    BeansModelImageDescriptor descriptor = new BeansModelImageDescriptor(image, this.getBeanFlags(bean));
                    image = BeansUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
                    CustomCompletionProposal proposal = new CustomCompletionProposal(replaceText, this.request.getReplacementBeginPosition() + 1, this.request.getReplacementLength() - 2, replaceText.length(), image, buf.toString(), null, BeansLablelProvider.createAdditionalProposalInfo(bean), 10);
                    this.request.addProposal((ICompletionProposal)proposal);
                    this.beans.put(key, proposal);
                }
            }
        }

        private int getBeanFlags(IBean bean) {
            int flags = 1;
            if (!bean.isSingleton()) {
                flags |= 8;
            }
            if (bean.isAbstract()) {
                flags |= 0x20;
            }
            if (bean.isLazyInit()) {
                flags |= 0x10;
            }
            if (bean.isRootBean() && bean.getClassName() == null && bean.getParentName() == null) {
                flags |= 0x40;
            }
            return flags;
        }

        public String getText(IFile file) {
            try {
                InputStream in = file.getContents();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int read = in.read(buf);
                while (read > 0) {
                    out.write(buf, 0, read);
                    read = in.read(buf);
                }
                return out.toString();
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
            return "";
        }
    }

    class VoidMethodSearchRequestor
    extends PropertyNameSearchRequestor {
        public VoidMethodSearchRequestor(ContentAssistRequest request) {
            super(request);
        }

        public void acceptSearchMatch(IMethod method) throws CoreException {
            String returnType = method.getReturnType();
            if (Flags.isPublic((int)method.getFlags()) && !Flags.isInterface((int)method.getFlags()) && "V".equals(returnType) && method.exists() && ((IType)method.getParent()).isClass() && !method.isConstructor()) {
                this.createMethodProposal(method);
            }
        }

        protected void createMethodProposal(IMethod method) {
            try {
                String[] parameterNames = method.getParameterNames();
                String[] parameterTypes = this.getParameterTypes(method);
                String key = String.valueOf(method.getElementName()) + method.getSignature();
                if (!this.methods.containsKey(key)) {
                    String replaceText = method.getElementName();
                    String displayText = null;
                    if (parameterTypes.length > 0 && parameterNames.length > 0) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(String.valueOf(replaceText) + "(");
                        int i = 0;
                        while (i < parameterTypes.length) {
                            buf.append(String.valueOf(parameterTypes[0]) + " " + parameterNames[0]);
                            if (i < parameterTypes.length - 1) {
                                buf.append(", ");
                            }
                            ++i;
                        }
                        buf.append(") void - ");
                        buf.append(method.getParent().getElementName());
                        displayText = buf.toString();
                    } else {
                        displayText = String.valueOf(replaceText) + "() void - " + method.getParent().getElementName();
                    }
                    Image image = this.imageProvider.getImageLabel((Object)method, method.getFlags() | 2);
                    BeansJavaDocUtils utils = new BeansJavaDocUtils((IMember)method);
                    String javadoc = utils.getJavaDoc();
                    CustomCompletionProposal proposal = new CustomCompletionProposal(replaceText, this.request.getReplacementBeginPosition() + 1, this.request.getReplacementLength() - 2, replaceText.length(), image, displayText, null, javadoc, 10);
                    this.request.addProposal((ICompletionProposal)proposal);
                    this.methods.put(method.getSignature(), proposal);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    class FactoryMethodSearchRequestor
    extends VoidMethodSearchRequestor {
        private String factoryClassName;

        public FactoryMethodSearchRequestor(ContentAssistRequest request, String className) {
            super(request);
            this.factoryClassName = className;
        }

        public void acceptSearchMatch(IMethod method) throws CoreException {
            String returnType = super.getReturnType(method);
            if (Flags.isPublic((int)method.getFlags()) && !Flags.isInterface((int)method.getFlags()) && method.exists() && ((IType)method.getParent()).isClass() && this.factoryClassName.equals(returnType) && !method.isConstructor()) {
                this.createMethodProposal(method);
            }
        }

        protected void createMethodProposal(IMethod method) {
            try {
                String[] parameterNames = method.getParameterNames();
                String[] parameterTypes = super.getParameterTypes(method);
                String returnType = super.getReturnType(method);
                returnType = Signature.getSimpleName((String)returnType);
                String key = String.valueOf(method.getElementName()) + method.getSignature();
                if (!this.methods.containsKey(key)) {
                    String replaceText = method.getElementName();
                    String displayText = null;
                    if (parameterTypes.length > 0 && parameterNames.length > 0) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(String.valueOf(replaceText) + "(");
                        int i = 0;
                        while (i < parameterTypes.length) {
                            buf.append(String.valueOf(parameterTypes[0]) + " " + parameterNames[0]);
                            if (i < parameterTypes.length - 1) {
                                buf.append(", ");
                            }
                            ++i;
                        }
                        buf.append(") ");
                        buf.append(returnType);
                        buf.append(" - ");
                        buf.append(method.getParent().getElementName());
                        displayText = buf.toString();
                    } else {
                        displayText = String.valueOf(replaceText) + "() " + returnType + " - " + method.getParent().getElementName();
                    }
                    Image image = this.imageProvider.getImageLabel((Object)method, method.getFlags() | 2);
                    BeansJavaDocUtils utils = new BeansJavaDocUtils((IMember)method);
                    String javadoc = utils.getJavaDoc();
                    CustomCompletionProposal proposal = new CustomCompletionProposal(replaceText, this.request.getReplacementBeginPosition() + 1, this.request.getReplacementLength() - 2, replaceText.length(), image, displayText, null, javadoc, 10);
                    this.request.addProposal((ICompletionProposal)proposal);
                    this.methods.put(method.getSignature(), proposal);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    class PropertyNameSearchRequestor {
        public static final int METHOD_RELEVANCE = 10;
        protected ContentAssistRequest request;
        protected Map methods;
        protected JavaElementImageProvider imageProvider;

        public PropertyNameSearchRequestor(ContentAssistRequest request) {
            this.request = request;
            this.methods = new HashMap();
            this.imageProvider = new JavaElementImageProvider();
        }

        public void acceptSearchMatch(IMethod method) throws CoreException {
            int parameterCount = method.getNumberOfParameters();
            String returnType = method.getReturnType();
            if (Flags.isPublic((int)method.getFlags()) && !Flags.isInterface((int)method.getFlags()) && parameterCount == 1 && "V".equals(returnType) && method.exists() && ((IType)method.getParent()).isClass() && !method.isConstructor()) {
                this.createMethodProposal(method);
            }
        }

        protected void createMethodProposal(IMethod method) {
            try {
                String[] parameterNames = method.getParameterNames();
                String[] parameterTypes = this.getParameterTypes(method);
                String key = String.valueOf(method.getElementName()) + method.getSignature();
                if (!this.methods.containsKey(key)) {
                    String replaceText = this.getPropertyNameFromMethodName(method);
                    String displayText = String.valueOf(replaceText) + " - " + method.getParent().getElementName() + "." + method.getElementName() + "(" + parameterTypes[0] + " " + parameterNames[0] + ")";
                    Image image = this.imageProvider.getImageLabel((Object)method, method.getFlags() | 2);
                    BeansJavaDocUtils utils = new BeansJavaDocUtils((IMember)method);
                    String javadoc = utils.getJavaDoc();
                    CustomCompletionProposal proposal = new CustomCompletionProposal(replaceText, this.request.getReplacementBeginPosition() + 1, this.request.getReplacementLength() - 2, replaceText.length(), image, displayText, null, javadoc, 10);
                    this.request.addProposal((ICompletionProposal)proposal);
                    this.methods.put(key, method);
                }
            }
            catch (JavaModelException javaModelException) {}
        }

        protected String getPropertyNameFromMethodName(IMethod method) {
            String replaceText = method.getElementName().substring("set".length(), method.getElementName().length());
            if (replaceText != null) {
                char c = replaceText.charAt(0);
                replaceText = replaceText.substring(1, replaceText.length());
                replaceText = String.valueOf(Character.toLowerCase(c)) + replaceText;
            }
            return replaceText;
        }

        protected String[] getParameterTypes(IMethod method) {
            try {
                String[] parameterQualifiedTypes = Signature.getParameterTypes((String)method.getSignature());
                int length = parameterQualifiedTypes == null ? 0 : parameterQualifiedTypes.length;
                String[] parameterPackages = new String[length];
                int i = 0;
                while (i < length) {
                    parameterQualifiedTypes[i] = parameterQualifiedTypes[i].replace('/', '.');
                    parameterPackages[i] = Signature.getSignatureSimpleName((String)parameterQualifiedTypes[i]);
                    ++i;
                }
                return parameterPackages;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (JavaModelException javaModelException) {}
            return null;
        }

        protected String getReturnType(IMethod method) {
            try {
                String parameterQualifiedTypes = Signature.getReturnType((String)method.getSignature());
                IType type = (IType)method.getParent();
                String tempString = Signature.getSignatureSimpleName((String)parameterQualifiedTypes);
                String[][] parameterPackages = type.resolveType(tempString);
                if (parameterPackages != null) {
                    return String.valueOf(parameterPackages[0][0]) + "." + parameterPackages[0][1];
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (JavaModelException javaModelException) {}
            return null;
        }
    }

    final class TypeSearchRequestor
    extends SearchRequestor {
        public static final int CLASS_RELEVANCE = 90;
        public static final int INTERFACE_RELEVANCE = 90;
        public static final int PACKAGE_RELEVANCE = 10;
        private ContentAssistRequest request;
        private Map types;
        private boolean invertOrder = false;
        private JavaElementImageProvider imageProvider;

        public TypeSearchRequestor(ContentAssistRequest request, boolean invertOrder) {
            this.request = request;
            this.types = new HashMap();
            this.invertOrder = invertOrder;
            this.imageProvider = new JavaElementImageProvider();
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            IPackageFragment packageFragment;
            if (match.getElement() instanceof IType) {
                IType type = (IType)match.getElement();
                if (type.exists()) {
                    this.createTypeProposal(type);
                }
            } else if (match.getElement() instanceof IPackageFragment && (packageFragment = (IPackageFragment)match.getElement()).exists()) {
                this.createPackageProposal(packageFragment);
            }
        }

        private void createPackageProposal(IPackageFragment pkg) {
            String displayText = pkg.getElementName();
            if (!this.types.containsKey(displayText)) {
                Image image = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
                int relevance = 10;
                if (this.invertOrder) {
                    relevance = -10;
                }
                CustomCompletionProposal proposal = new CustomCompletionProposal(displayText, this.request.getReplacementBeginPosition() + 1, this.request.getReplacementLength() - 2, displayText.length(), image, displayText, null, null, relevance);
                this.request.addProposal((ICompletionProposal)proposal);
                this.types.put(displayText, proposal);
            }
        }

        private void createTypeProposal(IType type) {
            try {
                String displayText = String.valueOf(type.getElementName()) + " - " + type.getPackageFragment().getElementName();
                if (!this.types.containsKey(displayText)) {
                    String replaceText = type.getFullyQualifiedName();
                    Image image = null;
                    int relevance = -1;
                    if (type.isInterface()) {
                        relevance = 90;
                        if (this.invertOrder) {
                            relevance = -90;
                        }
                    } else {
                        relevance = 90;
                        if (this.invertOrder) {
                            relevance = -90;
                        }
                    }
                    BeansJavaDocUtils utils = new BeansJavaDocUtils((IMember)type);
                    String javadoc = utils.getJavaDoc();
                    image = this.imageProvider.getImageLabel((Object)type, type.getFlags() | 2);
                    CustomCompletionProposal proposal = new CustomCompletionProposal(replaceText, this.request.getReplacementBeginPosition() + 1, this.request.getReplacementLength() - 2, replaceText.length(), image, displayText, null, javadoc, relevance);
                    this.request.addProposal((ICompletionProposal)proposal);
                    this.types.put(displayText, proposal);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

