/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;

public class BeansEditorUtils {
    public static List getBeansFromConfigSets(IFile file) {
        ArrayList beans = new ArrayList();
        HashMap<String, IBeansConfig> configsMap = new HashMap<String, IBeansConfig>();
        IBeansProject project = BeansCorePlugin.getModel().getProject(file.getProject());
        Iterator configSets = project.getConfigSets().iterator();
        while (configSets.hasNext()) {
            IBeansConfigSet configSet = (IBeansConfigSet)configSets.next();
            if (!configSet.hasConfig(file)) continue;
            Iterator configs = configSet.getConfigs().iterator();
            while (configs.hasNext()) {
                IResource resource;
                String beansConfigName = (String)configs.next();
                IBeansConfig beansConfig = project.getConfig(beansConfigName);
                if (beansConfig == null || configsMap.containsKey((resource = beansConfig.getElementResource()).getName()) || resource.getFullPath().equals((Object)file.getFullPath())) continue;
                configsMap.put(resource.getName(), beansConfig);
            }
        }
        Iterator paths = configsMap.keySet().iterator();
        while (paths.hasNext()) {
            IBeansConfig beansConfig = (IBeansConfig)configsMap.get((String)paths.next());
            beans.addAll(beansConfig.getBeans());
        }
        return beans;
    }
}

