/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistry;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistryImpl;
import org.eclipse.wst.xml.ui.internal.JobStatusLineHelper;
import org.osgi.framework.BundleContext;

public class BeansEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.beans.ui.editor";
    private static final String RESOURCE_NAME = "org.springframework.ide.eclipse.beans.ui.editor.messages";
    private static final String TEMPLATES_KEY = "org.springframework.ide.eclipse.beans.ui.editor.templates";
    private static BeansEditorPlugin plugin;
    private ResourceBundle resourceBundle;
    private ContextTypeRegistry contextTypeRegistry;
    private TemplateStore templateStore;

    public BeansEditorPlugin() {
        plugin = this;
        JobStatusLineHelper.init();
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException e) {
            BeansEditorPlugin.log(e);
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static BeansEditorPlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public AdapterFactoryRegistry getAdapterFactoryRegistry() {
        return AdapterFactoryRegistryImpl.getInstance();
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.contextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType("org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.all");
            registry.addContextType("org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.property");
            registry.addContextType("org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.bean");
            this.contextTypeRegistry = registry;
        }
        return this.contextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), TEMPLATES_KEY);
            try {
                this.templateStore.load();
            }
            catch (IOException e) {
                BeansEditorPlugin.log(e);
            }
        }
        return this.templateStore;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return BeansEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        return BeansEditorPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        return BeansEditorPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = BeansEditorPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                BeansEditorPlugin.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public static String getFormattedMessage(String key, String arg) {
        return BeansEditorPlugin.getFormattedMessage(key, new String[]{arg});
    }

    public static String getFormattedMessage(String key, String[] args) {
        return MessageFormat.format(BeansEditorPlugin.getResourceString(key), args);
    }

    public static boolean isDebug(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void log(IStatus status) {
        BeansEditorPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = BeansEditorPlugin.createErrorStatus(message, exception);
        BeansEditorPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        BeansEditorPlugin.getDefault().getLog().log(BeansEditorPlugin.createErrorStatus(BeansEditorPlugin.getResourceString("Plugin.internal_error"), exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }
}

