
#include "defines.h"
#include "frend.h"
#include "interface.h"
#include "misc.h"
#include "skins.h"
#include <time.h>
#include <string>

#ifndef S9X_PROFILER_H
#define S9X_PROFILER_H

#define S9X_PROFILE_NAME_LEN 50
#define S9X_PROFILE_ARGS_LEN 240

enum s9x_ProfileState {
  S9X_PROFILE_STATE_DEFAULT,
    S9X_PROFILE_STATE_SAVED,
    S9X_PROFILE_STATE_TEMP,
    S9X_PROFILE_STATE_DELETED
};


class s9x_Profiler :	public fr_Window, private fr_Listener {
 private:
  fr_Element		*Logo;
  fr_Box		*LogoBox;
  fr_Text		ProfName;
  fr_Button		BtnOK, BtnCancel;
  fr_Button		BtnApply, BtnSave, BtnDef, BtnDel;
  fr_Image              def_img, sav_img, del_img, tmp_img;
  fr_Box		BtnBox;
  fr_DataTable		ProfileList;
  s9x_File		ProfileFile;
  bool			InLoading;
  void			CreateProfileList();
  void			CreateButtonBar();
  const char		*NewProfileName;
  time_t		LastModified;
  int			LoadList();
  void			SetProfile(int r, s9x_ProfileState s, const std::string& N, const std::string& A);
  void			SetRowState(int row, s9x_ProfileState s);
  s9x_ProfileState	GetRowState(int row);
  void			ChangeState(s9x_ProfileState s);
  std::string		GetRowName(int row);
  std::string		GetRowArgsEncoded(int row);
  fr_ArgList*		GetRowArgList(int row);
  int			GetDefaultRow();
  int			GetSelectedRow();
  void			ApplyRow(int row);
  void			Apply();
  int			SaveList();
  void			EventOccurred(fr_Event*e);
 public:
			s9x_Profiler(s9x_Interface*parent);
			~s9x_Profiler();
  void			SetVisibility(bool s);
  void			RowSelected(int row);
  void			NameUpdated();
  void			ApplyDefaultProfile();
  void			ApplySkin(s9x_Skin*S);
};
#endif
