
#include "driver.h"

static tilemap *bg_layer,*fg_layer,*tx_layer;
UINT16 *raiden_back_data,*raiden_fore_data,*raiden_scroll_ram;

static int flipscreen,alternate;

/******************************************************************************/

WRITE16_HANDLER( raiden_background_w )
{
	COMBINE_DATA(&raiden_back_data[offset]);
	tilemap_mark_tile_dirty(bg_layer, offset);
}

WRITE16_HANDLER( raiden_foreground_w )
{
	COMBINE_DATA(&raiden_fore_data[offset]);
	tilemap_mark_tile_dirty(fg_layer, offset);
}

WRITE16_HANDLER( raiden_text_w )
{
	COMBINE_DATA(&videoram16[offset]);
	tilemap_mark_tile_dirty(tx_layer, offset);
}

static TILE_GET_INFO( get_back_tile_info )
{
	int tile=raiden_back_data[tile_index];
	int color=tile >> 12;

	tile=tile&0xfff;

	SET_TILE_INFO(
			1,
			tile,
			color,
			0);
}

static TILE_GET_INFO( get_fore_tile_info )
{
	int tile=raiden_fore_data[tile_index];
	int color=tile >> 12;

	tile=tile&0xfff;

	SET_TILE_INFO(
			2,
			tile,
			color,
			0);
}

static TILE_GET_INFO( get_text_tile_info )
{
	int tiledata = videoram16[tile_index];
	int tile = (tiledata & 0xff) | ((tiledata >> 6) & 0x300);
	int color = (tiledata >> 8) & 0x0f;

	SET_TILE_INFO(
			0,
			tile,
			color,
			0);
}

VIDEO_START( raiden )
{
	bg_layer = tilemap_create(get_back_tile_info,tilemap_scan_cols,TILEMAP_TYPE_PEN,     16,16,32,32);
	fg_layer = tilemap_create(get_fore_tile_info,tilemap_scan_cols,TILEMAP_TYPE_PEN,16,16,32,32);
	tx_layer = tilemap_create(get_text_tile_info,tilemap_scan_cols,TILEMAP_TYPE_PEN,8,8,32,32);
	alternate=0;

	tilemap_set_transparent_pen(fg_layer,15);
	tilemap_set_transparent_pen(tx_layer,15);
}

VIDEO_START( raidena )
{
	bg_layer = tilemap_create(get_back_tile_info,tilemap_scan_cols,TILEMAP_TYPE_PEN,     16,16,32,32);
	fg_layer = tilemap_create(get_fore_tile_info,tilemap_scan_cols,TILEMAP_TYPE_PEN,16,16,32,32);
	tx_layer = tilemap_create(get_text_tile_info,tilemap_scan_rows,TILEMAP_TYPE_PEN,8,8,32,32);
	alternate=1;

	tilemap_set_transparent_pen(fg_layer,15);
	tilemap_set_transparent_pen(tx_layer,15);
}

WRITE16_HANDLER( raiden_control_w )
{
	/* All other bits unknown - could be playfield enables */

	/* Flipscreen */
	if (offset==3 && ACCESSING_LSB) {
		flipscreen=data&0x2;
		tilemap_set_flip(ALL_TILEMAPS,flipscreen ? (TILEMAP_FLIPY | TILEMAP_FLIPX) : 0);
	}
}

static void draw_sprites(running_machine *machine, mame_bitmap *bitmap,const rectangle *cliprect,int pri_mask)
{
	int offs,fx,fy,x,y,color,sprite;

	for (offs = 0x1000/2-4;offs >= 0;offs -= 4)
	{
		if (!(pri_mask&(buffered_spriteram16[offs+2]>>8))) continue;

		fx    = buffered_spriteram16[offs+0] & 0x2000;
		fy    = buffered_spriteram16[offs+0] & 0x4000;
		color = (buffered_spriteram16[offs+0] & 0x0f00) >> 8;
		y = buffered_spriteram16[offs+0] & 0x00ff;

		sprite = buffered_spriteram16[offs+1];
		sprite &= 0x0fff;

		x = buffered_spriteram16[offs+2] & 0xff;
		if (buffered_spriteram16[offs+2] & 0x100) x=0-(0x100-x);

		if (flipscreen) {
			x=240-x;
			y=240-y;
			if (fx) fx=0; else fx=1;
			if (fy) fy=0; else fy=1;
		}

		drawgfx(bitmap,machine->gfx[3],
				sprite,
				color,fx,fy,x,y,
				cliprect,TRANSPARENCY_PEN,15);
	}
}

VIDEO_UPDATE( raiden )
{
	/* Setup the tilemaps, alternate version has different scroll positions */
	if (!alternate) {
		tilemap_set_scrollx( bg_layer,0, raiden_scroll_ram[0]);
		tilemap_set_scrolly( bg_layer,0, raiden_scroll_ram[1]);
		tilemap_set_scrollx( fg_layer,0, raiden_scroll_ram[2]);
		tilemap_set_scrolly( fg_layer,0, raiden_scroll_ram[3]);
	}
	else {
		tilemap_set_scrolly( bg_layer,0, ((raiden_scroll_ram[0x01]&0x30)<<4)+((raiden_scroll_ram[0x02]&0x7f)<<1)+((raiden_scroll_ram[0x02]&0x80)>>7) );
		tilemap_set_scrollx( bg_layer,0, ((raiden_scroll_ram[0x09]&0x30)<<4)+((raiden_scroll_ram[0x0a]&0x7f)<<1)+((raiden_scroll_ram[0x0a]&0x80)>>7) );
		tilemap_set_scrolly( fg_layer,0, ((raiden_scroll_ram[0x11]&0x30)<<4)+((raiden_scroll_ram[0x12]&0x7f)<<1)+((raiden_scroll_ram[0x12]&0x80)>>7) );
		tilemap_set_scrollx( fg_layer,0, ((raiden_scroll_ram[0x19]&0x30)<<4)+((raiden_scroll_ram[0x1a]&0x7f)<<1)+((raiden_scroll_ram[0x1a]&0x80)>>7) );
	}

	tilemap_draw(bitmap,cliprect,bg_layer,0,0);

	/* Draw sprites underneath foreground */
	draw_sprites(machine,bitmap,cliprect,0x40);
	tilemap_draw(bitmap,cliprect,fg_layer,0,0);

	/* Rest of sprites */
	draw_sprites(machine,bitmap,cliprect,0x80);

	/* Text layer */
	tilemap_draw(bitmap,cliprect,tx_layer,0,0);
	return 0;
}
