#include "rpggame.h"

///base functions
void rpgitem::resetmdl()
{
	temp.mdl = game::items.inrange(base) ? game::items[base]->mdl : "rc";
}

void rpgitem::update()
{
	resetmdl();
	temp.alpha = 1;
	temp.light = vec4(0, 0, 0, 0);

	moveplayer(this, 2, false);
	entities::touchents(this);
}

void rpgitem::applyeffects(statusgroup *g, float mag, bool instant, rpgent *owner)
{
	loopv(g->effects)
	{
		switch(g->effects[i]->type)
		{
			case STATUS_INVIS:
			{
				if(instant)
					continue;

				status_generic *gen = (status_generic *) g->effects[i];
				temp.alpha -= gen->strength / 100.0f * mag;

				continue;
			}
			case STATUS_LIGHT:
			{
				if(instant)
					continue;

				status_light *light = (status_light *) g->effects[i];
				vec4 l = vec4(light->colour, light->radius).mul(mag);

				temp.light.add(l);

				continue;
			}
			case STATUS_POLYMORPH:
			{
				if(instant)
					continue;

				status_polymorph *poly = (status_polymorph *) g->effects[i];
				temp.mdl = poly->mdl;
				continue;
			}
		}
	}
}

void rpgitem::render(bool mainpass)
{
	rendermodel(&light, temp.mdl ? temp.mdl : (game::items.inrange(base) ? game::items[base]->mdl : "rc") , ANIM_MAPMODEL|ANIM_LOOP, vec(o).sub(vec(0, 0, eyeheight)), yaw, pitch, 0, MDL_SHADOW|MDL_CULL_VFC|MDL_CULL_DIST|MDL_CULL_OCCLUDED|MDL_LIGHT, NULL, NULL, 0, 0, temp.alpha);
}

const char *rpgitem::getname() const
{
	if(game::items.inrange(base))
	{
		item_base *i = game::items[base];
		if(i->name)
			return i->name;
	}

	return "Tough Cookie";
}

int rpgitem::getscript()
{
	if(game::items.inrange(base))
		return game::items[base]->script;
	conoutf("WARNING: item %p uses non existant item base %i", this, base);
	return -1;
}

int rpgitem::getitemcount(int i)
{
	if(i == base)
		return quantity;
	return 0;
}

void rpgitem::hit(rpgent *attacker, use_weapon *weapon, use_weapon *ammo, float mul, vec dir)
{
	if(DEBUG_ENT)
		conoutf(CON_DEBUG, "DEBUG: ent %p hit by %p, applying effects from %p %p with mul %f", this, attacker, weapon, ammo, mul);

	if(!game::statuses.inrange(weapon->status) || (ammo && !game::statuses.inrange(ammo->status)))
	{
		conoutf(CON_ERROR, "ERROR: out of range effect, not applying: wep %p %i ammo %p %i", weapon, weapon->status, ammo, ammo ? ammo->status : 0);
		return;
	}

	seffects.add(new victimeffect(attacker, weapon->duration, weapon->status, mul));
	vel.add(vec(dir).mul(weapon->kickback));

	if(ammo)
	{
		seffects.add(new victimeffect(attacker, ammo->duration, ammo->status, mul));
		vel.add(vec(dir).mul(ammo->kickback));
	}

	rpgscript::doentscript(this, attacker, SCR_HIT);
}