#include "rpggame.h"

//essentially a collection of functions to greatly simplify the use of assorted effects; while making the aesthetics more consistent

namespace rpgeffect
{
	FVARP(partmul, .1, 1, 10);

	void setvars(effect *e, int type, int &fade, int &gravity, int &part, int &colour, float &size, int &num)
	{
		num = 1;
		switch(type)
		{
			default:
			case PROJ:
				fade = 1;
				gravity = 0;
				part = e->projpart;
				colour = e->projpartcol;
				size *= e->projpartsize;
				break;

			case TRAIL_SINGLE:
				num = 15;
			case TRAIL:
				fade = e->trailpartfade;
				gravity = e->trailpartgrav;
				part = e->trailpart;
				colour = e->trailpartcol;
				size *= e->trailpartsize;
				break;

			case DEATH:
				num = 20;
			case DEATH_PROLONG:
				fade = e->deathpartfade;
				gravity = e->deathpartgrav;
				part = e->deathpart;
				colour = e->deathpartcol;
				size *= e->deathpartsize;
				break;
		}
		if(type == DEATH_PROLONG)
		{
			if(e->deathpart == PART_EXPLOSION || e->deathpart == PART_EXPLOSION_BLUE)
				fade = 1;
		}
	}

	void drawsphere(effect *e, vec &o, float radius, float size, int type, int elapse)
	{
		if(!e || size == 0)
			return;
		if(size < 0)
			size = 1;

		int fade, gravity, part, colour, num;
		setvars(e, type, fade, gravity, part, colour, size, num);
		num *= .1 * radius / size * partmul * (elapse ? (float) elapse / 17 : 1);
		if(elapse && !num && rnd(int(10 / partmul))) return; //sometimes particles should not be drawn
		num = max(1, num);

		switch(part)
		{
			case PART_EXPLOSION:
			case PART_EXPLOSION_BLUE:
				particle_fireball(o, radius, part, fade, colour, size);
				break;
			case PART_STREAK:
			case PART_LIGHTNING:
				if(!curtime) break;
				loopi(num)
				{
					vec offset = vec(rnd(360) * RAD, rnd(360) * RAD).mul(radius);
					particle_flare(vec(o).sub(offset), vec(o).add(offset), fade, part, colour, size);
				}
				break;
			default:
				loopi(num)
				{
					vec offset = vec(rnd(360) * RAD, rnd(360) * RAD).mul(radius);
					particle_splash(part, 2, fade, offset.add(o), colour, size, max<int>(1, radius), gravity);
				}
				break;
		}
	}

	void drawsplash(effect *e, vec &o, float radius, float size, int type, int elapse)
	{
		if(!e || size == 0)
			return;
		if(size < 0)
			size = 1;

		int fade, gravity, part, colour, num;
		setvars(e, type, fade, gravity, part, colour, size, num);
		num *= .1 * radius / size * partmul * (elapse ? (float) elapse / 17 : 1);
		if(elapse && !num && rnd(int(10 / partmul))) return; //sometimes particles should not be drawn
		num = max(1, num);

		switch(part)
		{
			case PART_EXPLOSION:
			case PART_EXPLOSION_BLUE:
				particle_fireball(o, radius, part, fade, colour, size);
				break;
			case PART_STREAK:
			case PART_LIGHTNING:
				if(!curtime) break;
				num = (num / 2 + num % 2);
				loopi(num)
				{
					vec offset = vec(rnd(360) * RAD, (90 - rnd(180)) * RAD).mul(radius);
					particle_flare(vec(o).sub(offset), vec(o).add(offset), fade, part, colour, size);
				}
				break;
			default:
				particle_splash(part, num, fade, o, colour, size, max<int>(1, radius), gravity);
				break;
		}
	}

	VARP(linemaxsteps, 8, 32, 1024);

	bool drawline(effect *e, vec &from, vec &to, float size, int type, int elapse)
	{
		if(!e || size == 0)
			return false;
		if(size < 0)
			size = 1;

		int fade, gravity, part, colour, num;
		setvars(e, type, fade, gravity, part, colour, size, num);
		num *= from.dist(to) / (10 * size) * partmul * (elapse ? (float) elapse / 17 : 1);
		if(part == PART_STREAK || part == PART_LIGHTNING)
			num /= 2;

		if(!num)
			return false;
		num = min(num, linemaxsteps);

		vec delta = vec(to).sub(from).div(num);

		loopi(num)
		{
			switch(part)
			{
				case PART_EXPLOSION:
				case PART_EXPLOSION_BLUE:
					particle_fireball(from, size * 2, part, fade, colour, size * 2);
					break;
				case PART_STREAK:
				case PART_LIGHTNING:
				{
					if(!curtime) return false;
					vec start = vec(rnd(360) * RAD, rnd(360) * RAD).mul(4 * size).add(from);
					vec end = vec(delta).mul(1.5).add(start);

					particle_flare(start, end, fade, part, colour, size);
					break;
				}
				default:
					particle_splash(part, 2, fade, from, colour, size, max<int>(1, size * 5), gravity);
					break;
			}
			from.add(delta);
		}

		return true;
	}

	void drawaura(effect *e, rpgent *d, float size, int type, int elapse)
	{
		if(!e || size == 0)
			return;
		if(size < 0)
			size = 1;

		int fade, gravity, part, colour, num;
		setvars(e, type, fade, gravity, part, colour, size, num);

		num *= .2 * PI * d->radius / size * partmul * (elapse ? (float) elapse / 17 : 1);
		if(elapse && !num && rnd(int(10 / partmul))) return; //sometimes particles should not be drawn
		num = max<int>(1, num);

		loopi(num)
		{
			vec pos = vec(rnd(360) * RAD, 0).mul(d->radius + size).add(d->feetpos());
			switch(part)
			{
				case PART_EXPLOSION:
				case PART_EXPLOSION_BLUE:
					particle_fireball(pos, size, part, fade, colour, size);
					break;
				case PART_STREAK:
				case PART_LIGHTNING:
					if(!curtime) return;
					particle_flare(pos, vec(0, 0, d->eyeheight + d->aboveeye).add(pos), fade, part, colour, size);
					break;
				default:
					if(gravity >= 0)
						pos.add(vec(0, 0, d->eyeheight + d->aboveeye));

					particle_splash(part, 2, fade, pos, colour, size, max<int>(1, size * 2), gravity);
					break;
			}
		}
	}

	void drawcircle(effect *e, vec &o, vec dir, vec &axis, int angle, float radius, float size, int type, int elapse)
	{
		if(!e || size == 0)
			return;
		if(size < 0)
			size = 1;

		int fade, gravity, part, colour, num;
		setvars(e, type, fade, gravity, part, colour, size, num);

		num *= angle * partmul / size / 30 * (elapse ? (float) elapse / 17 : 1);
		num = max<int>(1, num);

		loopi(num)
		{
			vec ray = vec(dir).mul(radius);
			switch(part)
			{
				case PART_EXPLOSION:
				case PART_EXPLOSION_BLUE:
					ray.mul(rnd(101)/100.f).add(o);
					particle_fireball(ray, size, part, fade, colour, size);
					break;
				case PART_STREAK:
				case PART_LIGHTNING:
					if(!curtime) return;
					particle_flare(o, ray.add(o), fade, part, colour, size);
					break;
				default:
					ray.mul(rnd(101)/100.f).add(o);
					particle_splash(part, 2, fade, ray, colour, size, max<int>(1, size * 2), gravity);
					break;
			}
			dir.rotate(angle * RAD / num, axis);
		}
	}

	void drawcircle(rpgent *d, use_weapon *wep, float size, int type, int elapse)
	{
		vec dir;
		vec axis;
		if(wep->target == T_HORIZ)
		{
			dir = vec((d->yaw - wep->angle/2) * RAD, d->pitch * RAD);
			axis = vec(0, 0, 1);
		}
		else
		{
			dir = vec(d->yaw * RAD, (d->pitch - wep->angle/2) * RAD);
			axis = vec(d->yaw * RAD, d->pitch * RAD).rotate_around_z(-90 * RAD);
		}

		vec o = vec(d->o).sub(vec(0, 0, d->eyeheight / 2));
		drawcircle(game::effects[wep->effect], o, dir, axis, wep->angle, d->radius + wep->range, size, type, elapse);
	}
}
