#include "rpggame.h"

/*
This file is configures the following items

* scripts
* particle effects
* status effect groups
* item bases
* character bases
* factions

This file is also used to declare the following items (but disallows subsequent changes)

* Global Variables

*/

namespace game
{
	#define CHECK(x, v, c) \
		static x *check ## x (int i) \
		{ \
			if(v.inrange(i)) \
				return v[i]; \
			if(i <= 0) \
				conoutf(CON_ERROR, "ERROR: no " #v " exists, use r_" c "_new to create"); \
			else  \
				conoutf(CON_ERROR, "ERROR: " #x " %i is out of range", i); \
			return NULL; \
		}


	CHECK(script, scripts, "script")
	CHECK(effect, effects, "effect")
	CHECK(statusgroup, statuses, "status")
	CHECK(item_base, items, "item")
	CHECK(recipe, recipes, "recipe");
	CHECK(ammotype, ammotypes, "ammo")
	CHECK(char_base, chars, "char")
	CHECK(faction, factions, "faction")
	CHECK(object_base, objects, "object")
	CHECK(mapscript, mapscripts, "mapscript")

	#undef CHECK

	static use *checkuse(item_base *item, int type, int i)
	{
		if(item->uses.inrange(i))
		{
			if(item->uses[i]->type >= type)
				return item->uses[i];

			conoutf(CON_ERROR, "ERROR: item->uses[i] is of incorrect type");
		}
		else
		{
			if(i <= 0)
				conoutf(CON_ERROR, "ERORR: no uses have been declared, use r_item_use_new_{armour,consumable,weapon} to create");
			else
				conoutf(CON_ERROR, "ERROR: item->uses[%i] is out of range", i);
		}
		return NULL;
	}

	/// examples
	/// NOTE: the following variable names are reserved: i, f, s, x, y, z
	/// #define START(n, f, a, b)  ICOMMAND(r_script ## n, f, a, b)
	/// #define INIT script *e = checkscript(scripts.length() -1)       parent variable must always be named e, e->var is modified (see below for var)
	/// #define DEBUG "scripts[%i]"
	/// #define DEBUG_IND scripts.length() - 1

	#define INTN(name, var, min, max) \
		START(name, "i", (int *i), \
			INIT \
			if(!e) return; \
			e->var = clamp((int) max, (int) min, *i); \
			if(e->var != *i) \
				conoutf("WARNING: value provided for " DEBUG "->" #var "exceeded limits", DEBUG_IND); \
			if(DEBUG_CONF || e->var != *i) \
				conoutf(DEBUG "->" #var "= %i (%.8X)", DEBUG_IND, e->var, e->var); \
		)
	#define INT(var, min, max) INTN(var, var, min, max)

	#define FLOATN(name, var, min, max) \
		START(name, "f", (float *f), \
			INIT \
			if(!e) return; \
			e->var = clamp((float) max, (float) min, *f); \
			if(e->var != *f) \
				conoutf("WARNING: value provided for " DEBUG "->" #var "exceeded limits", DEBUG_IND); \
			if(DEBUG_CONF || e->var != *f) \
				conoutf(DEBUG "->" #var "= %g", DEBUG_IND, e->var); \
		)
	#define FLOAT(var, min, max) FLOATN(var, var, min, max)

	#define STRINGN(name, var) \
		START(name, "s", (const char *s), \
			INIT \
			if(!e) return; \
			if(e->var) delete[] e->var; \
			e->var = newstring(s); \
			if(DEBUG_CONF) \
				conoutf(CON_DEBUG, DEBUG "->" #var "= %s", DEBUG_IND, e->var); \
		)
	#define STRING(var) STRINGN(var, var)

	#define VECN(name, var, l1, l2, l3, h1, h2, h3) \
		START(name, "fff", (float *x, float *y, float *z), \
			INIT \
			if(!e) return; \
			e->var.x = clamp((float)h1, (float)l1, *x); \
			e->var.y = clamp((float)h2, (float)l2, *y); \
			e->var.z = clamp((float)h3, (float)l3, *z); \
			if(e->var.x != *x || e->var.y != *y || e->var.z != *z) \
				conoutf("WARNING: value provided for " DEBUG "->" #var "exceeded limits", DEBUG_IND); \
			if(DEBUG_CONF || e->var.x != *x || e->var.y != *y || e->var.z != *z) \
				conoutf(DEBUG "->" #var "= (%g, %g, %g)", DEBUG_IND, e->var.x, e->var.y, e->var.z); \
		)
	#define VEC(var, l1, l2, l3, h1, h2, h3) VECN(var, var, l1, l2, l3, h1, h2, h3)

	#define BOOLN(name, var) \
		START(name, "i", (int *i), \
			INIT \
			if(!e) return; \
			e->var = *i != 0; \
			if(DEBUG_CONF) \
				conoutf(CON_DEBUG, DEBUG "->" #var "= %i", DEBUG_IND, e->var); \
		)

	#define BOOL(var) BOOLN(var, var)

	#define STATREQ(var) \
		INTN(var ## _strength, var.attrs[STAT_STRENGTH], 1, 100) \
		INTN(var ## _endurance, var.attrs[STAT_ENDURANCE], 1, 100) \
		INTN(var ## _agility, var.attrs[STAT_AGILITY], 1, 100) \
		INTN(var ## _charisma, var.attrs[STAT_WISDOM], 1, 100) \
		INTN(var ## _wisdom, var.attrs[STAT_WISDOM], 1, 100) \
		INTN(var ## _intelligence, var.attrs[STAT_INTELLIGENCE], 1, 100) \
		INTN(var ## _luck, var.attrs[STAT_LUCK], 1, 100) \
		\
		INTN(var ## _armour, var.skills[SKILL_ARMOUR], 0, 100) \
		INTN(var ## _diplomacy, var.skills[SKILL_DIPLOMACY], 0, 100) \
		INTN(var ## _magic, var.skills[SKILL_MAGIC], 0, 100) \
		INTN(var ## _marksman, var.skills[SKILL_MARKSMAN], 0, 100) \
		INTN(var ## _melee, var.skills[SKILL_MELEE], 0, 100) \
		INTN(var ## _stealth, var.skills[SKILL_STEALTH], 0, 100) \

	#define STATS(var) \
		INTN(var ## _level, var.level, 1, 1000) \
		INTN(var ## _experience, var.experience, 0, 0x7FFFFFFF) \
		INTN(var ## _points, var.points, 0, 500) \
		INTN(var ## _strength, var.baseattrs[STAT_STRENGTH], 1, 100) \
		INTN(var ## _endurance, var.baseattrs[STAT_ENDURANCE], 1, 100) \
		INTN(var ## _agility, var.baseattrs[STAT_AGILITY], 1, 100) \
		INTN(var ## _charisma, var.baseattrs[STAT_WISDOM], 1, 100) \
		INTN(var ## _wisdom, var.baseattrs[STAT_WISDOM], 1, 100) \
		INTN(var ## _intelligence, var.baseattrs[STAT_INTELLIGENCE], 1, 100) \
		INTN(var ## _luck, var.baseattrs[STAT_LUCK], 1, 100) \
		\
		INTN(var ## _armour, var.baseskills[SKILL_ARMOUR], 0, 100) \
		INTN(var ## _diplomacy, var.baseskills[SKILL_DIPLOMACY], 0, 100) \
		INTN(var ## _magic, var.baseskills[SKILL_MAGIC], 0, 100) \
		INTN(var ## _marksman, var.baseskills[SKILL_MARKSMAN], 0, 100) \
		INTN(var ## _melee, var.baseskills[SKILL_MELEE], 0, 100) \
		INTN(var ## _stealth, var.baseskills[SKILL_STEALTH], 0, 100) \
		\
		INTN(var ## _fire_thresh, var.bonusthresh[ATTACK_FIRE], -500, 500) \
		INTN(var ## _water_thresh, var.bonusthresh[ATTACK_WATER], -500, 500) \
		INTN(var ## _air_thresh, var.bonusthresh[ATTACK_AIR], -500, 500) \
		INTN(var ## _earth_thresh, var.bonusthresh[ATTACK_EARTH], -500, 500) \
		INTN(var ## _magic_thresh, var.bonusthresh[ATTACK_MAGIC], -500, 500) \
		INTN(var ## _slash_thresh, var.bonusthresh[ATTACK_SLASH], -500, 500) \
		INTN(var ## _blunt_thresh, var.bonusthresh[ATTACK_BLUNT], -500, 500) \
		INTN(var ## _pierce_thresh, var.bonusthresh[ATTACK_PIERCE], -500, 500) \
		\
		INTN(var ## _fire_resist, var.bonusresist[ATTACK_FIRE], -200, 100) \
		INTN(var ## _water_resist, var.bonusresist[ATTACK_WATER], -200, 100) \
		INTN(var ## _air_resist, var.bonusresist[ATTACK_AIR], -200, 100) \
		INTN(var ## _earth_resist, var.bonusresist[ATTACK_EARTH], -200, 100) \
		INTN(var ## _magic_resist, var.bonusresist[ATTACK_MAGIC], -200, 100) \
		INTN(var ## _slash_resist, var.bonusresist[ATTACK_SLASH], -200, 100) \
		INTN(var ## _blunt_resist, var.bonusresist[ATTACK_BLUNT], -200, 100) \
		INTN(var ## _pierce_resist, var.bonusresist[ATTACK_PIERCE], -200, 100) \
		\
		INTN(var ## _maxspeed, var.bonusmovespeed, 0, 100) \
		INTN(var ## _jumpvel, var.bonusjumpvel, 0, 100) \
		INTN(var ## _maxhealth, var.bonushealth, 0, 100000) \
		INTN(var ## _maxmana, var.bonusmana, 0, 100000) \
		INTN(var ## _crit, var.bonuscrit, -100, 100) \
		FLOATN(var ## _healthregen, var.bonushregen, 0, 1000) \
		FLOATN(var ## _manaregen, var.bonusmregen, 0, 1000) \

	#define START(n, f, a, b) ICOMMAND(r_script_##n, f, a, b)
	#define INIT script *e = checkscript(scripts.length() - 1);
	#define DEBUG "script[%i]"
	#define DEBUG_IND scripts.length() - 1

	ICOMMAND(r_script_new, "", (),
		scripts.add(new script());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created script %i (%p)", scripts.length() - 1, scripts.last());
		intret(scripts.length() - 1);
	)

	ICOMMAND(r_script_dup, "i", (int *i),
		if(!checkscript(*i)) { intret(-1); return; }

		script *s = scripts.add(new script());
		scripts[*i]->transfer(*s);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated script %i in new slot %i (%p)", *i, scripts.length() - 1, scripts.last());
		intret(scripts.length() - 1);
	)

	ICOMMAND(r_script_say, "ss", (char *t, char *s),
		script *scr = checkscript(scripts.length() - 1);
		if(!scr) return;

		scr->dialogue.add(new rpgchat(newstring(t), newstring(s)));

		if(DEBUG_CONF)
		{
			conoutf(CON_DEBUG, "script[%i]->dialogue[%i]->talk = \"%s\"", scripts.length() - 1, scr->dialogue.length() - 1, t);
			conoutf(CON_DEBUG, "script[%i]->dialogue[%i]->script = \"%s\"", scripts.length() - 1, scr->dialogue.length() - 1, s);
		}
	)

	STRINGN(approach,     scripts[SCR_APPROACH])
	STRINGN(death,        scripts[SCR_DEATH])
	STRINGN(drop,         scripts[SCR_DROP])
	STRINGN(equip,        scripts[SCR_EQUIP])
	STRINGN(interact,     scripts[SCR_INTERACT])
	STRINGN(spawn,        scripts[SCR_SPAWN])
	STRINGN(use,          scripts[SCR_USE])
	STRINGN(hit,          scripts[SCR_HIT])
	STRINGN(collide,      scripts[SCR_COLLIDE])

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	#define START(n, f, a, b) ICOMMAND(r_effect_ ##n, f, a, b)
	#define INIT effect *e = checkeffect(effects.length() - 1);
	#define DEBUG "effect[%i]"
	#define DEBUG_IND effects.length() - 1

	ICOMMAND(r_effect_new, "", (),
		effects.add(new effect());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created effect %i (%p)", effects.length() - 1, effects.last());
		intret(effects.length() - 1);
	)

	ICOMMAND(r_effect_dup, "i", (int *i),
		if(!checkeffect(*i)) {intret(-1); return;}

		effect *e = effects.add(new effect());
		effects[*i]->transfer(*e);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated effect %i in new slot %i (%p)", *i, effects.length() - 1, effects.last());
		intret(effects.length() - 1);
	)

	INT(flags, 0, FX_MAX - 1)
	INT(decal, -1, DECAL_MAX - 1)

	STRING(mdl)
	INT(projpart, 0,	PART_LENS_FLARE - 1)
	INT(projpartcol, 0, 0xFFFFFF)
	FLOAT(projpartsize, 0.01f, 100.0f)

	INT(trailpart, 0, PART_LENS_FLARE - 1)
	INT(trailpartcol, 0, 0xFFFFFF)
	INT(trailpartfade, 1, 120000)
	INT(trailpartgrav, -10000, 10000)
	FLOAT(trailpartsize, 0.01f, 100.0f)

	INT(traillightradius, 16, 2048)
	VEC(traillightcol, -1, -1, -1, 1, 1, 1)

	INT(deathpart, 0, PART_LENS_FLARE - 1)
	INT(deathpartcol, 0, 0xFFFFFF)
	INT(deathpartfade, 1, 120000)
	INT(deathpartgrav, -10000, 10000)
	FLOAT(deathpartsize, 0.01f, 100.0f)

	INT(deathlightflags, 0, 7)
	INT(deathlightfade, 0, 120000)
	INT(deathlightradius, 16, 2048)
	INT(deathlightinitradius, 16, 2048)
	VEC(deathlightcol, -1, -1, -1, 1, 1, 1)
	VEC(deathlightinitcol, -1, -1, -1, 1, 1, 1)

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	#define START(n, f, a, b) ICOMMAND(r_status_ ##n, f, a, b)
	#define INIT statusgroup *e = checkstatusgroup(statuses.length() - 1);
	#define DEBUG "statusgroup[%i]"
	#define DEBUG_IND statuses.length() - 1

	ICOMMAND(r_status_new, "", (),
		statuses.add(new statusgroup());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created statusgroup %i (%p)", statuses.length() - 1, statuses.last());
		intret(statuses.length() - 1);
	)

	ICOMMAND(r_status_dup, "i", (int *i),
		if(!checkstatusgroup(*i)) { intret(-1); return; }

		statusgroup *e = statuses.add(new statusgroup());
		statuses[*i]->transfer(*e);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated effect %i in new slot %i (%p)", *i, statuses.length() - 1, statuses.last());
		intret(statuses.length() - 1);
	)

	ICOMMAND(r_status_addgeneric, "ii", (int *t, int *s),
		statusgroup *e = checkstatusgroup(statuses.length() - 1);
		if(!e) return;

		status_generic *g = new status_generic();
		e->effects.add(g);

		g->type = *t;
		g->strength = *s;

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: adding generic effect (%i %i), to statusgroup %i", *t, *s, statuses.length() - 1);
	)

	ICOMMAND(r_status_addpolymorph, "s", (char *m),
		statusgroup *e = checkstatusgroup(statuses.length() - 1);
		if(!e) return;

		status_polymorph *p = new status_polymorph();
		e->effects.add(p);
		p->type = STATUS_POLYMORPH;
		p->mdl = newstring(m);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: adding polymorph effect (%s), to statusgroup %i", m, statuses.length() - 1);
	)

	ICOMMAND(r_status_addlight, "fffi", (float *r, float *g, float *b, int *rad),
		statusgroup *e = checkstatusgroup(statuses.length() - 1);
		if(!e) return;

		status_light *l = new status_light();
		e->effects.add(l);
		l->type = STATUS_LIGHT;

		l->colour.x = clamp((float) 1, (float) -1, *r);
		l->colour.y = clamp((float) 1, (float) -1, *g);
		l->colour.z = clamp((float) 1, (float) -1, *b);
		l->radius = clamp((int) 512, (int) 8, *rad);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: adding light effect (%f %f %f --> %i), to statusgroup %i", l->colour.x, l->colour.y, l->colour.z, l->radius, statuses.length() - 1);
	)

	BOOL(friendly)
	STRING(icon)
	STRING(name)
	STRING(description)

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	#define START(n, f, a, b) ICOMMAND(r_item_ ##n, f, a, b)
	#define INIT item_base *e = checkitem_base(items.length() - 1);
	#define DEBUG "item_base[%i]"
	#define DEBUG_IND items.length() - 1

	ICOMMAND(r_item_new, "", (),
		items.add(new item_base());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created item_base %i (%p)", items.length() - 1, items.last());
		intret(items.length() - 1);
	)

	ICOMMAND(r_item_dup, "i", (int *i),
		if(!checkitem_base(*i)) { intret(-1); return; }

		item_base *b = items.add(new item_base());
		items[*i]->transfer(*b);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated slot %i in new slot %i (%p)", *i, items.length() - 1, items.last());
		intret(items.length() - 1);
	)

	ICOMMAND(r_item_use_new_consumable, "", (),
		item_base *item = checkitem_base(items.length() - 1);
		if(!item) return;

		item->uses.add(new use(item->script));
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created new consumable use (%i) for item %i", item->uses.length() - 1, items.length() - 1);
	)

	ICOMMAND(r_item_use_new_armour, "", (),
		item_base *item = checkitem_base(items.length() - 1);
		if(!item) return;

		item->uses.add(new use_armour(item->script));
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created new armour use (%i) for item %i", item->uses.length() - 1, items.length() - 1);
	)

	ICOMMAND(r_item_use_new_weapon, "", (),
		item_base *item = checkitem_base(items.length() - 1);
		if(!item) return;

		item->uses.add(new use_weapon(item->script));
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created new weapon use (%i) for item %i", item->uses.length() - 1, items.length() - 1);
	)

	STRING(name)
	STRING(icon)
	STRING(description)
	STRING(mdl)

	INT(script, 0, 0xFFFF)
	INT(type, 0, ITEM_MAX - 1)
	INT(flags, 0, item_base::F_MAX - 1)
	INT(worth, 0, 0xFFFFFF)
	INT(weight, 0, 0xFFFF)

	INT(cursebase, -1, 0xFFFF)

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	// recipes go here, they currently have no slots to configure, leaving the macros undefined

	ICOMMAND(r_recipe_new, "", (),
		recipes.add(new recipe());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created recipe %i (%p)", recipes.length() - 1, recipes.last());
		intret(recipes.length() - 1);
	)

	ICOMMAND(r_recipe_dup, "i", (int *i),
		if(!checkrecipe(*i)) { intret(-1); return; }

		recipe *b = recipes.add(new recipe());
		recipes[*i]->transfer(*b);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated slot %i in new slot %i (%p)", *i, recipes.length() - 1, recipes.last());
		intret(recipes.length() - 1);
	)

	ICOMMAND(r_recipe_add_ingredient, "ii", (int *base, int *qty),
		recipe *r = checkrecipe(recipes.length() - 1);
		if(!r) return;
		if(*qty <= 0) {conoutf(CON_ERROR, "ERROR: can't add an ingredient with a quantity of <= 0"); return;}

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: added ingredient %i (%i) to recipe %i (%p)", *base, *qty, recipes.length() - 1, recipes.last());

		r->ingredients.add(invstack(*base, *qty));
		//r->optimise()
	)

	ICOMMAND(r_recipe_add_catalyst, "ii", (int *base, int *qty),
		recipe *r = checkrecipe(recipes.length() - 1);
		if(!r) return;
		if(*qty <= 0) {conoutf(CON_ERROR, "ERROR: can't add an ingredient with a quantity of <= 0"); return;}

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: added catalyst %i (%i) to recipe %i (%p)", *base, *qty, recipes.length() - 1, recipes.last());

		r->catalysts.add(invstack(*base, *qty));
		//r->optimise()
	)

	ICOMMAND(r_recipe_add_product, "ii", (int *base, int *qty),
		recipe *r = checkrecipe(recipes.length() - 1);
		if(!r) return;
		if(*qty <= 0) {conoutf(CON_ERROR, "ERROR: can't add an ingredient with a quantity of <= 0"); return;}

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: added product %i (%i) to recipe %i (%p)", *base, *qty, recipes.length() - 1, recipes.last());

		r->product.add(invstack(*base, *qty));
		//r->optimise()
	)

	#define START(n, f, a, b) ICOMMAND(r_item_use_ ##n, f, a, b)

	#define INIT \
		item_base *b = checkitem_base(items.length() - 1); \
		if(!b) return; \
		CAST *e = (CAST *) checkuse(b, TYPE, b->uses.length() - 1);

	#define DEBUG "item_base[%i]->uses[%i]"
	#define DEBUG_IND items.length() - 1, items.last()->uses.length() - 1

	#define CAST use
	#define TYPE USE_CONSUME

	INT(script, 0, 0xFFFF)
	INT(status, 0, 0xFFFF)
	INT(duration, -1, 0xFFFF)
	INT(cooldown, 0, 0xFFFF)
	FLOAT(mul, 0, 100)

	#undef CAST
	#undef TYPE
	#define CAST use_armour
	#define TYPE USE_ARMOUR

	STATREQ(reqs)
	INT(slots, 0, SLOT_MAX - 1)
	INT(skill, -1, SKILL_MAX - 1)

	#undef CAST
	#undef TYPE
	#define CAST use_weapon
	#define TYPE USE_WEAPON

	INT(range, 0, 1024)
	INT(angle, 0, 360)
	INT(lifetime, 0, 0xFFFF)
	INT(effect, 0, 0xFFFF)
	INT(cost, 0, 0xFFFF)
	INT(flags, 0, P_MAX - 1)
	INT(element, 0, ATTACK_MAX - 1)
	INT(ammo, -3, 0xFFFF)
	INT(target, 0, T_MAX - 1)
	INT(radius, 4, 0xFFFF)
	INT(kickback, -0xFFFF, 0xFFFF)
	INT(charge, 0, 0xFFFF)
	FLOAT(basecharge, 0, 100)
	FLOAT(mincharge, 0, 100)
	FLOAT(maxcharge, 0, 100)
	FLOAT(elasticity, 0, 1)
	FLOAT(speed, 0, 100)

	#undef CAST
	#undef TYPE

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	#define START(n, f, a, b) ICOMMAND(r_ammo_ ##n, f, a, b)
	#define INIT ammotype *e = checkammotype(ammotypes.length() - 1);
	#define DEBUG "ammotype[%i]"
	#define DEBUG_IND ammotypes.length() - 1

	ICOMMAND(r_ammo_new, "", (),
		ammotypes.add(new ammotype());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created ammotype %i", ammotypes.length() - 1, ammotypes.last());

		intret(ammotypes.length() - 1);
	)

	ICOMMAND(r_ammo_dup, "i", (int *i),
		if(!checkammotype(*i)) {intret(-1); return;}

		ammotype *a = ammotypes.add(new ammotype());
		ammotypes[*i]->transfer(*a);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated ammotype %i in new slot %i (%p)", *i, ammotypes.length() - 1, ammotypes.last());
		intret(ammotypes.length() - 1);
	)

	ICOMMAND(r_ammo_additem, "i", (int *i),
		ammotype *e = checkammotype(ammotypes.length() - 1);
		if(!e) return;

		e->items.add(*i);
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: Classified item %i as member of ammo %i (%s)", *i, ammotypes.length() - 1, e->name ? e->name : "unnamed");
	)

	STRING(name)

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	#define START(n, f, a, b) ICOMMAND(r_ammo_ ##n, f, a, b)
	#define INIT ammotype *e = checkammotype(items.length() - 1);
	#define DEBUG "ammotype[%i]"
	#define DEBUG_IND ammotypes.length() - 1

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	#define START(n, f, a, b) ICOMMAND(r_char_ ##n, f, a, b)
	#define INIT char_base *e = checkchar_base(chars.length() - 1);
	#define DEBUG "char_base[%i]"
	#define DEBUG_IND chars.length() - 1

	ICOMMAND(r_char_new, "", (),
		chars.add(new char_base());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created character %i (%p)", chars.length() - 1, chars.last());
		intret(chars.length() - 1);
	)

	ICOMMAND(r_char_dup, "i", (int *i),
		if(!checkchar_base(*i)) { intret(-1); return; }

		char_base *b = chars.add(new char_base());
		chars[*i]->transfer(*b);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated slot %i in new slot %i (%p)", *i, chars.length() - 1, chars.last());
		intret(chars.length() - 1);
	)

	//ICOMMAND(r_char_additem, "ii", (int *i, int *q)

	STRING(name)
	STRING(mdl)
	INT(script, 0, 0xFFFF)
	INT(faction, 0, 0xFFFF)
	STATS(base)

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	#define START(n, f, a, b) ICOMMAND(r_faction_ ##n, f, a, b)
	#define INIT faction *e = checkfaction(factions.length() - 1);
	#define DEBUG "faction[%i]"
	#define DEBUG_IND factions.length() - 1

	ICOMMAND(r_faction_new, "", (),
		factions.add(new faction());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created faction %i (%p)", factions.length() - 1, factions.last());

		intret(factions.length() - 1);
	)

	ICOMMAND(r_faction_dup, "i", (int *i),
		if(!checkfaction(*i)) { intret(-1); return; }

		faction *f = factions.add(new faction());
		factions[*i]->transfer(*f);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated slot %i in new slot %i (%p)", *i, factions.length() - 1, factions.last());
		intret(factions.length() - 1);
	)

	ICOMMAND(r_faction_set_relation, "iii", (int *i, int *o, int *f),
		if(!checkfaction(*i)) return;
		factions[*i]->setrelation(*o, *f);
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: faction %i's liking of faction %i is now %i", *i, *o, *f);
	)

	STRING(name)
	STRING(logo)

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	#define START(n, f, a, b) ICOMMAND(r_object_ ##n, f, a, b)
	#define INIT object_base *e = checkobject_base(objects.length() - 1);
	#define DEBUG "object_base[%i]"
	#define DEBUG_IND objects.length() - 1

	ICOMMAND(r_object_new, "", (),
		objects.add(new object_base());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created object base %i (%p)", objects.length() - 1, objects.last());

		intret(objects.length() - 1);
	)

	ICOMMAND(r_object_dup, "i", (int *i),
		if(!checkobject_base(*i)) { intret(-1); return; }

		object_base *o = objects.add(new object_base());
		objects[*i]->transfer(*o);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated slot %i in new slot %i (%p)", *i, objects.length() - 1, objects.last());
		intret(objects.length() - 1);
	)

	//ICOMMAND(r_object_additem, "ii", (int *i, int *q)

	STRING(mdl)
	STRING(name)
	INT(flags, 0, rpgobject::F_MAX - 1)
	INT(weight, 0, 0xFFFF)
	INT(script, 0, 0xFFFF)


	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	#define START(n, f, a, b) ICOMMAND(r_mapscript_ ##n, f, a, b)
	#define INIT mapscript *e = checkmapscript(mapscripts.length() - 1);
	#define DEBUG "mapscript[%i]"
	#define DEBUG_IND mapscripts.length() - 1

	ICOMMAND(r_mapscript_new, "", (),
		mapscripts.add(new mapscript());
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created mapscript %i (%p)", mapscripts.length() - 1, mapscripts.last());

		intret(mapscripts.length() - 1)
	)

	ICOMMAND(r_mapscript_dup, "i", (int *i),
		if(!checkmapscript(*i)) { intret(-1); return; }

		mapscript *o = mapscripts.add(new mapscript());
		mapscripts[*i]->transfer(*o);

		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: duplicated slot %i in new slot %i (%p)", *i, mapscripts.length() - 1, mapscripts.last());
		intret(mapscripts.length() - 1);
	)

	STRINGN(load,		scripts[MSCR_LOAD])
	STRINGN(enter,		scripts[MSCR_ENTER])

	#undef START
	#undef INIT
	#undef DEBUG
	#undef DEBUG_IND

	ICOMMAND(r_global_new, "i", (int *v),
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: created new global variable - variables[%i] = %i", variables.length(), *v);
		variables.add(*v);
		intret(variables.length() - 1);
	)

	ICOMMAND(r_tip_new, "s", (const char *s),
		if(DEBUG_CONF)
			conoutf(CON_DEBUG, "DEBUG: added tip...\n%s", s);
		tips.add(newstring(s));
	)
}
