/*
 * robversion.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/**\file
  * Defines RoboTour's (and the associated programs') current version. 
  */
#include "robvars.h"
#include "robtrans.h"

namespace rt {

// The RoboTour version.
const lrt::String version = "3.21";

lrt::String getVersion() {
	return version; 
}

// same as version, but formatted for the user. 
lrt::String getUserVersion() {
#ifdef __RBI__ // full version
	return version; 
#else // lite version
	return version + "-lite " + _("(No RBI support)"); 
#endif
}

// copyright and release info
lrt::String getAboutText() {
	return lrt::String(_("Built on ")) + __DATE__  + "\n"
		   + "Copyright (C) 2000-2005 Florian Fischer " + _("and") + " Martin Trautmann\n"
#ifdef EXTRA_DATA_DIR
		   + _("Install(ed) to ") + EXTRA_DATA_DIR + "\n"
#endif
#ifndef __RBI__ // lite version
		   + _("Note that this version of RoboTour lacks certain features, such\n"
		 	   "as support for binary robot files (RBI).\n"
			   "The full version may be downloaded from the RoboCom homepage.\n")
#endif
		   + _("The RoboCom Homepage: http://www.cyty.com/robocom/"); 
}


/* The supported RoboCom Language version. This should be a three-digit number,
   it is the xxx in the ROB header  "Published Language RCxxx". */
int getLanguageVersion() {
	return 300;
}

}; // namespace
