/*
 * robtrans.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// Implements translation functions
#ifdef __WXWIN__ 



#include <rtstring.h>

#include "robwxutil.h"

#include <wx/intl.h>

namespace rt {


lrt::String getTranslation(const char* str)
{
#if wxUSE_UNICODE
	return Wx::Conv(wxGetTranslation(Wx::Conv(str)));
#else
	return wxGetTranslation(str); 
#endif
}

lrt::String getLanguageCode()
{
    wxLocale *pLoc = wxGetLocale();
    if (pLoc)
        return Wx::Conv(pLoc->GetCanonicalName());
    else
        return lrt::String(); 
}



} // namespace


#else // !__WXWIN__

// dummy implementation which does nothing

#include <rtstring.h>

namespace rt {


lrt::String getTranslation(const char* str)
{
	return str; 
}

lrt::String getLanguageCode()
{
	return lrt::String(); 
}

}


#endif // __WXWIN__

