/*
 * robsound.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file
  * Declares Sound output related classes
  */
#ifndef __RT_SOUND__
#define __RT_SOUND__

#include "robfrontend.h"
#include "robmanage.h"
#include "robbase.h"

#include <rtsystem.h>

namespace rt {

// predecl
class SoundPlugin; 
class SoundTourDisplayer; 
class SoundSimSupervisor; 

/** A frontend plugin which manages sound output. */
class SoundPlugin : public FrontendPlugin  
{
public:
	virtual FpInterpretePos getInterpretePos();
	virtual void reset(); // Tournament is reset
	virtual lrt::String getCodeName();
	virtual lrt::String getName();
	virtual lrt::String getHelpText();
	bool canPlay(bool checkSilent = true);
	virtual bool interpreteParams(const lrt::Array<lrt::String>& params, lrt::Array<bool>& used);
	virtual void fillOptions(SimOptions& options);
	virtual void setActive(bool a); 

	SoundPlugin(Frontend* parent);
	~SoundPlugin() {}
private:
	bool isSoundInstalled(const lrt::String& name, bool checkSilent = true);

	// pointers to the current instances of the tourDisp and simSup
	SoundTourDisplayer* tourDisp; 
	SoundSimSupervisor* simSup; 
};

class SoundTourDisplayer : public TourDisplayer
{
public:
	SoundTourDisplayer() : active(true) {}
	void setActive(bool a) { active = a; }
	bool isActive() { return active; }

	virtual void init(const TourInitInfo&);
	virtual TourStatusType update(const lrt::Array<TourResult>& status);
	virtual void exit(TourStatusType exitType, const lrt::Array<TourResult>& result);

private:
	bool active; 
};

class SoundSimSupervisor : public SimSupervisor 
{
public:
	SoundSimSupervisor();
	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual GameState exec(Simulation* const curSim);
	virtual void exitSim(Simulation* const curSim, const GameState& simResult);

	void setActive(bool a) { active = a; }
	bool isActive() { return active; }
private:
	bool active; 
	int cycles;
	static const int minMillis, maxMillis;
	lrt::Time lastTime;
	GameState retState;
};

} // namespace

#endif

