.TH ROBOTOUR "1" "2005-October" "robotour 3.2.1" "User Commands"
.SH NAME
robotour \- control mobile robots in this programmer's game
.SH SYNOPSIS
\fBrobotour\fR [\fIOPTION\fR]... \fIROBOT\fR...
.SH DESCRIPTION
Simulate the specified ROBOTs (.rob files). 

RoboCom is a programming game. Before the game starts, each player 
writes an assembler-like program
which has to decide for itself later on, in order to win the game.
The pieces on the chess-like field are robots, which have the
abilities to move, multiply, exchange program code etc. The goal is
to put the other players' robots out of action while staying
functional yourself.

RoboCom is not a military game! There is nothing like weapons: the
only way to influence another robot is to transfer program code. And
that makes it particularly interesting. The programming language is
easy to learn, however it provides an amazingly wide spectrum of
different strategies, which are all successful in another way.

RoboTour is a fast, portable, fully compatible and free RoboCom interpreter
and tournament engine. It can be used to run simple simulations, big tournaments
and even create competitions to which robots can be added later on. 
(Check out RoboTop by the same author, which makes this process much easier.) 
Graphical display of tournaments (even in 3D), robot debugging and simulation
history are all available. 
.SH OPTIONS
.TP
\fB\-vis\fR
Open the graphical visualization window (if available). You need
not specify any other options or robots, as these can also be set using the 
mouse. The simulation will be displayed while running. 
.TP
\fB\-h\fR, \fB\-help\fR, \fB\-\-help\fR
display command line help and exit
.TP
\fB\-\-version\fR
output version information and exit
.TP
\fB\-n\fR \fIN\fR
Repeat simulations \fIN\fR times. This will reduce the influence of random 
effects (such as starting positions) on the result. Default is 10, like the
Internet competitions.
.TP
\fB\-o\fR \fIFILE\fR
Specify location or file name of the option set (default: \fIrobocom.rco\fR, 
these are the RC3 rules)
.TP
\fB\-s\fR
Switch to "single" mode: Simulate the first specified robot against all others.
.TP
\fB\-c\fR
Switch to "charts" mode: Simulate everyone against everyone. (default)
.TP
\fB\-i\fR
Switch to "all in one" mode: Simulate all of the specified bots in one field, at the same time. 
.TP
\fB\-t\fR \fIN\fR
Switch to "top \fIN\fR" mode: Create a competition to which, later on, more
robots can be added. If there are more than \fIN\fR robots in the competition, 
the worst will be dropped. 
.TP
\fB\-T\fR \fIN\fR
Same as \fB\-t\fR, but results of partially simulated robots are recognized. 
(This will only make a difference from \fB-t\fR if the last run of RoboTour was aborted.) 
.TP
\fB\-cf\fR \fIF\fR
For top mode: Specify the competition folder for robots and result files. (default: current)
.TP
\fB\-p\fR \fIX\fR
print the field every \fIX\fR cycles (default: 0 = function inactive)
.TP
\fB\-debug\fR \fIP\fR \fIX\fR
Debug every \fIX\fR cycles (default: 0 = function inactive) the bots
on field range \fIP\fR (coords start at 0; example for p: 0,0:1,1)
.TP
\fB\-r\fR
No randomization => always the same result
.TP
\fB\-v\fR \fIN\fR
Set verbose level (0-5) (default = 5; no output = 0)
.TP
\fB\-sound\fR
Enable sound output using sox.
.TP
\fB\-rate\fR \fIN\fR
Produce a rating for the first bot on cycle \fIN\fR and end
the game. If \fIN\fR < 0, wait for timeout.
.TP
\fB\-prof\fR \fIT\fR
Create a profile of type \fIT\fR for all robots. Possible types are
\fIcount\fR (number of executions of each instruction in the program), 
\fItime\fR (spent during all of the executions) and \fIfail\fR, which
calculates the failure ratio for some instructions (such as \fBCREATE\fR
and \fBTRANS\fR). 

.SH "ROBOTS"
Robots are plain text files. Every robot consists of a header, which gives
general information about it (such as the robot's and the author's name),
followed by one or more code banks which contain the actual program. 
A very simple example robot follows: 

\fBExample robot\fR

  Published Name Turnaround Bot
  Published Author Robert Robot
  Published Country Nomansland

  Bank Main
    Turn 0    ; Turn left forever!\n
.PP
Some more examples are installed along with RoboTour (normally, in 
\fI/usr/share/robotour/samples/\fR). Detailed information on how to create
your own robots is available online at 
.UR http://www.cyty.com/robocom/?area=help
http://www.cyty.com/robocom/?area=help
.UE
\.

.SH "OPTION SETS"
An option set includes all the options and rules for a certain simulation. 
This includes the size of the board, the timeout, availability of the new RC3 
instructions or multitasking, how many cycles each instruction takes to execute, 
and much more.
Several option sets are installed along with RoboTour (normally, in 
\fI/usr/share/robotour/optsets/\fR): 
.TP
\fBrobocom.rco\fR
The default option set. These are the options that are used in the
World Cup at 
.UR http://www.cyty.com/robocom/
http://www.cyty.com/robocom/
.UE
, so it is recommended to stick 
to this one when developing robots for that competition. 
.TP
\fBRC3S.rco\fR
RoboCom 3 Standard Rules, a copy of the file above. 
.TP
\fBclassic.rco\fR
Classic rules from RoboCom 2. These are used for the classic competition. 
Many of the instructions are not allowed in this option set. 
.SH AUTHOR
Written by Florian Fischer <florianfischer@gmx.de> and Martin Trautmann
<martintrautmann@gmx.de>.

This manual page was written by Shaun Jackman <sjackman@debian.org>
for the Debian system and extended by Florian Fischer.
.SH "REPORTING BUGS"
Please report bugs to the authors.
.SH COPYRIGHT
Copyright 2000-2005 Florian Fischer and Martin Trautmann.
.SH "SEE ALSO"
http://www.cyty.com/robocom/
