/*
 * wxrtoolbar.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#include <wx/wx.h>
#include <wx/toolbar.h>

#include "wxrtoolbar.h"

wxxRToolBar::wxxRToolBar() : rToolId(-1)
{
}

wxxRToolBar::wxxRToolBar(wxWindow* parent, wxWindowID id, const wxPoint& pos, 
		const wxSize& size, long style, const wxString& name) 
		: wxToolBar(parent, id, pos, size, style, name), rToolId(-1)
{
	Connect(GetId(), wxEVT_SIZE, (wxObjectEventFunction) &wxxRToolBar::OnSize);
}

void wxxRToolBar::SetRTool(int toolId)
{
	rToolId = toolId;
}

void wxxRToolBar::OnSize(wxSizeEvent& event)
{
	if(rToolId == -1) return; // there's no right tool
	wxToolBarToolBase* tool = RemoveTool(rToolId);
	if(!tool) return; // it's an invalid ID

	int parWidth = GetParent()->GetClientSize().GetWidth();
	int xPos = parWidth - GetToolSize().GetWidth() - GetMargins().GetWidth();
	//wxMessageBox(wxString::Format(wxT("putting tool item to pos %d (of %d)"), xPos, parWidth));
	AddTool(tool->GetId(), tool->GetNormalBitmap(), tool->GetDisabledBitmap(), 
		tool->CanBeToggled(), xPos, -1, tool->GetClientData(), 
		tool->GetShortHelp(), tool->GetLongHelp());
	Realize();
}
