/*
 * wxfsel.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#include "wxfsel.h"

#include "bitmaps/open.xpm"

wxxFselWindow::wxxFselWindow(wxWindow* parent, wxWindowID id, const wxString& label, 
		const wxString& initialFile, bool selectFolder, const wxPoint& pos, const wxSize& size, long style, 
		const wxString& name) : wxPanel(parent, id, pos, size, style, name), selectFolder(selectFolder)
{
  wxBoxSizer* sizer = new wxBoxSizer( wxHORIZONTAL );

  wxStaticText* message = new wxStaticText(this, -1, label);
  myText = new wxTextCtrl(this, -1, initialFile, wxDefaultPosition, wxSize(250, 20), wxTE_READONLY);
  wxBitmap* openBitmap = new wxBitmap( open_xpm );
  wxBitmapButton* button = new wxBitmapButton(this, -1, *openBitmap);
  delete openBitmap;
  Connect(button->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) &wxxFselWindow::OnSelButton);

  sizer->Add( message,
    1,            // make horizontally stretchable
    wxEXPAND |    // make vertically stretchable
    wxALL,        //   and make border all around
    2 );         // set border width to 10

  sizer->Add(myText, 0, wxEXPAND | wxALL, 2);
  sizer->Add(button, 0, wxEXPAND | wxALL, 2);

  SetAutoLayout( TRUE );     // tell dialog to use sizer
  SetSizer( sizer );      // actually set the sizer

  sizer->Fit( this );            // set size to minimum size as calculated by the sizer
  sizer->SetSizeHints( this );   // set size hints to honour mininum size

}

wxxFselWindow::~wxxFselWindow()
{
}

void wxxFselWindow::SetTextReadOnly(bool ro)
{
    myText->SetEditable(!ro);
}

wxString wxxFselWindow::GetFile()
{
	return myText->GetValue();
}

void wxxFselWindow::OnSelButton(wxCommandEvent& event)
{
	wxString curFile = GetFile();
	wxString newFile = curFile;
	if(selectFolder)
	{
		wxDirDialog* dlg = new wxDirDialog(this);
		if(dlg->ShowModal() == wxID_OK)
		  newFile = dlg->GetPath();
	}
	else
	{
		wxString path, name, ext;
		wxSplitPath(curFile, &path, &name, &ext);
		wxString exts = wxString::Format(_("Selected extension (*.%s)|*.%s|All files(*.*)|*"), ext.c_str());
		newFile = wxFileSelector(_("Choose a file"), path, name, ext, exts, wxFILE_MUST_EXIST);
	}
	if(!newFile.IsEmpty())
		myText->SetValue(newFile);
}
	
