/*
 * tourview.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */
 
#ifndef __ROBOTOP_TOURVIEW_H__
#define __ROBOTOP_TOURVIEW_H__

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------

#include <wx/wx.h>
#include <wx/dynarray.h>

#include "reportctrl.h"
#include "reportdata.h"
#include "inirepdata.h"
#include "wxext.h" // bug fix

class TourData;
class InsertFrame;
class ChartsReportData;
class TournamentEvent;


// Define a new frame type: this is going to be our main frame
class TournamentFrame : public wxxMDIChildFrame
{
public:

	// ctor(s)
	// takes ownership of data
	TournamentFrame(wxMDIParentFrame* parent, TourData* data);
	~TournamentFrame();

	const TourData& GetConfigData();

	// my event handling
	// register your component for competition events (see below for evt table macros)
	void AddTournamentListener(wxEvtHandler* handler);
	// unregister your component (you must do that before it is destroyed!!)
	void RemoveTournamentListener(wxEvtHandler* handler);

	// event handlers (these functions should _not_ be virtual)
	void OnAddBot(wxCommandEvent& event);
	void OnDelBot(wxCommandEvent& event);
	void OnShowRobotInStatus(wxListEvent& event);
	void OnDetails(wxCommandEvent& event);
	void OnDetailsList(wxListEvent& event) { OnDetails(event); }
	void OnRedisplay(wxCommandEvent& event);
	void OnBrowser(wxCommandEvent& event);
	void OnMatrix(wxCommandEvent& event);
	void OnOptions(wxCommandEvent& event);
	void OnCloseCommand(wxCommandEvent& event);

	void OnCloseWindow(wxCloseEvent& event);

	// marks web pages as being outdated - makehtml will be called before opening them
	void SetNeedMakehtml(); 
	bool NeedsMakehtml();
	void RunMakeHtml(bool recalc, bool all);

private:
    wxMDIParentFrame* parent;
	wxxReportCtrl* chartsList;
	ChartsReportData* chartsData;
	TourData* configData;

	bool needMakeHtml; 

	wxArrayPtrVoid tourEventHandlers;

	InsertFrame* insertFrame;
	friend class InsertFrame; // so that it can set ours to 0
	// just returns insertFrame - whether or not it exists
	InsertFrame* GetInsertFrame();
	// gets the insert frame if there is one, otherwise creates one
	// if show is given, also shows it immediately
	InsertFrame* AccessInsertFrame(bool show = true);

	wxMenuBar* CreateMenu();
	void InitToolBar(wxToolBar* toolBar);

	void UpdateTitle();

	void InformListeners(int eventType, bool force = false);
	void Redisplay(bool runMakeHtml);

	// any class wishing to process wxWindows events must use this macro
	DECLARE_EVENT_TABLE();
};

// my event system ///////////////
// the event handler function
typedef void (wxEvtHandler::*TournamentEventFunction)(TournamentEvent&);

// available event types
#if wxCHECK_VERSION(2,3,0)
BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(EVT_TOUR_UPDATED, wxEVT_USER_FIRST + 200)
    DECLARE_EVENT_TYPE(EVT_TOUR_CLOSED, wxEVT_USER_FIRST + 201)
END_DECLARE_EVENT_TYPES()
#else
#define EVT_TOUR_UPDATED wxEVT_USER_FIRST + 200
#define EVT_TOUR_CLOSED wxEVT_USER_FIRST + 201
#endif

// event table macros
#if wxCHECK_VERSION(2,3,0)
#define EVT_TOUR_UPDATE(fn) DECLARE_EVENT_TABLE_ENTRY( EVT_TOUR_UPDATED, -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_TOUR_CLOSE(fn) DECLARE_EVENT_TABLE_ENTRY( EVT_TOUR_CLOSED, -1, -1, (wxObjectEventFunction) & fn, NULL ),
#else
#define EVT_TOUR_UPDATE(fn) { EVT_TOUR_UPDATED, -1, -1, (wxObjectEventFunction) & fn, NULL },
#define EVT_TOUR_CLOSE(fn)  { EVT_TOUR_CLOSED, -1, -1, (wxObjectEventFunction) & fn, NULL },
#endif

// my event class
class TournamentEvent : public wxEvent
{
    DECLARE_DYNAMIC_CLASS(TournamentEvent)
public:
	// we don't use the id but it has to be the same as in the event table
	TournamentEvent(int eventType = EVT_TOUR_UPDATED);
#if wxCHECK_VERSION(2,3,0) // the event duplication has been changed
	TournamentEvent(const TournamentEvent& evt);
    wxEvent* Clone() const;
#else
	void CopyObject(wxObject& objectDest) const;
#endif
	bool IsForce() { return force; }
	friend class TournamentFrame;
private:
	bool force;
};

////////// internal classes /////////

struct ChartsOrderData {
	ChartsOrderData(long row, long points);
	long row;
	long rank;
	long points;
};

WX_DECLARE_OBJARRAY(ChartsOrderData, ArrayOfCODs);


class ChartsReportData : public wxxIniReportData
{
public:
	ChartsReportData(const wxString& chartsIni);
	wxString GetItemText(long row, int col);
	bool DoSectionCache();
	int CompareItems(long row1, long row2);
private:
	void ReloadArray();
	ArrayOfCODs coData;
};


// IDs for the controls and the menu commands
enum
{
  // tool bar items
  TourFrame_AddBot = 200,
  TourFrame_DelBot,
  TourFrame_Redisplay,
  TourFrame_Options,
  TourFrame_Details,
  TourFrame_Browser,
  TourFrame_Matrix,
  TourFrame_List
};

#endif // file

