/*
 * inirepdata.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#include <wx/wx.h>

#include "inirepdata.h"

#include "wxini.h"

wxxIniReportData::wxxIniReportData(const wxString& iniFile, int colCount, const wxxIniColumnInfo** infos,
	wxxReportDeleteMode delInfos) : wxxReportData(colCount, (const wxxReportColumnInfo**)infos, delInfos), ini(0), 
	sectionCache(0), numSections(0), iniFile(iniFile)
{
	ini = new wxxIniFile;
	ini->Read(iniFile);
	DoSectionCache();
}

int wxxIniReportData::GetRowCount()
{
	return numSections;
}

wxString wxxIniReportData::GetRowName(long row)
{
	if((row < 0) || (row >= numSections)) {
		wxLogError(_("Invalid row number: %ld"), row); return wxEmptyString; 
	}
	return sectionCache[row]->GetName();
}

wxString wxxIniReportData::GetItemText(long row, int col)
{
	wxString field = ((wxxIniColumnInfo**)infos)[col]->field;
	return sectionCache[row]->Get(field);
}

bool wxxIniReportData::DoSectionCache()
{
	delete[] sectionCache;
	int oldSections = numSections;
	bool changed = false;
	numSections = ini->GetCount();
	if(numSections != oldSections) changed = true;

	sectionCache = new wxxIniSection*[numSections];
	ini->First();
	for(int i = 0; i < numSections; i++) {
		sectionCache[i] = ini->Next();
	}

	return changed;
}

int wxxIniReportData::CompareItems(long row1, long row2)
{
	wxxIniColumnInfo* colInfo = ((wxxIniColumnInfo**)infos)[GetSortColumn()];
	wxString field = colInfo->field;
	int res = 0;
	switch(colInfo->sortmode)
	{
		case wxREPORT_SORTSTRING:
		{
			wxString text2 = sectionCache[row2]->Get(field);
			res = sectionCache[row1]->Get(field).Cmp(
				text2.c_str());
			break;
		}
		case wxREPORT_SORTSTRING_NOCASE:
		{
			wxString text2 = sectionCache[row2]->Get(field);
			res = sectionCache[row1]->Get(field).CmpNoCase(
				text2.c_str());
			break;
		}
		case wxREPORT_SORTNUMERIC:
		{
			long l1 = sectionCache[row1]->GetLong(field);
			long l2 = sectionCache[row2]->GetLong(field);
			if(l1 < l2) 
				res = -1;
			else if(l1 > l2)
				res = 1;
			else
				res = 0;
			break;
		}
	}
	res *= GetSortOrder();

	return res;
}

bool wxxIniReportData::Reload()
{
	delete ini;
	ini = new wxxIniFile;
	bool ret = ini->Read(iniFile);
	DoSectionCache();
	DoRows();
	SortItems();
	return ret;
}

wxxIniReportData::~wxxIniReportData()
{ 
	delete ini; 
	delete[] sectionCache;
}


const wxxIniColumnInfo** wxxIniReportData::InitColumnInfo(wxxIniColumnInfo** infos, int count, bool& initialized) 
{
	if(!initialized) {
		for(int i = 0; i < count; i++) {
			infos[i]->title = wxGetTranslation(infos[i]->title);
		}
		initialized = true; 
	}

	return (const wxxIniColumnInfo**) infos; 
}
