#############################################################################
# ui.pm extension file, included from the puic-generated form implementation.
# If you wish to add, delete or rename signals or slots use
# the Perl-enabled Qt Designer which will update this file,
# preserving your code.
#
# 'SLOT:' markers are not meant to be created or edited manually.
# Please use the Slots dialog and/or the Object Browser.
#############################################################################


sub init
{
  for (my $i = 0; $i < pageCount (); $i++)
  {
    setHelpEnabled (page ($i), 0);
  }

  setBackEnabled (log_page, 0);
  setFinishEnabled (log_page, 1);
}


sub destroy
{
}


sub uninstall
{
  my $prog_name = $ENV {"PAR_PROGNAME"};
  my $inst_path = dirname ($prog_name);

  chdir ($inst_path) or croak "$inst_path: chdir failed: $!";

  open INF, "<", ".InstallInfo" or croak "$inst_path/.InstallInfo: $!";

  while (my $name = <INF>)
  {
    chomp ($name);

    unless (lstat ($name))
    {
      log_viewer -> append ("$name: cannot stat: $!");
      next;
    }

    if (-f _ || -l _)
    {
      unlink ($name) or log_viewer -> append ("$name: unlink failed: $!");
      next;
    }

    if (-d _)
    {
      rmdir ($name) or log_viewer -> append ("$name: rmdir failed: $!");
      next;
    }
  }

  close INF;
}


# overload function of Qt::Wizard
sub next
{
  uninstall () if (currentPage () eq startup_page);
  SUPER -> next (@_);
}


sub page_changed # SLOT: ( const QString & )
{
  for (currentPage ())
  {
    if ($_ eq log_page)
    {
      cancelButton () -> setEnabled (0);
      finishButton () -> setFocus ();
      last;
    }
  }
}
