/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <qmessagebox.h>

#include "engines/mediainterface.h"
#include "mediacreator.h"

void ConfigureDialog::slotPreferredEngine( const QString &newEngine )
{
	static bool bOneTimeFlag = true;
	MediaCreator::setPreferredEngine (newEngine);
	if (bOneTimeFlag)
		QMessageBox::information (NULL, "Attention", "You have to re-start QPlayer for the changes to take effect.", QMessageBox::Ok);
	bOneTimeFlag = false;
}

void ConfigureDialog::exec()
{
	QStringList listEngines = MediaCreator::getAvailableEngines();
	uint t=0;
	// Sanity check if the requested engine is supported.
	for (t=0;t<listEngines.count();t++)	{
		m_pComboPreferredEngine->insertItem (QString (listEngines[t]));
	}
	m_pComboPreferredEngine->setCurrentText (MediaCreator::preferredEngine());
	QDialog::exec();
}

void ConfigureDialog::slotEngineInfo()
{
	QString qsEngineName (m_pComboPreferredEngine->currentText());
	QString qsDescription(MediaCreator::getEngineDescription (qsEngineName));
	qsEngineName += tr(" Description");
	QMessageBox::information (NULL, qsEngineName, qsDescription, QMessageBox::Ok);
}

void ConfigureDialog::slotSetupEngine()
{
	MediaInterface *pInterface = (MediaInterface *)m_pMediaInterface;
	if (pInterface)
		pInterface->setupDialog ();
}
