/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_SoftwareInventoryIdentity.h"

CMPIObjectPath* SoftwareInventory_OpenDRIM_SoftwareInventoryIdentity_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_SoftwareInventoryIdentity& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_SoftwareInventoryIdentity_classnames[0], OpenDRIM_SoftwareInventoryIdentity_NAMESPACE);

	if (!instance.Antecedent_isNULL)
		op.addKey("Antecedent", instance.Antecedent);

	if (!instance.Dependent_isNULL)
		op.addKey("Dependent", instance.Dependent);

	_L_;
	return op.getHdl();
}

CMPIInstance* SoftwareInventory_OpenDRIM_SoftwareInventoryIdentity_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_SoftwareInventoryIdentity& instance) {
	_E_;
	Objectpath op(broker, SoftwareInventory_OpenDRIM_SoftwareInventoryIdentity_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.UpgradeCondition_isNULL)
		ci.setProperty("UpgradeCondition", instance.UpgradeCondition);

	if (!instance.OtherUpgradeCondition_isNULL)
		ci.setProperty("OtherUpgradeCondition", instance.OtherUpgradeCondition);

	if (!instance.ElementSoftwareStatus_isNULL)
		ci.setProperty("ElementSoftwareStatus", instance.ElementSoftwareStatus);

	_L_;
	return ci.getHdl();
}

void SoftwareInventory_OpenDRIM_SoftwareInventoryIdentity_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_SoftwareInventoryIdentity& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (op.getKey("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	_L_;
}

void SoftwareInventory_OpenDRIM_SoftwareInventoryIdentity_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_SoftwareInventoryIdentity& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (inst.getProperty("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	if (inst.getProperty("UpgradeCondition", instance.UpgradeCondition) == OK)
		instance.UpgradeCondition_isNULL = false;

	if (inst.getProperty("OtherUpgradeCondition", instance.OtherUpgradeCondition) == OK)
		instance.OtherUpgradeCondition_isNULL = false;

	if (inst.getProperty("ElementSoftwareStatus", instance.ElementSoftwareStatus) == OK)
		instance.ElementSoftwareStatus_isNULL = false;

	_L_;
}

