/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#include "cmpiOpenDRIM_AccountManagementServiceAffectsIdentity.h"

CMPIObjectPath* Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_AccountManagementServiceAffectsIdentity& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_AccountManagementServiceAffectsIdentity_classnames[0], OpenDRIM_AccountManagementServiceAffectsIdentity_NAMESPACE);

	if (!instance.AffectedElement_isNULL)
		op.addKey("AffectedElement", instance.AffectedElement);

	if (!instance.AffectingElement_isNULL)
		op.addKey("AffectingElement", instance.AffectingElement);

	_L_;
	return op.getHdl();
}

CMPIInstance* Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_AccountManagementServiceAffectsIdentity& instance) {
	_E_;
	Objectpath op(broker, Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.ElementEffects_isNULL)
		ci.setProperty("ElementEffects", instance.ElementEffects);

	if (!instance.OtherElementEffectsDescriptions_isNULL)
		ci.setProperty("OtherElementEffectsDescriptions", instance.OtherElementEffectsDescriptions);

	if (!instance.AssignedSequence_isNULL)
		ci.setProperty("AssignedSequence", instance.AssignedSequence);

	if (!instance.ElementAffects_isNULL)
		ci.setProperty("ElementAffects", instance.ElementAffects);

	_L_;
	return ci.getHdl();
}

void Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_AccountManagementServiceAffectsIdentity& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("AffectedElement", instance.AffectedElement) == OK)
		instance.AffectedElement_isNULL = false;

	if (op.getKey("AffectingElement", instance.AffectingElement) == OK)
		instance.AffectingElement_isNULL = false;

	_L_;
}

void Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_AccountManagementServiceAffectsIdentity& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("AffectedElement", instance.AffectedElement) == OK)
		instance.AffectedElement_isNULL = false;

	if (inst.getProperty("AffectingElement", instance.AffectingElement) == OK)
		instance.AffectingElement_isNULL = false;

	if (inst.getProperty("ElementEffects", instance.ElementEffects) == OK)
		instance.ElementEffects_isNULL = false;

	if (inst.getProperty("OtherElementEffectsDescriptions", instance.OtherElementEffectsDescriptions) == OK)
		instance.OtherElementEffectsDescriptions_isNULL = false;

	if (inst.getProperty("AssignedSequence", instance.AssignedSequence) == OK)
		instance.AssignedSequence_isNULL = false;

	if (inst.getProperty("ElementAffects", instance.ElementAffects) == OK)
		instance.ElementAffects_isNULL = false;

	_L_;
}

