#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_PhysicalAssetCapabilities.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_PhysicalAssetCapabilities provider module";
Name = "PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesModule";
Location = "cmpiPhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_PhysicalAssetCapabilities provider";
Name = "PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProvider";
ProviderModuleName = "PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_PhysicalAssetCapabilities provider capabilities";
ProviderModuleName = "PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesModule";
ProviderName = "PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProvider";
ClassName = "OpenDRIM_PhysicalAssetCapabilities";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "Description", "InstanceID", "ElementName", "FRUInfoSupported"};
SupportedMethods = {"CreateGoalSettings"};
CapabilityID = "PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_PhysicalAssetCapabilities.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_PhysicalAssetCapabilities]   
   provider: PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProvider
   location: cmpiPhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_PhysicalAssetCapabilities.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_PhysicalAssetCapabilities-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_PhysicalAssetCapabilities.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
