/*###############################################################################
# Linux Management Providers (LMP), Base_Server provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_ComputerSystemConformsToProfileAccess.h"

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Base_Server_CIM_RegisteredProfile_load(broker, errorMessage));
	CF_assert(Base_Server_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Base_Server_CIM_RegisteredProfile_unload(errorMessage));
	CF_assert(Base_Server_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_isAssociated(const Instance& ConformantStandard, const Instance& ManagedElement, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ComputerSystemConformsToProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_enumerateConformantStandards(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_enumerateConformantStandards(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		Base_Server_OpenDRIM_ComputerSystemConformsToProfile_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			ConformantStandard_classnames[0], ManagedElement_classnames[0],
			ConformantStandard_role.c_str(), ManagedElement_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_referenceConformantStandardToManagedElement(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ComputerSystemConformsToProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath ConformantStandard_objectpath;
	instance.getConformantStandard(ConformantStandard_objectpath);
	Instance ConformantStandard_instance;
	CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_getConformantStandard(broker, ctx, ConformantStandard_objectpath, ConformantStandard_instance, NULL, errorMessage));
	
	Objectpath ManagedElement_objectpath;
	instance.getManagedElement(ManagedElement_objectpath);
	Instance ManagedElement_instance;
	CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_getManagedElement(broker, ctx, ManagedElement_objectpath, ManagedElement_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_isAssociated(ConformantStandard_instance, ManagedElement_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemConformsToProfile& newInstance, const OpenDRIM_ComputerSystemConformsToProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemConformsToProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemConformsToProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> ManagedElement_instances;
	if (discriminant=="a")
		CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<ManagedElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_isAssociated(ConformantStandard_instance, ManagedElement_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			ManagedElement_associatedInstances.push_back(ManagedElement_instances[i]);
	}
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> ConformantStandard_instances;
	if (discriminant=="a")
		CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_enumerateConformantStandards(broker, ctx, ConformantStandard_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_enumerateConformantStandards(broker, ctx, ConformantStandard_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_enumerateConformantStandards(broker, ctx, ConformantStandard_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<ConformantStandard_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Base_Server_OpenDRIM_ComputerSystemConformsToProfile_isAssociated(ConformantStandard_instances[i], ManagedElement_instance, isAssociated, errorMessage));
		if (isAssociated)
			ConformantStandard_associatedInstances.push_back(ConformantStandard_instances[i]);
	}
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_ComputerSystemConformsToProfile>& OpenDRIM_ComputerSystemConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < ManagedElement_instances.size(); i++) {
		OpenDRIM_ComputerSystemConformsToProfile instance;
		instance.setConformantStandard(((Instance) ConformantStandard_instance).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instances[i]).getObjectpath());
		
		OpenDRIM_ComputerSystemConformsToProfile_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_ComputerSystemConformsToProfile>& OpenDRIM_ComputerSystemConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < ConformantStandard_instances.size(); i++) {
		OpenDRIM_ComputerSystemConformsToProfile instance;
		instance.setConformantStandard(((Instance) ConformantStandard_instances[i]).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instance).getObjectpath());
		
		OpenDRIM_ComputerSystemConformsToProfile_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_populate(OpenDRIM_ComputerSystemConformsToProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

