#line 1 "cfunc.mod"
#include "cm.h"
#line 1 "cfunc.mod"
/* $Id: cfunc.mod,v 1.2 2003/08/05 17:20:45 pnenzi Exp $ */

void ucm_real_gain (Mif_Private_t *private)
{
    double      *in;
    double      *out;

    double      in_offset;
    double      gain;
    double      out_offset;
    double      delay;
    double      ic;


    /* Get the input and output pointers */
    in = private->conn[0]->port[0]->input.pvalue;
    out = private->conn[1]->port[0]->output.pvalue;

    /* Get the parameters */
    in_offset  = private->param[0]->element[0].rvalue;
    gain       = private->param[1]->element[0].rvalue;
    out_offset = private->param[2]->element[0].rvalue;
    delay      = private->param[3]->element[0].rvalue;
    ic         = private->param[4]->element[0].rvalue;


    /* Assign the output and delay */    
    if(private->circuit.anal_type == DC) {
        *out = ic;
        if(private->circuit.init)
            cm_event_queue(delay);
    }
    else {
        *out = gain * (*in + in_offset) + out_offset;
        private->conn[1]->port[0]->delay = delay;
    }
}


