<?php
/**
 * Schedule a custom recording by manually specifying starttime and length
 *
 * @url         $URL: http://svn.mythtv.org/svn/branches/release-0-21-fixes/mythplugins/mythweb/modules/tv/schedules_manual.php $
 * @date        $Date: 2008-02-16 15:50:50 -0600 (Sat, 16 Feb 2008) $
 * @version     $Revision: 16069 $
 * @author      $Author: kormoc $
 *
 * @package     MythWeb
 * @subpackage  TV
 *
/**/

// Populate the $Channels array
    load_all_channels();

// Path-based
    if ($Path[3])
        $_GET['recordid'] = $Path[3];

// Load an existing schedule?
    if ($_GET['recordid'] && $Schedules[$_GET['recordid']]) {
        $schedule =& $Schedules[$_GET['recordid']];
    // Not a manual schedule
        if (empty($schedule->search) || $schedule->search != searchtype_manual)
            redirect_browser(root.'tv/schedules');
    }
// Create a new, empty schedule
    else
        $schedule = new Schedule(NULL);

// The user tried to update the recording settings - update the database and the variable in memory
    if (isset($_POST['save'])) {
    // Which type of recording is this?  Make sure an illegal one isn't specified
        switch ($_POST['record']) {
        // Only certain rectypes are allowed
            case rectype_once:        $type = rectype_once;        break;
            case rectype_daily:       $type = rectype_daily;       break;
            case rectype_weekly:      $type = rectype_weekly;      break;
        // Can override
            case rectype_override:    $type = rectype_override;    break;
            case rectype_dontrec:     $type = rectype_dontrec;     break;
        // Everything else gets ignored
            default:                  $type = 0;
        }
    // Cancelling a schedule?
        if ($type == 0) {
        // Cancel this schedule
            if ($schedule && $schedule->recordid) {
            // Delete the schedule
                $schedule->delete();
            // Redirect back to the schedule list
                add_warning(t('The requested recording schedule has been deleted.'));
                save_session_errors();
                header('Location: '.root.'tv/schedules');
                exit;
            }
        }
    // Adding a new schedule
        else {
        // Set things as the user requested
            $schedule->profile       = $_POST['profile'];
            $schedule->recgroup      = $_POST['recgroup'];
            $schedule->storagegroup  = $_POST['storagegroup'];
            $schedule->playgroup     = $_POST['playgroup'];
            $schedule->autoexpire    = $_POST['autoexpire']   ? 1 : 0;
            $schedule->autocommflag  = $_POST['autocommflag'] ? 1 : 0;
            $schedule->autouserjob1  = $_POST['autouserjob1'] ? 1 : 0;
            $schedule->autouserjob2  = $_POST['autouserjob2'] ? 1 : 0;
            $schedule->autouserjob3  = $_POST['autouserjob3'] ? 1 : 0;
            $schedule->autouserjob4  = $_POST['autouserjob4'] ? 1 : 0;
            $schedule->maxnewest     = $_POST['maxnewest']    ? 1 : 0;
            $schedule->dupin         = _or($_POST['dupin'] + $_POST['dupin2'], dupsin_all);
            $schedule->dupmethod     = _or($_POST['dupmethod'], 6);
            $schedule->recpriority   = intval($_POST['recpriority']);
            $schedule->maxepisodes   = intval($_POST['maxepisodes']);
            $schedule->startoffset   = intval($_POST['startoffset']);
            $schedule->endoffset     = intval($_POST['endoffset']);
        // Some settings specific to manual recordings (since we have no program to match against)
            $schedule->chanid        = $_POST['channel'];
            $schedule->station       = $Channels[$schedule->chanid]->callsign;
            $schedule->starttime     = strtotime($_POST['startdate'].' '.$_POST['starttime']);
            $schedule->endtime       = $schedule->starttime + ($_POST['length'] * 60);
            $schedule->description   = 'Manually scheduled';
            $schedule->category      = 'Manual recording';
            $schedule->search        = searchtype_manual;
            $schedule->findday       = date('w',     $schedule->starttime);
            $schedule->findtime      = date('H:m:s', $schedule->starttime);
            $schedule->autotranscode = $_POST['autotranscode'] ? 1 : 0;
            $schedule->transcoder    = $_POST['transcoder'];
        // Figure out the title
            $channel = $Channels[$_POST['channel']];
            if (strcasecmp($_POST['title'], t('Use callsign')) == 0) {
                if ($_SESSION["prefer_channum"])
                    $schedule->title = $channel->channum.' ('.$channel->callsign.')';
                else
                    $schedule->title = $channel->callsign.' ('.$channel->channum.')';
            }
            else
                $schedule->title = $_POST['title'];
        // Now the subtitle
            if (strcasecmp($_POST['subtitle'], t('Use date/time')) == 0)
                $schedule->subtitle = date('Y-m-d H:i:s', $schedule->starttime)
                                     .' ('.tn('$1 min', '$1 mins', $_POST['length']).')';
            else
                $schedule->subtitle = $_POST['subtitle'];
        // Save the schedule
            $schedule->save($type);
        // Redirect to the new schedule
            header('Location: '.root.'tv/schedules/manual/'.$schedule->recordid);
            exit;
        }
    }
// Load default settings for recpriority, autoexpire etc
    else {
    // Default title/subtitle
        if (!$schedule->title) {
            $schedule->title    = t('Use callsign');
            $schedule->subtitle = t('Use date/time');
        }
    // Make sure we have a default rectype
        if (!$schedule->type)
            $schedule->type = rectype_once;
    // Date/time/etc
        if (!$schedule->starttime)
            $schedule->starttime = time();
    // auto-commercial-flag
        if (!isset($schedule->autocommflag))
            $schedule->autocommflag = get_backend_setting('AutoCommercialFlag');
    // auto-user-jobs
        if (!isset($schedule->autouserjob1))
            $schedule->autouserjob1 = get_backend_setting('AutoRunUserJob1');
        if (!isset($schedule->autouserjob2))
            $schedule->autouserjob2 = get_backend_setting('AutoRunUserJob2');
        if (!isset($schedule->autouserjob3))
            $schedule->autouserjob3 = get_backend_setting('AutoRunUserJob3');
        if (!isset($schedule->autouserjob4))
            $schedule->autouserjob4 = get_backend_setting('AutoRunUserJob4');
    // auto-transcode
        if (!isset($schedule->autotranscode))
            $schedule->autotranscode = get_backend_setting('AutoTranscode');
    // transcoder
        if (!isset($schedule->transcoder))
            $schedule->transcoder = get_backend_setting('DefaultTranscoder');
    // recpriority
        if (!isset($schedule->recpriority)) {
            $result = mysql_query('SELECT recpriority from channel where chanid='.escape($program->chanid));
            list($schedule->recpriority) = mysql_fetch_row($result);
            mysql_free_result($result);
        }
    // autoexpire
        if (!isset($schedule->autoexpire)) {
            $result = mysql_query("SELECT data from settings where value='AutoExpireDefault'");
            list($schedule->autoexpire) = mysql_fetch_row($result);
            mysql_free_result($result);
        }
    }

// Calculate the length
    $schedule->length = intval(($schedule->endtime - $schedule->starttime) / 60);
    if ($schedule->length < 1)
        $schedule->length = 120;

// Load the utility/display functions for scheduling
    require_once 'includes/schedule_utils.php';

// Load the class for this page
    require_once tmpl_dir.'schedules_manual.php';

// Exit
    exit;

/**
 * prints a <select> of the available channels
/**/
    function channel_select($chanid) {
        global $Channels;
        echo '<select name="channel">';
        $seen = array();
        foreach ($Channels as $channel) {
        // Ignore invisible channels
            if ($channel->visible == 0)
                continue;
        // Group by channum
            if ($seen[$channel->channum])
                continue;
            $seen[$channel->channum] = $channel;

        // Print the option
            echo '<option value="', $channel->chanid, '"',
                 ' title="', html_entities($channel->name), '"';
        // Selected?
            if ($channel->chanid == $chanid)
                echo ' SELECTED';
        // Print ther est of the content
            echo '>';
            if ($_SESSION["prefer_channum"])
                echo $channel->channum.'&nbsp;&nbsp;('.html_entities($channel->callsign).')';
            else
                echo html_entities($channel->callsign).'&nbsp;&nbsp;('.$channel->channum.')';
            echo '</option>';
        }
        echo '</select>';
    }

