/*
 *   xlarray.c -- Mwave Manager code
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/*Could not get floating point to work in all Operating Systems with the*/
/*set of compilers being used.  Therefore, this look up array will be used*/
/*for consistent performance.  The equation is 32767 * 10**(pwr/200) where*/
/*pwr is in units of dBm/10.*/

#include "mwwttcus.h"  /* for the MIN_POWER_ALLOWED define*/

unsigned short XLarray [-MIN_POWER_ALLOWED + 1] =
{
  32767,    /*0x7FFF       0dBm*/
  32392,    /*0x7E88     -.1dBm*/
  32021,    /*0x7D15     -.2dBm*/
  31655,    /*0x7BA7     -.3dBm*/
  31292,    /*0x7A3C     -.4dBm*/
  30934,    /*0x78D6     -.5dBm*/
  30580,    /*0x7774     -.6dBm*/
  30230,    /*0x7616     -.7dBm*/
  29884,    /*0x74BC     -.8dBm*/
  29542,    /*0x7366     -.9dBm*/
  29204,    /*0x7214    -1.0dBm*/
  28869,    /*0x70C5    -1.1dBm*/
  28539,    /*0x6F7B    -1.2dBm*/
  28212,    /*0x6E34    -1.3dBm*/
  27889,    /*0x6CF1    -1.4dBm*/
  27570,    /*0x6BB2    -1.5dBm*/
  27254,    /*0x6A76    -1.6dBm*/
  26942,    /*0x693E    -1.7dBm*/
  26634,    /*0x680A    -1.8dBm*/
  26329,    /*0x66D9    -1.9dBm*/
  26028,    /*0x65AC    -2.0dBm*/
  25730,    /*0x6482    -2.1dBm*/
  25435,    /*0x635B    -2.2dBm*/
  25144,    /*0x6238    -2.3dBm*/
  24856,    /*0x6118    -2.4dBm*/
  24572,    /*0x5FFC    -2.5dBm*/
  24291,    /*0x5EE3    -2.6dBm*/
  24012,    /*0x5DCC    -2.7dBm*/
  23738,    /*0x5CBA    -2.8dBm*/
  23466,    /*0x5BAA    -2.9dBm*/
  23197,    /*0x5A9D    -3.0dBm*/
  22932,    /*0x5994    -3.1dBm*/
  22669,    /*0x588D    -3.2dBm*/
  22410,    /*0x578A    -3.3dBm*/
  22153,    /*0x5689    -3.4dBm*/
  21900,    /*0x558C    -3.5dBm*/
  21649,    /*0x5491    -3.6dBm*/
  21401,    /*0x5399    -3.7dBm*/
  21156,    /*0x52A4    -3.8dBm*/
  20914,    /*0x51B2    -3.9dBm*/
  20675,    /*0x50C3    -4.0dBm*/
  20438,    /*0x4FD6    -4.1dBm*/
  20204,    /*0x4EEC    -4.2dBm*/
  19973,    /*0x4E05    -4.3dBm*/
  19744,    /*0x4D20    -4.4dBm*/
  19518,    /*0x4C3E    -4.5dBm*/
  19295,    /*0x4B5F    -4.6dBm*/
  19074,    /*0x4A82    -4.7dBm*/
  18855,    /*0x49A7    -4.8dBm*/
  18640,    /*0x48D0    -4.9dBm*/
  18426,    /*0x47FA    -5.0dBm*/
  18215,    /*0x4727    -5.1dBm*/
  18007,    /*0x4657    -5.2dBm*/
  17801,    /*0x4589    -5.3dBm*/
  17597,    /*0x44BD    -5.4dBm*/
  17395,    /*0x43F3    -5.5dBm*/
  17196,    /*0x432C    -5.6dBm*/
  17000,    /*0x4268    -5.7dBm*/
  16805,    /*0x41A5    -5.8dBm*/
  16613,    /*0x40E5    -5.9dBm*/
  16422,    /*0x4026    -6.0dBm*/
  16234,    /*0x3F6A    -6.1dBm*/
  16049,    /*0x3EB1    -6.2dBm*/
  15865,    /*0x3DF9    -6.3dBm*/
  15683,    /*0x3D43    -6.4dBm*/
  15504,    /*0x3C90    -6.5dBm*/
  15326,    /*0x3BDE    -6.6dBm*/
  15151,    /*0x3B2F    -6.7dBm*/
  14977,    /*0x3A81    -6.8dBm*/
  14806,    /*0x39D6    -6.9dBm*/
  14636,    /*0x392C    -7.0dBm*/
  14469,    /*0x3885    -7.1dBm*/
  14303,    /*0x37DF    -7.2dBm*/
  14140,    /*0x373C    -7.3dBm*/
  13978,    /*0x369A    -7.4dBm*/
  13818,    /*0x35FA    -7.5dBm*/
  13660,    /*0x355C    -7.6dBm*/
  13503,    /*0x34BF    -7.7dBm*/
  13349,    /*0x3425    -7.8dBm*/
  13196,    /*0x338C    -7.9dBm*/
  13045,    /*0x32F5    -8.0dBm*/
  12895,    /*0x325F    -8.1dBm*/
  12748,    /*0x31CC    -8.2dBm*/
  12602,    /*0x313A    -8.3dBm*/
  12458,    /*0x30AA    -8.4dBm*/
  12315,    /*0x301B    -8.5dBm*/
  12174,    /*0x2F8E    -8.6dBm*/
  12035,    /*0x2F03    -8.7dBm*/
  11897,    /*0x2E79    -8.8dBm*/
  11761,    /*0x2DF1    -8.9dBm*/
  11626,    /*0x2D6A    -9.0dBm*/
  11493,    /*0x2CE5    -9.1dBm*/
  11362,    /*0x2C62    -9.2dBm*/
  11231,    /*0x2BDF    -9.3dBm*/
  11103,    /*0x2B5F    -9.4dBm*/
  10976,    /*0x2AE0    -9.5dBm*/
  10850,    /*0x2A62    -9.6dBm*/
  10726,    /*0x29E6    -9.7dBm*/
  10603,    /*0x296B    -9.8dBm*/
  10482,    /*0x28F2    -9.9dBm*/
  10362,    /*0x287A   -10.0dBm*/
  10243,    /*0x2803   -10.1dBm*/
  10126,    /*0x278E   -10.2dBm*/
  10010,    /*0x271A   -10.3dBm*/
   9895,    /*0x26A7   -10.4dBm*/
   9782,    /*0x2636   -10.5dBm*/
   9670,    /*0x25C6   -10.6dBm*/
   9560,    /*0x2558   -10.7dBm*/
   9450,    /*0x24EA   -10.8dBm*/
   9342,    /*0x247E   -10.9dBm*/
   9235,    /*0x2413   -11.0dBm*/
   9129,    /*0x23A9   -11.1dBm*/
   9025,    /*0x2341   -11.2dBm*/
   8921,    /*0x22D9   -11.3dBm*/
   8819,    /*0x2273   -11.4dBm*/
   8718,    /*0x220E   -11.5dBm*/
   8619,    /*0x21AB   -11.6dBm*/
   8520,    /*0x2148   -11.7dBm*/
   8422,    /*0x20E6   -11.8dBm*/
   8326,    /*0x2086   -11.9dBm*/
   8231,    /*0x2027   -12.0dBm*/
   8136,    /*0x1FC8   -12.1dBm*/
   8043,    /*0x1F6B   -12.2dBm*/
   7951,    /*0x1F0F   -12.3dBm*/
   7860,    /*0x1EB4   -12.4dBm*/
   7770,    /*0x1E5A   -12.5dBm*/
   7681,    /*0x1E01   -12.6dBm*/
   7593,    /*0x1DA9   -12.7dBm*/
   7506,    /*0x1D52   -12.8dBm*/
   7421,    /*0x1CFD   -12.9dBm*/
   7336,    /*0x1CA8   -13.0dBm*/
   7252,    /*0x1C54   -13.1dBm*/
   7169,    /*0x1C01   -13.2dBm*/
   7087,    /*0x1BAF   -13.3dBm*/
   7005,    /*0x1B5D   -13.4dBm*/
   6925,    /*0x1B0D   -13.5dBm*/
   6846,    /*0x1ABE   -13.6dBm*/
   6768,    /*0x1A70   -13.7dBm*/
   6690,    /*0x1A22   -13.8dBm*/
   6614,    /*0x19D6   -13.9dBm*/
   6538,    /*0x198A   -14.0dBm*/
   6463,    /*0x193F   -14.1dBm*/
   6389,    /*0x18F5   -14.2dBm*/
   6316,    /*0x18AC   -14.3dBm*/
   6244,    /*0x1864   -14.4dBm*/
   6172,    /*0x181C   -14.5dBm*/
   6102,    /*0x17D6   -14.6dBm*/
   6032,    /*0x1790   -14.7dBm*/
   5963,    /*0x174B   -14.8dBm*/
   5894,    /*0x1706   -14.9dBm*/
   5827,    /*0x16C3   -15.0dBm*/
   5760,    /*0x1680   -15.1dBm*/
   5694,    /*0x163E   -15.2dBm*/
   5629,    /*0x15FD   -15.3dBm*/
   5565,    /*0x15BD   -15.4dBm*/
   5501,    /*0x157D   -15.5dBm*/
   5438,    /*0x153E   -15.6dBm*/
   5376,    /*0x1500   -15.7dBm*/
   5314,    /*0x14C2   -15.8dBm*/
   5253,    /*0x1485   -15.9dBm*/
   5193,    /*0x1449   -16.0dBm*/
   5134,    /*0x140E   -16.1dBm*/
   5075,    /*0x13D3   -16.2dBm*/
   5017,    /*0x1399   -16.3dBm*/
   4959,    /*0x135F   -16.4dBm*/
   4903,    /*0x1327   -16.5dBm*/
   4847,    /*0x12EF   -16.6dBm*/
   4791,    /*0x12B7   -16.7dBm*/
   4736,    /*0x1280   -16.8dBm*/
   4682,    /*0x124A   -16.9dBm*/
   4628,    /*0x1214   -17.0dBm*/
   4575,    /*0x11DF   -17.1dBm*/
   4523,    /*0x11AB   -17.2dBm*/
   4471,    /*0x1177   -17.3dBm*/
   4420,    /*0x1144   -17.4dBm*/
   4370,    /*0x1112   -17.5dBm*/
   4320,    /*0x10E0   -17.6dBm*/
   4270,    /*0x10AE   -17.7dBm*/
   4221,    /*0x107D   -17.8dBm*/
   4173,    /*0x104D   -17.9dBm*/
   4125,    /*0x101D   -18.0dBm*/
   4078,    /*0x0FEE   -18.1dBm*/
   4031,    /*0x0FBF   -18.2dBm*/
   3985,    /*0x0F91   -18.3dBm*/
   3939,    /*0x0F63   -18.4dBm*/
   3894,    /*0x0F36   -18.5dBm*/
   3850,    /*0x0F0A   -18.6dBm*/
   3806,    /*0x0EDE   -18.7dBm*/
   3762,    /*0x0EB2   -18.8dBm*/
   3719,    /*0x0E87   -18.9dBm*/
   3677,    /*0x0E5D   -19.0dBm*/
   3634,    /*0x0E32   -19.1dBm*/
   3593,    /*0x0E09   -19.2dBm*/
   3552,    /*0x0DE0   -19.3dBm*/
   3511,    /*0x0DB7   -19.4dBm*/
   3471,    /*0x0D8F   -19.5dBm*/
   3431,    /*0x0D67   -19.6dBm*/
   3392,    /*0x0D40   -19.7dBm*/
   3353,    /*0x0D19   -19.8dBm*/
   3315,    /*0x0CF3   -19.9dBm*/
   3277,    /*0x0CCD   -20.0dBm*/
   3239,    /*0x0CA7   -20.1dBm*/
   3202,    /*0x0C82   -20.2dBm*/
   3165,    /*0x0C5D   -20.3dBm*/
   3129,    /*0x0C39   -20.4dBm*/
   3093,    /*0x0C15   -20.5dBm*/
   3058,    /*0x0BF2   -20.6dBm*/
   3023,    /*0x0BCF   -20.7dBm*/
   2988,    /*0x0BAC   -20.8dBm*/
   2954,    /*0x0B8A   -20.9dBm*/
   2920,    /*0x0B68   -21.0dBm*/
   2887,    /*0x0B47   -21.1dBm*/
   2854,    /*0x0B26   -21.2dBm*/
   2821,    /*0x0B05   -21.3dBm*/
   2789,    /*0x0AE5   -21.4dBm*/
   2757,    /*0x0AC5   -21.5dBm*/
   2725,    /*0x0AA5   -21.6dBm*/
   2694,    /*0x0A86   -21.7dBm*/
   2663,    /*0x0A67   -21.8dBm*/
   2633,    /*0x0A49   -21.9dBm*/
   2603,    /*0x0A2B   -22.0dBm*/
   2573,    /*0x0A0D   -22.1dBm*/
   2544,    /*0x09F0   -22.2dBm*/
   2514,    /*0x09D2   -22.3dBm*/
   2486,    /*0x09B6   -22.4dBm*/
   2457,    /*0x0999   -22.5dBm*/
   2429,    /*0x097D   -22.6dBm*/
   2401,    /*0x0961   -22.7dBm*/
   2374,    /*0x0946   -22.8dBm*/
   2347,    /*0x092B   -22.9dBm*/
   2320,    /*0x0910   -23.0dBm*/
   2293,    /*0x08F5   -23.1dBm*/
   2267,    /*0x08DB   -23.2dBm*/
   2241,    /*0x08C1   -23.3dBm*/
   2215,    /*0x08A7   -23.4dBm*/
   2190,    /*0x088E   -23.5dBm*/
   2165,    /*0x0875   -23.6dBm*/
   2140,    /*0x085C   -23.7dBm*/
   2116,    /*0x0844   -23.8dBm*/
   2091,    /*0x082B   -23.9dBm*/
   2067,    /*0x0813   -24.0dBm*/
   2044,    /*0x07FC   -24.1dBm*/
   2020,    /*0x07E4   -24.2dBm*/
   1997,    /*0x07CD   -24.3dBm*/
   1974,    /*0x07B6   -24.4dBm*/
   1952,    /*0x07A0   -24.5dBm*/
   1929,    /*0x0789   -24.6dBm*/
   1907,    /*0x0773   -24.7dBm*/
   1886,    /*0x075E   -24.8dBm*/
   1864,    /*0x0748   -24.9dBm*/
   1843,    /*0x0733   -25.0dBm*/
   1822,    /*0x071E   -25.1dBm*/
   1801,    /*0x0709   -25.2dBm*/
   1780,    /*0x06F4   -25.3dBm*/
   1760,    /*0x06E0   -25.4dBm*/
   1740,    /*0x06CC   -25.5dBm*/
   1720,    /*0x06B8   -25.6dBm*/
   1700,    /*0x06A4   -25.7dBm*/
   1680,    /*0x0690   -25.8dBm*/
   1661,    /*0x067D   -25.9dBm*/
   1642,    /*0x066A   -26.0dBm*/
   1623,    /*0x0657   -26.1dBm*/
   1605,    /*0x0645   -26.2dBm*/
   1586,    /*0x0632   -26.3dBm*/
   1568,    /*0x0620   -26.4dBm*/
   1550,    /*0x060E   -26.5dBm*/
   1533,    /*0x05FD   -26.6dBm*/
   1515,    /*0x05EB   -26.7dBm*/
   1498,    /*0x05DA   -26.8dBm*/
   1481,    /*0x05C9   -26.9dBm*/
   1464,    /*0x05B8   -27.0dBm*/
   1447,    /*0x05A7   -27.1dBm*/
   1430,    /*0x0596   -27.2dBm*/
   1414,    /*0x0586   -27.3dBm*/
   1398,    /*0x0576   -27.4dBm*/
   1382,    /*0x0566   -27.5dBm*/
   1366,    /*0x0556   -27.6dBm*/
   1350,    /*0x0546   -27.7dBm*/
   1335,    /*0x0537   -27.8dBm*/
   1320,    /*0x0528   -27.9dBm*/
   1304,    /*0x0518   -28.0dBm*/
   1290,    /*0x050A   -28.1dBm*/
   1275,    /*0x04FB   -28.2dBm*/
   1260,    /*0x04EC   -28.3dBm*/
   1246,    /*0x04DE   -28.4dBm*/
   1232,    /*0x04D0   -28.5dBm*/
   1217,    /*0x04C1   -28.6dBm*/
   1203,    /*0x04B3   -28.7dBm*/
   1190,    /*0x04A6   -28.8dBm*/
   1176,    /*0x0498   -28.9dBm*/
   1163,    /*0x048B   -29.0dBm*/
   1149,    /*0x047D   -29.1dBm*/
   1136,    /*0x0470   -29.2dBm*/
   1123,    /*0x0463   -29.3dBm*/
   1110,    /*0x0456   -29.4dBm*/
   1098,    /*0x044A   -29.5dBm*/
   1085,    /*0x043D   -29.6dBm*/
   1073,    /*0x0431   -29.7dBm*/
   1060,    /*0x0424   -29.8dBm*/
   1048,    /*0x0418   -29.9dBm*/
   1036,    /*0x040C   -30.0dBm*/
   1024,    /*0x0400   -30.1dBm*/
   1013,    /*0x03F5   -30.2dBm*/
   1001,    /*0x03E9   -30.3dBm*/
    990,    /*0x03DE   -30.4dBm*/
    978,    /*0x03D2   -30.5dBm*/
    967,    /*0x03C7   -30.6dBm*/
    956,    /*0x03BC   -30.7dBm*/
    945,    /*0x03B1   -30.8dBm*/
    934,    /*0x03A6   -30.9dBm*/
    923,    /*0x039B   -31.0dBm*/
    913,    /*0x0391   -31.1dBm*/
    902,    /*0x0386   -31.2dBm*/
    892,    /*0x037C   -31.3dBm*/
    882,    /*0x0372   -31.4dBm*/
    872,    /*0x0368   -31.5dBm*/
    862,    /*0x035E   -31.6dBm*/
    852,    /*0x0354   -31.7dBm*/
    842,    /*0x034A   -31.8dBm*/
    833,    /*0x0341   -31.9dBm*/
    823,    /*0x0337   -32.0dBm*/
    814,    /*0x032E   -32.1dBm*/
    804,    /*0x0324   -32.2dBm*/
    795,    /*0x031B   -32.3dBm*/
    786,    /*0x0312   -32.4dBm*/
    777,    /*0x0309   -32.5dBm*/
    768,    /*0x0300   -32.6dBm*/
    759,    /*0x02F7   -32.7dBm*/
    751,    /*0x02EF   -32.8dBm*/
    742,    /*0x02E6   -32.9dBm*/
    734,    /*0x02DE   -33.0dBm*/
    725,    /*0x02D5   -33.1dBm*/
    717,    /*0x02CD   -33.2dBm*/
    709,    /*0x02C5   -33.3dBm*/
    701,    /*0x02BD   -33.4dBm*/
    693,    /*0x02B5   -33.5dBm*/
    685,    /*0x02AD   -33.6dBm*/
    677,    /*0x02A5   -33.7dBm*/
    669,    /*0x029D   -33.8dBm*/
    661,    /*0x0295   -33.9dBm*/
    654,    /*0x028E   -34.0dBm*/
    646,    /*0x0286   -34.1dBm*/
    639,    /*0x027F   -34.2dBm*/
    632,    /*0x0278   -34.3dBm*/
    624,    /*0x0270   -34.4dBm*/
    617,    /*0x0269   -34.5dBm*/
    610,    /*0x0262   -34.6dBm*/
    603,    /*0x025B   -34.7dBm*/
    596,    /*0x0254   -34.8dBm*/
    589,    /*0x024D   -34.9dBm*/
    583,    /*0x0247   -35.0dBm*/
    576,    /*0x0240   -35.1dBm*/
    569,    /*0x0239   -35.2dBm*/
    563,    /*0x0233   -35.3dBm*/
    556,    /*0x022C   -35.4dBm*/
    550,    /*0x0226   -35.5dBm*/
    544,    /*0x0220   -35.6dBm*/
    538,    /*0x021A   -35.7dBm*/
    531,    /*0x0213   -35.8dBm*/
    525,    /*0x020D   -35.9dBm*/
    519,    /*0x0207   -36.0dBm*/
    513,    /*0x0201   -36.1dBm*/
    508,    /*0x01FC   -36.2dBm*/
    502,    /*0x01F6   -36.3dBm*/
    496,    /*0x01F0   -36.4dBm*/
    490,    /*0x01EA   -36.5dBm*/
    485,    /*0x01E5   -36.6dBm*/
    479,    /*0x01DF   -36.7dBm*/
    474,    /*0x01DA   -36.8dBm*/
    468,    /*0x01D4   -36.9dBm*/
    463,    /*0x01CF   -37.0dBm*/
    458,    /*0x01CA   -37.1dBm*/
    452,    /*0x01C4   -37.2dBm*/
    447,    /*0x01BF   -37.3dBm*/
    442,    /*0x01BA   -37.4dBm*/
    437,    /*0x01B5   -37.5dBm*/
    432,    /*0x01B0   -37.6dBm*/
    427,    /*0x01AB   -37.7dBm*/
    422,    /*0x01A6   -37.8dBm*/
    417,    /*0x01A1   -37.9dBm*/
    413,    /*0x019D   -38.0dBm*/
    408,    /*0x0198   -38.1dBm*/
    403,    /*0x0193   -38.2dBm*/
    399,    /*0x018F   -38.3dBm*/
    394,    /*0x018A   -38.4dBm*/
    389,    /*0x0185   -38.5dBm*/
    385,    /*0x0181   -38.6dBm*/
    381,    /*0x017D   -38.7dBm*/
    376,    /*0x0178   -38.8dBm*/
    372,    /*0x0174   -38.9dBm*/
    368,    /*0x0170   -39.0dBm*/
    363,    /*0x016B   -39.1dBm*/
    359,    /*0x0167   -39.2dBm*/
    355,    /*0x0163   -39.3dBm*/
    351,    /*0x015F   -39.4dBm*/
    347,    /*0x015B   -39.5dBm*/
    343,    /*0x0157   -39.6dBm*/
    339,    /*0x0153   -39.7dBm*/
    335,    /*0x014F   -39.8dBm*/
    331,    /*0x014B   -39.9dBm*/
    328,    /*0x0148   -40.0dBm*/
    324,    /*0x0144   -40.1dBm*/
    320,    /*0x0140   -40.2dBm*/
    317,    /*0x013D   -40.3dBm*/
    313,    /*0x0139   -40.4dBm*/
    309,    /*0x0135   -40.5dBm*/
    306,    /*0x0132   -40.6dBm*/
    302,    /*0x012E   -40.7dBm*/
    299,    /*0x012B   -40.8dBm*/
    295,    /*0x0127   -40.9dBm*/
    292,    /*0x0124   -41.0dBm*/
    289,    /*0x0121   -41.1dBm*/
    285,    /*0x011D   -41.2dBm*/
    282,    /*0x011A   -41.3dBm*/
    279,    /*0x0117   -41.4dBm*/
    276,    /*0x0114   -41.5dBm*/
    273,    /*0x0111   -41.6dBm*/
    269,    /*0x010D   -41.7dBm*/
    266,    /*0x010A   -41.8dBm*/
    263,    /*0x0107   -41.9dBm*/
    260,    /*0x0104   -42.0dBm*/
    257,    /*0x0101   -42.1dBm*/
    254,    /*0x00FE   -42.2dBm*/
    251,    /*0x00FB   -42.3dBm*/
    249,    /*0x00F9   -42.4dBm*/
    246,    /*0x00F6   -42.5dBm*/
    243,    /*0x00F3   -42.6dBm*/
    240,    /*0x00F0   -42.7dBm*/
    237,    /*0x00ED   -42.8dBm*/
    235,    /*0x00EB   -42.9dBm*/
    232,    /*0x00E8   -43.0dBm*/
    229,    /*0x00E5   -43.1dBm*/
    227,    /*0x00E3   -43.2dBm*/
    224,    /*0x00E0   -43.3dBm*/
    222,    /*0x00DE   -43.4dBm*/
    219,    /*0x00DB   -43.5dBm*/
    216,    /*0x00D8   -43.6dBm*/
    214,    /*0x00D6   -43.7dBm*/
    212,    /*0x00D4   -43.8dBm*/
    209,    /*0x00D1   -43.9dBm*/
    207,    /*0x00CF   -44.0dBm*/
    204,    /*0x00CC   -44.1dBm*/
    202,    /*0x00CA   -44.2dBm*/
    200,    /*0x00C8   -44.3dBm*/
    197,    /*0x00C5   -44.4dBm*/
    195,    /*0x00C3   -44.5dBm*/
    193,    /*0x00C1   -44.6dBm*/
    191,    /*0x00BF   -44.7dBm*/
    189,    /*0x00BD   -44.8dBm*/
    186,    /*0x00BA   -44.9dBm*/
    184,    /*0x00B8   -45.0dBm*/
    182,    /*0x00B6   -45.1dBm*/
    180,    /*0x00B4   -45.2dBm*/
    178,    /*0x00B2   -45.3dBm*/
    176,    /*0x00B0   -45.4dBm*/
    174,    /*0x00AE   -45.5dBm*/
    172,    /*0x00AC   -45.6dBm*/
    170,    /*0x00AA   -45.7dBm*/
    168,    /*0x00A8   -45.8dBm*/
    166,    /*0x00A6   -45.9dBm*/
    164,    /*0x00A4   -46.0dBm*/
    162,    /*0x00A2   -46.1dBm*/
    160,    /*0x00A0   -46.2dBm*/
    159,    /*0x009F   -46.3dBm*/
    157,    /*0x009D   -46.4dBm*/
    155,    /*0x009B   -46.5dBm*/
    153,    /*0x0099   -46.6dBm*/
    152,    /*0x0098   -46.7dBm*/
    150,    /*0x0096   -46.8dBm*/
    148,    /*0x0094   -46.9dBm*/
    146,    /*0x0092   -47.0dBm*/
    145,    /*0x0091   -47.1dBm*/
    143,    /*0x008F   -47.2dBm*/
    141,    /*0x008D   -47.3dBm*/
    140,    /*0x008C   -47.4dBm*/
    138,    /*0x008A   -47.5dBm*/
    137,    /*0x0089   -47.6dBm*/
    135,    /*0x0087   -47.7dBm*/
    133,    /*0x0085   -47.8dBm*/
    132,    /*0x0084   -47.9dBm*/
    130,    /*0x0082   -48.0dBm*/
    129,    /*0x0081   -48.1dBm*/
    127,    /*0x007F   -48.2dBm*/
    126,    /*0x007E   -48.3dBm*/
    125,    /*0x007D   -48.4dBm*/
    123,    /*0x007B   -48.5dBm*/
    122,    /*0x007A   -48.6dBm*/
    120,    /*0x0078   -48.7dBm*/
    119,    /*0x0077   -48.8dBm*/
    118,    /*0x0076   -48.9dBm*/
    116,    /*0x0074   -49.0dBm*/
    115,    /*0x0073   -49.1dBm*/
    114,    /*0x0072   -49.2dBm*/
    112,    /*0x0070   -49.3dBm*/
    111,    /*0x006F   -49.4dBm*/
    110,    /*0x006E   -49.5dBm*/
    109,    /*0x006D   -49.6dBm*/
    107,    /*0x006B   -49.7dBm*/
    106,    /*0x006A   -49.8dBm*/
    105,    /*0x0069   -49.9dBm*/
    104,    /*0x0068   -50.0dBm*/
    102,    /*0x0066   -50.1dBm*/
    101,    /*0x0065   -50.2dBm*/
    100,    /*0x0064   -50.3dBm*/
     99,    /*0x0063   -50.4dBm*/
     98,    /*0x0062   -50.5dBm*/
     97,    /*0x0061   -50.6dBm*/
     96,    /*0x0060   -50.7dBm*/
     95,    /*0x005F   -50.8dBm*/
     93,    /*0x005D   -50.9dBm*/
     92,    /*0x005C   -51.0dBm*/
     91,    /*0x005B   -51.1dBm*/
     90,    /*0x005A   -51.2dBm*/
     89,    /*0x0059   -51.3dBm*/
     88,    /*0x0058   -51.4dBm*/
     87,    /*0x0057   -51.5dBm*/
     86,    /*0x0056   -51.6dBm*/
     85,    /*0x0055   -51.7dBm*/
     84,    /*0x0054   -51.8dBm*/
     83,    /*0x0053   -51.9dBm*/
     82,    /*0x0052   -52.0dBm*/
     81,    /*0x0051   -52.1dBm*/
     80,    /*0x0050   -52.2dBm*/
     80,    /*0x0050   -52.3dBm*/
     79,    /*0x004F   -52.4dBm*/
     78,    /*0x004E   -52.5dBm*/
     77,    /*0x004D   -52.6dBm*/
     76,    /*0x004C   -52.7dBm*/
     75,    /*0x004B   -52.8dBm*/
     74,    /*0x004A   -52.9dBm*/
     73,    /*0x0049   -53.0dBm*/
     73,    /*0x0049   -53.1dBm*/
     72,    /*0x0048   -53.2dBm*/
     71,    /*0x0047   -53.3dBm*/
     70,    /*0x0046   -53.4dBm*/
     69,    /*0x0045   -53.5dBm*/
     68,    /*0x0044   -53.6dBm*/
     68,    /*0x0044   -53.7dBm*/
     67,    /*0x0043   -53.8dBm*/
     66,    /*0x0042   -53.9dBm*/
     65,    /*0x0041   -54.0dBm*/
     65,    /*0x0041   -54.1dBm*/
     64,    /*0x0040   -54.2dBm*/
     63,    /*0x003F   -54.3dBm*/
     62,    /*0x003E   -54.4dBm*/
     62,    /*0x003E   -54.5dBm*/
     61,    /*0x003D   -54.6dBm*/
     60,    /*0x003C   -54.7dBm*/
     60,    /*0x003C   -54.8dBm*/
     59,    /*0x003B   -54.9dBm*/
     58,    /*0x003A   -55.0dBm*/
     58,    /*0x003A   -55.1dBm*/
     57,    /*0x0039   -55.2dBm*/
     56,    /*0x0038   -55.3dBm*/
     56,    /*0x0038   -55.4dBm*/
     55,    /*0x0037   -55.5dBm*/
     54,    /*0x0036   -55.6dBm*/
     54,    /*0x0036   -55.7dBm*/
     53,    /*0x0035   -55.8dBm*/
     53,    /*0x0035   -55.9dBm*/
     52,    /*0x0034   -56.0dBm*/
     51,    /*0x0033   -56.1dBm*/
     51,    /*0x0033   -56.2dBm*/
     50,    /*0x0032   -56.3dBm*/
     50,    /*0x0032   -56.4dBm*/
     49,    /*0x0031   -56.5dBm*/
     48,    /*0x0030   -56.6dBm*/
     48,    /*0x0030   -56.7dBm*/
     47,    /*0x002F   -56.8dBm*/
     47,    /*0x002F   -56.9dBm*/
     46,    /*0x002E   -57.0dBm*/
     46,    /*0x002E   -57.1dBm*/
     45,    /*0x002D   -57.2dBm*/
     45,    /*0x002D   -57.3dBm*/
     44,    /*0x002C   -57.4dBm*/
     44,    /*0x002C   -57.5dBm*/
     43,    /*0x002B   -57.6dBm*/
     43,    /*0x002B   -57.7dBm*/
     42,    /*0x002A   -57.8dBm*/
     42,    /*0x002A   -57.9dBm*/
     41,    /*0x0029   -58.0dBm*/
     41,    /*0x0029   -58.1dBm*/
     40,    /*0x0028   -58.2dBm*/
     40,    /*0x0028   -58.3dBm*/
     39,    /*0x0027   -58.4dBm*/
     39,    /*0x0027   -58.5dBm*/
     38,    /*0x0026   -58.6dBm*/
     38,    /*0x0026   -58.7dBm*/
     38,    /*0x0026   -58.8dBm*/
     37,    /*0x0025   -58.9dBm*/
     37,    /*0x0025   -59.0dBm*/
     36,    /*0x0024   -59.1dBm*/
     36,    /*0x0024   -59.2dBm*/
     36,    /*0x0024   -59.3dBm*/
     35,    /*0x0023   -59.4dBm*/
     35,    /*0x0023   -59.5dBm*/
     34,    /*0x0022   -59.6dBm*/
     34,    /*0x0022   -59.7dBm*/
     34,    /*0x0022   -59.8dBm*/
     33,    /*0x0021   -59.9dBm*/
     33};   /*0x0021   -60.0dBm*/
