########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 29 August 2007 13:08:47 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header$
#
# $Id$
#

from traceback import print_exc
## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

from Volume.VisionInterface.VolumeNodes import vollib
masterNet.getEditor().addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from MolKit.VisionInterface.MolKitNodes import molkitlib
masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Select MolFrag ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_MolFrag_0 = NodeSelector(constrkw = {}, name='Select MolFrag', library=molkitlib)
    masterNet.addNode(Select_MolFrag_0,197,149)
    Select_MolFrag_0.inputPortByName['selectionString'].widget.set("CA", run=False)
except:
    print "WARNING: failed to restore NodeSelector named Select MolFrag in network masterNet"
    print_exc()
    Select_MolFrag_0=None

try:
    ## saving node Extract Atom Property ##
    from MolKit.VisionInterface.MolKitNodes import AtomsProperty
    Extract_Atom_Property_1 = AtomsProperty(constrkw = {}, name='Extract Atom Property', library=molkitlib)
    masterNet.addNode(Extract_Atom_Property_1,135,201)
    Extract_Atom_Property_1.inputPortByName['propertyName'].widget.set("coords", run=False)
    apply(Extract_Atom_Property_1.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore AtomsProperty named Extract Atom Property in network masterNet"
    print_exc()
    Extract_Atom_Property_1=None

try:
    ## saving node Pmv ##
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_2 = PmvNode(vf=masterNet.editor.vf, constrkw = {'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    masterNet.addNode(Pmv_2,395,22)
    Pmv_2.inputPortByName['cmdName'].widget.set("", run=False)
    Pmv_2.inputPortByName['molecule'].widget.set("", run=False)
except:
    print "WARNING: failed to restore PmvNode named Pmv in network masterNet"
    print_exc()
    Pmv_2=None

try:
    ## saving node Choose Cmd ##
    from Pmv.VisionInterface.PmvNodes import PmvChooseCommand
    Choose_Cmd_3 = PmvChooseCommand(constrkw = {}, name='Choose Cmd', library=pmvlib)
    masterNet.addNode(Choose_Cmd_3,386,142)
    Choose_Cmd_3.inputPortByName['cmdName'].widget.set("bindGeomToMolecularFragment", run=False)
    apply(Choose_Cmd_3.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore PmvChooseCommand named Choose Cmd in network masterNet"
    print_exc()
    Choose_Cmd_3=None

try:
    ## saving node UT-BlurSpheres(1) ##
    from Volume.VisionInterface.VolumeNodes import UTblurSpheres
    UT_BlurSpheres_1__4 = UTblurSpheres(constrkw = {}, name='UT-BlurSpheres(1)', library=vollib)
    masterNet.addNode(UT_BlurSpheres_1__4,221,288)
    UT_BlurSpheres_1__4.inputPortByName['blobbyness'].widget.set(-0.7, run=False)
    apply(UT_BlurSpheres_1__4.inputPortByName['resX'].widget.configure, (), {'labelCfg': {'text': 'X res  (Xdim=31)       '}})
    UT_BlurSpheres_1__4.inputPortByName['resX'].widget.set(1.5, run=False)
    apply(UT_BlurSpheres_1__4.inputPortByName['resY'].widget.configure, (), {'labelCfg': {'text': 'Y res  (Ydim=32)       '}})
    UT_BlurSpheres_1__4.inputPortByName['resY'].widget.set(1.5, run=False)
    apply(UT_BlurSpheres_1__4.inputPortByName['resZ'].widget.configure, (), {'labelCfg': {'text': 'Z res  (Zdim=31)       '}})
    UT_BlurSpheres_1__4.inputPortByName['resZ'].widget.set(1.5, run=False)
    apply(UT_BlurSpheres_1__4.inputPortByName['switch'].widget.configure, (), {'command': UT_BlurSpheres_1__4.usedims_cb})
except:
    print "WARNING: failed to restore UTblurSpheres named UT-BlurSpheres(1) in network masterNet"
    print_exc()
    UT_BlurSpheres_1__4=None

try:
    ## saving node Dial ##
    from Vision.StandardNodes import DialNE
    Dial_5 = DialNE(constrkw = {}, name='Dial', library=stdlib)
    masterNet.addNode(Dial_5,340,232)
    Dial_5.inputPortByName['dial'].widget.set(3.0, run=False)
    apply(Dial_5.configure, (), {'expanded': False})
except:
    print "WARNING: failed to restore DialNE named Dial in network masterNet"
    print_exc()
    Dial_5=None

try:
    ## saving node UT-Isocontour ##
    from Volume.VisionInterface.VolumeNodes import Isocontour
    UT_Isocontour_6 = Isocontour(constrkw = {}, name='UT-Isocontour', library=vollib)
    masterNet.addNode(UT_Isocontour_6,143,341)
    apply(UT_Isocontour_6.inputPortByName['isovalue'].widget.configure, (), {'max': 5.8188228607177734, 'min': 0.0})
    UT_Isocontour_6.inputPortByName['isovalue'].widget.set(1.25504032771, run=False)
except:
    print "WARNING: failed to restore Isocontour named UT-Isocontour in network masterNet"
    print_exc()
    UT_Isocontour_6=None

try:
    ## saving node heme2DChain ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    heme2DChain_7 = IndexedPolygonsNE(constrkw = {}, name='heme2DChain', library=vizlib)
    masterNet.addNode(heme2DChain_7,143,413)
    heme2DChain_7.inputPortByName['name'].unbindWidget()
    apply(heme2DChain_7.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore IndexedPolygonsNE named heme2DChain in network masterNet"
    print_exc()
    heme2DChain_7=None

try:
    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_8 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw = {'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_8,258,591)
    ##
    ## Saving State for Viewer
    Pmv_Viewer_8.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0, 0, 0, 1), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 27, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 624, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -128.91842651367188], 'd2cutH': 255, 'far': 326.58625031702718, 'd1off': 4, 'lookFrom': [0.0, 0.0, 128.91842651367188], 'd1cutH': 60, 'antialiased': False, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 120.0, 121.0, 122.0, 123.0, 124.0, 125.0, 126.0, 127.0, 128.0, 129.0, 130.0, 131.0, 132.0, 133.0, 134.0, 135.0, 136.0, 137.0, 138.0, 139.0, 140.0, 141.0, 142.0, 143.0, 144.0, 145.0, 146.0, 147.0, 148.0, 149.0, 150.0, 151.0, 152.0, 153.0, 154.0, 155.0, 156.0, 157.0, 158.0, 159.0, 160.0, 161.0, 162.0, 163.0, 164.0, 165.0, 166.0, 167.0, 168.0, 169.0, 170.0, 171.0, 172.0, 173.0, 174.0, 175.0, 176.0, 177.0, 178.0, 179.0, 180.0, 181.0, 182.0, 183.0, 184.0, 185.0, 186.0, 187.0, 188.0, 189.0, 190.0, 191.0, 192.0, 193.0, 194.0, 195.0, 196.0, 197.0, 198.0, 199.0, 200.0, 201.0, 202.0, 203.0, 204.0, 205.0, 206.0, 207.0, 208.0, 209.0, 210.0, 211.0, 212.0, 213.0, 214.0, 215.0, 216.0, 217.0, 218.0, 219.0, 220.0, 221.0, 222.0, 223.0, 224.0, 225.0, 226.0, 227.0, 228.0, 229.0, 230.0, 231.0, 232.0, 233.0, 234.0, 235.0, 236.0, 237.0, 238.0, 239.0, 240.0, 241.0, 242.0, 243.0, 244.0, 245.0, 246.0, 247.0, 248.0, 249.0, 250.0, 251.0, 252.0, 253.0, 254.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 122, 'd1scale': 0.080000000000000002}
    apply(Pmv_Viewer_8.vi.cameras[0].Set, (), state)

    state = {'end': 163.29312515851359, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 94.54371980487025, 'mode': 'GL_LINEAR'}
    apply(Pmv_Viewer_8.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [84.629219055175781, 43.604473114013672, 2.0353817939758301], 'rotation': [0.27641186118125916, -0.090043552219867706, -0.95681172609329224, 0.0, -0.95166110992431641, -0.164393350481987, -0.2594531774520874, 0.0, -0.13393139839172363, 0.98227643966674805, -0.13113121688365936, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-84.629219055175781, -43.604473114013672, -2.0353856086730957], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Pmv_Viewer_8.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Pmv_Viewer_8.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Pmv_Viewer_8.vi.rootObject:
        Pmv_Viewer_8.vi.rootObject.clipP = []
        Pmv_Viewer_8.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_8=None

try:
    ## saving node Select MolFrag ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_MolFrag_9 = NodeSelector(constrkw = {}, name='Select MolFrag', library=molkitlib)
    masterNet.addNode(Select_MolFrag_9,20,48)
    Select_MolFrag_9.inputPortByName['nodeType'].widget.set("Chain", run=False)
    Select_MolFrag_9.inputPortByName['selectionString'].widget.set("A,B,C,D", run=False)
except:
    print "WARNING: failed to restore NodeSelector named Select MolFrag in network masterNet"
    print_exc()
    Select_MolFrag_9=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_10 = Iterate(constrkw = {}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_10,116,95)
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_10=None

try:
    ## saving node Get id ##
    from Vision.StandardNodes import GetAttr
    Get_id_11 = GetAttr(constrkw = {}, name='Get id', library=stdlib)
    masterNet.addNode(Get_id_11,43,236)
    apply(Get_id_11.inputPortByName['attr'].widget.configure, (), {'choices': ['AAradii', 'AtomRadiiPatterns', 'NodesFromName', '_MarkTree', '__cmp__', '__doc__', '__eq__', '__hash__', '__init__', '__module__', '__ne__', '__repr__', '__str__', '_atomRadius', '_copyNode', '_numberOfDeletedNodes', '_uniqIndex', 'addBond', 'adopt', 'assignUniqIndex', 'attach_nonbonded_fragments', 'bonds', 'buildBondsBhtree', 'buildBondsByDistance', 'buildBondsByDistanceOnAtoms', 'buildBrokenBonds', 'childByName', 'children', 'childrenName', 'childrenSetClass', 'closerThan', 'compare', 'compiled_patterns', 'configureProgressBar', 'connectResidues', 'defaultRadii', 'deleteSubTree', 'dump', 'elementType', 'findLevels', 'findType', 'full_name', 'gaps', 'get', 'getAtoms', 'getCenter', 'getNbrAtoms', 'getNext', 'getParentOfType', 'getPrevious', 'getRoot', 'getTypeList', 'hasBonds', 'id', 'isAbove', 'isBelow', 'isDna', 'isHetatmChain', 'isProteic', 'makeNameUniq', 'merge', 'mergeNPH', 'name', 'number', 'p', 'parent', 'parser', 'read', 'remove', 'removeAllHydrogens', 'removeBond', 'residues', 'secondaryStructure', 'setClass', 'shortestDist', 'split', 'subTree', 'top', 'updateProgressBar', 'write']})
    Get_id_11.inputPortByName['attr'].widget.set("id", run=False)
except:
    print "WARNING: failed to restore GetAttr named Get id in network masterNet"
    print_exc()
    Get_id_11=None

try:
    ## saving node Filename ##
    from Vision.StandardNodes import Filename
    Filename_12 = Filename(constrkw = {}, name='Filename', library=stdlib)
    masterNet.addNode(Filename_12,36,368)
    apply(Filename_12.inputPortByName['number'].configure, (), {'datatype': 'string', 'originalDatatype': 'int'})
    Filename_12.inputPortByName['format'].widget.set("heme2%sChain", run=False)
    apply(Filename_12.configure, (), {'expanded': False})
except:
    print "WARNING: failed to restore Filename named Filename in network masterNet"
    print_exc()
    Filename_12=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_13 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_13,35,305)
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_13=None

try:
    ## saving node RemoveDupVert ##
    from DejaVu.VisionInterface.DejaVuNodes import RemoveDuplicatedVerticesNE
    RemoveDupVert_14 = RemoveDuplicatedVerticesNE(constrkw = {}, name='RemoveDupVert', library=vizlib)
    masterNet.addNode(RemoveDupVert_14,7,451)
except:
    print "WARNING: failed to restore RemoveDuplicatedVerticesNE named RemoveDupVert in network masterNet"
    print_exc()
    RemoveDupVert_14=None

try:
    ## saving node QSlim ##
    from DejaVu.VisionInterface.DejaVuNodes import QSlim
    QSlim_15 = QSlim(constrkw = {}, name='QSlim', library=vizlib)
    masterNet.addNode(QSlim_15,40,503)
    apply(QSlim_15.inputPortByName['percent'].widget.configure, (), {'continuous': None})
    QSlim_15.inputPortByName['targetfaces'].widget.set("4074", run=False)
except:
    print "WARNING: failed to restore QSlim named QSlim in network masterNet"
    print_exc()
    QSlim_15=None

try:
    ## saving node Run bindGeomToMolecularFragment ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    Run_bindGeomToMolecularFragment_16 = PmvRunCommand(sortedArgNames=['topCommand', 'setupUndo', 'cutoff_from', 'instanceMatrices', 'cutoff_to', 'redraw', 'log'], command=masterNet.editor.vf.bindGeomToMolecularFragment, namedArgs={'topCommand': True, 'setupUndo': True, 'cutoff_from': 3.5, 'instanceMatrices': None, 'cutoff_to': 40.0, 'redraw': True, 'log': True}, posArgsNames=['geom', 'nodes'], constrkw = {'sortedArgNames': "['topCommand', 'setupUndo', 'cutoff_from', 'instanceMatrices', 'cutoff_to', 'redraw', 'log']", 'command': 'masterNet.editor.vf.bindGeomToMolecularFragment', 'namedArgs': "{'topCommand': True, 'setupUndo': True, 'cutoff_from': 3.5, 'instanceMatrices': None, 'cutoff_to': 40.0, 'redraw': True, 'log': True}", 'posArgsNames': "['geom', 'nodes']"}, name='Run bindGeomToMolecularFragment', library=pmvlib)
    masterNet.addNode(Run_bindGeomToMolecularFragment_16,395,512)
    apply(Run_bindGeomToMolecularFragment_16.addInputPort, (), {'singleConnection': True, 'name': 'geom', 'cast': True, 'datatype': 'geom', 'required': True, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'red'})
    apply(Run_bindGeomToMolecularFragment_16.addInputPort, (), {'singleConnection': True, 'name': 'nodes', 'cast': True, 'datatype': 'AtomSet', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': '#fe92a0'})
    apply(Run_bindGeomToMolecularFragment_16.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_bindGeomToMolecularFragment_16.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_bindGeomToMolecularFragment_16.addInputPort, (), {'singleConnection': True, 'name': 'cutoff_from', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to3.5', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_bindGeomToMolecularFragment_16.addInputPort, (), {'singleConnection': True, 'name': 'instanceMatrices', 'cast': True, 'datatype': 'None', 'balloon': 'Defaults toNone', 'required': False, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Run_bindGeomToMolecularFragment_16.addInputPort, (), {'singleConnection': True, 'name': 'cutoff_to', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to40.0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_bindGeomToMolecularFragment_16.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_bindGeomToMolecularFragment_16.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_bindGeomToMolecularFragment_16.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 1, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 1}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    apply(Run_bindGeomToMolecularFragment_16.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    apply(Run_bindGeomToMolecularFragment_16.inputPortByName['cutoff_from'].createWidget, (), {'descr':{'initialValue': 3.5, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'cutoff_from'}, 'class': 'NEDial', 'oneTurn': 1}})
    apply(Run_bindGeomToMolecularFragment_16.inputPortByName['cutoff_to'].createWidget, (), {'descr':{'initialValue': 40.0, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'cutoff_to'}, 'class': 'NEDial', 'oneTurn': 1}})
    apply(Run_bindGeomToMolecularFragment_16.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 9, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 9}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    apply(Run_bindGeomToMolecularFragment_16.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 11, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 11}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
except:
    print "WARNING: failed to restore PmvRunCommand named Run bindGeomToMolecularFragment in network masterNet"
    print_exc()
    Run_bindGeomToMolecularFragment_16=None

try:
    ## saving node hemoglobin_deoxy ##
    import os
    from mglutil.util.relpath import rel2abs
    lRelFileName = 'hemoglobin-deoxy.pdb'
    lNetworkDir = os.path.dirname(os.path.abspath(masterNet.filename))
    lAbsFileName = rel2abs(lRelFileName, lNetworkDir)
    mol = masterNet.editor.vf.loadMoleculeIfNeeded(lAbsFileName)
    assert mol
    from Pmv.VisionInterface.PmvNodes import PmvMolecule
    hemoglobin_deoxy_17 = PmvMolecule(molecule=masterNet.editor.vf.expandNodes("hemoglobin_deoxy")[0], constrkw = {'molecule': 'masterNet.editor.vf.expandNodes("hemoglobin_deoxy")[0]'}, name='hemoglobin_deoxy', library=pmvlib)
    masterNet.addNode(hemoglobin_deoxy_17,21,5)
except:
    print "WARNING: failed to restore PmvMolecule named hemoglobin_deoxy in network masterNet"
    print_exc()
    hemoglobin_deoxy_17=None

masterNet.run()
masterNet.freeze()

## saving connections for network hemoglobin ##
if Select_MolFrag_0 is not None and Extract_Atom_Property_1 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_0, Extract_Atom_Property_1, "nodes", "atoms", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_0 and Extract_Atom_Property_1 in network masterNet"
if Pmv_2 is not None and Choose_Cmd_3 is not None:
    try:
        masterNet.connectNodes(
            Pmv_2, Choose_Cmd_3, "PMV", "viewer", blocking=True)
    except:
        print "WARNING: failed to restore connection between Pmv_2 and Choose_Cmd_3 in network masterNet"
if Dial_5 is not None and UT_BlurSpheres_1__4 is not None:
    try:
        masterNet.connectNodes(
            Dial_5, UT_BlurSpheres_1__4, "value", "radius", blocking=True)
    except:
        print "WARNING: failed to restore connection between Dial_5 and UT_BlurSpheres_1__4 in network masterNet"
if Extract_Atom_Property_1 is not None and UT_BlurSpheres_1__4 is not None:
    try:
        masterNet.connectNodes(
            Extract_Atom_Property_1, UT_BlurSpheres_1__4, "propertyValues", "coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between Extract_Atom_Property_1 and UT_BlurSpheres_1__4 in network masterNet"
if UT_BlurSpheres_1__4 is not None and UT_Isocontour_6 is not None:
    try:
        masterNet.connectNodes(
            UT_BlurSpheres_1__4, UT_Isocontour_6, "maskGrid", "grid3D", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_BlurSpheres_1__4 and UT_Isocontour_6 in network masterNet"
if UT_Isocontour_6 is not None and heme2DChain_7 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_6, heme2DChain_7, "normals", "vnormals", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_6 and heme2DChain_7 in network masterNet"
if UT_Isocontour_6 is not None and heme2DChain_7 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_6, heme2DChain_7, "indices", "indices", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_6 and heme2DChain_7 in network masterNet"
if UT_Isocontour_6 is not None and heme2DChain_7 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_6, heme2DChain_7, "coords", "coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_6 and heme2DChain_7 in network masterNet"
if Select_MolFrag_9 is not None and iterate_10 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_9, iterate_10, "nodes", "listToLoopOver", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_9 and iterate_10 in network masterNet"
if iterate_10 is not None and Get_id_11 is not None:
    try:
        masterNet.connectNodes(
            iterate_10, Get_id_11, "oneItem", "objects", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_10 and Get_id_11 in network masterNet"
if Get_id_11 is not None and Index_13 is not None:
    try:
        masterNet.connectNodes(
            Get_id_11, Index_13, "attrs", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between Get_id_11 and Index_13 in network masterNet"
if Index_13 is not None and Filename_12 is not None:
    try:
        masterNet.connectNodes(
            Index_13, Filename_12, "data", "number", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_13 and Filename_12 in network masterNet"
if Filename_12 is not None and heme2DChain_7 is not None:
    try:
        masterNet.connectNodes(
            Filename_12, heme2DChain_7, "filename", "name", blocking=True)
    except:
        print "WARNING: failed to restore connection between Filename_12 and heme2DChain_7 in network masterNet"
if heme2DChain_7 is not None and RemoveDupVert_14 is not None:
    try:
        masterNet.connectNodes(
            heme2DChain_7, RemoveDupVert_14, "indexedPolygons", "geom", blocking=True)
    except:
        print "WARNING: failed to restore connection between heme2DChain_7 and RemoveDupVert_14 in network masterNet"
if RemoveDupVert_14 is not None and QSlim_15 is not None:
    try:
        masterNet.connectNodes(
            RemoveDupVert_14, QSlim_15, "geom", "geometry", blocking=True)
    except:
        print "WARNING: failed to restore connection between RemoveDupVert_14 and QSlim_15 in network masterNet"
if QSlim_15 is not None and Pmv_Viewer_8 is not None:
    try:
        masterNet.connectNodes(
            QSlim_15, Pmv_Viewer_8, "geometry", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between QSlim_15 and Pmv_Viewer_8 in network masterNet"
if iterate_10 is not None and Select_MolFrag_0 is not None:
    try:
        masterNet.connectNodes(
            iterate_10, Select_MolFrag_0, "oneItem", "nodes", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_10 and Select_MolFrag_0 in network masterNet"
if Choose_Cmd_3 is not None and Run_bindGeomToMolecularFragment_16 is not None:
    try:
        masterNet.connectNodes(
            Choose_Cmd_3, Run_bindGeomToMolecularFragment_16, "cmd", "command", blocking=True)
    except:
        print "WARNING: failed to restore connection between Choose_Cmd_3 and Run_bindGeomToMolecularFragment_16 in network masterNet"
if heme2DChain_7 is not None and Run_bindGeomToMolecularFragment_16 is not None:
    try:
        masterNet.connectNodes(
            heme2DChain_7, Run_bindGeomToMolecularFragment_16, "indexedPolygons", "geom", blocking=True)
    except:
        print "WARNING: failed to restore connection between heme2DChain_7 and Run_bindGeomToMolecularFragment_16 in network masterNet"
if Select_MolFrag_0 is not None and Run_bindGeomToMolecularFragment_16 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_0, Run_bindGeomToMolecularFragment_16, "nodes", "nodes", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_0 and Run_bindGeomToMolecularFragment_16 in network masterNet"
if hemoglobin_deoxy_17 is not None and Select_MolFrag_9 is not None:
    try:
        masterNet.connectNodes(
            hemoglobin_deoxy_17, Select_MolFrag_9, "Molecule", "nodes", blocking=True)
    except:
        print "WARNING: failed to restore connection between hemoglobin_deoxy_17 and Select_MolFrag_9 in network masterNet"
masterNet.unfreeze()


def loadSavedStates_Pmv_Viewer_8(self=Pmv_Viewer_8, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|misc
    ## Object root|CoarseAPBSbox
    ## Object root|FineAPBSbox
    ## Object root|hemoglobin_deoxy
    ## Object root|misc|addBondsGeom
    ## Object root|misc|edit_geoms
    ## Object root|misc|measure_geoms
    ## Object root|misc|selectInSphereGeoms
    ## Object root|hemoglobin_deoxy|selection
    ## Object root|hemoglobin_deoxy|lines
    ## Object root|hemoglobin_deoxy|AtomLabels
    ## Object root|hemoglobin_deoxy|ResidueLabels
    ## Object root|hemoglobin_deoxy|ChainLabels
    ## Object root|hemoglobin_deoxy|ProteinLabels
    ## Object root|hemoglobin_deoxy|sticks
    ## Object root|hemoglobin_deoxy|balls
    ## Object root|hemoglobin_deoxy|cpk
    ## Object root|hemoglobin_deoxy|CAsticks
    ## Object root|hemoglobin_deoxy|CAballs
    ## Object root|hemoglobin_deoxy|heme2AChain
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'heme2AChain', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|hemoglobin_deoxy|heme2AChain')
    if obj:
        apply(obj.Set, (), state)

    ## Material for heme2AChain
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 0.938498854637146, 0.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for heme2AChain

    ## Clipping Planes for heme2AChain
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for heme2AChain

    ## Object root|hemoglobin_deoxy|heme2BChain
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'heme2BChain', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|hemoglobin_deoxy|heme2BChain')
    if obj:
        apply(obj.Set, (), state)

    ## Material for heme2BChain
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 0.0, 0.17058004438877106, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for heme2BChain

    ## Clipping Planes for heme2BChain
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for heme2BChain

    ## Object root|hemoglobin_deoxy|heme2CChain
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'heme2CChain', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|hemoglobin_deoxy|heme2CChain')
    if obj:
        apply(obj.Set, (), state)

    ## Material for heme2CChain
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.039233744144439697, 1.0, 0.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for heme2CChain

    ## Clipping Planes for heme2CChain
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for heme2CChain

    ## Object root|hemoglobin_deoxy|heme2DChain
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'heme2DChain', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|hemoglobin_deoxy|heme2DChain')
    if obj:
        apply(obj.Set, (), state)

    ## Material for heme2DChain
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.036825958639383316, 0.0, 1.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for heme2DChain

    ## Clipping Planes for heme2DChain
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for heme2DChain

    ## Object root|misc|addBondsGeom|addBondsSpheres
    ## Object root|misc|edit_geoms|editAtomTypeSphere
    ## Object root|misc|edit_geoms|editAtomChargeSphere
    ## Object root|misc|measure_geoms|measureDistGeomCtrl
    ## Object root|misc|measure_geoms|measureDistGeom
    ## Object root|misc|measure_geoms|measureAngleGeom
    ## Object root|misc|measure_geoms|measureTorsionGeom
    ## Object root|misc|selectInSphereGeoms|SelSphReg_selSph
    ## Object root|misc|selectInSphereGeoms|SelSphReg_cenCross
    ## Object root|hemoglobin_deoxy|lines|bonded
    ## Object root|hemoglobin_deoxy|lines|nobnds
    ## Object root|hemoglobin_deoxy|lines|bondorder
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLine
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLabel
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distSpheres
    ## Object root|misc|measure_geoms|measureDistGeom|distLine
    ## Object root|misc|measure_geoms|measureDistGeom|distLabel
    ## Object root|misc|measure_geoms|measureDistGeom|distSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLine
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLabel
    ## Object root|misc|measure_geoms|measureAngleGeom|angleSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angles
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': False, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'angles', 'backPolyMode': 'fill', 'inheritFrontPolyMode': 0, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 1, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|misc|measure_geoms|measureAngleGeom|angles')
    if obj:
        apply(obj.Set, (), state)

    ## Material for angles
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 0.5, 0.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for angles

    ## Clipping Planes for angles
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for angles

    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLine
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLabel
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres
    ## End Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres

    ##
    ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0, 0, 0, 1), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 624, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -128.91842651367188], 'd2cutH': 255, 'far': 326.58625031702718, 'd1off': 4, 'lookFrom': [0.0, 0.0, 128.91842651367188], 'd1cutH': 60, 'antialiased': False, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 120.0, 121.0, 122.0, 123.0, 124.0, 125.0, 126.0, 127.0, 128.0, 129.0, 130.0, 131.0, 132.0, 133.0, 134.0, 135.0, 136.0, 137.0, 138.0, 139.0, 140.0, 141.0, 142.0, 143.0, 144.0, 145.0, 146.0, 147.0, 148.0, 149.0, 150.0, 151.0, 152.0, 153.0, 154.0, 155.0, 156.0, 157.0, 158.0, 159.0, 160.0, 161.0, 162.0, 163.0, 164.0, 165.0, 166.0, 167.0, 168.0, 169.0, 170.0, 171.0, 172.0, 173.0, 174.0, 175.0, 176.0, 177.0, 178.0, 179.0, 180.0, 181.0, 182.0, 183.0, 184.0, 185.0, 186.0, 187.0, 188.0, 189.0, 190.0, 191.0, 192.0, 193.0, 194.0, 195.0, 196.0, 197.0, 198.0, 199.0, 200.0, 201.0, 202.0, 203.0, 204.0, 205.0, 206.0, 207.0, 208.0, 209.0, 210.0, 211.0, 212.0, 213.0, 214.0, 215.0, 216.0, 217.0, 218.0, 219.0, 220.0, 221.0, 222.0, 223.0, 224.0, 225.0, 226.0, 227.0, 228.0, 229.0, 230.0, 231.0, 232.0, 233.0, 234.0, 235.0, 236.0, 237.0, 238.0, 239.0, 240.0, 241.0, 242.0, 243.0, 244.0, 245.0, 246.0, 247.0, 248.0, 249.0, 250.0, 251.0, 252.0, 253.0, 254.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.080000000000000002}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 163.29312515851359, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 94.54371980487025, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [84.629219055175781, 43.604473114013672, 2.0353817939758301], 'rotation': [0.27641186118125916, -0.090043552219867706, -0.95681172609329224, 0.0, -0.95166110992431641, -0.164393350481987, -0.2594531774520874, 0.0, -0.13393139839172363, 0.98227643966674805, -0.13113121688365936, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-84.629219055175781, -43.604473114013672, -2.0353856086730957], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Pmv_Viewer_8.restoreStates_cb = Pmv_Viewer_8.restoreStatesFirstRun = loadSavedStates_Pmv_Viewer_8
Pmv_Viewer_8.menu.add_separator()
Pmv_Viewer_8.menu.add_command(label='Restore states', command=Pmv_Viewer_8.restoreStates_cb)

#masterNet.run()
