########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 24 August 2007 11:11:27 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/regioncapsid/regioncapsid_net.py,v 1.13 2007/10/08 20:20:31 vareille Exp $
#
# $Id: regioncapsid_net.py,v 1.13 2007/10/08 20:20:31 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from symserv.VisionInterface.SymservNodes import symlib
masterNet.getEditor().addLibraryInstance(symlib,"symserv.VisionInterface.SymservNodes", "symlib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

from Volume.VisionInterface.VolumeNodes import vollib
masterNet.getEditor().addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

try:
    ## saving node ReadCCP4 ##
    from Volume.VisionInterface.VolumeNodes import ReadCCP4file
    ReadCCP4_0 = ReadCCP4file(constrkw = {}, name='ReadCCP4', library=vollib)
    masterNet.addNode(ReadCCP4_0,17,8)
    ReadCCP4_0.inputPortByName['filename'].widget.set("nwv2.ccp4", run=False)
    apply(ReadCCP4_0.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadCCP4file named ReadCCP4 in network masterNet"
    print_exc()
    ReadCCP4_0=None

try:
    ## saving node Isocontour ##
    from Volume.VisionInterface.VolumeNodes import Isocontour
    Isocontour_1 = Isocontour(constrkw = {}, name='Isocontour', library=vollib)
    masterNet.addNode(Isocontour_1,23,117)
    apply(Isocontour_1.inputPortByName['isovalue'].widget.configure, (), {'max': 4.2821698188781738, 'min': -1.3103089332580566})
    Isocontour_1.inputPortByName['isovalue'].widget.set(1.0, run=False)
except:
    print "WARNING: failed to restore Isocontour named Isocontour in network masterNet"
    print_exc()
    Isocontour_1=None

try:
    ## saving node indexedPolygons ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    indexedPolygons_2 = IndexedPolygonsNE(constrkw = {}, name='indexedPolygons', library=vizlib)
    masterNet.addNode(indexedPolygons_2,23,236)
    indexedPolygons_2.inputPortByName['name'].widget.set("", run=False)
    apply(indexedPolygons_2.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore IndexedPolygonsNE named indexedPolygons in network masterNet"
    print_exc()
    indexedPolygons_2=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_3 = Viewer(constrkw = {}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_3,23,343)
    ##
    ## Saving State for Viewer
    Viewer_3.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 804, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 293, 'd1scale': 0.012999999999999999}
    apply(Viewer_3.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(Viewer_3.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [0.979151725769, 0.0218018181622, 0.201957061887, 0.0, -0.0500869564712, 0.989438533783, 0.136024802923, 0.0, -0.196858495474, -0.14330431819, 0.969902396202, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.0456112138927, 0.0456112138927, 0.0456112138927], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-6.6117332608e-05, -0.000109615575639, -0.000122491066577], 'transparent': False, 'sharpColorBoundaries': 0, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Viewer_3.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_3.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_3.vi.rootObject:
        Viewer_3.vi.rootObject.clipP = []
        Viewer_3.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_3=None

try:
    ## saving node RegionBox ##
    from Volume.VisionInterface.VolumeNodes import RegionBox
    RegionBox_4 = RegionBox(constrkw = {}, name='RegionBox', library=vollib)
    masterNet.addNode(RegionBox_4,176,34)
    apply(RegionBox_4.inputPortByName['placement'].widget.configure, (), {'choices': ('FrontI', 'FrontII', 'FrontIII', 'FrontIV', 'BackI', 'BackII', 'BackIII', 'BackIV', 'Front Half', 'Back Half', 'Right Half', 'Left Half')})
except:
    print "WARNING: failed to restore RegionBox named RegionBox in network masterNet"
    print_exc()
    RegionBox_4=None

try:
    ## saving node radialColoring ##
    from NetworkEditor.macros import MacroNode
    radialColoring_5 = MacroNode(name='radialColoring')
    masterNet.addNode(radialColoring_5, 146, 178)
    from symserv.VisionInterface.SymservNodes import DistanceToPoint
    DistanceToPoint_8 = DistanceToPoint(constrkw = {}, name='DistanceToPoint', library=symlib)
    radialColoring_5.macroNetwork.addNode(DistanceToPoint_8,226,120)
    from Vision.StandardNodes import Eval
    _0_0_0__9 = Eval(constrkw = {}, name='(0,0,0)', library=stdlib)
    radialColoring_5.macroNetwork.addNode(_0_0_0__9,471,50)
    _0_0_0__9.inputPortByName['command'].widget.set("(0,0,0)", run=False)
    apply(_0_0_0__9.configure, (), {'expanded': True})
    from DejaVu.VisionInterface.DejaVuNodes import ColorMapNE
    Color_Map_10 = ColorMapNE(constrkw = {}, name='Color Map', library=vizlib)
    radialColoring_5.macroNetwork.addNode(Color_Map_10,396,180)

    ## saving connections for network radialColoring ##
    radialColoring_5.macroNetwork.freeze()
    if _0_0_0__9 is not None and DistanceToPoint_8 is not None:
        try:
            radialColoring_5.macroNetwork.connectNodes(
                _0_0_0__9, DistanceToPoint_8, "result", "point", blocking=True)
        except:
            print "WARNING: failed to restore connection between _0_0_0__9 and DistanceToPoint_8 in network radialColoring_5.macroNetwork"
    input_Ports_6 = radialColoring_5.macroNetwork.ipNode
    if input_Ports_6 is not None and DistanceToPoint_8 is not None:
        try:
            radialColoring_5.macroNetwork.connectNodes(
                input_Ports_6, DistanceToPoint_8, "new", "coords", blocking=True)
        except:
            print "WARNING: failed to restore connection between input_Ports_6 and DistanceToPoint_8 in network radialColoring_5.macroNetwork"
    if DistanceToPoint_8 is not None and Color_Map_10 is not None:
        try:
            radialColoring_5.macroNetwork.connectNodes(
                DistanceToPoint_8, Color_Map_10, "dist", "values", blocking=True)
        except:
            print "WARNING: failed to restore connection between DistanceToPoint_8 and Color_Map_10 in network radialColoring_5.macroNetwork"
    output_Ports_7 = radialColoring_5.macroNetwork.opNode
    if Color_Map_10 is not None and output_Ports_7 is not None:
        try:
            radialColoring_5.macroNetwork.connectNodes(
                Color_Map_10, output_Ports_7, "mappedColors", "new", blocking=True)
        except:
            print "WARNING: failed to restore connection between Color_Map_10 and output_Ports_7 in network radialColoring_5.macroNetwork"
    radialColoring_5.macroNetwork.unfreeze()
    radialColoring_5.shrink()
except:
    print "WARNING: failed to restore MacroNode named radialColoring in network masterNet"
    print_exc()
    radialColoring_5=None

try:
    ## saving node FillMapWithBox ##
    from Volume.VisionInterface.VolumeNodes import FillMapWithBox
    FillMapWithBox_11 = FillMapWithBox(constrkw = {}, name='FillMapWithBox', library=vollib)
    masterNet.addNode(FillMapWithBox_11,159,115)
except:
    print "WARNING: failed to restore FillMapWithBox named FillMapWithBox in network masterNet"
    print_exc()
    FillMapWithBox_11=None

masterNet.run()
masterNet.freeze()

## saving connections for network regioncapsid ##
if Isocontour_1 is not None and indexedPolygons_2 is not None:
    try:
        masterNet.connectNodes(
            Isocontour_1, indexedPolygons_2, "normals", "vnormals", blocking=True)
    except:
        print "WARNING: failed to restore connection between Isocontour_1 and indexedPolygons_2 in network masterNet"
if Isocontour_1 is not None and indexedPolygons_2 is not None:
    try:
        masterNet.connectNodes(
            Isocontour_1, indexedPolygons_2, "indices", "indices", blocking=True)
    except:
        print "WARNING: failed to restore connection between Isocontour_1 and indexedPolygons_2 in network masterNet"
if Isocontour_1 is not None and indexedPolygons_2 is not None:
    try:
        masterNet.connectNodes(
            Isocontour_1, indexedPolygons_2, "coords", "coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between Isocontour_1 and indexedPolygons_2 in network masterNet"
if indexedPolygons_2 is not None and Viewer_3 is not None:
    try:
        masterNet.connectNodes(
            indexedPolygons_2, Viewer_3, "indexedPolygons", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between indexedPolygons_2 and Viewer_3 in network masterNet"
if ReadCCP4_0 is not None and RegionBox_4 is not None:
    try:
        masterNet.connectNodes(
            ReadCCP4_0, RegionBox_4, "grid", "grid", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadCCP4_0 and RegionBox_4 in network masterNet"
radialColoring_5 = masterNet.nodes[5]
if Isocontour_1 is not None and radialColoring_5 is not None:
    try:
        masterNet.connectNodes(
            Isocontour_1, radialColoring_5, "coords", "DistanceToPoint_coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between Isocontour_1 and radialColoring_5 in network masterNet"
if radialColoring_5 is not None and indexedPolygons_2 is not None:
    try:
        masterNet.connectNodes(
            radialColoring_5, indexedPolygons_2, "Color Map_mappedColors", "colors", blocking=True)
    except:
        print "WARNING: failed to restore connection between radialColoring_5 and indexedPolygons_2 in network masterNet"
if RegionBox_4 is not None and FillMapWithBox_11 is not None:
    try:
        masterNet.connectNodes(
            RegionBox_4, FillMapWithBox_11, "geom", "Box", blocking=True)
    except:
        print "WARNING: failed to restore connection between RegionBox_4 and FillMapWithBox_11 in network masterNet"
if ReadCCP4_0 is not None and FillMapWithBox_11 is not None:
    try:
        masterNet.connectNodes(
            ReadCCP4_0, FillMapWithBox_11, "grid", "grid3D", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadCCP4_0 and FillMapWithBox_11 in network masterNet"
if FillMapWithBox_11 is not None and Isocontour_1 is not None:
    try:
        masterNet.connectNodes(
            FillMapWithBox_11, Isocontour_1, "filledMap", "grid3D", blocking=True)
    except:
        print "WARNING: failed to restore connection between FillMapWithBox_11 and Isocontour_1 in network masterNet"
masterNet.unfreeze()


def loadSavedStates_Viewer_3(self=Viewer_3, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|indexedPolygons
    ## End Object root|indexedPolygons

    ##
    ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [0.979151725769, 0.0218018181622, 0.201957061887, 0.0, -0.0500869564712, 0.989438533783, 0.136024802923, 0.0, -0.196858495474, -0.14330431819, 0.969902396202, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.0456112138927, 0.0456112138927, 0.0456112138927], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-6.6117332608e-05, -0.000109615575639, -0.000122491066577], 'transparent': False, 'sharpColorBoundaries': 0, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_3.restoreStates_cb = Viewer_3.restoreStatesFirstRun = loadSavedStates_Viewer_3
Viewer_3.menu.add_separator()
Viewer_3.menu.add_command(label='Restore states', command=Viewer_3.restoreStates_cb)

#masterNet.run()
