########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 29 August 2007 12:58:26 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon4_net.py,v 1.4 2007/08/29 20:37:16 vareille Exp $
#
# $Id: cartoon4_net.py,v 1.4 2007/08/29 20:37:16 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.PILNodes import imagelib
masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Filelist ##
    from Vision.StandardNodes import Filelist
    Filelist_0 = Filelist(constrkw = {}, name='Filelist', library=stdlib)
    masterNet.addNode(Filelist_0,14,6)
    apply(Filelist_0.inputPortByName['match_str'].widget.configure, (), {'widgetGridCfgMyApp': {'column': 1, 'labelSide': 'left', 'row': 0}})
    Filelist_0.inputPortByName['match_str'].widget.set("cartoonMovie/*.png", run=False)
    code = """def doit(self, match_str):
    import glob
    values = glob.glob(match_str)
    values.sort()
    self.outputData(filelist=values)
"""
    Filelist_0.configure(function=code)
except:
    print "WARNING: failed to restore Filelist named Filelist in network masterNet"
    print_exc()
    Filelist_0=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_1 = ReadImage(constrkw = {}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_1,20,264)
    apply(Read_Image_1.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_1.inputPortByName['filename'].widget.set("", run=False)
    Read_Image_1.inputPortByName['filename'].unbindWidget()
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_1=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_2 = ResizeImage(constrkw = {}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_2,22,317)
    apply(Scale_2.inputPortByName['scale'].widget.configure, (), {'widgetGridCfgMyApp': {'column': 0, 'labelSide': 'top', 'row': 2}})
    Scale_2.inputPortByName['scale'].widget.set(0.753788687588, run=False)
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_2=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_3 = ShowImage(constrkw = {}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_3,21,374)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_3=None

try:
    ## saving node call method ##
    from Vision.StandardNodes import CallMethod
    call_method_4 = CallMethod(constrkw = {}, name='call method', library=stdlib)
    masterNet.addNode(call_method_4,14,82)
    call_method_4.inputPortByName['signature'].widget.set("sort", run=False)
    apply(call_method_4.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore CallMethod named call method in network masterNet"
    print_exc()
    call_method_4=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_5 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_5,55,157)
    apply(Index_5.inputPortByName['index'].widget.configure, (), {'max': 100, 'widgetGridCfgMyApp': {'column': 1, 'labelSide': 'left', 'row': 3}})
    apply(Index_5.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_5=None

masterNet.run()
masterNet.freeze()

## saving connections for network cartoon4 ##
if Read_Image_1 is not None and Scale_2 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_1, Scale_2, "image", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Read_Image_1 and Scale_2 in network masterNet"
if Scale_2 is not None and Show_Image_3 is not None:
    try:
        masterNet.connectNodes(
            Scale_2, Show_Image_3, "scaledImage", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Scale_2 and Show_Image_3 in network masterNet"
if Filelist_0 is not None and call_method_4 is not None:
    try:
        masterNet.connectNodes(
            Filelist_0, call_method_4, "filelist", "objects", blocking=True)
    except:
        print "WARNING: failed to restore connection between Filelist_0 and call_method_4 in network masterNet"
if call_method_4 is not None and Index_5 is not None:
    try:
        masterNet.connectNodes(
            call_method_4, Index_5, "objects", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between call_method_4 and Index_5 in network masterNet"
if Index_5 is not None and Read_Image_1 is not None:
    try:
        masterNet.connectNodes(
            Index_5, Read_Image_1, "data", "filename", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_5 and Read_Image_1 in network masterNet"
masterNet.unfreeze()

#masterNet.run()
