	/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA   02110-1301
	
	see: http://www.fsf.org/licensing/licenses/gpl-howto.html
	*/
	
	/****************************************************************************
	** ManDVD
	**
	** Created: Mon May 08 14:00:00 2006
	**      by: Gibault Stphane
	**	Hacked on by Mikael Bhm micko@bag.org (2008)
	**
	** This is a tool for simply creating DVD Video
	** 
	****************************************************************************/
	
	//#ifndef MAINFRMUI_H
	//#define MAINFRMUI_H

	#include "mandvd_global.h"
	#include "mandvd.h"		/* Generic functions for the ManDVD interface */
	#include "dvdbuild.h"       	/* Code to generate a DVD video */
	#include "slideshow.h"		/* Code for maning a slideshow */
	#include "animation.h"		/* Code for maning animation */
	#include "chapter.h"		/* Code for maning chapters */
	#include "cut.h"		/* Code for cutting movies */
	#include "subtitle.h"		/* Code for maning subtitles */

	/* Setup mainframe */
	void mainfrm::init () {

	QDir currentDir = QDir::home ();
	m_pMPlayerWidget = new QMPlayerWidget (vframe, "MPlayerWidget");
	m_pMPlayerLayout = new QGridLayout (vframe, 1, 1, 4, 6, "MPlayerMainLayout");
	m_pMPlayerLayout->addWidget (m_pMPlayerWidget, 0, 0);

	vframe->setGeometry (31, 125, 115, 71);

	vframe->hide ();
	newproj->hide ();

	QString myrec;
        QFile myfic (currentDir.path () + CONFIGFILE );

	if (myfic.open (IO_ReadOnly))
	{
	QTextStream mystream (&myfic);
	myrec = mystream.readLine ();
	wlanguage = myrec;
	myfic.close ();
	rc_003 = 0;
	
	/* Setup language for interface: mandvdrc exist! */
	bt_valid_langue_clicked ();

	}
	else
	{
	/* Show language selection dialog */ 
	rc_003 = 1;
	combolangue->insertItem ("Dutch", -1);
	combolangue->insertItem ("English", -1);
	combolangue->insertItem ("French", -1);
	combolangue->insertItem ("German", -1);
	combolangue->insertItem ("Italian", -1);
	combolangue->insertItem ("Spanish", -1);
	combolangue->insertItem ("Swedish", -1);
	combolangue->insertItem ("Portugus", -1);

	combolangue->setCurrentItem (0);

	parametrage->setGeometry (290, 260, 421, 221);
	
	/* Hide main program before language i choosen */
	Etape_03->hide ();
	vframe->hide ();
	Etape_02->hide ();

	parametrage->show ();
	parametrage->raise ();

	}
}



		
	void
	mainfrm::bt_color_1_clicked () {
	// ********************************
	// *** Choix de la couleur tat normal ***
	// ********************************
	couleur_1 =
	QColorDialog::getColor (couleur_1, this, table_message[71] );
	if (couleur_1.isValid ())
	{
	frame_couleur_1->setBackgroundColor (couleur_1);
	}
	}
	
	void
	mainfrm::bt_color_2_clicked () {
	// ***********************************
	// *** Choix de la couleur tat slectionn ***
	// ***********************************
	couleur_2 =
	QColorDialog::getColor (couleur_2, this, table_message[71] );
	
	if (couleur_2.isValid ())
	{
	int rouge;
	int vert;
	int bleu;
	couleur_2.getRgb (&rouge, &vert, &bleu);
	if (rouge == 255 && vert == 255 && bleu == 255)
		{
		couleur_2.setRgb (254, 254, 254);
		}
	frame_couleur_2->setBackgroundColor (couleur_2);
	}
	}
	
	void
	mainfrm::bt_color_3_clicked () {
	// *******************************
	// *** Choix de la couleur tat cliqu ***
	// *******************************
	couleur_3 =
	QColorDialog::getColor (couleur_3, this, table_message[71]);
	
	if (couleur_3.isValid ())
	{
	int rouge;
	int vert;
	int bleu;
	couleur_3.getRgb (&rouge, &vert, &bleu);
	if (rouge == 255 && vert == 255 && bleu == 255)
		{
		couleur_3.setRgb (254, 254, 254);
		}
	frame_couleur_3->setBackgroundColor (couleur_3);
	}
	}
	
	void
	mainfrm::bt_retourner_clicked () {
	// **********************************
	// *** Retourner l'image horizontalement ***
	// **********************************
	QImage myimg_2 = save_fond.mirror (true, false);
	save_fond = myimg_2.copy (0, 0, 720, 576, 0);
	QPixmap mypix (save_fond);
	apercu_fond->setPixmap (mypix);
	// *** Mise en place des fonds d'cran pour le menu ***       
	my_pixmap_001->setPixmap (mypix);
	}
	
	void
	mainfrm::bt_retourner_2_clicked () {
	// ********************************
	// *** Retourner l'image verticalement ***
	// ********************************
	QImage myimg_2 = save_fond.mirror (false, true);
	save_fond = myimg_2.copy (0, 0, 720, 576, 0);
	QPixmap mypix (save_fond);
	apercu_fond->setPixmap (mypix);
	// *** Mise en place des fonds d'cran pour le menu ***       
	my_pixmap_001->setPixmap (mypix);
	
	}
	
	void
	mainfrm::bt_invert_clicked () {
	// ****************
	// *** Invert pixels ***
	// ****************
	save_fond.invertPixels (true);
	QPixmap mypix (save_fond);
	apercu_fond->setPixmap (mypix);
	// *** Mise en place des fonds d'cran pour le menu ***       
	my_pixmap_001->setPixmap (mypix);
	}
	






	/* Probably for animation */

	/* Extract picures from video */	
	void
	mainfrm::bt_go_extract_clicked () {
	// *********************************
	// *** Extraction des images de la vido ***
	// *********************************
	if (namevideoimport->text () == "")
	{
	QMessageBox::warning (this, MANDVDVER, table_message[25]);
	}
	else
	{
	if (m_pMPlayerWidget->isPlaying () == true)
		{
		m_pMPlayerWidget->slotPause ();
		}
	QFile myfic_2 (wpathtotalproj + "/genmenuanim.sh");
	int debut;
	int fin;
	QString C_debut;
	QString C_fin;
	if (myfic_2.open (IO_WriteOnly))
		{
		tmp_001 = "#!/bin/bash\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "cd \"" + wpathtotalproj + "\"\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f gibmenanim*.*\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		debut = startvidmenanim->value () * projfps;
		fin =
		(dureevidmenanim->value () + startvidmenanim->value ()) * projfps;
		C_debut = QString::number (debut);
		C_fin = QString::number (fin);
	
		tmp_001 =
		"transcode -a 0 -c " + C_debut + "-" + C_fin +
		" -Z " PALDVD " -i \"" + namevideoimport->text () +
		"\" -y jpg -F 100 -o gibmenanim\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		myfic_2.close ();
		//
		pb_006->setTotalSteps (dureevidmenanim->value () * projfps);
		rc_002 = 0;
		textEdit4->clear ();
		nbre_images = 0;
		pb_006->setProgress (0);
		panel_menu_anim->setDisabled (true);
		//
		proc_001 = new QProcess (this);
		proc_001->addArgument ("bash");
		proc_001->addArgument (wpathtotalproj + "/genmenuanim.sh");
		connect (proc_001, SIGNAL (readyReadStdout ()), this,
			SLOT (stdout_genanimenu ()));
		connect (proc_001, SIGNAL (processExited ()), this,
			SLOT (fin_genanimenu ()));
		if (!proc_001->start ())
		{
		QMessageBox::warning (this, MANDVDVER,
					table_message[0] + "transcode");
		}
		else
		{
		bt_modif_gimp->setDisabled (true);
		bt_effets_anim->setDisabled (true);
		}
		}
	}
	}
	
	/* Extracting images finsh !? */
	void
	mainfrm::stdout_genanimenu () {
	// ***********************************************
	// *** Lecture de la sortie console d'extraction des images ***
	// ***********************************************
	lineEdit1->setText (proc_001->readStdout ());
	tmp_001 = lineEdit1->text ();
	
	rc_001 = tmp_001.find ("encoding frame [", 0);
	if (rc_001 != -1)
	{
	pb_006->setProgress (pb_006->progress () + 1);
	nbre_images = nbre_images + 1;
	}
	
	rc_001 = tmp_001.find ("Err", 0);
	if (rc_001 != -1)
	{
	rc_002 = 1;
	}
	
	textEdit4->append (lineEdit1->text ());
	}
	
	/* Extracting images finsh !? */
	void
	mainfrm::fin_genanimenu () {
	// ****************************
	// *** Fin d'extraction des images ***
	// ****************************
	pb_006->setProgress (dureevidmenanim->value () * projfps);
	if (rc_002 == 0 && nbre_images > 0)
	{
	cdraddmask->setEnabled (true);
	panel_menu_anim->setEnabled (true);
	QImage myimg (wpathtotalproj + "/gibmenanim000000.jpg", 0);
	QPixmap mypix (myimg);
	imgstart->setPixmap (mypix);
	exempleimg->setPixmap (mypix);
	bt_valid_menu_anim->setEnabled (true);
	progress = 0;
	wdebut = 0;
	nbre_images = dureevidmenanim->value () * projfps;
	wfin = nbre_images;
	txtnbreimages->setText (nr_of_im + QString::number (nbre_images));
	//txtnbreimages_2->setText ("Premire image : 0");
	txtnbreimages_2_2->setText (last_im + QString::number (nbre_images - 1));
	changingframe->setMaxValue (nbre_images - 1);
	changingframe->setValue (0);
	bt_modif_gimp->setEnabled (true);
	bt_effets_anim->setEnabled (true);
	}
	else
	{
	bt_valid_menu_anim->setDisabled (true);
	QMessageBox::warning (this, MANDVDVER, table_message[26]);
	}
	}
	
	void
	mainfrm::bt_console_menu_anim_clicked () {
	// ****************************************************
	// *** Affichage ou pas de la console dans cration menu anim ***
	// ****************************************************
	if (textEdit4->isVisible () == true)
	{
	textEdit4->hide ();
	}
	else
	{
	textEdit4->show ();
	textEdit4->raise ();
	}
	}

	/* Forward one picture */	
	void
	mainfrm::bt_avance_anim_clicked () {
	// *************************
	// *** On avance d'une image ***
	// *************************
	if (progress < nbre_images - 1)
	{
	progress = progress + 1;
	tmp_001 = QString::number (progress);
	tmp_002 = "gibmenanim000000";
	tmp_002.replace (tmp_002.length () - tmp_001.length (),
			tmp_001.length (), tmp_001);
	QImage myimg (wpathtotalproj + "/" + tmp_002 + ".jpg", 0);
	QPixmap mypix (myimg);
	imgstart->setPixmap (mypix);
	changingframe->setValue (progress);
	}
	}
		
	void
	mainfrm::bt_recul_anim_clicked () {
	// ************************
	// *** On recul d'une image ***
	// ************************
	if (progress > 0)
	{
	progress = progress - 1;
	tmp_001 = QString::number (progress);
	tmp_002 = "gibmenanim000000";
	tmp_002.replace (tmp_002.length () - tmp_001.length (),
			tmp_001.length (), tmp_001);
	QImage myimg (wpathtotalproj + "/" + tmp_002 + ".jpg", 0);
	QPixmap mypix (myimg);
	imgstart->setPixmap (mypix);
	changingframe->setValue (progress);
	}
	}
	
	void
	mainfrm::bt_last_imganim_clicked () {
	// *******************
	// *** Dernire image ***
	// *******************
	progress = nbre_images - 1;
	tmp_001 = QString::number (progress);
	tmp_002 = "gibmenanim000000";
	tmp_002.replace (tmp_002.length () - tmp_001.length (), tmp_001.length (),
			tmp_001);
	QImage myimg (wpathtotalproj + "/" + tmp_002 + ".jpg", 0);
	QPixmap mypix (myimg);
	imgstart->setPixmap (mypix);
	changingframe->setValue (progress);
	}
	


	


	


	
	void
	mainfrm::calculcadre () {
	QWMatrix m;
	QWMatrix z;
	QPixmap loadimg (table_images[num_photo->value () - 1][0]);
	QImage tmpsrc = loadimg.convertToImage ();
	QImage srcimg = tmpsrc.smoothScale (720, 576, QImage::ScaleFree);
	QImage srccdr_2 = pixcdrpho->pixmap ()->convertToImage ();
	QImage srccdr = srccdr_2.smoothScale (720, 576, QImage::ScaleFree);
	m.scale (0.75, 0.69);
	tmpsrc = srcimg.xForm (m);
	tmpsrc.setAlphaBuffer (true);
	tmpsrc.createHeuristicMask (true);
	bitBlt (&srccdr, 90, 90, &tmpsrc, 0, 0, -1, -1);
	z.rotate (dial1->value ());
	QPixmap Pfdcolor (720, 576);
	Pfdcolor.fill (fdcolor->paletteBackgroundColor ());
	if (wlanguage != "")
	{
	QPixmap tmpcreat (720, 576);
	tmpcreat.fill (Qt::black);
	QPixmap tmpcreat2 (wlanguage);
	QImage wl_img1 = tmpcreat2.convertToImage ();
	QImage wl_img2 = wl_img1.scale (720, 576, QImage::ScaleMin);
	QPixmap wl_pix1 (wl_img2.width (), wl_img2.height ());
	wl_pix1.convertFromImage (wl_img2);
	::bitBlt (&tmpcreat, (720 - wl_img2.width ()) / 2,
			(576 - wl_img2.height ()) / 2, &wl_pix1, 0, 0, -1, -1,
			Qt::CopyROP, false);
	::bitBlt (&Pfdcolor, 0, 0, &tmpcreat, 0, 0, -1, -1, Qt::CopyROP, false);
	}
	QImage Ifdcolor = Pfdcolor.convertToImage ();
	QImage fintran = srccdr.xForm (z);
	srcimg = fintran.smoothScale (720, 576, QImage::ScaleMin);
	srcimg.setAlphaBuffer (true);
	srcimg.createHeuristicMask (true);
	QImage wl_img1 =
	srcimg.smoothScale (dial_size->value (), dial_size->value () / 1.25,
				QImage::ScaleMin);
	bitBlt (&Ifdcolor, dial_x->value (), dial_y->value (), &wl_img1, 0, 0, -1,
		-1);
	pixmapLabel1_3->setPixmap (Ifdcolor);
	}
	
	void
	mainfrm::toolButton115_clicked () {
	cadredit->hide ();
	groupBox13->hide ();
	QTime nowtime;
	nowtime = QTime::currentTime ();
	tmp_009 =
	wpathtotalproj + "GIBtmpphoto_" + nowtime.toString ("hh:mm:ss") + ".png";
	QImage myimg = pixmapLabel1_3->pixmap ()->convertToImage ();
	myimg.save (tmp_009, "PNG");
	table_images[num_photo->value () - 1][0] = tmp_009;
	QLabel *pntloc = table_pnt_img[num_photo->value () - 1];
	QPixmap pixloc;
	pixloc.load (tmp_009);
	QImage tmptransf = pixloc.convertToImage ();
	myimg = tmptransf.scale (320, 256, QImage::ScaleMax);
	pntloc->setPixmap (myimg);
	apercu_photo_diapo->setPixmap (myimg);
	fen_slideshow->setEnabled (true);
	}
	
	void
	mainfrm::toolButton115_2_clicked () {
	cadredit->hide ();
	groupBox13->hide ();
	fen_slideshow->setEnabled (true);
	}
	
	void
	mainfrm::toolButton117_clicked () {
	QColor couleur_10 =
	QColorDialog::getColor (couleur_10, this, table_message[71]);
	if (couleur_10.isValid ())
	{
	fdcolor->setPaletteBackgroundColor (couleur_10);
	wlanguage = "";
	calculcadre ();
	}
	}




	
	void
	mainfrm::outils1_2_clicked () {
	editmask->setDisabled (true);
	addtxt2mask->setGeometry (300, 230, 400, 240);
	addtxt2mask->show ();
	addtxt2mask->raise ();
	lineEdit13->setFocus ();
	}
	
	void
	mainfrm::toolButton120_clicked () {
	if (lineEdit13->text () != "")
	{
	addtxt2mask->hide ();
	editmask->setEnabled (true);
	QIconSet wl_icoset = outils1_2->iconSet ();
	pixmapLabel1_5->setPixmap (wl_icoset.pixmap ());
	rc_003 = 2;
	buttonGroup63->setDisabled (true);
	}
	else
	{
	addtxt2mask->hide ();
	editmask->setEnabled (true);
	QIconSet wl_icoset = outils0->iconSet ();
	pixmapLabel1_5->setPixmap (wl_icoset.pixmap ());
	rc_003 = 0;
	buttonGroup63->setDisabled (true);
	}
	}
	
	void
	mainfrm::toolButton121_clicked () {
	myfontmask =
	QFontDialog::getFont (&ok, QFont ("Helvetica [Cronyx]", 10), this);
	taille_police_mask = myfontmask.pointSize ();
	testpol->setFont (myfontmask);
	}
	
	void
	mainfrm::dial1_valueChanged (int) {
	calculcadre ();
	}
	
	void
	mainfrm::toolButton122_clicked () {
	addfilter->hide ();
	//
	QString wvf = "";
	QString lum = QString::number (sl_lum->value ());
	QString con = QString::number (sl_con->value ());
	QString x = QString::number (spx->value ());
	QString y = QString::number (spy->value ());
	QString l = QString::number (spl->value ());
	QString h = QString::number (sph->value ());
	
	if (btreglages->isChecked () == true || btdelogo->isChecked () == true
	|| btmirroir->isChecked () == true || btdenoise->isChecked () == true)
	{
	wvf = ",";
	
	if (btreglages->isChecked () == true)
		{
		wvf = wvf + "eq=" + lum + ":" + con;
		}
	
	if (btdelogo->isChecked () == true)
		{
		if (btreglages->isChecked () == true)
		{
		wvf = wvf + ",";
		}
		wvf = wvf + "delogo=" + x + ":" + y + ":" + l + ":" + h + ":3";
		}
	
	if (btmirroir->isChecked () == true)
		{
		if (btreglages->isChecked () == true
		|| btdelogo->isChecked () == true)
		{
		wvf = wvf + ",";
		}
		wvf = wvf + "mirror";
		}
	
	if (btdenoise->isChecked () == true)
		{
		if (btreglages->isChecked () == true
		|| btdelogo->isChecked () == true
		|| btmirroir->isChecked () == true)
		{
		wvf = wvf + ",";
		}
		wvf = wvf + "denoise3d=8:6:12";
		}
	QListViewItem *i = lst_video_1->selectedItem ();
	
	if (i != 0)
		{
		QImage wl_img1 = i->pixmap (0)->convertToImage ();
		QPixmap wl_pix1 (wl_img1);
		QImage wl_img2 = previcon_3->pixmap ()->convertToImage ();
		QPixmap wl_pix2 (wl_img2);
		::bitBlt (&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP,
			false);
		tmp_004 = i->text (2);
		rc_003 = tmp_004.find ("/*EDL/*", 0);
		if (rc_003 != -1)
		{
		tmp_005 = tmp_004.mid (0, rc_003 + 7);
		tmp_005 = tmp_005 + wvf;
		i->setText (2, tmp_005);
		}
		else
		{
		i->setText (2, "1" + wvf + " ");
		}
		i->setPixmap (0, wl_pix1);
		bt_force->setDisabled (true);
		}
	}
	else
	{
	QListViewItem *i = lst_video_1->selectedItem ();
	
	if (i != 0)
		{
		tmp_001 = i->text (2);
		tmp_002 = tmp_001.mid (0, 1);
		i->setText (2, tmp_002);
		}
	}
	//
	Etape_02->setEnabled (true);
	}

	
	void
	mainfrm::btpreveffets_clicked () {
	QString wvf = "";
	QString lum = QString::number (sl_lum->value ());
	QString con = QString::number (sl_con->value ());
	QString x = QString::number (spx->value ());
	QString y = QString::number (spy->value ());
	QString l = QString::number (spl->value ());
	QString h = QString::number (sph->value ());
	
	proc_003 = new QProcess (this);
	proc_003->addArgument ("mplayer");
	proc_003->addArgument (nomfilm);
	
	if (btreglages->isChecked () == true || btdelogo->isChecked () == true
	|| btmirroir->isChecked () == true || btdenoise->isChecked () == true)
	{
	proc_003->addArgument ("-vf");
	
	if (btreglages->isChecked () == true)
		{
		wvf = "eq=" + lum + ":" + con;
		}
	
	if (btdelogo->isChecked () == true)
		{
		if (btreglages->isChecked () == true)
		{
		wvf = wvf + ",";
		}
		if (checkBox5->isChecked () == true)
		{
		wvf = wvf + "delogo=" + x + ":" + y + ":" + l + ":" + h + ":-1";
		}
		else
		{
		wvf = wvf + "delogo=" + x + ":" + y + ":" + l + ":" + h + ":3";
		}
		}
	
	if (btmirroir->isChecked () == true)
		{
		if (btreglages->isChecked () == true
		|| btdelogo->isChecked () == true)
		{
		wvf = wvf + ",";
		}
		wvf = wvf + "mirror";
		}
	
	if (btdenoise->isChecked () == true)
		{
		if (btreglages->isChecked () == true
		|| btdelogo->isChecked () == true
		|| btmirroir->isChecked () == true)
		{
		wvf = wvf + ",";
		}
		wvf = wvf + "denoise3d=8:6:12";
		}
	
	proc_003->addArgument (wvf);
	}
	connect (proc_003, SIGNAL (processExited ()), this,
		SLOT (fin_prevmplayer ()));
	
	if (!proc_003->start ())
	{
	QMessageBox::warning (this, MANDVDVER, table_message[0] + "Mplayer");
	}
	else
	{
	this->setDisabled (true);
	}
	}
	
	void
	mainfrm::fin_prevmplayer () {
	this->setEnabled (true);
	}
	
	void
	mainfrm::calcul_dureeslide () {
	int cpt1 = 0;
	int tottime = 0;
	int longueur_audio_1 = 0;
	int cumul_audio_1 = 0;
	
	if (nbre_images > 0)
	{
	bt_modif_gimp_2->setEnabled (true);
	bt_valid_info_image_2->setEnabled (true);
	bt_valid_info_image_3->setEnabled (true);
	}
	else
	{
	bt_modif_gimp_2->setDisabled (true);
	bt_valid_info_image_2->setDisabled (true);
	bt_valid_info_image_3->setDisabled (true);
	}
	
	while (cpt1 < nbre_images)
	{
	tmp_001 = table_images[cpt1][1];
	tmp_002 = table_images[cpt1][3];
	rc_001 = tmp_001.toInt (&ok, 10);
	if (ok == true)
		{
		tottime = tottime + rc_001;
		cumul_audio_1 = cumul_audio_1 + rc_001;
		}
	rc_001 = tmp_002.toInt (&ok, 10);
	if (ok == true && table_images[cpt1][2] != table_message[40])
		{
		tottime = tottime + rc_001;
		cumul_audio_1 = cumul_audio_1 + rc_001;
		}
	if (cumul_audio_1 > yaaudio && longueur_audio_1 == 0)
		{
		longueur_audio_1 = cpt1 + 1;
		}
	cpt1 = cpt1 + 1;
	}
	if (longueur_audio_1 == 0)
	{
	Audio_1->setGeometry (0, 121, 105 + (130 * nbre_images), 18);
	}
	else
	{
	Audio_1->setGeometry (0, 121, 5 + (130 * longueur_audio_1), 18);
	}
	texttottime->setText ("Total : " + QString::number (tottime) + " sec");
	}
	
	void
	mainfrm::avvalue_valueChanged (int) {
	if (avvalue->value () < 0)
	{
	grpaudio->setGeometry (62, 51, 130, 20);
	QColor c1 (255, 0, 0);
	avgroup->setPaletteForegroundColor (c1);
	}
	else
	{
	if (avvalue->value () > 0)
		{
		QColor c1 (255, 0, 0);
		avgroup->setPaletteForegroundColor (c1);
		grpaudio->setGeometry (10, 51, 130, 20);
		}
	else
		{
		QColor c1 (0, 255, 0);
		avgroup->setPaletteForegroundColor (c1);
		grpaudio->setGeometry (36, 51, 130, 20);
		}
	}
	}
	
	void
	mainfrm::btprevdelay_clicked () {
	//rc_003;			// Warningfix
	float decalage;
	tmp_004 = textLabel2_11->text ();
	rc_003 = tmp_004.find (":", 0);
	
	if (rc_003 != -1)
	{
	rc_003 = rc_003 + 2;
	tmp_008 = "";
	while (rc_003 < tmp_004.length ())
		{
		tmp_008 = tmp_008 + tmp_004.mid (rc_003, 1);
		rc_003 = rc_003 + 1;
		}
	rc_001 = tmp_008.toInt (&ok, 10);
	if (ok == true)
		{
		decalage = avvalue->value () - rc_001;
		}
	else
		{
		decalage = 0;
		}
	}
	else
	{
	decalage = 0;
	}
	float myval = decalage / 1000;
	QString thetest;
	thetest.setNum (myval, 'f', 3);
	proc_003 = new QProcess (this);
	proc_003->addArgument ("mplayer");
	proc_003->addArgument (path_video);
	proc_003->addArgument ("-delay");
	proc_003->addArgument (thetest);
	
	connect (proc_003, SIGNAL (processExited ()), this,
		SLOT (fin_prevmplayer ()));
	
	if (!proc_003->start ())
	{
	QMessageBox::warning (this, MANDVDVER, table_message[0] + "Mplayer");
	}
	else
	{
	this->setDisabled (true);
	}
	}
	
	void
	mainfrm::bt_dep_droite_clicked () {
	// *** Deplacement images vers droite ***
	if (nbre_images > 1)
	{
	int cpt1;
	QLabel *mylabel;
	QLabel *mylabel_2;
	QLabel *mylabel_3;
	QLabel *tmp_tab1[1][2];
	QLabel *tmp_tab2;
	QString tmp_tab3[1][5];
	
	cpt1 = num_photo->value ();
	
	if (nbre_images > 1 && num_photo->value () < nbre_images)
		{
		// *** Dcalage des contrles ***
		mylabel = table_pnt_img[cpt1 - 1];
		mylabel_2 = table_pnt_txt[cpt1 - 1][0];
		mylabel_3 = table_pnt_txt[cpt1 - 1][1];
		//
		mylabel->setGeometry ((10 + ((cpt1) * 120)) + ((cpt1) * 10), 6, 120,
					96);
		mylabel_2->setGeometry ((10 + ((cpt1) * 120)) + ((cpt1) * 10), 103,
					120, 14);
		mylabel_2->setText ("Photo : " + QString::number (cpt1 + 1));
		mylabel_3->setGeometry ((13 + ((cpt1) * 120)) + ((cpt1) * 10), 35,
					40, 40);
		// *** Dcalage des pointeurs et autres ***
		tmp_tab2 = table_pnt_img[cpt1 - 1];
		tmp_tab1[0][0] = table_pnt_txt[cpt1 - 1][0];
		tmp_tab1[0][1] = table_pnt_txt[cpt1 - 1][1];
		tmp_tab3[0][0] = table_images[cpt1 - 1][0];
		tmp_tab3[0][1] = table_images[cpt1 - 1][1];
		tmp_tab3[0][2] = table_images[cpt1 - 1][2];
		tmp_tab3[0][3] = table_images[cpt1 - 1][3];
		tmp_tab3[0][4] = table_images[cpt1 - 1][4];
		// *** Dcalage des contrles ***
		mylabel = table_pnt_img[cpt1];
		mylabel_2 = table_pnt_txt[cpt1][0];
		mylabel_3 = table_pnt_txt[cpt1][1];
		//
		mylabel->setGeometry ((10 + ((cpt1 - 1) * 120)) + ((cpt1 - 1) * 10),
					6, 120, 96);
		mylabel_2->setGeometry ((10 + ((cpt1 - 1) * 120)) +
					((cpt1 - 1) * 10), 103, 120, 14);
		mylabel_2->setText ("Photo : " + QString::number (cpt1));
		mylabel_3->setGeometry ((13 + ((cpt1 - 1) * 120)) +
					((cpt1 - 1) * 10), 35, 40, 40);
		//
		table_pnt_img[cpt1 - 1] = table_pnt_img[cpt1];
		table_pnt_txt[cpt1 - 1][0] = table_pnt_txt[cpt1][0];
		table_pnt_txt[cpt1 - 1][1] = table_pnt_txt[cpt1][1];
		table_images[cpt1 - 1][0] = table_images[cpt1][0];
		table_images[cpt1 - 1][1] = table_images[cpt1][1];
		table_images[cpt1 - 1][2] = table_images[cpt1][2];
		table_images[cpt1 - 1][3] = table_images[cpt1][3];
		table_images[cpt1 - 1][4] = table_images[cpt1][4];
		//
		table_pnt_img[cpt1] = tmp_tab2;
		table_pnt_txt[cpt1][0] = tmp_tab1[0][0];
		table_pnt_txt[cpt1][1] = tmp_tab1[0][1];
		table_images[cpt1][0] = tmp_tab3[0][0];
		table_images[cpt1][1] = tmp_tab3[0][1];
		table_images[cpt1][2] = tmp_tab3[0][2];
		table_images[cpt1][3] = tmp_tab3[0][3];
		table_images[cpt1][4] = tmp_tab3[0][4];
		//
		num_photo->setValue (cpt1 + 1);
		calcul_dureeslide ();
		}
	}
	}
	
	void
	mainfrm::bt_dep_gauche_clicked () {
	// *** Deplacement images vers gauche ***
	if (nbre_images > 1)
	{
	int cpt1;
	QLabel *mylabel;
	QLabel *mylabel_2;
	QLabel *mylabel_3;
	QLabel *tmp_tab1[1][2];
	QLabel *tmp_tab2;
	QString tmp_tab3[1][5];
	
	cpt1 = num_photo->value ();
	
	if (nbre_images > 1 && num_photo->value () > 1)
		{
		// *** Dcalage des contrles ***
		mylabel = table_pnt_img[cpt1 - 1];
		mylabel_2 = table_pnt_txt[cpt1 - 1][0];
		mylabel_3 = table_pnt_txt[cpt1 - 1][1];
		//
		mylabel->setGeometry ((10 + ((cpt1 - 2) * 120)) + ((cpt1 - 2) * 10),
					6, 120, 96);
		mylabel_2->setGeometry ((10 + ((cpt1 - 2) * 120)) +
					((cpt1 - 2) * 10), 103, 120, 14);
		mylabel_2->setText ("Photo : " + QString::number (cpt1 - 1));
		mylabel_3->setGeometry ((13 + ((cpt1 - 2) * 120)) +
					((cpt1 - 2) * 10), 35, 40, 40);
		// *** Dcalage des pointeurs et autres ***
		tmp_tab2 = table_pnt_img[cpt1 - 1];
		tmp_tab1[0][0] = table_pnt_txt[cpt1 - 1][0];
		tmp_tab1[0][1] = table_pnt_txt[cpt1 - 1][1];
		tmp_tab3[0][0] = table_images[cpt1 - 1][0];
		tmp_tab3[0][1] = table_images[cpt1 - 1][1];
		tmp_tab3[0][2] = table_images[cpt1 - 1][2];
		tmp_tab3[0][3] = table_images[cpt1 - 1][3];
		tmp_tab3[0][4] = table_images[cpt1 - 1][4];
		// *** Dcalage des contrles ***
		mylabel = table_pnt_img[cpt1 - 2];
		mylabel_2 = table_pnt_txt[cpt1 - 2][0];
		mylabel_3 = table_pnt_txt[cpt1 - 2][1];
		//
		mylabel->setGeometry ((10 + ((cpt1 - 1) * 120)) + ((cpt1 - 1) * 10),
					6, 120, 96);
		mylabel_2->setGeometry ((10 + ((cpt1 - 1) * 120)) +
					((cpt1 - 1) * 10), 103, 120, 14);
		mylabel_2->setText ("Photo : " + QString::number (cpt1));
		mylabel_3->setGeometry ((13 + ((cpt1 - 1) * 120)) +
					((cpt1 - 1) * 10), 35, 40, 40);
		//
		table_pnt_img[cpt1 - 1] = table_pnt_img[cpt1 - 2];
		table_pnt_txt[cpt1 - 1][0] = table_pnt_txt[cpt1 - 2][0];
		table_pnt_txt[cpt1 - 1][1] = table_pnt_txt[cpt1 - 2][1];
		table_images[cpt1 - 1][0] = table_images[cpt1 - 2][0];
		table_images[cpt1 - 1][1] = table_images[cpt1 - 2][1];
		table_images[cpt1 - 1][2] = table_images[cpt1 - 2][2];
		table_images[cpt1 - 1][3] = table_images[cpt1 - 2][3];
		table_images[cpt1 - 1][4] = table_images[cpt1 - 2][4];
		//
		table_pnt_img[cpt1 - 2] = tmp_tab2;
		table_pnt_txt[cpt1 - 2][0] = tmp_tab1[0][0];
		table_pnt_txt[cpt1 - 2][1] = tmp_tab1[0][1];
		table_images[cpt1 - 2][0] = tmp_tab3[0][0];
		table_images[cpt1 - 2][1] = tmp_tab3[0][1];
		table_images[cpt1 - 2][2] = tmp_tab3[0][2];
		table_images[cpt1 - 2][3] = tmp_tab3[0][3];
		table_images[cpt1 - 2][4] = tmp_tab3[0][4];
		//
		num_photo->setValue (cpt1 - 1);
		calcul_dureeslide ();
		}
	}
	}
	
	void
	mainfrm::bt_invert_2_clicked () {
	QImage saveimg = apercu_fond->pixmap ()->convertToImage ();
	saveimg.save (wpathtotalproj + "limagefond.png", "PNG");
	proc_001 = new QProcess (this);
	proc_001->addArgument ("convert");
	proc_001->addArgument (wpathtotalproj + "limagefond.png");
	proc_001->addArgument ("-sepia-tone");
	proc_001->addArgument ("50000");
	proc_001->addArgument (wpathtotalproj + "tmplimagefond.png");
	connect (proc_001, SIGNAL (processExited ()), this,
		SLOT (fin_effets_menu ()));
	if (!proc_001->start ())
	{
	QMessageBox::warning (this, MANDVDVER,
				table_message[0] + "convert (ImageMagick)");
	}
	else
	{
	this->setDisabled (true);
	}
	}
	
	void
	mainfrm::fin_effets_menu () {
	QImage saveimg;
	saveimg.load (wpathtotalproj + "tmplimagefond.png");
	apercu_fond->setPixmap (saveimg);
	my_pixmap_001->setPixmap (saveimg);
	bitBlt (&save_fond, 0, 0, &saveimg, 0, 0, -1, -1);
	this->setEnabled (true);
	}
	
	void
	mainfrm::toolButton129_clicked () {
	QPixmap save_cadre_2 (deplace_w->value (), deplace_h->value ());
	::bitBlt (&save_cadre_2, 0, 0, imgtravail->pixmap (), deplace_x->value (),
		deplace_y->value (), deplace_w->value (), deplace_h->value (),
		Qt::CopyROP, false);
	QImage save_cadre = save_cadre_2.convertToImage ();
	QImage save_cadre_3 = save_cadre.scale (720, 576, QImage::ScaleMin);
	QPixmap tmpcreat (720, 576);
	tmpcreat.fill (Qt::black);
	QPixmap tmpcreat2 (save_cadre_3);
	::bitBlt (&tmpcreat, (720 - save_cadre_3.width ()) / 2,
		(576 - save_cadre_3.height ()) / 2, &tmpcreat2, 0, 0, -1, -1,
		Qt::CopyROP, false);
	save_cadre_3 = tmpcreat.convertToImage ();
	QTime nowtime;
	nowtime = QTime::currentTime ();
	tmp_009 =
	wpathtotalproj + "GIBtmpphoto_" + nowtime.toString ("hh:mm:ss") + ".png";
	save_cadre_3.save (tmp_009, "PNG");
	table_images[num_photo->value () - 1][0] = tmp_009;
	QLabel *pntloc = table_pnt_img[num_photo->value () - 1];
	QPixmap pixloc;
	pixloc.load (tmp_009);
	QImage tmptransf = pixloc.convertToImage ();
	QImage myimg = tmptransf.scale (320, 256, QImage::ScaleMax);
	pntloc->setPixmap (myimg);
	apercu_photo_diapo->setPixmap (myimg);
	recadrage->hide ();
	fen_slideshow->setEnabled (true);
	}
	
	void
	mainfrm::deplace_y_valueChanged (int) {
	depl_coupe ();
	}
	
	void
	mainfrm::deplace_x_valueChanged (int) {
	depl_coupe ();
	}
	
	void
	mainfrm::depl_coupe () {
	QImage travfond = fantome_decoupe->pixmap ()->convertToImage ();
	imgtravail->setPixmap (travfond);
	QPixmap titi (travfond.width (), travfond.height ());
	deplace_x->setMaxValue (travfond.width () - deplace_w->value ());
	deplace_y->setMaxValue (travfond.height () - deplace_h->value ());
	QColor localcol (255, 0, 0);
	titi.fill (localcol);
	QPainter p (this);
	p.end ();
	p.begin (&titi);
	p.fillRect (deplace_x->value () - 2, deplace_y->value () - 2,
		deplace_w->value () + 4, deplace_h->value () + 4, Qt::white);
	p.fillRect (deplace_x->value (), deplace_y->value (), deplace_w->value (),
		deplace_h->value (), Qt::black);
	p.end ();
	::bitBlt (imgtravail->pixmap (), 0, 0, &titi, 0, 0, -1, -1, Qt::OrROP,
		false);
	}
	
	void
	mainfrm::toolButton129_2_clicked () {
	recadrage->hide ();
	fen_slideshow->setEnabled (true);
	}




	


	void
	mainfrm::bt_defil_1_2_clicked () {
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotBack ();
	}
	}
	
	void
	mainfrm::bt_defil_2_2_clicked () {
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotForward ();
	}
	}


	
	void
	mainfrm::bt_deb_sub_2_clicked () {
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	int iHour;
	int iMin;
	int iSec;
	QTime mytime;
	float fElapsedTime =
		m_pMPlayerWidget->m_rxParseElapsedTime.cap (1).toFloat ();
	iHour = (int) (fElapsedTime / 3600.0);
	iMin = (int) ((fElapsedTime - iHour * 3600) / 60.0);
	iSec = (int) (fElapsedTime - iHour * 3600 - iMin * 60);
	mytime.setHMS (iHour, iMin, iSec);
	hre_fin_sub->setTime (mytime);
	}
	}



	void
	mainfrm::bt_lire_pr_chap_2_clicked () {
	m_pMPlayerWidget->slotPlay ();
	}

	void
	mainfrm::bt_stop_play_chap_2_clicked () {
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotStop ();
	}
	}
	



	
	void
	mainfrm::listdessub_doubleClicked (QListViewItem *) {
	QListViewItem *i = listdessub->selectedItem ();
	
	if (i != 0)
	{
	int hre;
	int min;
	int sec;
	
	tmp_001 = i->text (0);
	tmp_002 = tmp_001.mid (0, 2);
	rc_001 = tmp_002.toInt (&ok, 10);
	
	if (ok == true)
		{
		hre = rc_001;
		}
	else
		{
		hre = 0;
		}
	tmp_002 = tmp_001.mid (3, 2);
	rc_001 = tmp_002.toInt (&ok, 10);
	if (ok == true)
		{
		min = rc_001;
		}
	else
		{
		min = 0;
		}
	tmp_002 = tmp_001.mid (6, 2);
	rc_001 = tmp_002.toInt (&ok, 10);
	if (ok == true)
		{
		sec = rc_001;
		}
	else
		{
		sec = 0;
		}
	QTime time1 (hre, min, sec);
	hre_deb_sub->setTime (time1);
	//
	tmp_001 = i->text (1);
	tmp_002 = tmp_001.mid (0, 2);
	rc_001 = tmp_002.toInt (&ok, 10);
	
	if (ok == true)
		{
		hre = rc_001;
		}
	else
		{
		hre = 0;
		}
	tmp_002 = tmp_001.mid (3, 2);
	rc_001 = tmp_002.toInt (&ok, 10);
	if (ok == true)
		{
		min = rc_001;
		}
	else
		{
		min = 0;
		}
	tmp_002 = tmp_001.mid (6, 2);
	rc_001 = tmp_002.toInt (&ok, 10);
	if (ok == true)
		{
		sec = rc_001;
		}
	else
		{
		sec = 0;
		}
	QTime time2 (hre, min, sec);
	hre_fin_sub->setTime (time2);
	//
	textsub->setText (i->text (2));
	toolButton133_2->setDisabled (true);
	toolButton133_2_2->setDisabled (true);
	btcloseedit->setDisabled (true);
	btcloseedit_2->setDisabled (true);
	newsubt->setEnabled (true);
	listdessub->setDisabled (true);
	rc_002 = 1;
	}
	}
	
	void
	mainfrm::toolButton133_2_clicked () {
	rc_002 = 0;
	newsubt->setEnabled (true);
	listdessub->setDisabled (true);
	toolButton133_2->setDisabled (true);
	toolButton133_2_2->setDisabled (true);
	btcloseedit->setDisabled (true);
	btcloseedit_2->setDisabled (true);
	}
	
	void
	mainfrm::toolButton133_2_2_clicked () {
	QListViewItem *i = listdessub->selectedItem ();
	
	if (i != 0)
	{
	listdessub->takeItem (i);
	}
	}
	
	void
	mainfrm::btcloseedit_2_clicked () {
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotStop ();
	}
	createsubtitle->hide ();
	mediabar->hide ();
	vframe->setGeometry (31, 125, 115, 71);
	vframe->show ();
	vframe->raise ();
	}
	
	void
	mainfrm::bt_lire_pr_chap_2_2_clicked () {
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotPause ();
	}
	}
	
	void
	mainfrm::listdessub_clicked (QListViewItem *) {
	QListViewItem *i = listdessub->selectedItem ();
	
	if (i != 0)
	{
	tmp_001 = i->text (0).mid (0, 2);
	tmp_002 = i->text (0).mid (3, 2);
	tmp_003 = i->text (0).mid (6, 2);
	int hre = tmp_001.toInt (&ok, 10);
	int min = tmp_002.toInt (&ok, 10);
	int sec = tmp_003.toInt (&ok, 10);
	float wpositionnow;
	wpositionnow = (hre * 3600) + (min * 60) + sec;
	if (m_pMPlayerWidget->isPlaying () == false)
		{
		m_pMPlayerWidget->slotPlay ();
		}
	m_pMPlayerWidget->slotSeek (wpositionnow, 2);
	}
	}
	
	void
	mainfrm::extimgvideo_clicked () {
	Etape_02->setDisabled (true);
	m_pMPlayerWidget->setFilename (path_video);
	captureframe->setGeometry (320, 170, 360, 360);
	captureframe->show ();
	captureframe->raise ();
	mediabar->setGeometry (330, 460, 290, 30);
	mediabar->show ();
	mediabar->raise ();
	vframe->setGeometry (330, 180, 341, 273);
	vframe->show ();
	vframe->raise ();
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotStop ();
	}
	m_pMPlayerWidget->slotPlay ();
	}
	
	void
	mainfrm::btvalidcapture_clicked () {
	captureframe->hide ();
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotStop ();
	}
	mediabar->hide ();
	Etape_02->setEnabled (true);
	vframe->setGeometry (31, 125, 115, 71);
	vframe->show ();
	vframe->raise ();
	}
	
	void
	mainfrm::bt_c_6_clicked () {
	QPixmap cap_screen (333, 248);
	cap_screen.fill (Qt::black);
	::bitBlt (&cap_screen, 0, 0, m_pMPlayerWidget, 0, 7, -1, -1, Qt::CopyROP,
		false);
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotPause ();
	}
	QString myfic = QFileDialog::getSaveFileName (path_out->text (),
							"Images (*.png *.PNG)",
							this,
							"Enregistrer",
							"Images");
	if (myfic.isNull ())
	{
	}
	else
	{
	if (myfic.right (4) != ".png" && myfic.right (4) != ".PNG")
		{
		myfic = myfic + ".png";
		}
	
	cap_screen.save (myfic, "PNG");
	btvalidcapture_clicked ();
	QImage myimg (myfic, 0);
	QPixmap mypix (myimg);
	appimgbt->setPixmap (mypix);
	appimgbt->show ();
	lineEdit8->setText (myfic);
	}
	}
	
	void
	mainfrm::extimgvideo_gimp_clicked () {
	// **************************************
	// *** Modification d'une frame avec the gimp ***
	// **************************************
	if (lineEdit8->text () != "")
	{
	proc_001 = new QProcess (this);
	proc_001->addArgument ("gimp");
	proc_001->addArgument (lineEdit8->text ());
	connect (proc_001, SIGNAL (processExited ()), this,
		SLOT (fin_thegimp_extractimg ()));
	if (!proc_001->start ())
		{
		QMessageBox::warning (this, MANDVDVER,
					table_message[0] + "The Gimp");
		}
	else
		{
		this->setDisabled (true);
		}
	}
	}
	
	void
	mainfrm::fin_thegimp_extractimg () {
	this->setEnabled (true);
	QImage myimg (lineEdit8->text (), 0);
	QPixmap mypix (myimg);
	appimgbt->setPixmap (mypix);
	}
	
	void
	mainfrm::bt_defil_1_2_2_2_clicked () {
	m_pMPlayerWidget->slotSeek (0.1, 0);
	m_pMPlayerWidget->slotPause ();
	}
	
	void
	mainfrm::bt_defil_1_2_2_clicked () {
	int myseek = 2;
	m_pMPlayerWidget->slotSeek (-myseek, 0);
	m_pMPlayerWidget->slotPause ();
	}



	/* Real backend functions for interfae */
	void
	mainfrm::openedl (QString myfic) {
	QString myrec;
	// QString tmp_001; Testing if causeing strange error! 
	QFile myfichier (myfic);
	QTextStream mystream (&myfichier);
	QListViewItem *j;
	QTime time_1 (0, 0, 0);
	QTime time_2 (0, 0, 0);
	QTime time_3 (0, 0, 0);
	QTime time_4 (0, 0, 0);
	int thestartint;
	int theendint;
	int cpt1;
	
	if (myfichier.open (IO_ReadOnly))
	{
	myrec = mystream.readLine ();
	tmp_001 = "";
	cpt1 = 0;
	
	while (myrec.mid (cpt1, 1) != " " && cpt1 < myrec.length ())
		{
		tmp_001 = tmp_001 + myrec.mid (cpt1, 1);
		cpt1 = cpt1 + 1;
		}
	//
	cpt1 = cpt1 + 1;
	tmp_002 = "";
	while (myrec.mid (cpt1, 1) != " " && cpt1 < myrec.length ())
		{
		tmp_002 = tmp_002 + myrec.mid (cpt1, 1);
		cpt1 = cpt1 + 1;
		}
	//
	thestartint = tmp_001.toInt (&ok, 10);
	if (ok != true)
		{
		thestartint = 0;
		}
	theendint = tmp_002.toInt (&ok, 10);
	if (ok != true)
		{
		theendint = 0;
		}
	//
	time_1.setHMS (0, 0, 0);
	time_2.setHMS (0, 0, 0);
	time_3 = time_1.addSecs (thestartint);
	time_4 = time_2.addSecs (theendint);
	if (theendint != 0)
		{
		j =
		new QListViewItem (lstcut, time_3.toString ("hh:mm:ss"),
				time_4.toString ("hh:mm:ss"));
		}
	
	while (mystream.atEnd () == false)
		{
		myrec = mystream.readLine ();
		tmp_001 = "";
		cpt1 = 0;
	
		while (myrec.mid (cpt1, 1) != " " && cpt1 < myrec.length ())
		{
		tmp_001 = tmp_001 + myrec.mid (cpt1, 1);
		cpt1 = cpt1 + 1;
		}
		//
		cpt1 = cpt1 + 1;
		tmp_002 = "";
		while (myrec.mid (cpt1, 1) != " " && cpt1 < myrec.length ())
		{
		tmp_002 = tmp_002 + myrec.mid (cpt1, 1);
		cpt1 = cpt1 + 1;
		}
		//
		thestartint = tmp_001.toInt (&ok, 10);
		if (ok != true)
		{
		thestartint = 0;
		}
		theendint = tmp_002.toInt (&ok, 10);
		if (ok != true)
		{
		theendint = 0;
		}
		//
		time_1.setHMS (0, 0, 0);
		time_2.setHMS (0, 0, 0);
		time_3 = time_1.addSecs (thestartint);
		time_4 = time_2.addSecs (theendint);
		//
		if (theendint != 0)
		{
		j =
			new QListViewItem (lstcut, time_3.toString ("hh:mm:ss"),
					time_4.toString ("hh:mm:ss"));
		}
		}
	if (lstcut->childCount () > 0)
		{
		lstcut->setSortColumn (1);
		lstcut->sort ();
		}
	}
	}
	
	void
	mainfrm::outils1_2_2_clicked () {
	rc_003 = 3;
	QIconSet wl_icoset = outils1_2_2->iconSet ();
	pixmapLabel1_5->setPixmap (wl_icoset.pixmap ());
	tabpoint[0] = 0;
	tabpoint[1] = 0;
	buttonGroup63->setDisabled (true);
	}
	
	void
	mainfrm::toolButton158_clicked () {
	rc_004 = 0;
	}
	
	void
	mainfrm::toolButton158_2_clicked () {
	rc_004 = 1;
	}
	
	void
	mainfrm::toolButton158_3_clicked () {
	rc_004 = 2;
	}
	
	void
	mainfrm::toolButton158_3_2_clicked () {
	rc_004 = 3;
	}
	
	void
	mainfrm::toolButton158_3_2_2_clicked () {
	rc_004 = 4;
	}
	



	//#endif // MAINFRMUI_H

