/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

/*
 * Created on Feb 27, 2006
 */
package org.jboss.test.remoting.transport.multiplex;

import java.util.HashMap;
import java.util.Map;

import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transporter.TransporterServer;


/**
 * A EventRegistry_Impl.

 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 * @version $Revision: 1.2 $
 * <p>
 * Copyright (c) 2005
 * </p>
 */

public class EventRegistry_Impl implements EventRegistry
{
   public static String eventRegistryLocatorUriString = "socket://localhost:5280";
   private static final Logger log = Logger.getLogger(MultiplexInvokerShutdownTestServer.class);
   
   private TransporterServer server = null;
   private Map eventMap = new HashMap();

   
   public void start() throws Exception
   {
      InvokerLocator serverLocator = new InvokerLocator(eventRegistryLocatorUriString);
      server = TransporterServer.createTransporterServer(serverLocator, this, EventRegistry.class.getName());
   }

   
   public void stop()
   {
      if (server != null)
      {
         server.stop();
      }
   }
   
   
   public synchronized void postEvent(String eventName)
   {
      this.postEvent(eventName, null);
   }
   
   
   public synchronized void postEvent(String eventName, Object eventObject)
   {
      eventMap.put(eventName, eventObject);
      notifyAll();
   }
   
   
   public synchronized Object waitOnEvent(String eventName)
   {
      while (!eventMap.containsKey(eventName))
      {
         try
         {
            wait();
         }
         catch (InterruptedException ignored)
         {
         }
      }
      
      return eventMap.get(eventName);
   }
}

