/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qpainter.h>
#include <qpixmap.h>
#include <klistview.h>
#include <klocale.h>
#include "ColorListViewItem.h"
#include "kxmame.h"
#include "game_list.h"
#include "options_string.h"

extern "C" {
#include "unzip.h"
}

void ColorListViewItem::paintCell(
        QPainter *p, const QColorGroup &cg,
        int column, int width, int align)
{
	QColorGroup _cg = cg;
	if (clone )
		_cg.setColor(QColorGroup::Text, QColor(
			gui_prefs.clone_color.red  *256/65535,
			gui_prefs.clone_color.green*256/65535,
			gui_prefs.clone_color.blue *256/65535));

	KListViewItem::paintCell(p, _cg, column, width, align);
}

QString ColorListViewItem::column_value (int column_num)
{
	RomEntry *tmprom = mRom;
	QString my_hassamples;
	
	switch (column_num) {
		case GAMENAME:
			return rom_entry_get_list_name (tmprom);
		case HAS_ROMS:	   return tmprom->has_roms ? i18n("Yes") : i18n("No");
		case HAS_SAMPLES:
			if (tmprom->nb_samples == 0)
				my_hassamples = "";
			else
				my_hassamples = tmprom->has_samples ? QString(i18n("Yes")) : QString(i18n("No"));
			return  my_hassamples;
		case ROMNAME:	   return tmprom->romname;
		case VECTOR: 	   return tmprom->vector ? i18n("Vector") : i18n("Raster");
		case CONTROL:
			if (!strcmp (tmprom->control, i18n("trackball")))
				return i18n("Yes");
			else
				return i18n("No");
		case TIMESPLAYED:  return QString::number(tmprom->timesplayed);
		case MANU:	   return tmprom->manu;
		case YEAR:	   return tmprom->year;
		case CLONE:	   return tmprom->cloneof;
		case DRIVER:       return tmprom->driver;
		case STATUS:       return tmprom->has_roms ? i18n("Available") : i18n("Not Available");
		case ROMOF:        return tmprom->romof;
		case DRIVERSTATUS: return tmprom->status ? i18n("Working") : i18n("Not Working");
		case NUMPLAYERS:   return QString::number(tmprom->num_players);
		case NUMBUTTONS:   return QString::number(tmprom->num_buttons);
		case CPU1:         return tmprom->cpu_info[0].name;
		case CPU2:         return tmprom->cpu_info[1].name;
		case CPU3:         return tmprom->cpu_info[2].name;
		case CPU4:         return tmprom->cpu_info[3].name;
		case SOUND1:       return tmprom->sound_info[0].name;
		case SOUND2:       return tmprom->sound_info[1].name;
		case SOUND3:       return tmprom->sound_info[2].name;
		case SOUND4:       return tmprom->sound_info[3].name;
		case MAMEVER:      return tmprom->mame_ver_added;
		case CATEGORY:     return tmprom->category;
		case FAVORITE:     return tmprom->favourite ? i18n("Yes") : i18n("No");
		case CHANNELS:     return QString::number(tmprom->channels);
		default:
			return QString();
	}
}
void ColorListViewItem::setupGameListViewItem(RomEntry *tmprom, uint index, bool isClone, const QPixmap &icon)
{
	mRom = tmprom;
	mIndex = index;
	clone = isClone;

	if(globalIsMess) {
		setText(0,column_value( GAMENAME));
		return;
	}

	int col=0,id;
	for(int i=0; i< NUMBER_COLUMN; i++) {
		id = gui_prefs.ColumnShownId[i];
		if(id != -1) {
			setText(col, column_value(id));
			if (id == GAMENAME)
				setPixmap(col, icon);
			col++;
		}
		else 
			break;
	}
}

