/*************************************************************************
* Bulgarian-English Dictionary
* Copyright (C) 2000, 2001  Radostin Radnev <radnev@yahoo.com>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*************************************************************************/

#ifdef WITH_KDE
#include <kapp.h>
#include <kmessagebox.h>
#else
#include <qapplication.h>
#include <qmessagebox.h>
#endif

#include "encodechar.h"

#include "win.h"


//========================================================================
// $Id: main.cpp,v 1.4 2001/01/19 09:17:15 radnev Exp $
//========================================================================


QTextCodec* Converter1251;

const char MISSING_DATA[] =
	"Cannot open dictionary files 'en_bg.dat' and/or 'bg_en.dat'.\n"
	"Please look at README for additional information and help.";


int main(int argc, char **argv) {
	Converter1251 = QTextCodec::codecForName("CP1251");
#ifdef WITH_KDE
	KApplication a(argc, argv, "KBEDictionary");
#else
	QApplication a(argc, argv);
#endif
	// translation file for application strings
	QTranslator qtr(0);
	qtr.load(QString(Win::getLocalePath()) + "kbedic_" + QTextCodec::locale(), ".");
	a.installTranslator(&qtr);
	Win win;
	a.setMainWidget(&win);
	if (!win.getDataOk()) {
#ifdef WITH_KDE
		KMessageBox::sorry(0, W2U(MISSING_DATA), win.caption());
#else
		QMessageBox::critical(0, win.caption(), W2U(MISSING_DATA));
#endif
		a.exit(1);
		return 1;
	}
	win.show();
	return a.exec();
} // End of main
