package jfractionlab.worksheets;

import java.io.File;
import java.util.ArrayList;


public class WSGExtending extends WorkSheetGenerator {
	
	private ArrayList<ExerciseExtending> al_exercises;
	
	public WSGExtending(File exerciseFile, File solutionFile, int fractionmax, int factormax){
		super(lang.Messages.getString("extend_fractions"), WorkSheetGenerator.TWO_COLUMN);
		if (
				(fractionmax == 10 || fractionmax == 100) 
				&& 
				(factormax == 10 || factormax == 100)
		){
			al_exercises = new ArrayList<ExerciseExtending>();
			al_solutionLine = new ArrayList<String>();
			mkExercises(nb_of_exercises,fractionmax, factormax);
			generateText();
			writeFile(
					exerciseFile,
					al_exercisesText,
					true
			);
			writeFile(
					solutionFile,
					al_solutionsText,
					false
			);
		}else{
			throw new IllegalArgumentException( "fractionmax and factormax have to be 10 or 100" );
		}
	}
	
	protected void mkExercises(int nb, int fractionmax, int factormax) {
		for (int i = 0; i<nb; i++){
			al_exercises.add(new ExerciseExtending(fractionmax, factormax));
		}//for
	}

	@Override
	protected String writeOneLine(boolean isExercise, int nb) {
		String strReturn = "";
		n1 = al_exercises.get(nb).getN1();
		d1 = al_exercises.get(nb).getD1();
		int f1 = al_exercises.get(nb).getFactor();
		n2 = al_exercises.get(nb+1).getN1();
		d2 = al_exercises.get(nb+1).getD1();
		int f2 = al_exercises.get(nb+1).getFactor();
			strReturn += String.valueOf(nb+1);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+n1+"}{"+d1+"}$";
			strReturn += " ; ("+f1+") = ";
			if(!isExercise){
				strReturn += "$\\frac{"+n1+"\\cdot"+f1+"}{"+d1+"\\cdot"+f1+"}$ = ";
				strReturn += "$\\frac{"+(n1*f1)+"}{"+(d1*f1)+"}$";
				al_solutionLine.add("$\\frac{"+(n1*f1)+"}{"+(d1*f1)+"}$");
			}
			strReturn += "&"; //-----------------------
			strReturn += String.valueOf(nb+2);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+n2+"}{"+d2+"}$";
			strReturn += " ; ("+f2+") = ";
			if(!isExercise){
				strReturn += "$\\frac{"+n2+"\\cdot"+f2+"}{"+d2+"\\cdot"+f2+"}$ = ";
				strReturn += "$\\frac{"+(n2*f2)+"}{"+(d2*f2)+"}$";
				al_solutionLine.add("$\\frac{"+(n2*f2)+"}{"+(d2*f2)+"}$");
			}
			strReturn += "\\\\";
		return strReturn;
	}

}

//package jfractionlab.worksheets;
//
//import java.io.File;
//import java.util.ArrayList;
//
//
//public class WSGExtending extends WorkSheetGenerator {
//	
//	private ArrayList<ExerciseExtending> al_exercises;
//	
//	public WSGExtending(File exerciseFile, File solutionFile, int fractionmax, int factormax){
//		super(lang.Messages.getString("extend_fractions"), WorkSheetGenerator.TWO_COLUMN);
//		if (
//				(fractionmax == 10 || fractionmax == 100) 
//				&& 
//				(factormax == 10 || factormax == 100)
//		){
//			al_exercises = new ArrayList<ExerciseExtending>();
//			al_solutionLine = new ArrayList<String>();
//			mkExercises(nb_of_exercises,fractionmax, factormax);
//			generateText();
//			writeFile(
//					exerciseFile,
//					al_exercisesText,
//					true
//			);
//			writeFile(
//					solutionFile,
//					al_solutionsText,
//					false
//			);
//		}else{
//			throw new IllegalArgumentException( "fractionmax and factormax have to be 10 or 100" );
//		}
//	}
//	
//	protected void mkExercises(int nb, int fractionmax, int factormax) {
//		for (int i = 0; i<nb; i++){
//			al_exercises.add(new ExerciseExtending(fractionmax, factormax));
//		}//for
//	}
//
//	@Override
//	protected String writeOneLine(boolean isExercise, int nb) {
//		String strReturn = "";
//		n1 = al_exercises.get(nb).getN1();
//		d1 = al_exercises.get(nb).getD1();
//		int f1 = al_exercises.get(nb).getFactor();
//			strReturn += String.valueOf(nb+1);
//			strReturn += "&"; //-----------------------
//			strReturn += "$\\frac{"+n1+"}{"+d1+"}$";
//			strReturn += " ; ("+f1+") = ";
//			if(!isExercise){
//				strReturn += "$\\frac{"+n1+"\\cdot"+f1+"}{"+d1+"\\cdot"+f1+"}$ = ";
//				strReturn += "$\\frac{"+(n1*f1)+"}{"+(d1*f1)+"}$";
//				al_solutionLine.add("$\\frac{"+(n1*f1)+"}{"+(d1*f1)+"}$");
//			}
//			strReturn += "\\\\";
//		return strReturn;
//	}
//
//}
