/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.Tool;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.Message;
import org.antlr.tool.Rule;

public class TestSymbolDefinitions
extends BaseTest {
    public void testParserSimpleTokens() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A | B;\nb : C ;");
        String rules = "a, b";
        String tokenNames = "A, B, C";
        this.checkSymbols(g, rules, tokenNames);
    }

    public void testParserTokensSection() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ntokens {\n  C;\n  D;}\na : A | B;\nb : C ;");
        String rules = "a, b";
        String tokenNames = "A, B, C, D";
        this.checkSymbols(g, rules, tokenNames);
    }

    public void testLexerTokensSection() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\ntokens {\n  C;\n  D;}\nA : 'a';\nC : 'c' ;");
        String rules = "A, C, Tokens";
        String tokenNames = "A, C, D";
        this.checkSymbols(g, rules, tokenNames);
    }

    public void testTokensSectionWithAssignmentSection() throws Exception {
        Grammar g = new Grammar("grammar t;\ntokens {\n  C='c';\n  D;}\na : A | B;\nb : C ;");
        String rules = "a, b";
        String tokenNames = "A, B, C, D, 'c'";
        this.checkSymbols(g, rules, tokenNames);
    }

    public void testCombinedGrammarLiterals() throws Exception {
        Grammar g = new Grammar("grammar t;\na : 'begin' b 'end';\nb : C ';' ;\nID : 'a' ;\nFOO : 'foo' ;\nC : 'c' ;\n");
        String rules = "a, b";
        String tokenNames = "C, FOO, ID, 'begin', 'end', ';'";
        this.checkSymbols(g, rules, tokenNames);
    }

    public void testCombinedGrammarWithRefToLiteralButNoTokenIDRef() throws Exception {
        Grammar g = new Grammar("grammar t;\na : 'a' ;\nA : 'a' ;\n");
        String rules = "a";
        String tokenNames = "A, 'a'";
        this.checkSymbols(g, rules, tokenNames);
    }

    public void testSimplePlusEqualLabel() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : ids+=ID ( COMMA ids+=ID )* ;\n");
        String rule = "a";
        String tokenLabels = "ids";
        String ruleLabels = null;
        this.checkPlusEqualsLabels(g, rule, tokenLabels, ruleLabels);
    }

    public void testMixedPlusEqualLabel() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {output=AST;}\na : id+=ID ( ',' e+=expr )* ;\nexpr : 'e';\nID : 'a';\n");
        String rule = "a";
        String tokenLabels = "id";
        String ruleLabels = "e";
        this.checkPlusEqualsLabels(g, rule, tokenLabels, ruleLabels);
    }

    public void testParserCharLiteralWithEscape() throws Exception {
        Grammar g = new Grammar("grammar t;\na : '\\n';\n");
        Set literals = g.getStringLiterals();
        TestSymbolDefinitions.assertEquals((Object)"'\\n'", (Object)literals.toArray()[0]);
    }

    public void testParserStringLiterals() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na : 'begin' b ;\nb : C ;");
        String expectedArg = "'begin'";
        int expectedMsgID = 107;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testParserCharLiterals() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na : '(' b ;\nb : C ;");
        String expectedArg = "'('";
        int expectedMsgID = 107;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testEmptyNotChar() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar foo;\na : (~'x')+ ;\n");
        g.createNFAs();
        String expectedArg = "'x'";
        int expectedMsgID = 139;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testEmptyNotToken() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar foo;\na : (~A)+ ;\n");
        g.createNFAs();
        String expectedArg = "A";
        int expectedMsgID = 139;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testEmptyNotSet() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar foo;\na : (~(A|B))+ ;\n");
        g.createNFAs();
        Object expectedArg = null;
        int expectedMsgID = 139;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testStringLiteralInParserTokensSection() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\ntokens {\n  B='begin';\n}\na : A B;\nb : C ;");
        String expectedArg = "'begin'";
        int expectedMsgID = 107;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testCharLiteralInParserTokensSection() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\ntokens {\n  B='(';\n}\na : A B;\nb : C ;");
        String expectedArg = "'('";
        int expectedMsgID = 107;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testCharLiteralInLexerTokensSection() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("lexer grammar t;\ntokens {\n  B='(';\n}\nID : 'a';\n");
        String expectedArg = "'('";
        int expectedMsgID = 108;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testRuleRedefinition() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na : A | B;\na : C ;");
        String expectedArg = "a";
        int expectedMsgID = 101;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testLexerRuleRedefinition() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("lexer grammar t;\nID : 'a' ;\nID : 'd' ;");
        String expectedArg = "ID";
        int expectedMsgID = 101;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testCombinedRuleRedefinition() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar t;\nx : ID ;\nID : 'a' ;\nx : ID ID ;");
        String expectedArg = "x";
        int expectedMsgID = 101;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testUndefinedToken() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar t;\nx : ID ;");
        String expectedArg = "ID";
        int expectedMsgID = 105;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testUndefinedTokenOkInParser() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\nx : ID ;");
        TestSymbolDefinitions.assertEquals((String)"should not be an error", (int)0, (int)equeue.errors.size());
    }

    public void testUndefinedRule() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar t;\nx : r ;");
        String expectedArg = "r";
        int expectedMsgID = 106;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testLexerRuleInParser() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\nX : ;");
        String expectedArg = "X";
        int expectedMsgID = 102;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testParserRuleInLexer() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("lexer grammar t;\na : ;");
        String expectedArg = "a";
        int expectedMsgID = 103;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testRuleScopeConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar t;\nscope a {\n  int n;\n}\na : \n  ;\n");
        String expectedArg = "a";
        int expectedMsgID = 118;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testTokenRuleScopeConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar t;\nscope ID {\n  int n;\n}\nID : 'a'\n  ;\n");
        String expectedArg = "ID";
        int expectedMsgID = 118;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testTokenScopeConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar t;\ntokens { ID; }\nscope ID {\n  int n;\n}\na : \n  ;\n");
        String expectedArg = "ID";
        int expectedMsgID = 118;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testTokenRuleScopeConflictInLexerGrammar() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("lexer grammar t;\nscope ID {\n  int n;\n}\nID : 'a'\n  ;\n");
        String expectedArg = "ID";
        int expectedMsgID = 118;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testTokenLabelScopeConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\nscope s {\n  int n;\n}\na : s=ID \n  ;\n");
        String expectedArg = "s";
        int expectedMsgID = 118;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testRuleLabelScopeConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\nscope s {\n  int n;\n}\na : s=b \n  ;\nb : ;\n");
        String expectedArg = "s";
        int expectedMsgID = 118;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testLabelAndRuleNameConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na : c=b \n  ;\nb : ;\nc : ;\n");
        String expectedArg = "c";
        int expectedMsgID = 119;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testLabelAndTokenNameConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na : ID=b \n  ;\nb : ID ;\nc : ;\n");
        String expectedArg = "ID";
        int expectedMsgID = 120;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testLabelAndArgConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na[int i] returns [int x]: i=ID \n  ;\n");
        String expectedArg = "i";
        int expectedMsgID = 122;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testLabelAndParameterConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na[int i] returns [int x]: x=ID \n  ;\n");
        String expectedArg = "x";
        int expectedMsgID = 122;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testLabelRuleScopeConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na\nscope {  int n;}\n  : n=ID\n  ;\n");
        String expectedArg = "n";
        String expectedArg2 = "a";
        int expectedMsgID = 121;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    public void testRuleScopeArgConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na[int n]\nscope {  int n;}\n  : \n  ;\n");
        String expectedArg = "n";
        String expectedArg2 = "a";
        int expectedMsgID = 124;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    public void testRuleScopeReturnValueConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na returns [int n]\nscope {  int n;}\n  : \n  ;\n");
        String expectedArg = "n";
        String expectedArg2 = "a";
        int expectedMsgID = 124;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    public void testRuleScopeRuleNameConflict() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na\nscope {  int a;}\n  : \n  ;\n");
        String expectedArg = "a";
        Object expectedArg2 = null;
        int expectedMsgID = 123;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    public void testBadGrammarOption() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Tool antlr = this.newTool();
        Grammar g = new Grammar(antlr, "t", new StringReader("grammar t;\noptions {foo=3; language=Java;}\na : 'a';\n"));
        String expectedArg = "foo";
        int expectedMsgID = 133;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testBadRuleOption() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar t;\na\noptions {k=3; tokenVocab=blort;}\n  : 'a';\n");
        String expectedArg = "tokenVocab";
        int expectedMsgID = 133;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    public void testBadSubRuleOption() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("grammar t;\na : ( options {k=3; language=Java;}\n    : 'a'\n    | 'b'\n    )\n  ;\n");
        String expectedArg = "language";
        int expectedMsgID = 133;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg);
        this.checkError(equeue, expectedMessage);
    }

    protected void checkError(ErrorQueue equeue, GrammarSemanticsMessage expectedMessage) throws Exception {
        Message foundMsg = null;
        int i = 0;
        while (i < equeue.errors.size()) {
            Message m = (Message)equeue.errors.get(i);
            if (m.msgID == expectedMessage.msgID) {
                foundMsg = m;
            }
            ++i;
        }
        TestSymbolDefinitions.assertNotNull((String)("no error; " + expectedMessage.msgID + " expected"), foundMsg);
        TestSymbolDefinitions.assertTrue((String)"error is not a GrammarSemanticsMessage", (boolean)(foundMsg instanceof GrammarSemanticsMessage));
        TestSymbolDefinitions.assertEquals((Object)expectedMessage.arg, (Object)foundMsg.arg);
    }

    protected void checkPlusEqualsLabels(Grammar g, String ruleName, String tokenLabelsStr, String ruleLabelsStr) throws Exception {
        Rule r = g.getRule(ruleName);
        StringTokenizer st = new StringTokenizer(tokenLabelsStr, ", ");
        HashSet<String> tokenLabels = null;
        while (st.hasMoreTokens()) {
            if (tokenLabels == null) {
                tokenLabels = new HashSet<String>();
            }
            String labelName = st.nextToken();
            tokenLabels.add(labelName);
        }
        HashSet<String> ruleLabels = null;
        if (ruleLabelsStr != null) {
            st = new StringTokenizer(ruleLabelsStr, ", ");
            ruleLabels = new HashSet<String>();
            while (st.hasMoreTokens()) {
                String labelName = st.nextToken();
                ruleLabels.add(labelName);
            }
        }
        String string = "token += labels mismatch; " + tokenLabels + "!=" + r.tokenListLabels;
        boolean bl = false;
        if (tokenLabels != null && r.tokenListLabels != null || tokenLabels == null && r.tokenListLabels == null) {
            bl = true;
        }
        TestSymbolDefinitions.assertTrue((String)string, (boolean)bl);
        String string2 = "rule += labels mismatch; " + ruleLabels + "!=" + r.ruleListLabels;
        boolean bl2 = false;
        if (ruleLabels != null && r.ruleListLabels != null || ruleLabels == null && r.ruleListLabels == null) {
            bl2 = true;
        }
        TestSymbolDefinitions.assertTrue((String)string2, (boolean)bl2);
        if (tokenLabels != null) {
            TestSymbolDefinitions.assertEquals(tokenLabels, r.tokenListLabels.keySet());
        }
        if (ruleLabels != null) {
            TestSymbolDefinitions.assertEquals(ruleLabels, r.ruleListLabels.keySet());
        }
    }

    protected void checkSymbols(Grammar g, String rulesStr, String tokensStr) throws Exception {
        Set tokens = g.getTokenDisplayNames();
        StringTokenizer st = new StringTokenizer(tokensStr, ", ");
        while (st.hasMoreTokens()) {
            String tokenName = st.nextToken();
            String string = "token " + tokenName + " expected";
            boolean bl = false;
            if (g.getTokenType(tokenName) != -6) {
                bl = true;
            }
            TestSymbolDefinitions.assertTrue((String)string, (boolean)bl);
            tokens.remove(tokenName);
        }
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            String tokenName = (String)iter.next();
            String string = "unexpected token name " + tokenName;
            boolean bl = false;
            if (g.getTokenType(tokenName) < 4) {
                bl = true;
            }
            TestSymbolDefinitions.assertTrue((String)string, (boolean)bl);
        }
        st = new StringTokenizer(rulesStr, ", ");
        int n = 0;
        while (st.hasMoreTokens()) {
            String ruleName = st.nextToken();
            TestSymbolDefinitions.assertNotNull((String)("rule " + ruleName + " expected"), (Object)g.getRule(ruleName));
            ++n;
        }
        Collection rules = g.getRules();
        System.out.println("rules=" + rules);
        TestSymbolDefinitions.assertEquals((String)("number of rules mismatch; expecting " + n + "; found " + rules.size()), (int)n, (int)rules.size());
    }
}

