/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.antlr.Tool;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.Grammar;

public abstract class BaseTest
extends TestCase {
    public static final String jikes = null;
    public static final String pathSep = System.getProperty("path.separator");
    public static final String CLASSPATH = System.getProperty("java.class.path");
    public static final String tmpdir = new File(System.getProperty("java.io.tmpdir"), "antlr3").getAbsolutePath();

    protected Tool newTool() {
        Tool tool = new Tool();
        tool.setOutputDirectory(tmpdir);
        return tool;
    }

    protected boolean compile(String fileName) {
        String compiler = "javac";
        String classpathOption = "-classpath";
        if (jikes != null) {
            compiler = jikes;
            classpathOption = "-bootclasspath";
        }
        String[] args = new String[]{compiler, "-d", tmpdir, classpathOption, tmpdir + pathSep + CLASSPATH, tmpdir + '/' + fileName};
        String cmdLine = compiler + " -d " + tmpdir + ' ' + classpathOption + ' ' + tmpdir + pathSep + CLASSPATH + ' ' + fileName;
        File outputDir = new File(tmpdir);
        try {
            Process process = Runtime.getRuntime().exec(args, null, outputDir);
            StreamVacuum stdout = new StreamVacuum(process.getInputStream());
            StreamVacuum stderr = new StreamVacuum(process.getErrorStream());
            stdout.start();
            stderr.start();
            process.waitFor();
            if (stdout.toString().length() > 0) {
                System.err.println("compile stderr from: " + cmdLine);
                System.err.println(stdout);
            }
            if (stderr.toString().length() > 0) {
                System.err.println("compile stderr from: " + cmdLine);
                System.err.println(stderr);
            }
            int ret = process.exitValue();
            boolean bl = false;
            if (ret == 0) {
                bl = true;
            }
            return bl;
        }
        catch (Exception e) {
            System.err.println("can't exec compilation");
            e.printStackTrace(System.err);
            return false;
        }
    }

    protected void antlr(String fileName, String grammarStr, boolean debug) {
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, fileName, grammarStr);
        try {
            Grammar g = new Grammar(grammarStr);
            ArrayList<String> options = new ArrayList<String>();
            if (debug) {
                options.add("-debug");
            }
            options.add("-o");
            options.add(tmpdir);
            options.add(new File(tmpdir, g.name + ".g").toString());
            String[] optionsA = new String[options.size()];
            options.toArray(optionsA);
            Tool antlr = new Tool(optionsA);
            antlr.process();
        }
        catch (Exception e) {
            System.err.println("problems building grammar: " + e);
            e.printStackTrace(System.err);
        }
    }

    protected String execParser(String grammarFileName, String grammarStr, String parserName, String lexerName, String startRuleName, String input, boolean debug) {
        this.eraseFiles(".class");
        this.eraseFiles(".java");
        this.rawGenerateAndBuildRecognizer(grammarFileName, grammarStr, parserName, lexerName, debug);
        this.writeFile(tmpdir, "input", input);
        boolean bl = false;
        if (grammarStr.indexOf("output=AST") >= 0) {
            bl = true;
        }
        boolean parserBuildsTrees = bl;
        boolean bl2 = false;
        if (grammarStr.indexOf("output=template") >= 0) {
            bl2 = true;
        }
        boolean parserBuildsTemplate = bl2;
        return this.rawExecRecognizer(parserName, null, lexerName, startRuleName, null, parserBuildsTrees, parserBuildsTemplate, debug);
    }

    protected String execTreeParser(String parserGrammarFileName, String parserGrammarStr, String parserName, String treeParserGrammarFileName, String treeParserGrammarStr, String treeParserName, String lexerName, String parserStartRuleName, String treeParserStartRuleName, String input) {
        return this.execTreeParser(parserGrammarFileName, parserGrammarStr, parserName, treeParserGrammarFileName, treeParserGrammarStr, treeParserName, lexerName, parserStartRuleName, treeParserStartRuleName, input, false);
    }

    protected String execTreeParser(String parserGrammarFileName, String parserGrammarStr, String parserName, String treeParserGrammarFileName, String treeParserGrammarStr, String treeParserName, String lexerName, String parserStartRuleName, String treeParserStartRuleName, String input, boolean debug) {
        this.eraseFiles(".class");
        this.eraseFiles(".java");
        this.rawGenerateAndBuildRecognizer(parserGrammarFileName, parserGrammarStr, parserName, lexerName, debug);
        this.rawGenerateAndBuildRecognizer(treeParserGrammarFileName, treeParserGrammarStr, treeParserName, lexerName, debug);
        this.writeFile(tmpdir, "input", input);
        boolean bl = false;
        if (parserGrammarStr.indexOf("output=AST") >= 0) {
            bl = true;
        }
        boolean parserBuildsTrees = bl;
        boolean bl2 = false;
        if (parserGrammarStr.indexOf("output=template") >= 0) {
            bl2 = true;
        }
        boolean parserBuildsTemplate = bl2;
        return this.rawExecRecognizer(parserName, treeParserName, lexerName, parserStartRuleName, treeParserStartRuleName, parserBuildsTrees, parserBuildsTemplate, debug);
    }

    protected void rawGenerateAndBuildRecognizer(String grammarFileName, String grammarStr, String parserName, String lexerName, boolean debug) {
        this.antlr(grammarFileName, grammarStr, debug);
        if (lexerName != null) {
            this.compile(parserName + ".java");
            this.compile(lexerName + ".java");
        } else {
            this.compile(parserName + ".java");
        }
    }

    protected String rawExecRecognizer(String parserName, String treeParserName, String lexerName, String parserStartRuleName, String treeParserStartRuleName, boolean parserBuildsTrees, boolean parserBuildsTemplate, boolean debug) {
        if (parserBuildsTrees) {
            this.writeTreeTestFile(parserName, treeParserName, lexerName, parserStartRuleName, treeParserStartRuleName, debug);
        } else if (parserBuildsTemplate) {
            this.writeTemplateTestFile(parserName, lexerName, parserStartRuleName, debug);
        } else {
            this.writeTestFile(parserName, lexerName, parserStartRuleName, debug);
        }
        this.compile("Test.java");
        try {
            String[] args = new String[]{"java", "-classpath", CLASSPATH + pathSep + tmpdir, "Test", new File(tmpdir, "input").getAbsolutePath()};
            String cmdLine = "java -classpath " + CLASSPATH + pathSep + tmpdir + " Test " + new File(tmpdir, "input").getAbsolutePath();
            Process process = Runtime.getRuntime().exec(args, null, new File(tmpdir));
            StreamVacuum stdout = new StreamVacuum(process.getInputStream());
            StreamVacuum stderr = new StreamVacuum(process.getErrorStream());
            stdout.start();
            stderr.start();
            process.waitFor();
            stdout.join();
            stderr.join();
            String output = null;
            output = stdout.toString();
            if (stderr.toString().length() > 0) {
                System.err.println("exec parser stderr: " + stderr);
            }
            return output;
        }
        catch (Exception e) {
            System.err.println("can't exec parser");
            e.printStackTrace(System.err);
            return null;
        }
    }

    protected void writeFile(String dir, String fileName, String content) {
        try {
            File f = new File(dir, fileName);
            FileWriter w = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(w);
            bw.write(content);
            bw.close();
            w.close();
        }
        catch (IOException ioe) {
            System.err.println("can't write file");
            ioe.printStackTrace(System.err);
        }
    }

    protected void mkdir(String dir) {
        File f = new File(dir);
        f.mkdirs();
    }

    protected void writeTestFile(String parserName, String lexerName, String parserStartRuleName, boolean debug) {
        StringTemplate outputFileST = new StringTemplate("import org.antlr.runtime.*;\nimport org.antlr.runtime.tree.*;\nimport org.antlr.runtime.debug.*;\n\nclass Profiler2 extends Profiler {\n    public void terminate() { ; }\n}\npublic class Test {\n    public static void main(String[] args) throws Exception {\n        CharStream input = new ANTLRFileStream(args[0]);\n        $lexerName$ lex = new $lexerName$(input);\n        CommonTokenStream tokens = new CommonTokenStream(lex);\n        $createParser$\n        parser.$parserStartRuleName$();\n    }\n}");
        StringTemplate createParserST = new StringTemplate("        Profiler2 profiler = new Profiler2();\n        $parserName$ parser = new $parserName$(tokens,profiler);\n        profiler.setParser(parser);\n");
        if (!debug) {
            createParserST = new StringTemplate("        $parserName$ parser = new $parserName$(tokens);\n");
        }
        outputFileST.setAttribute("createParser", (Object)createParserST);
        outputFileST.setAttribute("parserName", (Object)parserName);
        outputFileST.setAttribute("lexerName", (Object)lexerName);
        outputFileST.setAttribute("parserStartRuleName", (Object)parserStartRuleName);
        this.writeFile(tmpdir, "Test.java", outputFileST.toString());
    }

    protected void writeTreeTestFile(String parserName, String treeParserName, String lexerName, String parserStartRuleName, String treeParserStartRuleName, boolean debug) {
        StringTemplate outputFileST = new StringTemplate("import org.antlr.runtime.*;\nimport org.antlr.runtime.tree.*;\nimport org.antlr.runtime.debug.*;\n\nclass Profiler2 extends Profiler {\n    public void terminate() { ; }\n}\npublic class Test {\n    public static void main(String[] args) throws Exception {\n        CharStream input = new ANTLRFileStream(args[0]);\n        $lexerName$ lex = new $lexerName$(input);\n        CommonTokenStream tokens = new CommonTokenStream(lex);\n        $createParser$\n        $parserName$.$parserStartRuleName$_return r = parser.$parserStartRuleName$();\n        $if(!treeParserStartRuleName)$\n        if ( r.tree!=null )\n            System.out.println(((Tree)r.tree).toStringTree());\n        $else$\n        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Tree)r.tree);\n        $treeParserName$ walker = new $treeParserName$(nodes);\n        walker.$treeParserStartRuleName$();\n        $endif$\n    }\n}");
        StringTemplate createParserST = new StringTemplate("        Profiler2 profiler = new Profiler2();\n        $parserName$ parser = new $parserName$(tokens,profiler);\n        profiler.setParser(parser);\n");
        if (!debug) {
            createParserST = new StringTemplate("        $parserName$ parser = new $parserName$(tokens);\n");
        }
        outputFileST.setAttribute("createParser", (Object)createParserST);
        outputFileST.setAttribute("parserName", (Object)parserName);
        outputFileST.setAttribute("treeParserName", (Object)treeParserName);
        outputFileST.setAttribute("lexerName", (Object)lexerName);
        outputFileST.setAttribute("parserStartRuleName", (Object)parserStartRuleName);
        outputFileST.setAttribute("treeParserStartRuleName", (Object)treeParserStartRuleName);
        this.writeFile(tmpdir, "Test.java", outputFileST.toString());
    }

    protected void writeTemplateTestFile(String parserName, String lexerName, String parserStartRuleName, boolean debug) {
        StringTemplate outputFileST = new StringTemplate("import org.antlr.runtime.*;\nimport org.antlr.stringtemplate.*;\nimport org.antlr.stringtemplate.language.*;\nimport org.antlr.runtime.debug.*;\nimport java.io.*;\n\nclass Profiler2 extends Profiler {\n    public void terminate() { ; }\n}\npublic class Test {\n    static String templates =\n    \t\t\"group test;\"+    \t\t\"foo(x,y) ::= \\\"<x> <y>\\\"\";\n    static StringTemplateGroup group =    \t\tnew StringTemplateGroup(new StringReader(templates),\t\t\t\t\tAngleBracketTemplateLexer.class);    public static void main(String[] args) throws Exception {\n        CharStream input = new ANTLRFileStream(args[0]);\n        $lexerName$ lex = new $lexerName$(input);\n        CommonTokenStream tokens = new CommonTokenStream(lex);\n        $createParser$\n\t\t parser.setTemplateLib(group);\n        $parserName$.$parserStartRuleName$_return r = parser.$parserStartRuleName$();\n        if ( r.st!=null )\n            System.out.print(r.st.toString());\n\t \t else\n            System.out.print(\"\");\n    }\n}");
        StringTemplate createParserST = new StringTemplate("        Profiler2 profiler = new Profiler2();\n        $parserName$ parser = new $parserName$(tokens,profiler);\n        profiler.setParser(parser);\n");
        if (!debug) {
            createParserST = new StringTemplate("        $parserName$ parser = new $parserName$(tokens);\n");
        }
        outputFileST.setAttribute("createParser", (Object)createParserST);
        outputFileST.setAttribute("parserName", (Object)parserName);
        outputFileST.setAttribute("lexerName", (Object)lexerName);
        outputFileST.setAttribute("parserStartRuleName", (Object)parserStartRuleName);
        this.writeFile(tmpdir, "Test.java", outputFileST.toString());
    }

    protected void eraseFiles(String filesEndingWith) {
        File tmpdirF = new File(tmpdir);
        String[] files = tmpdirF.list();
        int i = 0;
        while (files != null && i < files.length) {
            if (files[i].endsWith(filesEndingWith)) {
                new File(tmpdir + '/' + files[i]).delete();
            }
            ++i;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class StreamVacuum
    implements Runnable {
        StringBuffer buf;
        BufferedReader in;
        Thread sucker;

        public void start() {
            this.sucker = new Thread(this);
            this.sucker.start();
        }

        public void run() {
            try {
                String line = this.in.readLine();
                while (line != null) {
                    this.buf.append(line);
                    this.buf.append('\n');
                    line = this.in.readLine();
                }
            }
            catch (IOException ioe) {
                System.err.println("can't read output from process");
            }
        }

        public void join() throws InterruptedException {
            this.sucker.join();
        }

        public String toString() {
            return this.buf.toString();
        }

        private final /* synthetic */ void this() {
            this.buf = new StringBuffer();
        }

        public StreamVacuum(InputStream in) {
            this.this();
            this.in = new BufferedReader(new InputStreamReader(in));
        }
    }
}

