/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.Message;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TestRewriteAST
extends BaseTest {
    protected boolean debug;

    public void testDelete() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID INT -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"", (String)found);
    }

    public void testSingleToken() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID -> ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)found);
    }

    public void testSingleCharLiteral() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : 'c' -> 'c';\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "c", this.debug);
        TestRewriteAST.assertEquals((String)"c\n", (String)found);
    }

    public void testSingleStringLiteral() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : 'ick' -> 'ick';\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "ick", this.debug);
        TestRewriteAST.assertEquals((String)"ick\n", (String)found);
    }

    public void testSingleRule() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : b -> b;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)found);
    }

    public void testReorderTokens() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID INT -> INT ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"34 abc\n", (String)found);
    }

    public void testReorderTokenAndRule() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : b INT -> INT b;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"34 abc\n", (String)found);
    }

    public void testTokenTree() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(INT ID);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"(34 abc)\n", (String)found);
    }

    public void testTokenTreeAfterOtherStuff() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : 'void' ID INT -> 'void' ^(INT ID);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "void abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"void (34 abc)\n", (String)found);
    }

    public void testNestedTokenTreeWithOuterLoop() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {DUH;}\na : ID INT ID INT -> ^( DUH ID ^( DUH INT) )+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a 1 b 2", this.debug);
        TestRewriteAST.assertEquals((String)"(DUH a (DUH 1)) (DUH b (DUH 2))\n", (String)found);
    }

    public void testOptionalSingleToken() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID -> ID? ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)found);
    }

    public void testClosureSingleToken() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID ID -> ID* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)found);
    }

    public void testPositiveClosureSingleToken() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID ID -> ID+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)found);
    }

    public void testOptionalSingleRule() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : b -> b?;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)found);
    }

    public void testClosureSingleRule() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : b b -> b*;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)found);
    }

    public void testClosureOfLabel() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : x+=b x+=b -> $x*;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)found);
    }

    public void testOptionalLabelNoListLabel() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : (x=ID)? -> $x?;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a", this.debug);
        TestRewriteAST.assertEquals((String)"a\n", (String)found);
    }

    public void testPositiveClosureSingleRule() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : b b -> b+;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)found);
    }

    public void testSinglePredicateT() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID -> {true}? ID -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)found);
    }

    public void testSinglePredicateF() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID -> {false}? ID -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"", (String)found);
    }

    public void testMultiplePredicate() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID INT -> {false}? ID\n           -> {true}? INT\n           -> \n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a 2", this.debug);
        TestRewriteAST.assertEquals((String)"2\n", (String)found);
    }

    public void testMultiplePredicateTrees() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID INT -> {false}? ^(ID INT)\n           -> {true}? ^(INT ID)\n           -> ID\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a 2", this.debug);
        TestRewriteAST.assertEquals((String)"(2 a)\n", (String)found);
    }

    public void testSimpleTree() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : op INT -> ^(op INT);\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "-34", this.debug);
        TestRewriteAST.assertEquals((String)"(- 34)\n", (String)found);
    }

    public void testSimpleTree2() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : op INT -> ^(INT op);\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "+ 34", this.debug);
        TestRewriteAST.assertEquals((String)"(34 +)\n", (String)found);
    }

    public void testQueueingOfTokens() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : 'int' ID (',' ID)* ';' -> ^('int' ID+) ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "int a,b,c;", this.debug);
        TestRewriteAST.assertEquals((String)"(int a b c)\n", (String)found);
    }

    public void testNestedTrees() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : 'var' (ID ':' type ';')+ -> ^('var' ^(':' ID type)+) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "var a:int; b:float;", this.debug);
        TestRewriteAST.assertEquals((String)"(var (: a int) (: b float))\n", (String)found);
    }

    public void testImaginaryTokenCopy() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {VAR;}\na : ID (',' ID)*-> ^(VAR ID)+ ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a,b,c", this.debug);
        TestRewriteAST.assertEquals((String)"(VAR a) (VAR b) (VAR c)\n", (String)found);
    }

    public void testImaginaryTokenCopySetText() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {VAR;}\na : ID (',' ID)*-> ^(VAR[\"var\"] ID)+ ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a,b,c", this.debug);
        TestRewriteAST.assertEquals((String)"(var a) (var b) (var c)\n", (String)found);
    }

    public void testImaginaryTokenNoCopyFromToken() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : lc='{' ID+ '}' -> ^(BLOCK[$lc] ID+) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "{a b c}", this.debug);
        TestRewriteAST.assertEquals((String)"({ a b c)\n", (String)found);
    }

    public void testImaginaryTokenNoCopyFromTokenSetText() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : lc='{' ID+ '}' -> ^(BLOCK[$lc,\"block\"] ID+) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "{a b c}", this.debug);
        TestRewriteAST.assertEquals((String)"(block a b c)\n", (String)found);
    }

    public void testMixedRewriteAndAutoAST() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : b b^ ;\nb : ID INT -> INT ID\n  | INT\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a 1 2", this.debug);
        TestRewriteAST.assertEquals((String)"(2 1 a)\n", (String)found);
    }

    public void testSubruleWithRewrite() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : b b ;\nb : (ID INT -> INT ID | INT INT -> INT+ )\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a 1 2 3", this.debug);
        TestRewriteAST.assertEquals((String)"1 a 2 3\n", (String)found);
    }

    public void testSubruleWithRewriteReferencingPreviousElement() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {TYPE;}\na : b b ;\nb : 'int'\n    ( ID -> ^(TYPE 'int' ID)\n    | ID '=' INT -> ^(TYPE 'int' ID INT)\n    )\n    ';'\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "int a; int b=3;", this.debug);
        TestRewriteAST.assertEquals((String)"(TYPE int a) (TYPE int b 3)\n", (String)found);
    }

    public void testNestedRewriteShutsOffAutoAST() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : b b ;\nb : ID ( ID (last=ID -> $last)+ ) ';'\n  | INT\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b c d; 42", this.debug);
        TestRewriteAST.assertEquals((String)"d 42\n", (String)found);
    }

    public void testRewriteActions() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : atom -> ^({adaptor.create(INT,\"9\")} atom) ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "3", this.debug);
        TestRewriteAST.assertEquals((String)"(9 3)\n", (String)found);
    }

    public void testRewriteActions2() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : atom -> {adaptor.create(INT,\"9\")} atom ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "3", this.debug);
        TestRewriteAST.assertEquals((String)"9 3\n", (String)found);
    }

    public void testRefToOldValue() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : (atom -> atom) (op='+' r=atom -> ^($op $a $r) )* ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "3+4+5", this.debug);
        TestRewriteAST.assertEquals((String)"(+ (+ 3 4) 5)\n", (String)found);
    }

    public void testCopySemanticsForRules() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : atom -> ^(atom atom) ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "3", this.debug);
        TestRewriteAST.assertEquals((String)"(3 3)\n", (String)found);
    }

    public void testComplicatedMelange() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : A A b=B B b=B c+=C C c+=C D {$D.text;} -> A+ B+ C+ D ;\ntype : 'int' | 'float' ;\nA : 'a' ;\nB : 'b' ;\nC : 'c' ;\nD : 'd' ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a a b b b c c c d", this.debug);
        TestRewriteAST.assertEquals((String)"a a b b b c c c d\n", (String)found);
    }

    public void testRuleListLabel() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=b x+=b -> $x+;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)found);
    }

    public void testOptional() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=b (y=b)? -> $x $y?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a", this.debug);
        TestRewriteAST.assertEquals((String)"a\n", (String)found);
    }

    public void testOptional2() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=ID (y=b)? -> $x $y?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)found);
    }

    public void testOptional3() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=ID (y=b)? -> ($x $y)?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)found);
    }

    public void testOptional4() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=ID (y=b)? -> ($x $y)?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)found);
    }

    public void testArbitraryExprType() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=b x+=b -> {new Object()};\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"nil\n", (String)found);
    }

    public void testUnknownRule() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        String grammar = "grammar T;\noptions {output=AST;}\na : INT -> ugh ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar g = new Grammar(grammar);
        Tool antlr = this.newTool();
        antlr.setOutputDirectory(null);
        CodeGenerator generator = new CodeGenerator(antlr, g, "Java");
        g.setCodeGenerator(generator);
        generator.genRecognizer();
        int expectedMsgID = 106;
        String expectedArg = "ugh";
        Object expectedArg2 = null;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    public void testKnownRuleButNotInLHS() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        String grammar = "grammar T;\noptions {output=AST;}\na : INT -> b ;\nb : 'b' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar g = new Grammar(grammar);
        Tool antlr = this.newTool();
        antlr.setOutputDirectory(null);
        CodeGenerator generator = new CodeGenerator(antlr, g, "Java");
        g.setCodeGenerator(generator);
        generator.genRecognizer();
        int expectedMsgID = 136;
        String expectedArg = "b";
        Object expectedArg2 = null;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    public void testUnknownToken() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        String grammar = "grammar T;\noptions {output=AST;}\na : INT -> ICK ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar g = new Grammar(grammar);
        Tool antlr = this.newTool();
        antlr.setOutputDirectory(null);
        CodeGenerator generator = new CodeGenerator(antlr, g, "Java");
        g.setCodeGenerator(generator);
        generator.genRecognizer();
        int expectedMsgID = 135;
        String expectedArg = "ICK";
        Object expectedArg2 = null;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    public void testUnknownLabel() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        String grammar = "grammar T;\noptions {output=AST;}\na : INT -> $foo ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar g = new Grammar(grammar);
        Tool antlr = this.newTool();
        antlr.setOutputDirectory(null);
        CodeGenerator generator = new CodeGenerator(antlr, g, "Java");
        g.setCodeGenerator(generator);
        generator.genRecognizer();
        int expectedMsgID = 137;
        String expectedArg = "foo";
        Object expectedArg2 = null;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    public void testUnknownCharLiteralToken() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        String grammar = "grammar T;\noptions {output=AST;}\na : INT -> 'a' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar g = new Grammar(grammar);
        Tool antlr = this.newTool();
        antlr.setOutputDirectory(null);
        CodeGenerator generator = new CodeGenerator(antlr, g, "Java");
        g.setCodeGenerator(generator);
        generator.genRecognizer();
        int expectedMsgID = 135;
        String expectedArg = "'a'";
        Object expectedArg2 = null;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    public void testUnknownStringLiteralToken() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        String grammar = "grammar T;\noptions {output=AST;}\na : INT -> 'foo' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar g = new Grammar(grammar);
        Tool antlr = this.newTool();
        antlr.setOutputDirectory(null);
        CodeGenerator generator = new CodeGenerator(antlr, g, "Java");
        g.setCodeGenerator(generator);
        generator.genRecognizer();
        int expectedMsgID = 135;
        String expectedArg = "'foo'";
        Object expectedArg2 = null;
        GrammarSemanticsMessage expectedMessage = new GrammarSemanticsMessage(expectedMsgID, g, null, expectedArg, expectedArg2);
        this.checkError(equeue, expectedMessage);
    }

    protected void checkError(ErrorQueue equeue, GrammarSemanticsMessage expectedMessage) throws Exception {
        Message foundMsg = null;
        int i = 0;
        while (i < equeue.errors.size()) {
            Message m = (Message)equeue.errors.get(i);
            if (m.msgID == expectedMessage.msgID) {
                foundMsg = m;
            }
            ++i;
        }
        String string = "no error; " + expectedMessage.msgID + " expected";
        boolean bl = false;
        if (equeue.errors.size() > 0) {
            bl = true;
        }
        TestRewriteAST.assertTrue((String)string, (boolean)bl);
        String string2 = "too many errors; " + equeue.errors;
        boolean bl2 = false;
        if (equeue.errors.size() <= 1) {
            bl2 = true;
        }
        TestRewriteAST.assertTrue((String)string2, (boolean)bl2);
        TestRewriteAST.assertNotNull((String)("couldn't find expected error: " + expectedMessage.msgID), (Object)foundMsg);
        TestRewriteAST.assertTrue((String)"error is not a GrammarSemanticsMessage", (boolean)(foundMsg instanceof GrammarSemanticsMessage));
        TestRewriteAST.assertEquals((Object)expectedMessage.arg, (Object)foundMsg.arg);
        TestRewriteAST.assertEquals((Object)expectedMessage.arg2, (Object)foundMsg.arg2);
        ErrorManager.resetErrorState();
    }

    private final /* synthetic */ void this() {
        this.debug = false;
    }

    public TestRewriteAST() {
        this.this();
    }
}

