/*
 *  DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 *  Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 *  The contents of this file are subject to the terms of either the GNU
 *  General Public License Version 2 only ("GPL") or the Common Development
 *  and Distribution License ("CDDL") (collectively, the "License").  You may
 *  not use this file except in compliance with the License.  You can obtain
 *  a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 *  or mq/legal/LICENSE.txt.  See the License for the specific language
 *  governing permissions and limitations under the License.
 * 
 *  When distributing the software, include this License Header Notice in each
 *  file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 *  this particular file as subject to the "Classpath" exception as provided by
 *  Sun in the GPL Version 2 section of the License file that accompanied this
 *  code.  If applicable, add the following below the License Header, with the
 *  fields enclosed by brackets [] replaced by your own identifying information:
 *  "Portions Copyrighted [year] [name of copyright owner]"
 * 
 *  Contributor(s):
 * 
 *  If you wish your version of this file to be governed by only the CDDL or
 *  only the GPL Version 2, indicate your decision by adding "[Contributor]
 *  elects to include this software in this distribution under the [CDDL or GPL
 *  Version 2] license."  If you don't indicate a single choice of license, a
 *  recipient has the option to distribute your version of this file under
 *  either the CDDL, the GPL Version 2 or  to extend the choice of license to
 *  its licensees as provided above.  However, if you add GPL Version 2 code
 *  and therefore, elected the GPL Version 2 license, then the option applies
 *  only if the new code is made subject to such option by the copyright holder. 
 *
 *  EmbeddedBrokerRunner.java
 *
 *  @(#)EmbeddedBrokerRunner.java	1.20 07/12/07
 */

package com.sun.messaging.jms.ra;

import java.util.logging.Logger;
import java.util.Vector;
import java.util.Properties;
import java.util.Enumeration;
import java.util.StringTokenizer;

import com.sun.messaging.jmq.jmsserver.BrokerProcess;
import com.sun.messaging.jmq.jmsserver.BrokerNotification;

import com.sun.messaging.jmq.jmsservice.JMSBroker;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.jmsservice.BrokerErrorEvent;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;

/**
 *  Runs an embedded broker instance through
 *  the Broker* interfaces exposed for in-process
 *  broker lifecycle control
 */

public class EmbeddedBrokerRunner
        implements BrokerNotification, BrokerEventListener {

    /** The class that implements the JMSBroker interface */
    private static final String JMSBROKER_CLASS =
            "com.sun.messaging.jmq.jmsserver.BrokerProcess";

    /** Properties to be used by the embedded broker */
    private Properties brokerProps = null;

    /** The JMSBroker instance */
    private JMSBroker bkr;

    /** The JMSService acquired from the JMSBroker */
    private JMSService jmsservice= null;

    /* The BrokerProcess instance */
    private BrokerProcess bp = null;

    /* The main broker thread */
    //private Thread bt = null;

    /* Loggers */
    private static transient final String _className =
            "com.sun.messaging.jms.ra.EmbeddedBrokerRunner";
    protected static transient final String _lgrNameLifecycle =
            "javax.resourceadapter.mqjmsra.lifecycle";
    protected static transient final Logger _loggerL =
            Logger.getLogger(_lgrNameLifecycle);
    protected static transient final String _lgrMIDPrefix = "MQJMSRA_EB";
    protected static transient final String _lgrMID_EET = _lgrMIDPrefix + "1001: ";
    protected static transient final String _lgrMID_INF = _lgrMIDPrefix + "1101: ";
    protected static transient final String _lgrMID_WRN = _lgrMIDPrefix + "2001: ";
    protected static transient final String _lgrMID_ERR = _lgrMIDPrefix + "3001: ";
    protected static transient final String _lgrMID_EXC = _lgrMIDPrefix + "4001: ";

    public EmbeddedBrokerRunner(
            String brokerInstanceName, String brokerBindAddress, int brokerPort,
            String brokerHomeDir, String brokerLibDir, String brokerVarDir, String brokerJavaDir,
            String brokerExtraArgs,
            boolean useJNDIRMIServiceURL, int rmiRegistryPort, boolean startRMIRegistry,
            boolean useSSLJMXConnector, int brokerStartTimeout,
            String adminUsername, String adminPassword, String adminPassFile, Properties sysProps)
    {
        Object params[] = new Object[16];
        params[0] = brokerInstanceName;
        params[1] = brokerBindAddress;
        params[2] = Integer.toString(brokerPort);
        params[3] = brokerHomeDir;
        params[4] = brokerLibDir;
        params[5] = brokerVarDir;
        params[6] = brokerJavaDir;
        params[7] = brokerExtraArgs;
        params[8] = new Boolean(useJNDIRMIServiceURL);
        params[9] = new Integer(rmiRegistryPort);
        params[10] = new Boolean(startRMIRegistry);
        params[11] = new Boolean(useSSLJMXConnector);
        params[12] = new Integer(brokerStartTimeout);
        params[13] = adminUsername;
        params[14] = adminPassFile;
        params[15] = sysProps;

        _loggerL.entering(_className, "constructor()", params);

        Vector<String> v = new Vector<String>();

        //Add extra args first; explicit config will override args 
        if (brokerExtraArgs != null && !("".equals(brokerExtraArgs)) ) {
            StringTokenizer st = new StringTokenizer(brokerExtraArgs, " ");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                v.add(t);
            }
        }

        //Add explicit config
        //
        v.add("-port");
        v.add(Integer.toString(brokerPort));

        if (brokerInstanceName != null) {
            v.add("-name");
            v.add(brokerInstanceName);
        }
 
        if (brokerHomeDir != null) {
            v.add("-imqhome");
            v.add(brokerHomeDir);
        }
 
        if (brokerVarDir != null) {
            v.add("-varhome");
            v.add(brokerVarDir);
        }

        if (brokerLibDir != null && !("".equals(brokerLibDir))) {
            v.add("-libhome");
            v.add(brokerLibDir);
        }

        if (useJNDIRMIServiceURL == true) {
            if (startRMIRegistry == true) {
                v.add("-startRmiRegistry");
            } else {
                v.add("-useRmiRegistry");
            }
            v.add("-rmiRegistryPort");
            v.add(Integer.toString(rmiRegistryPort));
        }
        
        //Add -save cli option to have the broker save properties at startup
        //The properties that are to be saved are defined by the broker
        //Enables MQ cli utilities that depend on the configuration to be run
        //after AS has shut down.
        v.add("-save");

        //Add -silent cli option to minimize broker output to AS log
        v.add("-silent");

        ////XXX: use useSSLJMXConnector

        String[] brokerArgs = (String []) v.toArray(new String[0]);

        try {
            bkr = (JMSBroker)Class.forName(this.JMSBROKER_CLASS).newInstance();
        } catch (IllegalAccessException ex) {
            System.out.println("SJSMQRA_EB:DebugCFN-ExcMsg="+ex.getMessage());
            ex.printStackTrace();
        } catch (ClassNotFoundException ex) {
            System.out.println("SJSMQRA_EB:DebugCFN-ExcMsg="+ex.getMessage());
            ex.printStackTrace();
        } catch (InstantiationException ex) {
            System.out.println("SJSMQRA_EB:DebugCFN-ExcMsg="+ex.getMessage());
            ex.printStackTrace();
        }

        //bp = BrokerProcess.getBrokerProcess(); 
 
        //brokerProps = bp.convertArgs(brokerArgs);
        brokerProps = bkr.parseArgs(brokerArgs);
 
        if (brokerBindAddress != null && !("localhost".equals(brokerBindAddress)) ) {
            brokerProps.setProperty("imq.hostname", brokerBindAddress);
        }

        String key;
        String val;
        //System.out.println("SJSMQRA_EB:DebugENM_BEGIN>>>>>>>>>>>>>>>>");
        for (Enumeration e = sysProps.keys() ; e.hasMoreElements() ;) {
            key = (String)e.nextElement();
            //System.out.println("SJSMQRA_EB:DebugENM_Key="+key);
            if (key != null) {
                val = (String)sysProps.getProperty(key);
                //System.out.println("SJSMQRA_EB:DebugENM_Val="+val);
                brokerProps.setProperty(key, val);
            } else {
                //System.out.println("SJSMQRA_EB:DebugENM_Val=null");
            }
        }

        //System.out.println("SJSMQRA_EB:DebugDump_BEGIN>>>>>>>>>>>>>");
        //System.out.println("SJSMQRA_EB:brokerArgs="+brokerArgs);
        //System.out.println("SJSMQRA_EB:EmbeddedBroker:brokerProps="+brokerProps.toString());
        //System.out.println("SJSMQRA_EB:EmbeddedBroker:SystemProps="+System.getProperties().toString());
        //System.out.println("SJSMQRA_EB:DebugDump___END>>>>>>>>>>>>>");

        //bt = new Thread(this, "SJSMQRA_EmbeddedBrokerRunnerThread");
        //bt.setDaemon(true);
    }

    public synchronized void
    init()
    {
        _loggerL.entering(_className, "init()");
        int code = -1;
        //if (bp != null) {
        if (bkr != null) {
            try {
                //code = bp.init(true, brokerProps, (BrokerNotification)this);
                code = bkr.init(true, brokerProps, (BrokerEventListener)this);
            } catch (IllegalArgumentException iae) {
                _loggerL.severe(_lgrMID_EXC+"run:Broker Init Failure:IllegalArgumentException Message="+iae.getMessage());
            }
            if (code != 0) {
                throw new RuntimeException("EMBEDDED Broker init failure:code = "+code);
            } else {
                _loggerL.info(_lgrMID_INF+"run:EMBEDDED broker initialized with code ="+code);
            }
        }
    }

    public synchronized void
    start()
    {
        _loggerL.entering(_className, "start()");
        _loggerL.config(_lgrMID_INF+"EB-start:brokerProps="+brokerProps.toString());
        int code = -1;
        //if (bp != null) {
        if (bkr != null) {
            try {
                //code = bp.start(true, brokerProps, (BrokerNotification)this);
                code = bkr.start(true, brokerProps, (BrokerEventListener)this);
            } catch (IllegalArgumentException iae) {
                _loggerL.severe(_lgrMID_EXC+"run:Broker Start Failure:IllegalArgumentException Message="+iae.getMessage());
            }
            if (code != 0) {
                throw new RuntimeException("EMBEDDED Broker start failure:code = "+code);
            } else {
                _loggerL.info(_lgrMID_INF+"EMBEDDED broker started with code ="+code);
            }
        }
    }

    protected synchronized void
    stop()
    {
        _loggerL.entering(_className, "stop()");

        //Unkown whether the VM is about to be shutdown
        //So, indicate that the VM is *not* about to be shutdown
        //    thereby making a .start possible within the same VM
        try {
            //bp.stop(true);
            bkr.stop(true);
        } catch (Exception bse) {
            _loggerL.severe(_lgrMID_EXC+"stop:Exception on EMBEDDED broker shutdown:msg="+bse.getMessage());
            bse.printStackTrace();
        }
    }

    //com.sun.messaging.jmq.jmsserver.BrokerNotification interface methods
    /**
    * Broker would like to exit for some reason.
    * @param reason why the broker would like to exit, one of
    *              <UL><LI>REASON_SHUTDOWN</LI>
    *                  <LI>REASON_RESTART</LI>
    *                  <LI>REASON_FATAL</LI>
    *                  <LI>REASON_ERROR</LI>
    *                  <LI>REASON_EXCEPTION</LI>
    *                  <LI>REASON_STOP</LI></UL>
    * @param info string which indicates when the exit was requested
    * @param thr optional Throwable
    * @return true if the broker should clean up and exit and false
    *         if the request to exit was denied (if the request to
    *         shutdown after a fatal error is denied, the broker may not
    *         respond correctly).
    */
    public boolean
    exitRequested(int reason, String info, Throwable thr)
    {
        Object params[] = new Object[3];
        params[0] = new Integer(reason);
        params[1] = info;
        params[2] = thr;

        _loggerL.entering(_className, "exitRequested()", params);
        _loggerL.severe(_lgrMID_INF+"exitRequested:Reason="+reason+":"+info+":"+(thr == null ? "null" : thr.getMessage()));
        return true;
    }

    /**
    * Notification that the broker has shutdown.
    */
    public void
    brokerShutdown()
    {
        _loggerL.entering(_className, "brokerShutdown()");
    }

    /**
    * Notification that the broker has started and is responding to jms requests.
    */
    public void
    brokerStarted()
    {
        _loggerL.entering(_className, "brokerStarted()");
    }

    public JMSService getJMSService(){
        if (jmsservice == null) {
            //jmsservice = (JMSService)com.sun.messaging.jmq.jmsserver.Globals.getServiceManager().getService("jmsdirect");
            jmsservice = bkr.getJMSService();
        }
        return jmsservice;
    }
    
    //BrokerEventListener methods
    public void brokerErrorOccurred(BrokerErrorEvent bErrEvt){
        System.out.println("SJSMQRA_EB:Debug-brokerErrorOccurred");
        Thread.dumpStack();
    }

    public boolean exitRequested (BrokerEvent bEvt, Throwable thr){
        System.out.println("SJSMQRA_EB:Debug-exitRequested");
        Thread.dumpStack();
        return true;
    }

    public void brokerStarted(BrokerEvent bEvt){
        System.out.println("SJSMQRA_EB:Debug-brokerStarted");
        Thread.dumpStack();
    }

    public void brokerShutdown(BrokerEvent bEvt){
        System.out.println("SJSMQRA_EB:Debug-brokerShutdown");
        Thread.dumpStack();
    }
}
