/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)Producer.java	1.29 06/28/07
 */ 

package com.sun.messaging.jmq.jmsserver.core;

import java.util.*;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.service.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;

/**
 *
 */

//XXX - it would be nice to add metrics info
// unfortunately we dont know what producer a message
// comes from at this time
public class Producer {
    
    private static boolean DEBUG=false;

    private transient Logger logger = Globals.getLogger();

    // record information about the last 20 removed
    // producers
    private static CacheHashMap cache = new CacheHashMap(20);

    private boolean valid = true;
    
    private static Map allProducers = Collections.synchronizedMap(
                    new HashMap());

    private ConnectionUID connection_uid;
    
    private DestinationUID destination_uid;
    private ProducerUID uid;
    
    private long creationTime;

    private int pauseCnt = 0;
    private int resumeCnt = 0;
    private int msgCnt = 0;
    transient String creator = null;

    public String toString() {
        return "Producer["+ uid + "," + destination_uid + "," +
               connection_uid + "]";
    }
    
    public static Hashtable getAllDebugState() {
        Hashtable ht = new Hashtable();
        ht.put("TABLE", "AllProducers");
        Vector v = new Vector();
        synchronized (cache) {
            Iterator itr = cache.keySet().iterator();
            while (itr.hasNext()) {
                v.add(String.valueOf(((ProducerUID)itr.next()).longValue()));
            }
            
        }
        ht.put("cache", v);
        HashMap tmp = null;
        synchronized(allProducers) {
            tmp = new HashMap(allProducers);
        }
        Hashtable producers = new Hashtable();
        Iterator itr = tmp.keySet().iterator();
        while(itr.hasNext()) {
            ProducerUID p = (ProducerUID)itr.next();
            Producer producer = (Producer)tmp.get(p);
            producers.put(String.valueOf(p.longValue()),
                  producer.getDebugState());
        }
        ht.put("producersCnt", new Integer(allProducers.size()));
        ht.put("producers", producers);
        return ht;
            
    }

    public synchronized void pause() {
        pauseCnt ++;
    }

    public synchronized void addMsg()
    {
        msgCnt ++;
    }

    public synchronized int getMsgCnt()
    {
        return msgCnt;
    }
    public synchronized boolean isPaused()
    {
        return pauseCnt > resumeCnt;
    }

    public synchronized void resume() { 
        resumeCnt ++;
    }

    public Hashtable getDebugState() {
        Hashtable ht = new Hashtable();
        ht.put("TABLE", "Producer["+uid.longValue()+"]");
        ht.put("uid", String.valueOf(uid.longValue()));
        ht.put("valid", String.valueOf(valid));
        ht.put("pauseCnt", String.valueOf(pauseCnt));
        ht.put("resumeCnt", String.valueOf(resumeCnt));
        if (connection_uid != null)
            ht.put("connectionUID", String.valueOf(connection_uid.longValue()));
        if (destination_uid != null)
            ht.put("destination", destination_uid.toString());
        return ht;
    }

    /** Creates a new instance of Producer */
    private Producer(ConnectionUID cuid, DestinationUID duid) {
        uid = new ProducerUID();
        this.connection_uid = cuid;
        this.destination_uid = duid;
        logger.log(Logger.DEBUG,"Creating new Producer " + uid + " on "
             + duid + " for connection " + cuid);
    }
   
    public ProducerUID getProducerUID() {
        return uid;
    } 

    public ConnectionUID getConnectionUID() {
        return connection_uid;
    }
    public DestinationUID getDestinationUID() {
        return destination_uid;
    }

    public static void clearProducers() {
        cache.clear();
        allProducers.clear();
    }

    public static String checkProducer(ProducerUID uid)
    {
        String str = null;

        synchronized (cache) {
            str = (String)cache.get(uid);
        }
        if (str == null) {
             return " pid " + uid + " not of of last 20 removed";
        }
        return "Producer[" +uid + "]:" + str;
    }

    public static void updateProducerInfo(ProducerUID uid, String str)
    {
        synchronized (cache) {
            cache.put(uid, System.currentTimeMillis() + ":" + str);
        }
    }

    public static Iterator getAllProducers() {
        return (new ArrayList(allProducers.values())).iterator();
    }

    public static int getNumProducers() {
        return (allProducers.size());
    }

    public static Producer getProducer(ProducerUID uid) {
        return (Producer)allProducers.get(uid);
    }

    public static Producer destroyProducer(ProducerUID uid, String info) {
        Producer p = (Producer)allProducers.remove(uid);
        updateProducerInfo(uid, info);
        if (p == null) {
            return p;
        }
        Destination d = Destination.getDestination(p.getDestinationUID());
        if (d != null) {
           d.removeProducer(uid);
        }
        p.destroy();
        return p;
    }

    

    public static Producer createProducer(DestinationUID duid,
              ConnectionUID cuid, String id) 
    {
        Producer producer = new Producer(cuid, duid);
        Object old = allProducers.put(producer.getProducerUID(), producer);
        producer.creator = id;
        assert old == null : old;

        return producer;
    }

    public synchronized void destroy() {
        valid = false;
    }

    public synchronized boolean isValid() {
        return valid;
    }

    public static Producer getProducer(String creator)
    {
        if (creator == null) return null;

        synchronized(allProducers) {
            Iterator itr = allProducers.values().iterator();
            while (itr.hasNext()) {
                Producer c = (Producer)itr.next();
                if (creator.equals(c.creator))
                    return c;
            }
        }
        return null;
    }

}
