/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)DestinationUID.java	1.16 06/28/07
 */ 

package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.Globals;
import java.util.Collections;
import java.util.Map;
import java.util.HashMap;


public class DestinationUID extends StringUID {

    static final long serialVersionUID = 3047167637056417589L;
    
    private static Map topics = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_topics"));
    private static Map queues = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_queues"));

    private boolean isQueue = false;
    private String name = null;

    private static String localQueue = 
          Globals.getBrokerResources().getString(
              BrokerResources.M_QUEUE);

    private static String localTopic =
          Globals.getBrokerResources().getString(
              BrokerResources.M_TOPIC);

    public static void clearCache() {
        queues.clear();
        topics.clear();
    }
        
    protected DestinationUID(String name, boolean queue) {
        super(getUniqueString(name,queue));
        this.name = name;
        this.isQueue = queue;
    }

    public DestinationUID(String str) {
        super(str);
        name = getName(str);
        isQueue = getIsQueue(str);
    }

    public String getDestType() {
        if (isQueue)
            return localQueue;
        return localTopic;
    }

    public String getLocalizedName() {
        return Globals.getBrokerResources().getString(
              BrokerResources.M_DESTINATION, name,
                getDestType());
    }


    private String getName(String str) {
        return str.substring(2);
    }
    private boolean getIsQueue(String str) {
        return str.charAt(0) == 'Q';
    }

    public String getName() {
        return name;
    }

    public boolean isQueue() {
        return isQueue;
    }

    public static DestinationUID getUID(String name, int type) {
        return getUID(name,DestType.isQueue(type));
    }


    public static DestinationUID getUID(String name, boolean isQueue) {
         
        DestinationUID duid = null;

        if (isQueue) {
            duid = (DestinationUID)queues.get(name);
            if (duid == null) {
                duid = new DestinationUID(name, isQueue);
                queues.put(name, duid);
            }
        } else {
            duid = (DestinationUID)topics.get(name);
            if (duid == null) {
                duid = new DestinationUID(name, isQueue);
                topics.put(name, duid);
            }
        }
        return duid;
    }

    public static void clearUID(DestinationUID uid) {
        if (uid.isQueue())
            queues.remove(uid.getName());
        else
            topics.remove(uid.getName());
    }

    public String toString() {
        return super.toString();
   }

    public String getLongString() {
        if (isQueue)
            return "queue:" + name;
        return "topic:" + name;
    }


    
    public static final String getUniqueString(String name, boolean isQueue) {
        StringBuffer buf = new StringBuffer();
        if (isQueue) {
            buf.append("Q:");
        } else {
            buf.append("T:");
        }
        buf.append(name);

        if (buf.indexOf("/") != -1) {
            for (int i=0; i < buf.length(); i ++) {
                char c = buf.charAt(i);
                if (c == '/') {
                   buf.setCharAt(i, '_');
                }
            }
        }
        return buf.toString();
    }

        
}
