/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ClusterDiscoveryService;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.net.MQServerSocketFactory;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PortMapper
implements Runnable,
ConfigListener {
    public static final int PORTMAPPER_DEFAULT_PORT = 7676;
    private static final String HOSTNAME_PROPERTY = "imq.portmapper.hostname";
    private static final String IMQHOSTNAME_PROPERTY = "imq.hostname";
    private static final String PORT_PROPERTY = "imq.portmapper.port";
    private static final String BACKLOG_PROPERTY = "imq.portmapper.backlog";
    private static final String SOTIMEOUT_PROPERTY = "imq.portmapper.sotimeout";
    private static final String SOLINGER_PROPERTY = "imq.portmapper.solinger";
    static final String SERVICE_NAME = "portmapper";
    private static boolean DEBUG = false;
    private Logger logger = null;
    private BrokerResources rb = null;
    private BrokerConfig bc = Globals.getConfig();
    private PortMapperTable portMapTable = null;
    private ServerSocket serverSocket = null;
    private int port = 0;
    private int backlog = 100;
    private int sotimeout = 100;
    private int solinger = -1;
    private InetAddress bindAddr = null;
    private String hostname = null;
    private HashMap portmapperMap = null;
    private boolean running = true;
    private static MQServerSocketFactory ssf = (MQServerSocketFactory)MQServerSocketFactory.getDefault();

    public void updateProperties() {
        this.portmapperMap = new HashMap();
        if (Globals.getBrokerID() != null) {
            this.portmapperMap.put("brokerid", Globals.getBrokerID());
        }
        if (Globals.getBrokerSessionID() != null) {
            this.portmapperMap.put("sessionid", Globals.getBrokerSessionID().toString());
            String string = Globals.getConfig().getProperty("imq.home");
            if (string != null && !string.equals("")) {
                this.portmapperMap.put("imqhome", string);
            }
            if ((string = Globals.getConfig().getProperty("imq.varhome")) != null && !string.equals("")) {
                this.portmapperMap.put("imqvarhome", string);
            }
        }
        this.updateServiceProperties(SERVICE_NAME, this.portmapperMap);
    }

    public PortMapper(String string) {
        if (!this.bc.getBooleanProperty("imq.portmapper.reuseAddress", true)) {
            ssf.setReuseAddress(false);
        }
        this.portMapTable = new PortMapperTable();
        this.portMapTable.setBrokerInstanceName(string);
        this.portMapTable.setBrokerVersion(Globals.getVersion().getProductVersion());
        this.logger = Globals.getLogger();
        this.rb = Globals.getBrokerResources();
        this.addService(SERVICE_NAME, "tcp", "PORTMAPPER", this.port, this.portmapperMap);
        ClusterDiscoveryService clusterDiscoveryService = Globals.getClusterDiscoveryService();
        if (clusterDiscoveryService != null) {
            clusterDiscoveryService.addService(SERVICE_NAME, "tcp", "PORTMAPPER", this.port, null);
        }
        this.bc.addListener(PORT_PROPERTY, this);
        this.bc.addListener(BACKLOG_PROPERTY, this);
    }

    public void destroy() {
        this.running = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            this.logger.logStack(8, "Error closing portmapper", iOException);
        }
        this.serverSocket = null;
    }

    public void setParameters(Properties properties) throws PropertyUpdateException {
        String string = properties.getProperty(HOSTNAME_PROPERTY);
        if (string == null || string.trim().length() == 0) {
            string = properties.getProperty(IMQHOSTNAME_PROPERTY);
        }
        this.validate(HOSTNAME_PROPERTY, string);
        this.update(HOSTNAME_PROPERTY, string);
        string = properties.getProperty(PORT_PROPERTY);
        this.validate(PORT_PROPERTY, string);
        this.update(PORT_PROPERTY, string);
        string = properties.getProperty(BACKLOG_PROPERTY);
        this.validate(BACKLOG_PROPERTY, string);
        this.update(BACKLOG_PROPERTY, string);
        string = properties.getProperty(SOTIMEOUT_PROPERTY);
        if (string != null) {
            this.validate(SOTIMEOUT_PROPERTY, string);
            this.update(SOTIMEOUT_PROPERTY, string);
        }
        if ((string = properties.getProperty(SOLINGER_PROPERTY)) != null) {
            this.validate(SOLINGER_PROPERTY, string);
            this.update(SOLINGER_PROPERTY, string);
        }
    }

    public synchronized void setPort(int n) {
        if (n == this.port) {
            return;
        }
        this.port = n;
        this.addService(SERVICE_NAME, "tcp", "PORTMAPPER", n, this.portmapperMap);
        ClusterDiscoveryService clusterDiscoveryService = Globals.getClusterDiscoveryService();
        if (clusterDiscoveryService != null) {
            clusterDiscoveryService.addService(SERVICE_NAME, "tcp", "PORTMAPPER", n, null);
        }
        LockFile lockFile = LockFile.getCurrentLockFile();
        try {
            if (lockFile != null) {
                lockFile.updatePort(n);
            }
        }
        catch (IOException iOException) {
            this.logger.log(16, "B3088", iOException);
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public synchronized void setHostname(String string) throws PropertyUpdateException {
        if (string == null || string.equals("*") || string.trim().length() == 0) {
            this.hostname = null;
            this.bindAddr = null;
            return;
        }
        if (string.equals(this.hostname)) {
            return;
        }
        try {
            this.bindAddr = InetAddress.getByName(string);
        }
        catch (Exception exception) {
            throw new PropertyUpdateException(2, this.rb.getString("B3150", string), exception);
        }
        this.hostname = string;
        LockFile lockFile = LockFile.getCurrentLockFile();
        try {
            if (lockFile != null) {
                lockFile.updateHostname(string);
            }
        }
        catch (IOException iOException) {
            this.logger.log(16, "B3088", iOException);
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public synchronized void setBacklog(int n) {
        this.backlog = n;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void addService(String string, String string2, String string3, int n, HashMap hashMap) {
        PortMapperEntry portMapperEntry = new PortMapperEntry();
        portMapperEntry.setName(string);
        portMapperEntry.setProtocol(string2);
        portMapperEntry.setType(string3);
        portMapperEntry.setPort(n);
        if (hashMap != null) {
            portMapperEntry.addProperties(hashMap);
        }
        this.portMapTable.add(portMapperEntry);
    }

    public synchronized void updateServicePort(String string, int n) {
        PortMapperEntry portMapperEntry = this.portMapTable.get(string);
        if (portMapperEntry != null) {
            portMapperEntry.setPort(n);
        }
    }

    public synchronized void updateServiceProperties(String string, HashMap hashMap) {
        PortMapperEntry portMapperEntry = this.portMapTable.get(string);
        if (portMapperEntry != null) {
            portMapperEntry.addProperties(hashMap);
        }
    }

    public synchronized void addService(String string, PortMapperEntry portMapperEntry) {
        this.portMapTable.add(portMapperEntry);
    }

    public synchronized void removeService(String string) {
        this.portMapTable.remove(string);
    }

    public synchronized Map getServices() {
        return this.portMapTable.getServices();
    }

    public synchronized String toString() {
        return this.portMapTable.toString();
    }

    public synchronized int bind() {
        this.serverSocket = this.createPortMapperServerSocket(this.port, this.bindAddr);
        if (this.serverSocket == null) {
            return -1;
        }
        return this.port;
    }

    public synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private ServerSocket createPortMapperServerSocket(int n, InetAddress inetAddress) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = ssf.createServerSocket(n, this.backlog, inetAddress);
        }
        catch (BindException bindException) {
            this.logger.log(32, "B3068", (Object)SERVICE_NAME, new Integer(n));
            return null;
        }
        catch (IOException iOException) {
            this.logger.log(32, "B3022", SERVICE_NAME, new Integer(n), iOException);
            return null;
        }
        Object[] objectArray = new Object[]{SERVICE_NAME, "tcp [ " + n + ", " + this.backlog + ", " + (inetAddress != null ? inetAddress.getHostAddress() : "*") + " ]", new Integer(1), new Integer(1)};
        this.logger.log(8, "B1004", objectArray);
        return serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        var1_1 = BrokerStateHandler.getRestartCode();
        var2_2 = this.rb.getKString("B0081");
        var3_3 = this.rb.getKString("B0080");
        var4_4 = this.rb.getKString("B0079");
        var5_5 = null;
        var6_6 = false;
        try {
            if (this.serverSocket == null) {
                this.serverSocket = this.createPortMapperServerSocket(this.port, this.bindAddr);
            }
            if (PortMapper.DEBUG && this.serverSocket != null) {
                this.logger.log(4, "PortMapper: " + this.serverSocket + " " + MQServerSocketFactory.serverSocketToString(this.serverSocket) + ", backlog=" + this.backlog + "");
            }
            var7_7 = true;
            while (this.running) {
                block83: {
                    if (this.serverSocket != null) break block83;
                    this.logger.log(32, "B3070");
                    var17_29 = null;
                    ** GOTO lbl168
                }
                try {
                    var5_5 = this.serverSocket.accept();
                    var7_7 = true;
                }
                catch (SocketException var8_10) {
                    block85: {
                        block84: {
                            if (var8_10 instanceof BindException || var8_10 instanceof ConnectException) break block84;
                            if (!(var8_10 instanceof NoRouteToHostException)) break block85;
                        }
                        this.logger.log(32, "B3069", var8_10);
                        PortMapper.sleep(1);
                        continue;
                    }
                    if (!this.running) ** GOTO lbl189
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException var9_20) {
                    }
                    catch (NullPointerException var9_21) {
                        if (!this.running) ** GOTO lbl189
                    }
                    this.serverSocket = this.createPortMapperServerSocket(this.port, this.bindAddr);
                    continue;
                    {
                    }
                }
                catch (IOException var8_11) {
                    this.logger.logStack(32, "B3069", var8_11);
                    PortMapper.sleep(1);
                    continue;
                }
                catch (OutOfMemoryError var8_12) {
                    if (this.running) {
                        if (var7_7) {
                            var7_7 = false;
                            Globals.handleGlobalError(var8_12, var4_4);
                            PortMapper.sleep(1);
                            continue;
                        }
                        Broker.getBroker().exit(var1_1, var2_2, 1, null, false, false, true);
                        var17_30 = null;
                        try {
                            try {
                                if (var5_5 != null) {
                                    var5_5.close();
                                }
                                if (this.serverSocket != null) {
                                    this.serverSocket.close();
                                }
                            }
                            catch (IOException var18_35) {
                                // empty catch block
                            }
                            if (var6_6 && this.running) {
                                this.logger.log(32, var2_2);
                                Broker.getBroker().exit(var1_1, var2_2, 1, null, false, false, true);
                            }
                            if (this.running == false) return;
                            this.logger.log(8, "B0082");
                            return;
                        }
                        catch (OutOfMemoryError var18_36) {
                            if (this.running == false) return;
                            Broker.getBroker().exit(var1_1, var2_2, 1, null, false, false, true);
                        }
                        return;
                    }
                    ** GOTO lbl189
                }
                if (!var5_5.isConnected()) {
                    this.logger.log(4, "PortMapper: accepted client connection (" + var5_5.toString() + ") that is" + " no longer connected. Ignoring.");
                    try {
                        var5_5.close();
                    }
                    catch (IOException var8_13) {}
                    continue;
                }
                try {
                    var8_9 = this;
                    synchronized (var8_9) {
                        var5_5.setSoTimeout(this.sotimeout);
                        if (this.solinger > 0) {
                            var5_5.setSoLinger(true, this.solinger);
                        }
                        var9_19 = var5_5.getInputStream();
                        var10_24 = new BufferedReader(new InputStreamReader((InputStream)var9_19));
                        var11_25 = "101";
                        try {
                            var11_25 = var10_24.readLine();
                        }
                        catch (SocketTimeoutException var12_26) {
                            // empty catch block
                        }
                        this.portMapTable.write(var5_5.getOutputStream());
                        try {
                            var12_27 = 0;
                            while (var10_24.readLine() != null && ++var12_27 < 5) {
                            }
                        }
                        catch (SocketTimeoutException var12_28) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException var8_15) {
                    var9_19 = var5_5.getInetAddress();
                    this.logger.logStack(16, "B3164", var9_19.getHostAddress(), (Throwable)var8_15);
                }
                catch (OutOfMemoryError var8_17) {
                    if (this.running) {
                        this.logger.log(16, var3_3);
                        try {
                            var5_5.close();
                        }
                        catch (Throwable var9_23) {
                            // empty catch block
                        }
                        Globals.handleGlobalError(var8_17, var3_3);
                        PortMapper.sleep(1);
                        continue;
                    }
                    ** GOTO lbl189
                }
                finally {
                    try {
                        var5_5.close();
                    }
                    catch (IOException var8_16) {}
                }
            }
            ** GOTO lbl189
        }
        catch (OutOfMemoryError var7_8) {
            var6_6 = true;
            throw var7_8;
        }
        {
            block88: {
                block87: {
                    catch (Throwable var16_43) {
                        block86: {
                            var17_32 = null;
                            ** try [egrp 18[TRYBLOCK] [31 : 744->834)] { 
lbl148:
                            // 1 sources

                            ** try [egrp 19[TRYBLOCK] [30 : 744->771)] { 
lbl149:
                            // 1 sources

                            if (var5_5 != null) {
                                var5_5.close();
                            }
                            if (this.serverSocket != null) {
                                this.serverSocket.close();
                            }
                            break block86;
lbl154:
                            // 1 sources

                            catch (IOException var18_39) {
                                // empty catch block
                            }
                        }
                        if (var6_6 && this.running) {
                            this.logger.log(32, var2_2);
                            Broker.getBroker().exit(var1_1, var2_2, 1, null, false, false, true);
                        }
                        if (this.running == false) throw var16_43;
                        this.logger.log(8, "B0082");
                        throw var16_43;
lbl164:
                        // 1 sources

                        catch (OutOfMemoryError var18_40) {
                            if (this.running == false) throw var16_43;
                            Broker.getBroker().exit(var1_1, var2_2, 1, null, false, false, true);
                        }
                        throw var16_43;
                    }
lbl168:
                    // 1 sources

                    ** try [egrp 18[TRYBLOCK] [31 : 744->834)] { 
lbl169:
                    // 1 sources

                    ** try [egrp 19[TRYBLOCK] [30 : 744->771)] { 
lbl170:
                    // 1 sources

                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                    break block87;
lbl175:
                    // 1 sources

                    catch (IOException var18_33) {
                        // empty catch block
                    }
                }
                if (var6_6 && this.running) {
                    this.logger.log(32, var2_2);
                    Broker.getBroker().exit(var1_1, var2_2, 1, null, false, false, true);
                }
                if (this.running == false) return;
                this.logger.log(8, "B0082");
                return;
lbl185:
                // 1 sources

                catch (OutOfMemoryError var18_34) {
                    if (this.running == false) return;
                    Broker.getBroker().exit(var1_1, var2_2, 1, null, false, false, true);
                }
                return;
lbl189:
                // 5 sources

                var17_31 = null;
                try {}
                catch (OutOfMemoryError var18_38) {}
                if (this.running == false) return;
                Broker.getBroker().exit(var1_1, var2_2, 1, null, false, false, true);
                return;
                ** try [egrp 19[TRYBLOCK] [30 : 744->771)] { 
lbl196:
                // 1 sources

                if (var5_5 != null) {
                    var5_5.close();
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
                break block88;
lbl201:
                // 1 sources

                catch (IOException var18_37) {
                    // empty catch block
                }
            }
            if (var6_6 && this.running) {
                this.logger.log(32, var2_2);
                Broker.getBroker().exit(var1_1, var2_2, 1, null, false, false, true);
            }
            if (this.running == false) return;
            this.logger.log(8, "B0082");
            return;
        }
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (!(string.equals(PORT_PROPERTY) || string.equals(BACKLOG_PROPERTY) || string.equals(SOLINGER_PROPERTY) || string.equals(HOSTNAME_PROPERTY) || string.equals(SOTIMEOUT_PROPERTY))) {
            throw new PropertyUpdateException(this.rb.getString("B4028", string));
        }
        if (string.equals(HOSTNAME_PROPERTY)) {
            if (string2 == null || string2.trim().length() == 0 || string2.equals("*")) {
                return;
            }
            try {
                InetAddress.getByName(string2);
            }
            catch (Exception exception) {
                throw new PropertyUpdateException(2, this.rb.getString("B3151", string2, string), exception);
            }
            return;
        }
        int n = this.getIntProperty(string, string2);
        if (string.equals(PORT_PROPERTY)) {
            if (n == this.port) {
                return;
            }
            try {
                PortMapper.canBind(n, this.bindAddr);
            }
            catch (BindException bindException) {
                throw new PropertyUpdateException(this.rb.getString("B3068", SERVICE_NAME, string2));
            }
            catch (IOException iOException) {
                throw new PropertyUpdateException(this.rb.getString("B3022", SERVICE_NAME, string2) + iOException.toString());
            }
        }
    }

    public boolean update(String string, String string2) {
        try {
            if (string.equals(PORT_PROPERTY)) {
                this.setPort(this.getIntProperty(string, string2));
            } else if (string.equals(BACKLOG_PROPERTY)) {
                this.setBacklog(this.getIntProperty(string, string2));
            } else if (string.equals(SOTIMEOUT_PROPERTY)) {
                this.sotimeout = this.getIntProperty(string, string2);
            } else if (string.equals(SOLINGER_PROPERTY)) {
                this.solinger = this.getIntProperty(string, string2);
            } else {
                this.setHostname(string2);
            }
        }
        catch (PropertyUpdateException propertyUpdateException) {
            this.logger.log(32, this.rb.getString("B4027", string + "=" + string2), propertyUpdateException);
            return false;
        }
        return true;
    }

    public int getIntProperty(String string, String string2) throws PropertyUpdateException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyUpdateException(this.rb.getString("B4027", string + "=" + string2));
        }
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void canBind(int n, InetAddress inetAddress) throws IOException {
        ServerSocket serverSocket = null;
        serverSocket = ssf.createServerSocket(n, 0, inetAddress);
        serverSocket.close();
    }

    public static String getBrokerAtPort(String string, int n) throws IOException {
        InetAddress inetAddress = null;
        inetAddress = string == null ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        String string2 = String.valueOf(101) + "\n";
        Socket socket = new Socket(inetAddress, n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            outputStream.write(string2.getBytes());
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PortMapperTable portMapperTable = new PortMapperTable();
        portMapperTable.read(inputStream);
        return portMapperTable.getBrokerInstanceName();
    }
}

