/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class DBConnectionPool
implements DBConstants {
    public static final String REAP_INTERVAL_PROP = "imq.persist.jdbc.connection.reaptime";
    public static final int DEFAULT_REAP_INTERVAL = 300;
    public static final String NUM_CONN_PROP = "imq.persist.jdbc.connection.limit";
    public static final String MIN_CONN_PROP = "imq.persist.jdbc.min_connections";
    public static final String MAX_CONN_PROP = "imq.persist.jdbc.max_connections";
    static final int DEFAULT_NUM_CONN = 5;
    private static int minConnections;
    private static int maxConnections;
    private static boolean initialized;
    private static ReentrantLock lock;
    private static Condition notEmpty;
    private static LinkedList idleConnections;
    private static HashMap activeConnections;
    private static ConnectionReaperTask connectionReaper;
    private static long reapInterval;
    private static DBManager dbmgr;
    private static Logger logger;
    private static BrokerResources br;
    private static ConfigListener cfgListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(DBManager dBManager) throws BrokerException {
        if (!initialized) {
            lock.lock();
            try {
                int n;
                if (initialized) {
                    return;
                }
                dbmgr = dBManager;
                int n2 = Globals.getConfig().getIntProperty(NUM_CONN_PROP, 5);
                if (n2 < 1) {
                    n2 = 5;
                    logger.log(16, "Invalid number of connections specified, set to default of " + n2);
                }
                if ((minConnections = Globals.getConfig().getIntProperty(MIN_CONN_PROP, n2)) < 1) {
                    minConnections = n2;
                    logger.log(16, "Invalid number of minimum connections specified, set to default of " + minConnections);
                }
                if ((maxConnections = Globals.getConfig().getIntProperty(MAX_CONN_PROP, n2)) < minConnections) {
                    maxConnections = minConnections;
                    logger.log(16, "Invalid number of maximum connections specified, set to default of " + maxConnections);
                }
                if ((n = Globals.getConfig().getIntProperty(REAP_INTERVAL_PROP, 300)) < 60) {
                    n = 300;
                    logger.log(16, "Invalid reap time interval for pool maintenance thread specified, set to default of " + n);
                }
                reapInterval = n * 1000;
                if (dbmgr.getCreateDBURL() != null && Globals.getConfig().getBooleanProperty("imq.persist.storecreate.all", false)) {
                    try {
                        Connection connection = dbmgr.connectToCreate();
                        connection.close();
                    }
                    catch (Exception exception) {
                        String string = dbmgr.getCreateDBURL();
                        logger.log(32, "B3073", (Object)string, (Throwable)exception);
                        throw new BrokerException(br.getString("B3073", string, exception));
                    }
                }
                for (int i = 0; i < minConnections; ++i) {
                    Connection connection = dbmgr.newConnection(true);
                    idleConnections.add(connection);
                }
                Globals.getConfig().addListener(MIN_CONN_PROP, cfgListener);
                Globals.getConfig().addListener(MAX_CONN_PROP, cfgListener);
                Globals.getConfig().addListener(REAP_INTERVAL_PROP, cfgListener);
                if (maxConnections > minConnections) {
                    if (connectionReaper != null) {
                        connectionReaper.cancel();
                    }
                    connectionReaper = new ConnectionReaperTask();
                    Globals.getTimer().schedule((TimerTask)connectionReaper, reapInterval, reapInterval);
                }
                initialized = true;
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        if (!initialized) {
            return;
        }
        lock.lock();
        try {
            if (connectionReaper != null) {
                connectionReaper.cancel();
                connectionReaper = null;
            }
            Globals.getConfig().removeListener(MIN_CONN_PROP, cfgListener);
            Globals.getConfig().removeListener(MAX_CONN_PROP, cfgListener);
            Globals.getConfig().removeListener(REAP_INTERVAL_PROP, cfgListener);
            for (Connection connection : idleConnections) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    logger.log(16, "B4103", sQLException);
                }
            }
            idleConnections.clear();
            initialized = false;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getConnection() throws BrokerException {
        lock.lock();
        try {
            Object object;
            Object object2;
            boolean bl;
            boolean bl2 = bl = maxConnections - idleConnections.size() - activeConnections.size() > 0;
            if (idleConnections.isEmpty() && bl) {
                object2 = dbmgr.newConnection(true);
            } else {
                boolean bl3;
                while (idleConnections.isEmpty()) {
                    try {
                        bl3 = notEmpty.await(300L, TimeUnit.SECONDS);
                        if (bl3) continue;
                        object = new StringBuffer(1024);
                        for (Map.Entry entry : activeConnections.entrySet()) {
                            Thread thread = (Thread)entry.getValue();
                            ((StringBuffer)object).append("\n").append(thread.getName()).append(": using connection: ").append(entry.getKey());
                            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                                ((StringBuffer)object).append("\n\tat " + stackTraceElementArray[i]);
                            }
                        }
                        logger.log(8, "Unable to obtain database connection after waiting for 300 secs [pool size: min=" + minConnections + ", max=" + maxConnections + "]: stack trace of connection pool:" + ((StringBuffer)object).toString());
                    }
                    catch (Exception exception) {
                        logger.log(4, "DBConnectionPool.getConnection(): " + exception);
                    }
                }
                object2 = (Connection)idleConnections.removeFirst();
                bl3 = false;
                try {
                    bl3 = object2.isClosed();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (bl3) {
                    try {
                        object2 = object = dbmgr.newConnection(true);
                        logger.log(8, br.getString("B1149", dbmgr.getOpenDBURL()));
                    }
                    catch (BrokerException brokerException) {
                        logger.log(32, br.getString("B4206", dbmgr.getOpenDBURL()), brokerException);
                        idleConnections.add(object2);
                        throw brokerException;
                    }
                }
            }
            Thread thread = Thread.currentThread();
            activeConnections.put(object2, thread);
            if (Store.getDEBUG()) {
                logger.log(4, "DBConnectionPool.getConnection(): " + thread.getName() + " [" + new Date() + "]: check out connection: " + object2);
            }
            object = object2;
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void freeConnection(Connection connection) {
        if (Store.getDEBUG()) {
            logger.log(4, "DBConnectionPool.freeConnection(): check in connection: " + connection);
        }
        lock.lock();
        try {
            if (activeConnections.remove(connection) == null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    logger.logStack(16, Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException), sQLException);
                }
            } else {
                idleConnections.add(connection);
                notEmpty.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reapExcessConnection() {
        lock.lock();
        try {
            if (Store.getDEBUG()) {
                logger.log(4, "DBConnectionPool.reapExcessConnection(): pool size: min=" + minConnections + ", max=" + maxConnections + ", active=" + activeConnections.size() + ", idle=" + idleConnections.size());
            }
            while (activeConnections.size() + idleConnections.size() > minConnections) {
                try {
                    int n = lock.getQueueLength() + lock.getWaitQueueLength(notEmpty);
                    if (n > idleConnections.size()) {
                        break;
                    }
                    Connection connection = (Connection)idleConnections.removeFirst();
                    connection.close();
                }
                catch (SQLException sQLException) {
                    logger.logStack(16, Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException), sQLException);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    static boolean validate(Connection connection) {
        try {
            connection.getMetaData();
        }
        catch (Exception exception) {
            logger.log(4, "DBConnectionPool.validate(): Lost database connection to " + dbmgr.getOpenDBURL(), exception);
            return false;
        }
        return true;
    }

    static boolean handleException(Connection connection, Throwable throwable) {
        if (DBConnectionPool.validate(connection)) {
            logger.log(4, "connection is good; return false (no need to retry)");
            return false;
        }
        return true;
    }

    static {
        initialized = false;
        lock = new ReentrantLock();
        notEmpty = lock.newCondition();
        idleConnections = new LinkedList();
        activeConnections = new HashMap();
        connectionReaper = null;
        dbmgr = null;
        logger = Globals.getLogger();
        br = Globals.getBrokerResources();
        cfgListener = new ConfigListener(){

            public void validate(String string, String string2) throws PropertyUpdateException {
                if (string.equals(DBConnectionPool.MIN_CONN_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < 1) {
                        throw new PropertyUpdateException(2, "A minimum value of 1 connection is required");
                    }
                    if (n > maxConnections) {
                        throw new PropertyUpdateException(2, "Minimum connections " + n + " is greater than maximum connections " + maxConnections);
                    }
                } else if (string.equals(DBConnectionPool.MAX_CONN_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < minConnections) {
                        throw new PropertyUpdateException(2, "Maximum connections " + n + " is less than minimum connections " + minConnections);
                    }
                } else if (string.equals(DBConnectionPool.REAP_INTERVAL_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < 60) {
                        throw new PropertyUpdateException(2, "A minimum value of 60 seconds is required for reap time interval");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean update(String string, String string2) {
                BrokerConfig brokerConfig = Globals.getConfig();
                lock.lock();
                try {
                    if (string.equals(DBConnectionPool.MAX_CONN_PROP)) {
                        maxConnections = brokerConfig.getIntProperty(DBConnectionPool.MAX_CONN_PROP);
                    } else if (string.equals(DBConnectionPool.MIN_CONN_PROP)) {
                        minConnections = brokerConfig.getIntProperty(DBConnectionPool.MIN_CONN_PROP);
                    } else if (string.equals(DBConnectionPool.REAP_INTERVAL_PROP)) {
                        reapInterval = brokerConfig.getIntProperty(DBConnectionPool.REAP_INTERVAL_PROP) * 1000;
                    }
                }
                finally {
                    lock.unlock();
                }
                if (maxConnections > minConnections) {
                    if (connectionReaper != null) {
                        connectionReaper.cancel();
                    }
                    connectionReaper = new ConnectionReaperTask();
                    Globals.getTimer().schedule((TimerTask)connectionReaper, reapInterval, reapInterval);
                }
                return true;
            }
        };
    }

    static class ConnectionReaperTask
    extends TimerTask {
        private volatile boolean canceled = false;

        ConnectionReaperTask() {
        }

        public boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        public void run() {
            if (this.canceled) {
                return;
            }
            try {
                DBConnectionPool.reapExcessConnection();
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(32, "B3177", exception);
            }
        }
    }
}

