/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.GlobalProperties;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.BrokerDownException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.UID;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class TransactionHandler
extends PacketHandler {
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG;
    private TransactionList translist = null;
    FaultInjection fi = FaultInjection.getInjection();

    public TransactionHandler(TransactionList transactionList) {
        this.translist = transactionList;
    }

    public TransactionList getTransactionList() {
        return this.translist;
    }

    public void sendReply(IMQConnection iMQConnection, Packet packet, int n, int n2, long l, String string) {
        this.sendReply(iMQConnection, packet, n, n2, l, string, null);
    }

    public void sendReply(IMQConnection iMQConnection, Packet packet, int n, int n2, long l, String string, BrokerException brokerException) {
        if (FaultInjection.FAULT_INJECTION) {
            this.checkFIAfterProcess(packet.getPacketType());
        }
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(n);
        packet2.setConsumerID(packet.getConsumerID());
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQStatus", new Integer(n2));
        if (string != null) {
            hashtable.put("JMQReason", string);
        }
        if (l != 0L) {
            hashtable.put("JMQTransactionID", new Long(l));
        }
        if (brokerException != null && brokerException.isRemote()) {
            hashtable.put("JMQRemote", true);
            if (brokerException.getRemoteConsumerUIDs() != null) {
                hashtable.put("JMQRemoteConsumerIDs", brokerException.getRemoteConsumerUIDs());
            }
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        if (FaultInjection.FAULT_INJECTION) {
            this.checkFIAfterReply(packet.getPacketType());
        }
    }

    public void sendReplyBody(IMQConnection iMQConnection, Packet packet, int n, int n2, Hashtable hashtable, byte[] byArray) {
        Packet packet2;
        block6: {
            block5: {
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setPacketType(n);
                packet2.setConsumerID(packet.getConsumerID());
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Integer>();
                }
                hashtable.put("JMQStatus", new Integer(n2));
                IMQIPConnection cfr_ignored_0 = (IMQIPConnection)iMQConnection;
                if (IMQIPConnection.getDumpPacket()) break block5;
                IMQIPConnection cfr_ignored_1 = (IMQIPConnection)iMQConnection;
                if (!IMQIPConnection.getDumpOutPacket()) break block6;
            }
            hashtable.put("JMQReqID", (Integer)((Object)packet.getSysMessageID().toString()));
        }
        packet2.setProperties(hashtable);
        if (byArray != null) {
            packet2.setMessageBody(byArray);
        }
        iMQConnection.sendControlMessage(packet2);
    }

    public long getJMQTransactionID(Hashtable hashtable) {
        if (hashtable != null) {
            Object v = hashtable.get("JMQTransactionID");
            if (v != null && v instanceof Integer) {
                return ((Integer)v).intValue();
            }
            if (v != null) {
                return (Long)v;
            }
        }
        return 0L;
    }

    public static void convertPacketTid(IMQConnection iMQConnection, Packet packet) {
        long l = packet.getTransactionID();
        HashMap hashMap = (HashMap)iMQConnection.getClientData("tidmap");
        if (hashMap == null) {
            return;
        }
        TransactionUID transactionUID = (TransactionUID)hashMap.get(new Long(l));
        if (transactionUID == null) {
            return;
        }
        packet.setTransactionID(transactionUID.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean handle(IMQConnection var1_1, Packet var2_2) throws BrokerException {
        block76: {
            block77: {
                block75: {
                    var3_3 = 0L;
                    var5_4 = null;
                    var6_5 = null;
                    var7_6 = null;
                    var8_7 = null;
                    var9_8 = false;
                    var10_9 = true;
                    var11_10 = var2_2.getIndempontent();
                    var12_11 = false;
                    var13_12 = false;
                    var14_13 = null;
                    var15_14 = null;
                    var16_15 = null;
                    try {
                        var15_14 = var2_2.getProperties();
                        if (var15_14 == null) {
                            var15_14 = new Hashtable<K, V>();
                        }
                    }
                    catch (Exception var17_16) {
                        this.logger.log(8, "Internal Error: unable to retrieve  properties from transaction message " + var2_2, var17_16);
                        var15_14 = new Hashtable<K, V>();
                    }
                    var17_17 = (Boolean)var15_14.get("JMQRedeliver");
                    var9_8 = var17_17 == null ? false : var17_17;
                    var18_18 = (Boolean)var15_14.get("JMQSetRedelivered");
                    var10_9 = var18_18 == null ? true : var18_18;
                    var14_13 = (Boolean)var15_14.get("JMQXAOnePhase");
                    v0 = var13_12 = var14_13 == null ? false : var14_13;
                    if (TransactionHandler.DEBUG) {
                        this.logger.log(4, PacketType.getString(var2_2.getPacketType()) + ": " + "TUID=" + var5_4 + ", JMQRedeliver=" + var17_17 + (var14_13 == null ? "" : ", JMQXAOnePhase=" + var13_12));
                    }
                    if ((var19_19 = (ArrayList<E>)var1_1.getClientData("transaction")) == null) {
                        var19_19 = new ArrayList<E>();
                        var1_1.addClientData("transaction", var19_19);
                    }
                    if ((var20_20 = var2_2.getMessageBody()) != null) {
                        var21_21 = new JMQByteBufferInputStream(var20_20);
                        try {
                            var7_6 = JMQXid.read(new DataInputStream((InputStream)var21_21));
                        }
                        catch (IOException var22_22) {
                            this.logger.log(32, "B3100", "Could not decode xid from packet: " + var22_22 + " Ignoring " + PacketType.getString(var2_2.getPacketType()));
                            var16_15 = var22_22.getMessage();
                            this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 400, 0L, var16_15);
                            return true;
                        }
                    }
                    if (var15_14 != null) {
                        var8_7 = (Integer)var15_14.get("JMQXAFlags");
                    }
                    var21_21 = null;
                    var22_23 = var1_1;
                    synchronized (var22_23) {
                        var21_21 = (HashMap)var1_1.getClientData("tidmap");
                        if (var21_21 == null) {
                            var21_21 = new HashMap<K, V>();
                            var1_1.addClientData("tidmap", var21_21);
                        }
                    }
                    var3_3 = this.getJMQTransactionID(var15_14);
                    if (FaultInjection.FAULT_INJECTION) {
                        this.checkFIBeforeProcess(var2_2.getPacketType());
                    }
                    if (var2_2.getPacketType() != 44 || var8_7 != null && !TransactionState.isFlagSet(0, var8_7)) break block75;
                    if (var11_10) {
                        var5_4 = this.translist.getTransaction(var2_2.getSysMessageID().toString());
                        if (var5_4 != null) {
                            var12_11 = true;
                        } else {
                            var5_4 = new TransactionUID();
                        }
                    } else {
                        var5_4 = new TransactionUID();
                    }
                    break block76;
                }
                if (var2_2.getPacketType() != 60) break block77;
                if (var3_3 != 0L) {
                    var5_4 = new TransactionUID(var3_3);
                }
                var7_6 = null;
                break block76;
            }
            if (var3_3 != 0L || var7_6 == null) ** GOTO lbl87
            var5_4 = this.translist.xidToUID(var7_6);
            if (var5_4 != null) {
                var3_3 = var5_4.longValue();
            } else {
                this.logger.log(16, PacketType.getString(var2_2.getPacketType()) + ": Ignoring unknown XID=" + var7_6 + " broker will " + (var2_2.getSendAcknowledge() != false ? "notify the client" : " not notify the client"));
                if (var2_2.getSendAcknowledge()) {
                    var16_15 = "Uknown XID " + var7_6;
                    this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 404, 0L, var16_15);
                }
                return true;
lbl87:
                // 1 sources

                if (var3_3 != 0L) {
                    if (var1_1.getClientProtocolVersion() == 100) {
                        var22_23 = var21_21;
                        synchronized (var22_23) {
                            var5_4 = (TransactionUID)var21_21.get(new Long(var3_3));
                        }
                    } else {
                        var5_4 = new TransactionUID(var3_3);
                    }
                }
            }
            if (var5_4 == null) {
                this.logger.log(8, "InternalError: Transaction ID was not passed by the jms api on a method that reqires an existing transaction ");
                this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 500, 0L, "Internal Error: bad MQ protocol, missing TransactionID");
                return true;
            }
            var6_5 = this.translist.retrieveState(var5_4);
            if (var6_5 == null) {
                if (var11_10 && (var2_2.getPacketType() == 48 || var2_2.getPacketType() == 46)) {
                    if (var2_2.getSendAcknowledge()) {
                        this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 200, var5_4.longValue(), var16_15);
                        return true;
                    }
                    if (FaultInjection.FAULT_INJECTION) {
                        this.checkFIAfterProcess(var2_2.getPacketType());
                        this.checkFIAfterReply(var2_2.getPacketType());
                    }
                } else {
                    var6_5 = this.cacheGetState(var5_4, var1_1);
                    if (var6_5 != null) {
                        this.logger.log(32, "Transaction ID " + var5_4 + " has already been resolved. Ignoring request: " + PacketType.getString(var2_2.getPacketType()) + ". Last state of this transaction: " + var6_5.toString() + " broker will " + (var2_2.getSendAcknowledge() != false ? "notify the client" : " not notify the client"));
                    } else {
                        this.logger.log(BrokerStateHandler.shuttingDown != false ? 4 : 16, Globals.getBrokerResources().getKString(var2_2.getSendAcknowledge() != false ? "B2188" : "B2189", "" + var5_4 + "(" + var3_3 + ")" + (var7_6 == null ? "" : "XID=" + var7_6), PacketType.getString(var2_2.getPacketType())) + "\n" + PacketUtil.dumpPacket(var2_2));
                    }
                    if (var2_2.getSendAcknowledge()) {
                        var16_15 = "Unknown transaction " + var5_4;
                        this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 404, var5_4.longValue(), var16_15);
                    }
                    return true;
                }
            }
        }
        if (TransactionHandler.DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + PacketType.getString(var2_2.getPacketType()) + ": " + "TUID=" + var5_4 + " XAFLAGS=" + TransactionState.xaFlagToString(var8_7) + (var14_13 == null ? "" : " JMQXAOnePhase=" + var13_12) + " State=" + var6_5 + " Xid=" + var7_6);
        }
        if (!(var7_6 == null || var6_5 == null || var6_5.getXid() != null && var7_6.equals(var6_5.getXid()))) {
            this.logger.log(32, "B3100", "Transaction Xid mismatch. " + PacketType.getString(var2_2.getPacketType()) + " Packet has tuid=" + var5_4 + " xid=" + var7_6 + ", transaction table has tuid=" + var5_4 + " xid=" + var6_5.getXid() + ". Using values from table.");
            var7_6 = var6_5.getXid();
        }
        if (var7_6 == null && var6_5 != null && var6_5.getXid() != null && var2_2.getPacketType() != 60) {
            var7_6 = var6_5.getXid();
            this.logger.log(16, "B3100", "Transaction Xid " + var7_6 + " not found in " + PacketType.getString(var2_2.getPacketType()) + " packet for tuid " + var5_4 + ". Will use " + var7_6);
        }
        var22_24 = 200;
        var23_26 = null;
        var24_28 = 0L;
        var26_29 = false;
        var27_30 = (Integer)var15_14.get("JMQAutoRollback");
        var28_31 = (Long)var15_14.get("JMQLifetime");
        var29_32 = (Boolean)var15_14.get("JMQSessionLess");
        if (var27_30 != null) {
            var23_26 = AutoRollbackType.getType(var27_30);
        }
        if (var28_31 != null) {
            var24_28 = var28_31;
        }
        var26_29 = var29_32 != null ? var29_32 : var7_6 != null;
        switch (var2_2.getPacketType()) {
            case 44: {
                try {
                    var30_33 = null;
                    var31_36 = (Long)var15_14.get("JMQSessionID");
                    if (var31_36 != null) {
                        var30_33 = new SessionUID(var31_36);
                    }
                    this.doStart(var5_4, var19_19, var1_1, var23_26, var7_6, var26_29, var24_28, var3_3, var8_7, var2_2.getPacketType(), var12_11, var2_2.getSysMessageID().toString());
                }
                catch (Exception var30_34) {
                    var22_24 = 500;
                    this.logger.logStack(32, "B3100", var30_34.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6, (Throwable)var30_34);
                    var16_15 = var30_34.getMessage();
                    if (!(var30_34 instanceof BrokerException)) ** GOTO lbl156
                    var22_24 = ((BrokerException)var30_34).getStatusCode();
                }
lbl156:
                // 3 sources

                this.sendReply(var1_1, var2_2, 45, var22_24, var5_4.longValue(), var16_15);
                break;
            }
            case 58: {
                this.doEnd(var2_2.getPacketType(), var7_6, var8_7, var6_5, var5_4);
                this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var22_24, var5_4.longValue(), var16_15);
                break;
            }
            case 56: {
                var30_35 = null;
                try {
                    this.doPrepare(var5_4, var8_7, var6_5, var2_2.getPacketType(), var13_12);
                }
                catch (Exception var31_37) {
                    var22_24 = 500;
                    if (!(var31_37 instanceof BrokerDownException) && !(var31_37 instanceof AckEntryNotFoundException) || TransactionHandler.DEBUG_CLUSTER_TXN) {
                        this.logger.logStack(32, var31_37.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6, var31_37);
                    } else {
                        this.logger.log(var31_37 instanceof AckEntryNotFoundException != false ? 16 : 32, var31_37.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6);
                    }
                    var16_15 = var31_37.getMessage();
                    if (!(var31_37 instanceof BrokerException)) ** GOTO lbl177
                    var22_24 = ((BrokerException)var31_37).getStatusCode();
                    var30_35 = (BrokerException)var31_37;
                }
lbl177:
                // 3 sources

                this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var22_24, var5_4.longValue(), var16_15, var30_35);
                break;
            }
            case 60: {
                var31_38 = null;
                if (var5_4 != null) {
                    var31_38 = new Vector();
                    var6_5 = this.translist.retrieveState(var5_4);
                    if (var6_5.getState() == 5) {
                        var31_38.add(var5_4);
                    }
                } else {
                    if (var8_7 == null || !TransactionState.isFlagSet(0x1000000, var8_7)) {
                        var32_39 = new Hashtable<String, Integer>();
                        var32_39.put("JMQQuantity", new Integer(0));
                        this.sendReplyBody(var1_1, var2_2, 61, 200, var32_39, null);
                        break;
                    }
                    var31_38 = this.translist.getTransactions(5);
                }
                var32_40 = var31_38.size();
                var33_41 = 0;
                var34_42 = new ByteArrayOutputStream(var32_40 * JMQXid.size());
                var35_43 = new DataOutputStream(var34_42);
                for (var36_44 = 0; var36_44 < var32_40; ++var36_44) {
                    var37_46 = (TransactionUID)var31_38.get(var36_44);
                    var38_52 = this.translist.retrieveState(var37_46);
                    if (var38_52 == null) {
                        this.logger.log(32, "B3100", "Could not find state for TUID " + var37_46);
                        continue;
                    }
                    var39_53 = var38_52.getXid();
                    if (var39_53 == null) continue;
                    try {
                        var39_53.write(var35_43);
                        ++var33_41;
                        continue;
                    }
                    catch (Exception var40_54) {
                        this.logger.log(32, "B3100", "Could not write Xid " + var39_53 + " to message body: " + var40_54.toString());
                    }
                }
                var36_45 = new Hashtable<String, Number>();
                var36_45.put("JMQQuantity", new Integer(var33_41));
                if (var5_4 != null) {
                    var36_45.put("JMQTransactionID", new Long(var5_4.longValue()));
                }
                this.sendReplyBody(var1_1, var2_2, 61, 200, var36_45, var34_42.toByteArray());
                break;
            }
            case 46: {
                try {
                    if (var8_7 != null && var13_12) {
                        var37_47 = new Integer(var8_7 & -1073741825);
                        this.doCommit(var5_4, var7_6, var37_47, var6_5, var19_19, true, var1_1, var2_2);
                        break;
                    }
                    this.doCommit(var5_4, var7_6, var8_7, var6_5, var19_19, true, var1_1, var2_2);
                }
                catch (BrokerException var37_48) {
                    var22_24 = var37_48.getStatusCode();
                    var16_15 = var37_48.getMessage();
                    if (var2_2.getSendAcknowledge()) {
                        this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var22_24, var5_4.longValue(), var16_15, var37_48);
                        break;
                    }
                    if (!FaultInjection.FAULT_INJECTION) break;
                    this.checkFIAfterProcess(var2_2.getPacketType());
                    this.checkFIAfterReply(var2_2.getPacketType());
                }
                break;
            }
            case 48: {
                try {
                    var37_49 = var9_8;
                    this.redeliverUnacked(var5_4, var37_49, var10_9);
                }
                catch (BrokerException var37_50) {
                    this.logger.logStack(32, "B3100", "REDELIVER: " + var37_50.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6, (Throwable)var37_50);
                    var16_15 = var37_50.getMessage();
                    var22_24 = var37_50.getStatusCode();
                }
                try {
                    this.doRollback(var5_4, var7_6, var8_7, var6_5, var19_19, var1_1, RollbackReason.APPLICATION);
                }
                catch (BrokerException var37_51) {
                    var16_15 = var37_51.getMessage();
                    var22_24 = var37_51.getStatusCode();
                }
                if (var2_2.getSendAcknowledge()) {
                    this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var22_24, var5_4.longValue(), var16_15);
                    break;
                }
                if (!FaultInjection.FAULT_INJECTION) break;
                this.checkFIAfterProcess(var2_2.getPacketType());
                this.checkFIAfterReply(var2_2.getPacketType());
            }
        }
        return true;
    }

    public void checkFIBeforeProcess(int n) {
        switch (n) {
            case 44: {
                this.fi.checkFaultAndExit("txn.start.1", null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit("txn.end.1", null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit("txn.prepare.1", null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.1", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.1", null, 2, false);
            }
        }
    }

    public void checkFIAfterProcess(int n) {
        switch (n) {
            case 44: {
                this.fi.checkFaultAndExit("txn.start.2", null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit("txn.end.2", null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit("txn.prepare.2", null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.2", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.2", null, 2, false);
            }
        }
    }

    public void checkFIAfterDB(int n) {
        switch (n) {
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.4", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.4", null, 2, false);
            }
        }
    }

    public void checkFIAfterReply(int n) {
        switch (n) {
            case 44: {
                this.fi.checkFaultAndExit("txn.start.3", null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit("txn.end.3", null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit("txn.prepare.3", null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.3", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.3", null, 2, false);
            }
        }
    }

    private void cacheSetState(TransactionUID transactionUID, TransactionState transactionState, IMQConnection iMQConnection) {
        if (GlobalProperties.getGlobalProperties().TRANSACTION_DEBUG) {
            if (iMQConnection == null) {
                return;
            }
            CacheHashMap cacheHashMap = (CacheHashMap)iMQConnection.getClientData("txncache");
            if (cacheHashMap == null) {
                cacheHashMap = new CacheHashMap(4);
                iMQConnection.addClientData("txncache", cacheHashMap);
            }
            cacheHashMap.put(transactionUID, transactionState);
        }
    }

    private TransactionState cacheGetState(TransactionUID transactionUID, IMQConnection iMQConnection) {
        CacheHashMap cacheHashMap;
        TransactionState transactionState = null;
        if (GlobalProperties.getGlobalProperties().TRANSACTION_DEBUG && (cacheHashMap = (CacheHashMap)iMQConnection.getClientData("txncache")) != null) {
            transactionState = (TransactionState)cacheHashMap.get(transactionUID);
        }
        return transactionState;
    }

    public void doCommit(TransactionUID transactionUID, JMQXid jMQXid, Integer n, TransactionState transactionState, List list, boolean bl, IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Collection<ConsumerUID> collection;
        Serializable serializable;
        Object object5;
        int n2;
        int n3 = 200;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        Object var12_12 = null;
        List list2 = null;
        list2 = this.translist.retrieveSentMessages(transactionUID);
        hashMap = this.translist.retrieveConsumedMessages(transactionUID);
        hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
        this.cacheSetState(transactionUID, transactionState, iMQConnection);
        if (list != null) {
            list.remove(transactionUID);
        }
        try {
            int n4 = jMQXid == null ? 6 : transactionState.nextState(46, n);
            this.doRemoteCommit(transactionUID, n, transactionState, n4, packet);
            if (FaultInjection.FAULT_INJECTION) {
                this.fi.checkFaultAndThrowBrokerException("txn.commit.1_1", null);
            }
            transactionState = this.translist.updateState(transactionUID, n4, true);
            if (FaultInjection.FAULT_INJECTION) {
                this.checkFIAfterDB(46);
                this.fi.checkFaultAndExit("txn.commit.1_5", null, 2, false);
            }
            if (bl) {
                this.sendReply(iMQConnection, packet, 47, n3, transactionUID.longValue(), null);
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(brokerException instanceof AckEntryNotFoundException ? 16 : 32, brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid, brokerException);
            throw brokerException;
        }
        try {
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.notifyTransactionCommit(transactionUID);
            }
        }
        catch (Exception exception) {
            this.logger.log(16, "JMX agent notify transaction committed failed:" + exception.getMessage());
        }
        int n5 = 0;
        ArrayList<byte[]> arrayList = null;
        for (n2 = 0; list2 != null && n2 < list2.size(); ++n2) {
            SysMessageID sysMessageID = (SysMessageID)list2.get(n2);
            object5 = Destination.get(sysMessageID);
            if (object5 == null) {
                this.logger.log(32, "B3100", "transacted message removed too early " + sysMessageID);
                continue;
            }
            try {
                if (Globals.txnLogEnabled()) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<byte[]>();
                    }
                    n5 = (int)((long)n5 + ((PacketReference)object5).getSize());
                    arrayList.add(((PacketReference)object5).getPacket().getBytes());
                }
                serializable = Destination.getDestination(((PacketReference)object5).getDestinationUID());
                if (FaultInjection.FAULT_INJECTION) {
                    this.fi.checkFaultAndExit("txn.commit.1_6", null, 2, false);
                }
                collection = ((Destination)serializable).routeNewMessage((PacketReference)object5);
                ((Destination)serializable).forwardMessage((Set)collection, (PacketReference)object5);
                continue;
            }
            catch (Exception exception) {
                this.logger.logStack(BrokerStateHandler.shuttingDown ? 4 : 32, "B3100", "unable to route/send transaction message " + sysMessageID, (Throwable)exception);
            }
        }
        n2 = 1;
        int n6 = 0;
        object5 = null;
        serializable = null;
        collection = null;
        HashMap hashMap3 = new HashMap();
        if (hashMap != null && hashMap.size() > 0) {
            for (Map.Entry object6 : hashMap.entrySet()) {
                object4 = (SysMessageID)object6.getKey();
                if (object4 == null || (object3 = Destination.get((SysMessageID)object4)) == null || ((PacketReference)object3).isDestroyed() || ((PacketReference)object3).isInvalid()) continue;
                object2 = Destination.getDestination(((PacketReference)object3).getDestinationUID());
                object = (List)object6.getValue();
                for (int i = 0; i < object.size(); ++i) {
                    ConsumerUID consumerUID = (ConsumerUID)object.get(i);
                    ConsumerUID consumerUID2 = (ConsumerUID)hashMap2.get(consumerUID);
                    if (consumerUID2 == null) {
                        consumerUID2 = consumerUID;
                    }
                    try {
                        Session session = Session.getSession(consumerUID);
                        if (session != null) {
                            PacketReference packetReference = null;
                            if (FaultInjection.FAULT_INJECTION && this.fi.checkFault("txn.commit.1_7_1", null)) {
                                Globals.getConnectionManager().getConnection(session.getConnectionUID()).destroyConnection(true, 6, "Fault injection of closing connection");
                            }
                            if ((packetReference = session.ackMessage(consumerUID, (SysMessageID)object4, transactionUID, hashMap3)) != null) {
                                if (FaultInjection.FAULT_INJECTION) {
                                    this.fi.checkFaultAndExit("txn.commit.1_7", null, 2, false);
                                }
                                ((Destination)object2).removeMessage(((PacketReference)object3).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                            } else {
                                session = Session.getSession(consumerUID);
                            }
                        }
                        if (session == null) {
                            try {
                                if (((PacketReference)object3).acknowledged(consumerUID, consumerUID2, true, true, transactionUID, hashMap3)) {
                                    ((Destination)object2).removeMessage(((PacketReference)object3).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                                }
                            }
                            catch (BrokerException brokerException) {
                                this.logger.log(16, "Internal error", brokerException);
                            }
                        }
                        if (!Globals.txnLogEnabled()) continue;
                        if (object5 == null) {
                            object5 = new ArrayList();
                            serializable = new ArrayList();
                            collection = new ArrayList();
                        }
                        if (!((Destination)object2).isQueue() && !consumerUID2.shouldStore()) continue;
                        ++n6;
                        ((ArrayList)object5).add(((Destination)object2).getUniqueName());
                        ((ArrayList)serializable).add(object4);
                        ((ArrayList)collection).add(consumerUID2);
                        continue;
                    }
                    catch (Exception exception) {
                        n2 = 0;
                        this.logger.logStack(32, "B3100", "-------------------------------------------Processing Acknowledgement during committ [" + object4 + ":" + consumerUID + ":" + iMQConnection.getConnectionUID() + "]\nReference is " + (object3 == null ? null : ((PacketReference)object3).getSysMessageID()) + "\n" + PacketUtil.dumpPacket(packet) + "--------------------------------------------", (Throwable)exception);
                    }
                }
            }
        }
        this.translist.removeTransaction(transactionUID, n2 == 0 || hashMap.size() > 0 && BrokerStateHandler.shuttingDown);
        if (list == null) {
            this.logger.log(16, "B2178", (Object)transactionUID, jMQXid == null ? "null" : jMQXid.toString());
        }
        try {
            Object object7;
            if (n5 > 0 && n6 > 0) {
                object7 = new ByteArrayOutputStream(n5 + n6 * 72 + 16);
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object7);
                dataOutputStream.writeLong(transactionUID.longValue());
                dataOutputStream.writeInt(arrayList.size());
                object4 = arrayList.iterator();
                while (object4.hasNext()) {
                    dataOutputStream.write((byte[])object4.next());
                }
                dataOutputStream.writeInt(n6);
                for (int i = 0; i < n6; ++i) {
                    object2 = (String)((ArrayList)object5).get(i);
                    dataOutputStream.writeUTF((String)object2);
                    object = (SysMessageID)((ArrayList)serializable).get(i);
                    ((SysMessageID)object).writeID(dataOutputStream);
                    ConsumerUID consumerUID = (ConsumerUID)((ArrayList)collection).get(i);
                    dataOutputStream.writeLong(consumerUID.longValue());
                }
                dataOutputStream.close();
                ((ByteArrayOutputStream)object7).close();
                Globals.getStore().logTxn(4, ((ByteArrayOutputStream)object7).toByteArray());
            } else if (n5 > 0) {
                object7 = ByteBuffer.allocate(n5 + 12);
                ((ByteBuffer)object7).putLong(transactionUID.longValue());
                ((ByteBuffer)object7).putInt(arrayList.size());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((ByteBuffer)object7).put((byte[])iterator.next());
                }
                Globals.getStore().logTxn(1, ((ByteBuffer)object7).array());
            } else if (n6 > 0) {
                object7 = new ByteArrayOutputStream(n6 * 72 + 12);
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object7);
                dataOutputStream.writeLong(transactionUID.longValue());
                dataOutputStream.writeInt(n6);
                for (int i = 0; i < n6; ++i) {
                    object3 = (String)((ArrayList)object5).get(i);
                    dataOutputStream.writeUTF((String)object3);
                    object2 = (SysMessageID)((ArrayList)serializable).get(i);
                    ((SysMessageID)object2).writeID(dataOutputStream);
                    object = (ConsumerUID)((ArrayList)collection).get(i);
                    dataOutputStream.writeLong(((UID)object).longValue());
                }
                dataOutputStream.close();
                ((ByteArrayOutputStream)object7).close();
                Globals.getStore().logTxn(2, ((ByteArrayOutputStream)object7).toByteArray());
            }
        }
        catch (IOException iOException) {
            this.logger.logStack(32, "B3100", "Got exception while writing to transaction log", (Throwable)iOException);
            throw new BrokerException("Internal Error: Got exception while writing to transaction log", iOException);
        }
    }

    public void doRollback(TransactionUID transactionUID, JMQXid jMQXid, Integer n, TransactionState transactionState, List list, IMQConnection iMQConnection, RollbackReason rollbackReason) throws BrokerException {
        Map map;
        Object object;
        Object object2;
        Object object4;
        Object[] objectArray;
        int n2;
        int n3 = transactionState.getState();
        try {
            if (jMQXid == null) {
                n2 = 7;
            } else {
                if ((rollbackReason == RollbackReason.ADMIN || rollbackReason == RollbackReason.CONNECTION_CLEANUP) && transactionState.getState() == 1) {
                    transactionState = this.translist.updateState(transactionUID, 2, 1, true);
                    objectArray = new String[]{rollbackReason.toString(), transactionUID.toString() + "[" + TransactionState.toString(n3) + "]", jMQXid == null ? "null" : jMQXid.toString()};
                    this.logger.log(16, Globals.getBrokerResources().getKString("B2176", objectArray));
                }
                n2 = transactionState.nextState(48, n);
            }
        }
        catch (BrokerException brokerException) {
            if (brokerException.getStatusCode() == 409) {
                this.logger.log(32, brokerException.toString());
            } else {
                this.logger.log(32, "B3100", brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid);
            }
            throw brokerException;
        }
        transactionState = this.translist.updateState(transactionUID, n2, true);
        if (FaultInjection.FAULT_INJECTION) {
            this.checkFIAfterDB(48);
        }
        objectArray = new ArrayList(this.translist.retrieveSentMessages(transactionUID));
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            PacketReference object32;
            object4 = (SysMessageID)objectArray.get(i);
            if (DEBUG) {
                this.logger.log(4, "Removing " + object4 + " because of rollback");
            }
            if ((object32 = Destination.get((SysMessageID)object4)) == null) continue;
            object2 = object32.getDestinationUID();
            object = Destination.getDestination((DestinationUID)object2);
            ((Destination)object).removeMessage((SysMessageID)object4, RemoveReason.ROLLBACK);
        }
        if (list != null) {
            list.remove(transactionUID);
        }
        if ((map = this.translist.getOrphanAck(transactionUID)) != null) {
            for (Map.Entry entry : map.entrySet()) {
                object2 = (SysMessageID)entry.getKey();
                object = Destination.get((SysMessageID)object2, false);
                if (object == null) {
                    this.logger.log(4, transactionUID + ":Unknown orphan " + object2);
                    continue;
                }
                List list2 = (List)entry.getValue();
                for (ConsumerUID consumerUID : list2) {
                    ((PacketReference)object).getDestination().forwardOrphanMessage((PacketReference)object, consumerUID);
                }
            }
        }
        this.translist.removeTransactionAck(transactionUID, true);
        object4 = Globals.getAgent();
        if (object4 != null) {
            ((Agent)object4).notifyTransactionRollback(transactionUID);
        }
        try {
            transactionState.setState(n2);
            this.cacheSetState(transactionUID, transactionState, iMQConnection);
            this.doRemoteRollback(transactionUID, n2);
            this.translist.removeTransactionID(transactionUID);
            if (rollbackReason == RollbackReason.ADMIN || rollbackReason == RollbackReason.CONNECTION_CLEANUP) {
                Object[] objectArray2 = new String[]{rollbackReason.toString(), transactionUID.toString() + "[" + TransactionState.toString(n3) + "]", jMQXid == null ? "null" : jMQXid.toString()};
                this.logger.log(16, Globals.getBrokerResources().getKString("B2177", objectArray2));
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(32, "B3100", "exception removing transaction", (Throwable)brokerException);
            throw brokerException;
        }
    }

    public void redeliverUnacked(TransactionUID transactionUID, boolean bl, boolean bl2) throws BrokerException {
        Set<Object> set;
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        Map.Entry entry2;
        Object var4_4 = null;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        Object var7_7 = null;
        hashMap = this.translist.retrieveConsumedMessages(transactionUID);
        hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
        HashMap hashMap3 = new HashMap();
        if (hashMap != null && hashMap.size() > 0) {
            for (Map.Entry entry2 : hashMap.entrySet()) {
                object4 = (SysMessageID)entry2.getKey();
                if (object4 == null || (object3 = Destination.get((SysMessageID)object4, false)) == null || ((PacketReference)object3).isDestroyed() || ((PacketReference)object3).isInvalid()) continue;
                object2 = (List)entry2.getValue();
                for (int i = 0; i < object2.size(); ++i) {
                    serializable = (ConsumerUID)object2.get(i);
                    object = (ConsumerUID)hashMap2.get(serializable);
                    if (object == null) {
                        object = serializable;
                    }
                    if ((set = (TreeSet<Object>)hashMap3.get(serializable)) == null) {
                        set = new TreeSet<Object>(new RefCompare());
                        hashMap3.put(serializable, set);
                    }
                    try {
                        if (bl2) {
                            ((PacketReference)object3).consumed((ConsumerUID)object, false, false);
                        } else {
                            ((PacketReference)object3).removeDelivered((ConsumerUID)object, true);
                        }
                    }
                    catch (IOException iOException) {
                        this.logger.log(16, "Internal error", iOException);
                    }
                    set.add(object3);
                }
            }
        }
        Iterator iterator = hashMap3.entrySet().iterator();
        while (iterator.hasNext()) {
            entry2 = iterator.next();
            object4 = (ConsumerUID)entry2.getKey();
            object3 = Consumer.getConsumer((ConsumerUID)object4);
            if (object3 == null) {
                if (!DEBUG) continue;
                this.logger.log(8, transactionUID + ":Can not redeliver messages to " + object4 + " consumer is gone");
                continue;
            }
            object2 = (SortedSet)entry2.getValue();
            if (DEBUG) {
                this.logger.log(8, transactionUID + ":Redelivering " + object2.size() + " msgs to " + object4);
            }
            if (!bl) {
                iterator.remove();
                continue;
            }
            if (((Consumer)object3).routeMessages((Collection)object2, true)) {
                if (DEBUG) {
                    this.logger.log(8, "Sucessfully routed msgs to " + object3);
                }
                iterator.remove();
                continue;
            }
            if (!DEBUG) continue;
            this.logger.log(8, "Could not route messages to " + object3);
        }
        if (DEBUG) {
            this.logger.log(8, transactionUID + ":after redeliver, " + hashMap3.size() + " inactive consumers remaining");
        }
        iterator = hashMap3.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object5;
            entry2 = iterator.next();
            object4 = (ConsumerUID)entry2.getKey();
            object3 = (ConsumerUID)hashMap2.get(object4);
            if (object3 == null || object4 == object3) {
                iterator.remove();
                continue;
            }
            if (object3 == PacketReference.getQueueUID()) {
                object2 = (SortedSet)entry2.getValue();
                if (object2.isEmpty()) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "Internal Error:  empty set");
                    continue;
                }
                object5 = (PacketReference)object2.first();
                if (object5 == null) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "Internal Error:  null reterence");
                    continue;
                }
                try {
                    if (bl2) {
                        ((PacketReference)object5).consumed((ConsumerUID)object3, false, false);
                    } else {
                        ((PacketReference)object5).removeDelivered((ConsumerUID)object3, false);
                    }
                }
                catch (IOException iOException) {
                    this.logger.log(16, "Internal error", iOException);
                }
                serializable = ((PacketReference)object5).getDestination();
                if (serializable == null) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "Internal Error:  unknown destination for reference: " + object5);
                    continue;
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    object5 = (PacketReference)object.next();
                    try {
                        set = ((Destination)serializable).routeNewMessage((PacketReference)object5);
                        ((Destination)serializable).forwardMessage(set, (PacketReference)object5);
                    }
                    catch (Exception exception) {
                        this.logger.log(8, "Internal Error: Unable to re-queue message  to queue " + serializable, exception);
                    }
                }
                continue;
            }
            object2 = Consumer.getConsumer((ConsumerUID)object3);
            if (object2 == null) {
                if (!DEBUG) continue;
                this.logger.log(8, "Internal Error:  unknown consumer " + object3);
                continue;
            }
            object5 = (SortedSet)hashMap3.get(object4);
            if (object5 == null || object5.isEmpty() || !((Consumer)object2).routeMessages((Collection)object5, true)) continue;
            iterator.remove();
        }
        if (DEBUG && hashMap3.size() > 0) {
            this.logger.log(8, transactionUID + ":after all processing, " + hashMap3.size() + " inactive consumers remaining");
        }
    }

    public void doPrepare(TransactionUID transactionUID, Integer n, TransactionState transactionState, int n2) throws BrokerException {
        this.doPrepare(transactionUID, n, transactionState, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPrepare(TransactionUID transactionUID, Integer n, TransactionState transactionState, int n2, boolean bl) throws BrokerException {
        boolean bl2 = false;
        int n3 = transactionState.nextState(n2, n);
        try {
            TransactionState transactionState2 = new TransactionState(transactionState);
            transactionState2.setState(n3);
            this.doRemotePrepare(transactionUID, transactionState, transactionState2);
            this.translist.updateState(transactionUID, n3, bl, true);
            bl2 = true;
            try {
                Agent agent = Globals.getAgent();
                if (agent != null) {
                    agent.notifyTransactionPrepare(transactionUID);
                }
            }
            catch (Throwable throwable) {
                this.logger.log(16, "XXXI18N - JMX agent notify transaction prepared failed: " + throwable.getMessage());
            }
        }
        finally {
            if (!bl2) {
                this.translist.updateState(transactionUID, 2, bl, 5, true);
            }
        }
    }

    private void doRemotePrepare(TransactionUID transactionUID, TransactionState transactionState, TransactionState transactionState2) throws BrokerException {
        ArrayList[] arrayListArray;
        if (transactionState2.getState() != 5) {
            throw new BrokerException("Unexpected state " + transactionState2 + " for transactionID:" + transactionUID);
        }
        HashMap hashMap = this.retrieveConsumedRemoteMessages(transactionUID, false);
        if (hashMap == null) {
            return;
        }
        if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
            return;
        }
        TransactionBroker[] transactionBrokerArray = hashMap.keySet().toArray(new TransactionBroker[0]);
        this.translist.logClusterTransaction(transactionUID, transactionState2, transactionBrokerArray, true, true);
        if (DEBUG_CLUSTER_TXN) {
            arrayListArray = new StringBuffer();
            arrayListArray.append("Preparing transaction " + transactionUID + ", brokers");
            for (int i = 0; i < transactionBrokerArray.length; ++i) {
                arrayListArray.append("\n\t" + transactionBrokerArray[i]);
            }
            this.logger.log(8, arrayListArray.toString());
        }
        arrayListArray = null;
        TransactionBroker transactionBroker = null;
        for (int i = 0; i < transactionBrokerArray.length; ++i) {
            transactionBroker = transactionBrokerArray[i];
            if (transactionBroker.getBrokerAddress() == Globals.getMyAddress()) continue;
            arrayListArray = (ArrayList[])hashMap.get(transactionBroker);
            try {
                Globals.getClusterBroadcast().acknowledgeMessage2P(transactionBroker.getBrokerAddress(), arrayListArray[0].toArray(new SysMessageID[0]), arrayListArray[1].toArray(new ConsumerUID[0]), 8, null, new Long(transactionUID.longValue()), true);
                continue;
            }
            catch (BrokerException brokerException) {
                ConsumerUID consumerUID;
                SysMessageID sysMessageID;
                int n;
                if (!(brokerException instanceof BrokerDownException) && !(brokerException instanceof AckEntryNotFoundException)) {
                    throw brokerException;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                StringBuffer stringBuffer = new StringBuffer();
                String string = null;
                StringBuffer stringBuffer2 = new StringBuffer();
                for (n = 0; n < arrayListArray[0].size(); ++n) {
                    sysMessageID = (SysMessageID)arrayListArray[0].get(n);
                    consumerUID = (ConsumerUID)arrayListArray[1].get(n);
                    if (brokerException.isRemote() && !arrayList.contains(string = String.valueOf(consumerUID.longValue()))) {
                        arrayList.add(string);
                        stringBuffer.append(string);
                        stringBuffer.append(" ");
                        Consumer consumer = Consumer.getConsumer(consumerUID);
                        if (consumer != null) {
                            consumer.recreationRequested();
                        } else {
                            this.logger.log(16, "Consumer " + consumerUID + " not found in processing remote exception on preparing transaction " + transactionUID);
                        }
                    }
                    stringBuffer2.append("\n\t[" + sysMessageID + ":" + consumerUID + "]");
                }
                if (brokerException.isRemote()) {
                    brokerException.setRemoteConsumerUIDs(stringBuffer.toString());
                }
                try {
                    this.translist.updateState(transactionUID, 2, false, 5, true);
                }
                catch (Exception exception) {
                    this.logger.logStack(16, "Unable to update transaction " + transactionUID + " state to FAILED on PREPARE failure from " + transactionBroker + ": " + exception.getMessage() + stringBuffer2.toString(), exception);
                    throw brokerException;
                }
                if (brokerException instanceof AckEntryNotFoundException) {
                    arrayListArray = ((AckEntryNotFoundException)brokerException).getAckEntries();
                }
                for (n = 0; n < arrayListArray[0].size(); ++n) {
                    sysMessageID = (SysMessageID)arrayListArray[0].get(n);
                    consumerUID = (ConsumerUID)arrayListArray[1].get(n);
                    try {
                        this.translist.removeAcknowledgement(transactionUID, sysMessageID, consumerUID);
                        continue;
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "Unable to remove transaction " + transactionUID + " ack [" + sysMessageID + ":" + consumerUID + "] on PREPARE failure from " + transactionBroker + ": " + exception.getMessage(), exception);
                    }
                }
                this.logger.log(8, "Preparing transaction + " + transactionUID + " failed from " + transactionBroker + ": " + brokerException.getMessage() + stringBuffer2.toString());
                throw brokerException;
            }
        }
    }

    private void doRemoteRollback(TransactionUID transactionUID, int n) throws BrokerException {
        block13: {
            if (n != 7) {
                throw new BrokerException("Unexpected state " + n + " for transactionUID:" + transactionUID);
            }
            if (!this.translist.hasRemoteBroker(transactionUID)) {
                return;
            }
            if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
                return;
            }
            try {
                int n2;
                Serializable serializable;
                TransactionBroker[] transactionBrokerArray = this.translist.getClusterTransactionBrokers(transactionUID);
                if (DEBUG_CLUSTER_TXN) {
                    serializable = new StringBuffer();
                    ((StringBuffer)serializable).append("Rollback transaction " + transactionUID + ", remote brokers");
                    for (n2 = 0; n2 < transactionBrokerArray.length; ++n2) {
                        ((StringBuffer)serializable).append("\n\t" + transactionBrokerArray[n2]);
                    }
                    this.logger.log(8, ((StringBuffer)serializable).toString());
                }
                serializable = null;
                for (n2 = 0; n2 < transactionBrokerArray.length; ++n2) {
                    if (transactionBrokerArray[n2].getBrokerAddress() == Globals.getMyAddress()) continue;
                    serializable = transactionBrokerArray[n2].getCurrentBrokerAddress();
                    if (serializable == Globals.getMyAddress()) {
                        if (DEBUG_CLUSTER_TXN) {
                            this.logger.log(8, "Transaction remote broker current address " + transactionBrokerArray[n2].toString() + " is my address, TUID=" + transactionUID);
                        }
                    } else if (DEBUG_CLUSTER_TXN) {
                        this.logger.log(8, "Transaction remote broker current address " + serializable + ", TUID=" + transactionUID);
                    }
                    if (serializable != null) {
                        Globals.getClusterBroadcast().acknowledgeMessage2P((BrokerAddress)serializable, null, null, 9, null, new Long(transactionUID.longValue()), false);
                        continue;
                    }
                    throw new BrokerDownException("Failed to rollback transaction " + transactionUID + " to broker " + transactionBrokerArray[n2].toString(), 410);
                }
            }
            catch (Exception exception) {
                this.logger.log(16, "notify rollback transaction" + transactionUID + " failed:" + exception.getMessage());
                if (!DEBUG_CLUSTER_TXN) break block13;
                this.logger.logStack(16, "Notifying rollback transaction " + transactionUID + " failed:" + exception.getMessage(), exception);
            }
        }
    }

    private void doRemoteCommit(TransactionUID transactionUID, Integer n, TransactionState transactionState, int n2, Packet packet) throws BrokerException {
        if (n2 != 6) {
            throw new BrokerException("Unexpected next state: " + n2 + " for transaction " + transactionUID);
        }
        if (transactionState.getState() != 5 && this.retrieveConsumedRemoteMessages(transactionUID, true) != null) {
            if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
                return;
            }
            Packet packet2 = new Packet();
            try {
                packet2.fill(packet);
            }
            catch (IOException iOException) {
                this.logger.logStack(8, "Internal Exception processing packet ", iOException);
                throw new BrokerException(iOException.getMessage(), iOException);
            }
            packet2.setPacketType(56);
            if (transactionState.getState() == 1 && transactionState.getXid() == null) {
                transactionState.setState(4);
                n = new Integer(0);
            }
            this.doPrepare(transactionUID, n, transactionState, packet2.getPacketType(), true);
        }
    }

    private HashMap retrieveConsumedRemoteMessages(TransactionUID transactionUID, boolean bl) throws BrokerException {
        HashMap hashMap = this.translist.retrieveConsumedMessages(transactionUID);
        if (hashMap == null || hashMap.size() == 0) {
            return null;
        }
        Iterator iterator = hashMap.keySet().iterator();
        HashMap<Serializable, ArrayList[]> hashMap2 = new HashMap<Serializable, ArrayList[]>();
        ArrayList[] arrayListArray = null;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            int n;
            List list;
            Serializable serializable;
            Serializable serializable2;
            SysMessageID sysMessageID = (SysMessageID)iterator.next();
            if (sysMessageID == null) continue;
            PacketReference packetReference = Destination.get(sysMessageID, false);
            if (this.checkRefRequeued(transactionUID, packetReference, sysMessageID)) {
                serializable2 = new BrokerException("XXXI18N-Message requened: " + sysMessageID + ", TUID=" + transactionUID, 410);
                ((BrokerException)serializable2).setRemote(true);
                serializable = new StringBuffer();
                list = (List)hashMap.get(sysMessageID);
                for (n = 0; n < list.size(); ++n) {
                    ((StringBuffer)serializable).append(String.valueOf(((ConsumerUID)list.get(n)).longValue()));
                    ((StringBuffer)serializable).append(" ");
                }
                ((BrokerException)serializable2).setRemoteConsumerUIDs(((StringBuffer)serializable).toString());
                throw serializable2;
            }
            if (packetReference == null) {
                throw new BrokerException("XXXI18N-Message " + sysMessageID + " has been removed, TUID=" + transactionUID, 409);
            }
            serializable2 = packetReference.getAddress();
            if (serializable2 == null) {
                serializable2 = Globals.getMyAddress();
            }
            if (serializable2 != Globals.getMyAddress() && !bl2) {
                bl2 = true;
                if (bl) {
                    return new HashMap();
                }
            }
            if ((arrayListArray = (ArrayList[])hashMap2.get(serializable = new TransactionBroker((BrokerAddress)serializable2))) == null) {
                arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
                hashMap2.put(serializable, arrayListArray);
            }
            list = (List)hashMap.get(sysMessageID);
            for (n = 0; n < list.size(); ++n) {
                arrayListArray[0].add(sysMessageID);
                arrayListArray[1].add(list.get(n));
            }
        }
        if (!bl2) {
            return null;
        }
        return hashMap2;
    }

    private boolean checkRefRequeued(TransactionUID transactionUID, PacketReference packetReference, SysMessageID sysMessageID) throws BrokerException {
        HashMap hashMap = this.translist.retrieveAckBrokerAddresses(transactionUID);
        BrokerAddress brokerAddress = (BrokerAddress)hashMap.get(sysMessageID);
        if (packetReference == null && Destination.isLocked(sysMessageID)) {
            this.logger.log(16, "Message " + sysMessageID + (brokerAddress == null ? "" : " (" + brokerAddress + ")") + " is in takeover, TUID=" + transactionUID);
            return true;
        }
        if (packetReference == null) {
            this.logger.log(16, "Message " + sysMessageID + (brokerAddress == null ? "" : " (" + brokerAddress + ")") + " has been removed, TUID=" + transactionUID);
            return false;
        }
        if (packetReference.isOverrided()) {
            return true;
        }
        BrokerAddress brokerAddress2 = packetReference.getAddress();
        if (brokerAddress == null && brokerAddress2 == null) {
            return false;
        }
        if (brokerAddress == null && brokerAddress2 != null || brokerAddress != null && brokerAddress2 == null) {
            return true;
        }
        if (!brokerAddress.equals(brokerAddress2)) {
            return true;
        }
        UID uID = brokerAddress.getBrokerSessionUID();
        UID uID2 = brokerAddress2.getBrokerSessionUID();
        if (uID == null || uID2 == null) {
            return false;
        }
        return !uID.equals(uID2);
    }

    public void doStart(TransactionUID transactionUID, List list, IMQConnection iMQConnection, AutoRollbackType autoRollbackType, JMQXid jMQXid, boolean bl, long l, long l2, Integer n, int n2, boolean bl2, String string) throws BrokerException {
        HashMap hashMap = (HashMap)iMQConnection.getClientData("tidmap");
        int n3 = 0;
        String string2 = null;
        TransactionState transactionState = null;
        transactionState = this.translist.retrieveState(transactionUID);
        if (autoRollbackType == AutoRollbackType.NEVER || l > 0L) {
            n3 = 501;
            string2 = "AutoRollbackType of NEVER not supported";
            throw new BrokerException(string2, n3);
        }
        if (jMQXid != null && !bl) {
            n3 = 501;
            string2 = "XA transactions only supported on sessionless connections";
            throw new BrokerException(string2, n3);
        }
        if (jMQXid == null && bl) {
            n3 = 500;
            string2 = "non-XA transactions only supported on  non-sessionless connections";
            throw new BrokerException(string2, n3);
        }
        if (!bl2) {
            if (n != null && !TransactionState.isFlagSet(0, n)) {
                int n4 = transactionState.nextState(n2, n);
                this.translist.updateState(transactionUID, n4, true);
            } else {
                try {
                    if (iMQConnection.getClientProtocolVersion() == 100) {
                        hashMap.put(new Long(l2), transactionUID);
                    }
                    if (jMQXid != null && autoRollbackType == null) {
                        autoRollbackType = TransactionList.AUTO_ROLLBACK ? AutoRollbackType.ALL : AutoRollbackType.NOT_PREPARED;
                    }
                    transactionState = new TransactionState(autoRollbackType, l, bl);
                    transactionState.setState(1);
                    transactionState.setUser(iMQConnection.getUserName());
                    transactionState.setCreator(string);
                    transactionState.setClientID((String)iMQConnection.getClientData("client id"));
                    transactionState.setXid(jMQXid);
                    if (iMQConnection instanceof IMQConnection) {
                        transactionState.setConnectionString(iMQConnection.userReadableString());
                        transactionState.setConnectionUID(iMQConnection.getConnectionUID());
                    }
                    this.translist.addTransactionID(transactionUID, transactionState);
                    list.add(transactionUID);
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, "Exception starting new transaction: " + brokerException.toString(), brokerException);
                    throw brokerException;
                }
            }
        }
    }

    public void doEnd(int n, JMQXid jMQXid, Integer n2, TransactionState transactionState, TransactionUID transactionUID) throws BrokerException {
        String string = null;
        int n3 = 0;
        try {
            int n4 = transactionState.nextState(n, n2);
            this.translist.updateState(transactionUID, n4, true);
        }
        catch (Exception exception) {
            n3 = 500;
            this.logger.logStack(32, "B3100", exception.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid, (Throwable)exception);
            string = exception.getMessage();
            if (exception instanceof BrokerException) {
                n3 = ((BrokerException)exception).getStatusCode();
            }
            throw new BrokerException(string, n3);
        }
    }
}

