/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.UserProperties;
import com.sun.messaging.jmq.admin.util.UserPropertiesException;
import java.util.Enumeration;

public class ObjStoreListProperties
extends UserProperties {
    public static final String FIRST_VERSION = "2.0";
    public static final String VERSION = "2.0";
    private static final String PROP_NAME_VERSION = "version";
    private static final String PROP_NAME_OBJSTORE_BASENAME = "objstore";
    private static final String PROP_NAME_OBJSTORE_COUNT = "objstore.count";
    private static final String PROP_NAME_OBJSTORE_ID_PREFIX = "id";
    private static final String PROP_NAME_OBJSTORE_DESC_PREFIX = "desc";
    private static final String PROP_NAME_OBJSTORE_ATTR_PREFIX = "attrs";
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public ObjStoreListProperties() {
        this.setProperty(PROP_NAME_VERSION, "2.0");
    }

    public String getVersion() {
        String string = this.getProperty(PROP_NAME_VERSION);
        return string;
    }

    public int getObjStoreCount() {
        int n;
        String string = this.getProperty(PROP_NAME_OBJSTORE_COUNT);
        if (string == null || string.equals("")) {
            return 0;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public ObjStoreAttrs[] getObjStoreAttrs() {
        int n = this.getObjStoreCount();
        if (n <= 0) {
            return null;
        }
        ObjStoreAttrs[] objStoreAttrsArray = new ObjStoreAttrs[n];
        for (int i = 0; i < n; ++i) {
            objStoreAttrsArray[i] = this.getObjStoreAttrs(i);
        }
        return objStoreAttrsArray;
    }

    public ObjStoreAttrs getObjStoreAttrs(int n) {
        ObjStoreAttrs objStoreAttrs = new ObjStoreAttrs();
        String string = PROP_NAME_OBJSTORE_BASENAME + new Integer(n).toString() + ".";
        String string2 = string + PROP_NAME_OBJSTORE_ID_PREFIX;
        String string3 = this.getProperty(string2, "");
        String string4 = string + PROP_NAME_OBJSTORE_DESC_PREFIX;
        String string5 = this.getProperty(string4, "");
        objStoreAttrs = new ObjStoreAttrs(string3, string5);
        String string6 = PROP_NAME_OBJSTORE_BASENAME + new Integer(n).toString() + "." + PROP_NAME_OBJSTORE_ATTR_PREFIX + ".";
        int n2 = string6.length();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string7 = (String)enumeration.nextElement();
            if (!string7.startsWith(string6)) continue;
            String string8 = string7.substring(n2);
            String string9 = this.getProperty(string7);
            objStoreAttrs.put(string8, string9);
        }
        return objStoreAttrs;
    }

    public void addObjStoreAttrs(ObjStoreAttrs objStoreAttrs) {
        int n = this.getObjStoreCount();
        String string = PROP_NAME_OBJSTORE_BASENAME + new Integer(n).toString() + ".";
        String string2 = string + PROP_NAME_OBJSTORE_ID_PREFIX;
        String string3 = objStoreAttrs.getID();
        this.setProperty(string2, string3);
        String string4 = string + PROP_NAME_OBJSTORE_DESC_PREFIX;
        String string5 = objStoreAttrs.getDescription();
        this.setProperty(string4, string5);
        String string6 = string + PROP_NAME_OBJSTORE_ATTR_PREFIX + ".";
        Enumeration enumeration = objStoreAttrs.keys();
        while (enumeration.hasMoreElements()) {
            String string7 = (String)enumeration.nextElement();
            String string8 = (String)objStoreAttrs.get(string7);
            String string9 = string6 + string7;
            this.setProperty(string9, string8);
        }
        this.setProperty(PROP_NAME_OBJSTORE_COUNT, new Integer(++n).toString());
    }

    public void load() throws UserPropertiesException, SecurityException {
        super.load();
        String string = this.getVersion();
        if (string == null) {
            return;
        }
        this.checkVersion(string, "2.0", "2.0");
    }

    private void checkVersion(String string, String string2, String string3) throws UserPropertiesException {
        double d;
        double d2;
        double d3;
        try {
            d3 = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            double d4 = 0.0;
            UserPropertiesException userPropertiesException = new UserPropertiesException(acr.getString("A3082", string2));
            throw userPropertiesException;
        }
        try {
            d2 = Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            double d5 = 0.0;
            UserPropertiesException userPropertiesException = new UserPropertiesException(acr.getString("A3082", string3));
            throw userPropertiesException;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[4];
            double d6 = 0.0;
            objectArray[0] = this.getAbsoluteFileName();
            objectArray[1] = PROP_NAME_VERSION;
            objectArray[2] = string;
            objectArray[3] = string2;
            String string4 = acr.getString("A3083", objectArray);
            UserPropertiesException userPropertiesException = new UserPropertiesException(string4);
            throw userPropertiesException;
        }
        if (d < d2) {
            Object[] objectArray = new Object[]{this.getAbsoluteFileName(), PROP_NAME_VERSION, string, string2};
            String string5 = acr.getString("A3083", objectArray);
            UserPropertiesException userPropertiesException = new UserPropertiesException(string5);
            throw userPropertiesException;
        }
        if (d > d3) {
            Object[] objectArray = new Object[]{this.getAbsoluteFileName(), PROP_NAME_VERSION, string, string2};
            String string6 = acr.getString("A3083", objectArray);
            UserPropertiesException userPropertiesException = new UserPropertiesException(string6);
            throw userPropertiesException;
        }
    }
}

