/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerReader;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsspi.ServerSession;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;

public class ConnectionConsumerImpl
extends Consumer
implements ConnectionConsumer,
Traceable {
    protected ServerSessionPool serverSessionPool;
    protected int maxMessages;
    private SessionQueue readQueue = null;
    private ConnectionConsumerReader reader = null;
    private Long readQueueId = null;
    private javax.jms.ServerSession serverSession = null;
    private SessionImpl session = null;

    public ConnectionConsumerImpl(ConnectionImpl connectionImpl, Destination destination, String string, ServerSessionPool serverSessionPool, int n, String string2) throws JMSException {
        super(connectionImpl, destination, string, false);
        if (string2 != null) {
            if (connectionImpl.clientID == null) {
                String string3 = AdministeredObject.cr.getKString("C4053", "\"\"");
                throw new JMSException(string3, "C4053");
            }
            this.setDurable(true);
            this.setDurableName(string2);
        }
        this.serverSessionPool = serverSessionPool;
        this.maxMessages = n;
        this.init();
    }

    public void init() throws JMSException {
        this.readQueue = new SessionQueue();
        if (this.connection.getIsStopped()) {
            this.readQueue.setIsLocked(true);
        }
        this.readQueueId = this.connection.getNextSessionId();
        this.connection.addToReadQTable(this.readQueueId, this.readQueue);
        this.reader = new ConnectionConsumerReader(this);
        this.reader.start();
        this.addInterest();
    }

    private void addInterest() throws JMSException {
        this.connection.addConnectionConsumer(this);
        this.registerInterest();
    }

    private void removeInterest() throws JMSException {
        this.connection.removeConnectionConsumer(this);
        this.deregisterInterest();
    }

    protected Long getReadQueueId() {
        return this.readQueueId;
    }

    protected SessionQueue getReadQueue() {
        return this.readQueue;
    }

    protected void onMessage(MessageImpl messageImpl) throws JMSException {
        if (this.session == null) {
            this.serverSession = this.serverSessionPool.getServerSession();
            try {
                this.session = (SessionImpl)((Object)this.serverSession.getSession());
                if (this.session.getConnection() != this.connection) {
                    String string = AdministeredObject.cr.getKString("C4029");
                    throw new JMSException(string, "C4029");
                }
                if (this.session.getMessageListener() == null) {
                    String string = AdministeredObject.cr.getKString("C4029");
                    throw new IllegalStateException(string, "C4029");
                }
            }
            catch (JMSException jMSException) {
                if (this.session != null && this.serverSession instanceof ServerSession) {
                    ((ServerSession)this.serverSession).destroy();
                }
                this.session = null;
                this.serverSession = null;
                throw jMSException;
            }
        }
        messageImpl.setSession(this.session);
        this.session.loadMessageToServerSession(messageImpl, this.serverSession);
    }

    protected void startServerSession() throws JMSException {
        if (this.serverSession != null) {
            this.serverSession.start();
            this.serverSession = null;
            this.session = null;
        }
    }

    protected int getMaxMessages() {
        return this.maxMessages;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    public void close() throws JMSException {
        this.reader.close();
        this.removeInterest();
        this.connection.removeFromReadQTable(this.readQueueId);
        this.isClosed = true;
    }

    protected void stop() {
        this.readQueue.stop(false);
    }

    protected void start() {
        this.readQueue.start();
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ ConnectionConsumerImpl dump ------");
        printStream.println("Interest ID: " + this.getInterestId());
        printStream.println("is registered: " + this.getIsRegistered());
        printStream.println("is durable: " + this.getDurable());
        if (this.durable) {
            printStream.println("durableName: " + this.getDurableName());
        }
        printStream.println("destination: " + this.getDestination());
        printStream.println("selector: " + this.messageSelector);
        printStream.println("maxMessages: " + this.maxMessages);
    }

    protected Hashtable getDebugState(boolean bl) {
        Hashtable hashtable = super.getDebugState(bl);
        hashtable.put("maxMessages", String.valueOf(this.maxMessages));
        return hashtable;
    }
}

