/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.security;

import java.io.FilePermission;
import java.security.Permission;
import java.security.Permissions;

public class MockSecurityManager
extends SecurityManager {
    private Permissions permissions = new Permissions();
    private static final Permission setSecurityManagerPerm = new RuntimePermission("setSecurityManager");
    private int untrustedCodeCount = 0;

    public MockSecurityManager() {
        this.permissions.add(setSecurityManagerPerm);
    }

    public void addPermission(Permission p) {
        this.permissions.add(p);
    }

    public int getUntrustedCodeCount() {
        return this.untrustedCodeCount;
    }

    public void checkPermission(Permission p) throws SecurityException {
        FilePermission fp;
        if (setSecurityManagerPerm.implies(p)) {
            return;
        }
        if (p instanceof FilePermission && (fp = (FilePermission)p).getActions().equals("read")) {
            return;
        }
        System.out.println("\n\ntesting permission:" + p.getClass() + ":" + p);
        Exception e = new Exception();
        e.fillInStackTrace();
        StackTraceElement[] stack = e.getStackTrace();
        for (int i = 1; i < stack.length; ++i) {
            String cname = stack[i].getClassName();
            System.out.println("" + i + ":" + stack[i].getClassName() + "." + stack[i].getMethodName());
            if (cname.equals("java.security.AccessController")) {
                System.out.println("Access controller found: returning");
                return;
            }
            if (cname.startsWith("java.") || cname.startsWith("javax.") || cname.startsWith("junit.") || cname.startsWith("org.apache.tools.ant.") || cname.startsWith("sun.")) continue;
            if (cname.startsWith("org.apache.commons.logging.security")) {
                ++this.untrustedCodeCount;
                System.out.println("Untrusted code [testcase] found");
                throw new SecurityException("Untrusted code [testcase] found");
            }
            if (cname.startsWith("org.apache.commons.logging.")) {
                if (this.permissions.implies(p)) {
                    System.out.println("Permission in allowed set for JCL class");
                    continue;
                }
                System.out.println("Permission refused:" + p.getClass() + ":" + p);
                throw new SecurityException("Permission refused:" + p.getClass() + ":" + p);
            }
            System.out.println("Unexpected code: permission refused:" + p.getClass() + ":" + p);
            throw new SecurityException("Unexpected code: permission refused:" + p.getClass() + ":" + p);
        }
    }
}

