/* GStreamer audio parsers
 * Copyright (C) 2009 Tim-Philipp Müller <tim centricular net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gstaacparse.h"
#include "gstamrparse.h"
#include "gstac3parse.h"
#include "gstflacparse.h"

static gboolean
plugin_init (GstPlugin * plugin)
{
  gboolean ret;

  ret = gst_element_register (plugin, "aacparse",
      GST_RANK_NONE, GST_TYPE_AACPARSE);
  ret &= gst_element_register (plugin, "amrparse",
      GST_RANK_PRIMARY + 1, GST_TYPE_AMRPARSE);
  ret &= gst_element_register (plugin, "ac3parse",
      GST_RANK_MARGINAL, GST_TYPE_AC3_PARSE);
  ret &= gst_element_register (plugin, "flacparse",
      GST_RANK_NONE, GST_TYPE_FLAC_PARSE);

  return ret;
}


GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    "audioparsersbad",
    "audioparsers",
    plugin_init, VERSION, "LGPL", GST_PACKAGE_NAME, GST_PACKAGE_ORIGIN);
